package com.facebook.places.model;

public class CurrentPlaceFeedbackRequestParams {
    public final String placeId;
    public final String tracking;
    public final Boolean wasHere;

    public static class Builder {
        public String placeId;
        public String tracking;
        public Boolean wasHere;

        public CurrentPlaceFeedbackRequestParams build() {
            return new CurrentPlaceFeedbackRequestParams(this);
        }

        public Builder setPlaceId(String str) {
            this.placeId = str;
            return this;
        }

        public Builder setTracking(String str) {
            this.tracking = str;
            return this;
        }

        public Builder setWasHere(boolean z) {
            this.wasHere = Boolean.valueOf(z);
            return this;
        }
    }

    public String getPlaceId() {
        return this.placeId;
    }

    public String getTracking() {
        return this.tracking;
    }

    public Boolean wasHere() {
        return this.wasHere;
    }

    public CurrentPlaceFeedbackRequestParams(Builder builder) {
        this.tracking = builder.tracking;
        this.placeId = builder.placeId;
        this.wasHere = builder.wasHere;
    }
}
