package com.facebook.login;

public enum LoginBehavior {
    NATIVE_WITH_FALLBACK(true, true, true, false, true, true),
    NATIVE_ONLY(true, true, false, false, false, true),
    KATANA_ONLY(false, true, false, false, false, false),
    WEB_ONLY(false, false, true, false, true, false),
    WEB_VIEW_ONLY(false, false, true, false, false, false),
    DIALOG_ONLY(false, true, true, false, true, true),
    DEVICE_AUTH(false, false, false, true, false, false);
    
    public final boolean allowsCustomTabAuth;
    public final boolean allowsDeviceAuth;
    public final boolean allowsFacebookLiteAuth;
    public final boolean allowsGetTokenAuth;
    public final boolean allowsKatanaAuth;
    public final boolean allowsWebViewAuth;

    /* access modifiers changed from: public */
    LoginBehavior(boolean z, boolean z2, boolean z3, boolean z4, boolean z5, boolean z6) {
        this.allowsGetTokenAuth = z;
        this.allowsKatanaAuth = z2;
        this.allowsWebViewAuth = z3;
        this.allowsDeviceAuth = z4;
        this.allowsCustomTabAuth = z5;
        this.allowsFacebookLiteAuth = z6;
    }

    public boolean allowsCustomTabAuth() {
        return this.allowsCustomTabAuth;
    }

    public boolean allowsDeviceAuth() {
        return this.allowsDeviceAuth;
    }

    public boolean allowsFacebookLiteAuth() {
        return this.allowsFacebookLiteAuth;
    }

    public boolean allowsGetTokenAuth() {
        return this.allowsGetTokenAuth;
    }

    public boolean allowsKatanaAuth() {
        return this.allowsKatanaAuth;
    }

    public boolean allowsWebViewAuth() {
        return this.allowsWebViewAuth;
    }
}
