package com.facebook.internal;

import com.android.installreferrer.api.InstallReferrerClient;
import com.android.installreferrer.api.InstallReferrerStateListener;
import com.facebook.FacebookSdk;

public class InstallReferrerUtil {
    public static final String IS_REFERRER_UPDATED = "is_referrer_updated";

    public interface Callback {
        void onReceiveReferrerUrl(String str);
    }

    public static boolean isUpdated() {
        return FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0).getBoolean(IS_REFERRER_UPDATED, false);
    }

    public static void tryConnectReferrerInfo(final Callback callback) {
        final InstallReferrerClient build = InstallReferrerClient.newBuilder(FacebookSdk.getApplicationContext()).build();
        build.startConnection(new InstallReferrerStateListener() {
            /* class com.facebook.internal.InstallReferrerUtil.AnonymousClass1 */

            @Override // com.android.installreferrer.api.InstallReferrerStateListener
            public void onInstallReferrerServiceDisconnected() {
            }

            @Override // com.android.installreferrer.api.InstallReferrerStateListener
            public void onInstallReferrerSetupFinished(int i) {
                if (i == 0) {
                    try {
                        String installReferrer = build.getInstallReferrer().getInstallReferrer();
                        if (installReferrer != null && (installReferrer.contains("fb") || installReferrer.contains("facebook"))) {
                            callback.onReceiveReferrerUrl(installReferrer);
                        }
                        InstallReferrerUtil.updateReferrer();
                    } catch (Exception unused) {
                    }
                } else if (i == 2) {
                    InstallReferrerUtil.updateReferrer();
                }
            }
        });
    }

    public static void tryUpdateReferrerInfo(Callback callback) {
        if (!isUpdated()) {
            tryConnectReferrerInfo(callback);
        }
    }

    public static void updateReferrer() {
        FacebookSdk.getApplicationContext().getSharedPreferences("com.facebook.sdk.appEventPreferences", 0).edit().putBoolean(IS_REFERRER_UPDATED, true).apply();
    }
}
