package com.facebook.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import com.facebook.FacebookSdk;
import com.facebook.GraphRequest;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import ඓ.K.K.K.C1293;

public final class FetchedAppGateKeepersManager {
    public static final String APPLICATION_FIELDS = "fields";
    public static final long APPLICATION_GATEKEEPER_CACHE_TIMEOUT = 3600000;
    public static final String APPLICATION_GATEKEEPER_EDGE = "mobile_sdk_gk";
    public static final String APPLICATION_GATEKEEPER_FIELD = "gatekeepers";
    public static final String APPLICATION_GRAPH_DATA = "data";
    public static final String APPLICATION_PLATFORM = "platform";
    public static final String APPLICATION_SDK_VERSION = "sdk_version";
    public static final String APP_GATEKEEPERS_PREFS_KEY_FORMAT = "com.facebook.internal.APP_GATEKEEPERS.%s";
    public static final String APP_GATEKEEPERS_PREFS_STORE = "com.facebook.internal.preferences.APP_GATEKEEPERS";
    public static final String APP_PLATFORM = "android";
    public static final String TAG = "com.facebook.internal.FetchedAppGateKeepersManager";
    public static final ConcurrentLinkedQueue<Callback> callbacks = new ConcurrentLinkedQueue<>();
    public static final Map<String, JSONObject> fetchedAppGateKeepers = new ConcurrentHashMap();
    public static final AtomicBoolean isLoading = new AtomicBoolean(false);
    public static Long timestamp;

    public interface Callback {
        void onCompleted();
    }

    public static JSONObject getAppGateKeepersQueryResponse(String str) {
        Bundle r0 = C1293.m3401("platform", "android");
        r0.putString(APPLICATION_SDK_VERSION, FacebookSdk.getSdkVersion());
        r0.putString("fields", APPLICATION_GATEKEEPER_FIELD);
        GraphRequest newGraphPathRequest = GraphRequest.newGraphPathRequest(null, String.format("%s/%s", str, APPLICATION_GATEKEEPER_EDGE), null);
        newGraphPathRequest.setSkipClientToken(true);
        newGraphPathRequest.setParameters(r0);
        return newGraphPathRequest.executeAndWait().getJSONObject();
    }

    public static boolean getGateKeeperForKey(String str, String str2, boolean z) {
        loadAppGateKeepersAsync();
        return (str2 == null || !fetchedAppGateKeepers.containsKey(str2)) ? z : fetchedAppGateKeepers.get(str2).optBoolean(str, z);
    }

    public static boolean isTimestampValid(Long l) {
        return l != null && System.currentTimeMillis() - l.longValue() < 3600000;
    }

    public static void loadAppGateKeepersAsync() {
        loadAppGateKeepersAsync(null);
    }

    public static synchronized JSONObject parseAppGateKeepersFromJSON(String str, JSONObject jSONObject) {
        JSONObject jSONObject2;
        synchronized (FetchedAppGateKeepersManager.class) {
            if (fetchedAppGateKeepers.containsKey(str)) {
                jSONObject2 = fetchedAppGateKeepers.get(str);
            } else {
                jSONObject2 = new JSONObject();
            }
            JSONArray optJSONArray = jSONObject.optJSONArray("data");
            JSONObject jSONObject3 = null;
            if (optJSONArray != null) {
                jSONObject3 = optJSONArray.optJSONObject(0);
            }
            if (!(jSONObject3 == null || jSONObject3.optJSONArray(APPLICATION_GATEKEEPER_FIELD) == null)) {
                JSONArray optJSONArray2 = jSONObject3.optJSONArray(APPLICATION_GATEKEEPER_FIELD);
                for (int i = 0; i < optJSONArray2.length(); i++) {
                    try {
                        JSONObject jSONObject4 = optJSONArray2.getJSONObject(i);
                        jSONObject2.put(jSONObject4.getString(FileLruCache.HEADER_CACHEKEY_KEY), jSONObject4.getBoolean("value"));
                    } catch (JSONException e) {
                        Utility.logd(Utility.LOG_TAG, e);
                    }
                }
            }
            fetchedAppGateKeepers.put(str, jSONObject2);
        }
        return jSONObject2;
    }

    public static void pollCallbacks() {
        Handler handler = new Handler(Looper.getMainLooper());
        while (!callbacks.isEmpty()) {
            final Callback poll = callbacks.poll();
            if (poll != null) {
                handler.post(new Runnable() {
                    /* class com.facebook.internal.FetchedAppGateKeepersManager.AnonymousClass2 */

                    public void run() {
                        poll.onCompleted();
                    }
                });
            }
        }
    }

    public static JSONObject queryAppGateKeepers(String str, boolean z) {
        if (!z && fetchedAppGateKeepers.containsKey(str)) {
            return fetchedAppGateKeepers.get(str);
        }
        JSONObject appGateKeepersQueryResponse = getAppGateKeepersQueryResponse(str);
        if (appGateKeepersQueryResponse == null) {
            return null;
        }
        Context applicationContext = FacebookSdk.getApplicationContext();
        applicationContext.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0).edit().putString(String.format(APP_GATEKEEPERS_PREFS_KEY_FORMAT, str), appGateKeepersQueryResponse.toString()).apply();
        return parseAppGateKeepersFromJSON(str, appGateKeepersQueryResponse);
    }

    public static synchronized void loadAppGateKeepersAsync(Callback callback) {
        synchronized (FetchedAppGateKeepersManager.class) {
            if (callback != null) {
                callbacks.add(callback);
            }
            if (isTimestampValid(timestamp)) {
                pollCallbacks();
                return;
            }
            final Context applicationContext = FacebookSdk.getApplicationContext();
            final String applicationId = FacebookSdk.getApplicationId();
            final String format = String.format(APP_GATEKEEPERS_PREFS_KEY_FORMAT, applicationId);
            if (applicationContext != null) {
                JSONObject jSONObject = null;
                String string = applicationContext.getSharedPreferences(APP_GATEKEEPERS_PREFS_STORE, 0).getString(format, null);
                if (!Utility.isNullOrEmpty(string)) {
                    try {
                        jSONObject = new JSONObject(string);
                    } catch (JSONException e) {
                        Utility.logd(Utility.LOG_TAG, e);
                    }
                    if (jSONObject != null) {
                        parseAppGateKeepersFromJSON(applicationId, jSONObject);
                    }
                }
                Executor executor = FacebookSdk.getExecutor();
                if (executor != null) {
                    if (isLoading.compareAndSet(false, true)) {
                        executor.execute(new Runnable() {
                            /* class com.facebook.internal.FetchedAppGateKeepersManager.AnonymousClass1 */

                            public void run() {
                                JSONObject appGateKeepersQueryResponse = FetchedAppGateKeepersManager.getAppGateKeepersQueryResponse(applicationId);
                                if (appGateKeepersQueryResponse != null) {
                                    FetchedAppGateKeepersManager.parseAppGateKeepersFromJSON(applicationId, appGateKeepersQueryResponse);
                                    applicationContext.getSharedPreferences(FetchedAppGateKeepersManager.APP_GATEKEEPERS_PREFS_STORE, 0).edit().putString(format, appGateKeepersQueryResponse.toString()).apply();
                                    Long unused = FetchedAppGateKeepersManager.timestamp = Long.valueOf(System.currentTimeMillis());
                                }
                                FetchedAppGateKeepersManager.pollCallbacks();
                                FetchedAppGateKeepersManager.isLoading.set(false);
                            }
                        });
                    }
                }
            }
        }
    }
}
