package com.facebook.internal;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.Bundle;
import com.facebook.appevents.InternalAppEventsLogger;
import ඓ.K.K.K.C1293;
import ῲ.㗽.K.C2243;

public class BoltsMeasurementEventListener extends BroadcastReceiver {
    public static final String BOLTS_MEASUREMENT_EVENT_PREFIX = "bf_";
    public static final String MEASUREMENT_EVENT_ARGS_KEY = "event_args";
    public static final String MEASUREMENT_EVENT_NAME_KEY = "event_name";
    public static final String MEASUREMENT_EVENT_NOTIFICATION_NAME = "com.parse.bolts.measurement_event";
    public static BoltsMeasurementEventListener _instance;
    public Context applicationContext;

    public BoltsMeasurementEventListener(Context context) {
        this.applicationContext = context.getApplicationContext();
    }

    private void close() {
        C2243.m5866(this.applicationContext).m5868(this);
    }

    public static BoltsMeasurementEventListener getInstance(Context context) {
        BoltsMeasurementEventListener boltsMeasurementEventListener = _instance;
        if (boltsMeasurementEventListener != null) {
            return boltsMeasurementEventListener;
        }
        _instance = new BoltsMeasurementEventListener(context);
        _instance.open();
        return _instance;
    }

    private void open() {
        C2243.m5866(this.applicationContext).m5869(this, new IntentFilter(MEASUREMENT_EVENT_NOTIFICATION_NAME));
    }

    @Override // java.lang.Object
    public void finalize() throws Throwable {
        try {
            close();
        } finally {
            super.finalize();
        }
    }

    public void onReceive(Context context, Intent intent) {
        InternalAppEventsLogger internalAppEventsLogger = new InternalAppEventsLogger(context);
        StringBuilder r8 = C1293.m3416(BOLTS_MEASUREMENT_EVENT_PREFIX);
        r8.append(intent.getStringExtra(MEASUREMENT_EVENT_NAME_KEY));
        String sb = r8.toString();
        Bundle bundleExtra = intent.getBundleExtra(MEASUREMENT_EVENT_ARGS_KEY);
        Bundle bundle = new Bundle();
        for (String str : bundleExtra.keySet()) {
            bundle.putString(str.replaceAll("[^0-9a-zA-Z _-]", "-").replaceAll("^[ -]*", "").replaceAll("[ -]*$", ""), (String) bundleExtra.get(str));
        }
        internalAppEventsLogger.logEvent(sb, bundle);
    }
}
