package com.facebook.internal;

import android.content.Intent;
import java.util.UUID;

public class AppCall {
    public static AppCall currentPendingCall;
    public UUID callId;
    public int requestCode;
    public Intent requestIntent;

    public AppCall(int i) {
        this(i, UUID.randomUUID());
    }

    public static synchronized AppCall finishPendingCall(UUID uuid, int i) {
        synchronized (AppCall.class) {
            AppCall currentPendingCall2 = getCurrentPendingCall();
            if (currentPendingCall2 != null && currentPendingCall2.getCallId().equals(uuid)) {
                if (currentPendingCall2.getRequestCode() == i) {
                    setCurrentPendingCall(null);
                    return currentPendingCall2;
                }
            }
            return null;
        }
    }

    public static AppCall getCurrentPendingCall() {
        return currentPendingCall;
    }

    public static synchronized boolean setCurrentPendingCall(AppCall appCall) {
        boolean z;
        synchronized (AppCall.class) {
            AppCall currentPendingCall2 = getCurrentPendingCall();
            currentPendingCall = appCall;
            z = currentPendingCall2 != null;
        }
        return z;
    }

    public UUID getCallId() {
        return this.callId;
    }

    public int getRequestCode() {
        return this.requestCode;
    }

    public Intent getRequestIntent() {
        return this.requestIntent;
    }

    public boolean setPending() {
        return setCurrentPendingCall(this);
    }

    public void setRequestCode(int i) {
        this.requestCode = i;
    }

    public void setRequestIntent(Intent intent) {
        this.requestIntent = intent;
    }

    public AppCall(int i, UUID uuid) {
        this.callId = uuid;
        this.requestCode = i;
    }
}
