package com.facebook.appevents.suggestedevents;

import android.app.Activity;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import com.facebook.appevents.codeless.internal.SensitiveUserDataUtils;
import com.facebook.appevents.codeless.internal.ViewHierarchy;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public final class ViewObserver implements ViewTreeObserver.OnGlobalLayoutListener {
    public static final int MAX_TEXT_LENGTH = 300;
    public static final String TAG = ViewObserver.class.getCanonicalName();
    public static final Map<Integer, ViewObserver> observers = new HashMap();
    public WeakReference<Activity> activityWeakReference;
    public AtomicBoolean isTracking = new AtomicBoolean(false);
    public final Handler uiThreadHandler = new Handler(Looper.getMainLooper());

    public ViewObserver(Activity activity) {
        this.activityWeakReference = new WeakReference<>(activity);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private View getRootView() {
        Window window;
        Activity activity = this.activityWeakReference.get();
        if (activity == null || (window = activity.getWindow()) == null) {
            return null;
        }
        return window.getDecorView().getRootView();
    }

    private void process() {
        AnonymousClass1 r0 = new Runnable() {
            /* class com.facebook.appevents.suggestedevents.ViewObserver.AnonymousClass1 */

            public void run() {
                try {
                    View rootView = ViewObserver.this.getRootView();
                    Activity activity = (Activity) ViewObserver.this.activityWeakReference.get();
                    if (rootView == null) {
                        return;
                    }
                    if (activity != null) {
                        for (View view : SuggestedEventViewHierarchy.getAllClickableViews(rootView)) {
                            if (!SensitiveUserDataUtils.isSensitiveUserData(view)) {
                                String textOfView = ViewHierarchy.getTextOfView(view);
                                if (!textOfView.isEmpty() && textOfView.length() <= 300) {
                                    ViewOnClickListener.attachListener(view, rootView, activity.getLocalClassName());
                                }
                            }
                        }
                    }
                } catch (Exception unused) {
                }
            }
        };
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r0.run();
        } else {
            this.uiThreadHandler.post(r0);
        }
    }

    private void startTracking() {
        View rootView;
        if (!this.isTracking.getAndSet(true) && (rootView = getRootView()) != null) {
            ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                viewTreeObserver.addOnGlobalLayoutListener(this);
                process();
            }
        }
    }

    public static void startTrackingActivity(Activity activity) {
        int hashCode = activity.hashCode();
        if (!observers.containsKey(Integer.valueOf(hashCode))) {
            ViewObserver viewObserver = new ViewObserver(activity);
            observers.put(Integer.valueOf(hashCode), viewObserver);
            viewObserver.startTracking();
        }
    }

    private void stopTracking() {
        View rootView;
        if (this.isTracking.getAndSet(false) && (rootView = getRootView()) != null) {
            ViewTreeObserver viewTreeObserver = rootView.getViewTreeObserver();
            if (viewTreeObserver.isAlive()) {
                int i = Build.VERSION.SDK_INT;
                viewTreeObserver.removeOnGlobalLayoutListener(this);
            }
        }
    }

    public static void stopTrackingActivity(Activity activity) {
        int hashCode = activity.hashCode();
        if (observers.containsKey(Integer.valueOf(hashCode))) {
            observers.remove(Integer.valueOf(hashCode));
            observers.get(Integer.valueOf(hashCode)).stopTracking();
        }
    }

    public void onGlobalLayout() {
        process();
    }
}
