package com.facebook.appevents.internal;

import androidx.recyclerview.widget.RecyclerView;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.math.BigInteger;
import java.security.MessageDigest;

public final class HashUtils {
    public static final String MD5 = "MD5";

    public static final String computeChecksum(String str) throws Exception {
        return computeFileMd5(new File(str));
    }

    /* JADX WARNING: Code restructure failed: missing block: B:14:0x0037, code lost:
        r1 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:16:?, code lost:
        r0.close();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:17:0x003c, code lost:
        r0 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:18:0x003d, code lost:
        r4.addSuppressed(r0);
     */
    /* JADX WARNING: Code restructure failed: missing block: B:19:0x0040, code lost:
        throw r1;
     */
    public static String computeFileMd5(File file) throws Exception {
        int read;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file), RecyclerView.AbstractC0269.FLAG_ADAPTER_FULLUPDATE);
        MessageDigest instance = MessageDigest.getInstance("MD5");
        byte[] bArr = new byte[RecyclerView.AbstractC0269.FLAG_ADAPTER_FULLUPDATE];
        do {
            read = bufferedInputStream.read(bArr);
            if (read > 0) {
                instance.update(bArr, 0, read);
            }
        } while (read != -1);
        String bigInteger = new BigInteger(1, instance.digest()).toString(16);
        bufferedInputStream.close();
        return bigInteger;
    }
}
