package com.facebook.appevents.eventdeactivation;

import com.facebook.FacebookSdk;
import com.facebook.appevents.AppEvent;
import com.facebook.internal.FetchedAppSettings;
import com.facebook.internal.FetchedAppSettingsManager;
import com.facebook.internal.Utility;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONObject;

public final class EventDeactivationManager {
    public static final Set<String> deprecatedEvents = new HashSet();
    public static final List<DeprecatedParamFilter> deprecatedParamFilters = new ArrayList();
    public static boolean enabled = false;

    public static class DeprecatedParamFilter {
        public List<String> deprecateParams;
        public String eventName;

        public DeprecatedParamFilter(String str, List<String> list) {
            this.eventName = str;
            this.deprecateParams = list;
        }
    }

    public static void enable() {
        enabled = true;
        initialize();
    }

    /* JADX WARNING: Exception block dominator not found, dom blocks: [] */
    public static synchronized void initialize() {
        synchronized (EventDeactivationManager.class) {
            FetchedAppSettings queryAppSettings = FetchedAppSettingsManager.queryAppSettings(FacebookSdk.getApplicationId(), false);
            if (queryAppSettings != null) {
                String restrictiveDataSetting = queryAppSettings.getRestrictiveDataSetting();
                if (!restrictiveDataSetting.isEmpty()) {
                    JSONObject jSONObject = new JSONObject(restrictiveDataSetting);
                    deprecatedParamFilters.clear();
                    Iterator<String> keys = jSONObject.keys();
                    while (keys.hasNext()) {
                        String next = keys.next();
                        JSONObject jSONObject2 = jSONObject.getJSONObject(next);
                        if (jSONObject2 != null) {
                            if (jSONObject2.optBoolean("is_deprecated_event")) {
                                deprecatedEvents.add(next);
                            } else {
                                JSONArray optJSONArray = jSONObject2.optJSONArray("deprecated_param");
                                DeprecatedParamFilter deprecatedParamFilter = new DeprecatedParamFilter(next, new ArrayList());
                                if (optJSONArray != null) {
                                    deprecatedParamFilter.deprecateParams = Utility.convertJSONArrayToList(optJSONArray);
                                }
                                deprecatedParamFilters.add(deprecatedParamFilter);
                            }
                        }
                    }
                }
            }
        }
    }

    public static void processDeprecatedParameters(Map<String, String> map, String str) {
        if (enabled) {
            ArrayList<String> arrayList = new ArrayList(map.keySet());
            for (DeprecatedParamFilter deprecatedParamFilter : new ArrayList(deprecatedParamFilters)) {
                if (deprecatedParamFilter.eventName.equals(str)) {
                    for (String str2 : arrayList) {
                        if (deprecatedParamFilter.deprecateParams.contains(str2)) {
                            map.remove(str2);
                        }
                    }
                }
            }
        }
    }

    public static void processEvents(List<AppEvent> list) {
        if (enabled) {
            Iterator<AppEvent> it2 = list.iterator();
            while (it2.hasNext()) {
                if (deprecatedEvents.contains(it2.next().getName())) {
                    it2.remove();
                }
            }
        }
    }
}
