package com.facebook.appevents.codeless.internal;

import org.json.JSONException;
import org.json.JSONObject;

public final class PathComponent {
    public static final String PATH_CLASS_NAME_KEY = "class_name";
    public static final String PATH_DESCRIPTION_KEY = "description";
    public static final String PATH_HINT_KEY = "hint";
    public static final String PATH_ID_KEY = "id";
    public static final String PATH_INDEX_KEY = "index";
    public static final String PATH_MATCH_BITMASK_KEY = "match_bitmask";
    public static final String PATH_TAG_KEY = "tag";
    public static final String PATH_TEXT_KEY = "text";
    public final String className;
    public final String description;
    public final String hint;
    public final int id;
    public final int index;
    public final int matchBitmask;
    public final String tag;
    public final String text;

    public enum MatchBitmaskType {
        ID(1),
        TEXT(2),
        TAG(4),
        DESCRIPTION(8),
        HINT(16);
        
        public final int value;

        /* access modifiers changed from: public */
        MatchBitmaskType(int i) {
            this.value = i;
        }

        public int getValue() {
            return this.value;
        }
    }

    public PathComponent(JSONObject jSONObject) throws JSONException {
        this.className = jSONObject.getString(PATH_CLASS_NAME_KEY);
        this.index = jSONObject.optInt(PATH_INDEX_KEY, -1);
        this.id = jSONObject.optInt("id");
        this.text = jSONObject.optString("text");
        this.tag = jSONObject.optString("tag");
        this.description = jSONObject.optString("description");
        this.hint = jSONObject.optString("hint");
        this.matchBitmask = jSONObject.optInt(PATH_MATCH_BITMASK_KEY);
    }
}
