package com.facebook.appevents.aam;

import com.facebook.appevents.UserDataStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public final class MetadataRule {
    public static final String FIELD_K = "k";
    public static final String FIELD_V = "v";
    public static final String FILED_K_DELIMITER = ",";
    public static final String TAG = "com.facebook.appevents.aam.MetadataRule";
    public static List<MetadataRule> rules = new ArrayList();
    public List<String> keyRules;
    public String name;
    public String valRule;

    public MetadataRule(String str, List<String> list, String str2) {
        this.name = str;
        this.keyRules = list;
        this.valRule = str2;
    }

    public static void constructRules(JSONObject jSONObject) {
        try {
            Iterator<String> keys = jSONObject.keys();
            while (keys.hasNext()) {
                String next = keys.next();
                if (jSONObject.get(next) instanceof JSONObject) {
                    JSONObject jSONObject2 = jSONObject.getJSONObject(next);
                    if (jSONObject2.has(FIELD_K) && jSONObject2.has(FIELD_V) && !jSONObject2.getString(FIELD_K).isEmpty()) {
                        if (!jSONObject2.getString(FIELD_V).isEmpty()) {
                            rules.add(new MetadataRule(next, Arrays.asList(jSONObject2.getString(FIELD_K).split(",")), jSONObject2.getString(FIELD_V)));
                        }
                    }
                }
            }
        } catch (JSONException unused) {
        }
    }

    public static List<MetadataRule> getRules() {
        return new ArrayList(rules);
    }

    public static void removeUnusedRules() {
        Map<String, String> internalHashedUserData = UserDataStore.getInternalHashedUserData();
        if (!internalHashedUserData.isEmpty()) {
            HashSet hashSet = new HashSet();
            for (MetadataRule metadataRule : rules) {
                hashSet.add(metadataRule.getName());
            }
            ArrayList arrayList = new ArrayList();
            for (String str : internalHashedUserData.keySet()) {
                if (!hashSet.contains(str)) {
                    arrayList.add(str);
                }
            }
            if (!arrayList.isEmpty()) {
                UserDataStore.removeRules(arrayList);
            }
        }
    }

    public static void updateRules(String str) {
        try {
            rules.clear();
            constructRules(new JSONObject(str));
            removeUnusedRules();
        } catch (JSONException unused) {
        }
    }

    public List<String> getKeyRules() {
        return new ArrayList(this.keyRules);
    }

    public String getName() {
        return this.name;
    }

    public String getValRule() {
        return this.valRule;
    }
}
