package com.facebook.appevents;

import android.content.Context;
import android.util.Log;
import com.facebook.FacebookSdk;
import com.facebook.appevents.AccessTokenAppIdPair;
import com.facebook.appevents.AppEvent;
import com.facebook.appevents.internal.AppEventUtility;
import com.facebook.internal.Utility;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;

public class AppEventStore {
    public static final String PERSISTED_EVENTS_FILENAME = "AppEventsLogger.persistedevents";
    public static final String TAG = "com.facebook.appevents.AppEventStore";

    public static class MovedClassObjectInputStream extends ObjectInputStream {
        public static final String ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AccessTokenAppIdPair$SerializationProxyV1";
        public static final String APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME = "com.facebook.appevents.AppEventsLogger$AppEvent$SerializationProxyV1";

        public MovedClassObjectInputStream(InputStream inputStream) throws IOException {
            super(inputStream);
        }

        @Override // java.io.ObjectInputStream
        public ObjectStreamClass readClassDescriptor() throws IOException, ClassNotFoundException {
            ObjectStreamClass readClassDescriptor = super.readClassDescriptor();
            if (readClassDescriptor.getName().equals(ACCESS_TOKEN_APP_ID_PAIR_SERIALIZATION_PROXY_V1_CLASS_NAME)) {
                return ObjectStreamClass.lookup(AccessTokenAppIdPair.SerializationProxyV1.class);
            }
            return readClassDescriptor.getName().equals(APP_EVENT_SERIALIZATION_PROXY_V1_CLASS_NAME) ? ObjectStreamClass.lookup(AppEvent.SerializationProxyV1.class) : readClassDescriptor;
        }
    }

    public static synchronized void persistEvents(AccessTokenAppIdPair accessTokenAppIdPair, SessionEventsState sessionEventsState) {
        synchronized (AppEventStore.class) {
            AppEventUtility.assertIsNotMainThread();
            PersistedEvents readAndClearStore = readAndClearStore();
            if (readAndClearStore.containsKey(accessTokenAppIdPair)) {
                readAndClearStore.get(accessTokenAppIdPair).addAll(sessionEventsState.getEventsToPersist());
            } else {
                readAndClearStore.addEvents(accessTokenAppIdPair, sessionEventsState.getEventsToPersist());
            }
            saveEventsToDisk(readAndClearStore);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:44:0x008a  */
    public static synchronized PersistedEvents readAndClearStore() {
        PersistedEvents persistedEvents;
        MovedClassObjectInputStream movedClassObjectInputStream;
        String str;
        String str2;
        Throwable th;
        Exception e;
        synchronized (AppEventStore.class) {
            AppEventUtility.assertIsNotMainThread();
            Context applicationContext = FacebookSdk.getApplicationContext();
            persistedEvents = null;
            MovedClassObjectInputStream movedClassObjectInputStream2 = null;
            persistedEvents = null;
            persistedEvents = null;
            try {
                movedClassObjectInputStream = new MovedClassObjectInputStream(new BufferedInputStream(applicationContext.openFileInput(PERSISTED_EVENTS_FILENAME)));
                try {
                    PersistedEvents persistedEvents2 = (PersistedEvents) movedClassObjectInputStream.readObject();
                    Utility.closeQuietly(movedClassObjectInputStream);
                    try {
                        applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                    } catch (Exception e2) {
                        Log.w(TAG, "Got unexpected exception when removing events file: ", e2);
                    }
                    persistedEvents = persistedEvents2;
                } catch (FileNotFoundException unused) {
                    Utility.closeQuietly(movedClassObjectInputStream);
                    try {
                        applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                    } catch (Exception e3) {
                        e = e3;
                        str = TAG;
                        str2 = "Got unexpected exception when removing events file: ";
                    }
                    if (persistedEvents == null) {
                    }
                    return persistedEvents;
                } catch (Exception e4) {
                    e = e4;
                    try {
                        Log.w(TAG, "Got unexpected exception while reading events: ", e);
                        Utility.closeQuietly(movedClassObjectInputStream);
                        try {
                            applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                        } catch (Exception e5) {
                            e = e5;
                            str = TAG;
                            str2 = "Got unexpected exception when removing events file: ";
                        }
                        if (persistedEvents == null) {
                        }
                        return persistedEvents;
                    } catch (Throwable th2) {
                        th = th2;
                        movedClassObjectInputStream2 = movedClassObjectInputStream;
                        Utility.closeQuietly(movedClassObjectInputStream2);
                        try {
                            applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                        } catch (Exception e6) {
                            Log.w(TAG, "Got unexpected exception when removing events file: ", e6);
                        }
                        throw th;
                    }
                }
            } catch (FileNotFoundException unused2) {
                movedClassObjectInputStream = null;
                Utility.closeQuietly(movedClassObjectInputStream);
                applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                if (persistedEvents == null) {
                }
                return persistedEvents;
            } catch (Exception e7) {
                e = e7;
                movedClassObjectInputStream = null;
                Log.w(TAG, "Got unexpected exception while reading events: ", e);
                Utility.closeQuietly(movedClassObjectInputStream);
                applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                if (persistedEvents == null) {
                }
                return persistedEvents;
            } catch (Throwable th3) {
                th = th3;
                Utility.closeQuietly(movedClassObjectInputStream2);
                applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                throw th;
            }
            if (persistedEvents == null) {
                persistedEvents = new PersistedEvents();
            }
        }
        return persistedEvents;
        Log.w(str, str2, e);
        if (persistedEvents == null) {
        }
        return persistedEvents;
    }

    public static void saveEventsToDisk(PersistedEvents persistedEvents) {
        Throwable th;
        Exception e;
        Context applicationContext = FacebookSdk.getApplicationContext();
        ObjectOutputStream objectOutputStream = null;
        try {
            ObjectOutputStream objectOutputStream2 = new ObjectOutputStream(new BufferedOutputStream(applicationContext.openFileOutput(PERSISTED_EVENTS_FILENAME, 0)));
            try {
                objectOutputStream2.writeObject(persistedEvents);
                Utility.closeQuietly(objectOutputStream2);
            } catch (Exception e2) {
                e = e2;
                objectOutputStream = objectOutputStream2;
                try {
                    Log.w(TAG, "Got unexpected exception while persisting events: ", e);
                    try {
                        applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
                    } catch (Exception unused) {
                    }
                    Utility.closeQuietly(objectOutputStream);
                } catch (Throwable th2) {
                    th = th2;
                    Utility.closeQuietly(objectOutputStream);
                    throw th;
                }
            } catch (Throwable th3) {
                th = th3;
                objectOutputStream = objectOutputStream2;
                Utility.closeQuietly(objectOutputStream);
                throw th;
            }
        } catch (Exception e3) {
            e = e3;
            Log.w(TAG, "Got unexpected exception while persisting events: ", e);
            applicationContext.getFileStreamPath(PERSISTED_EVENTS_FILENAME).delete();
            Utility.closeQuietly(objectOutputStream);
        }
    }

    public static synchronized void persistEvents(AppEventCollection appEventCollection) {
        synchronized (AppEventStore.class) {
            AppEventUtility.assertIsNotMainThread();
            PersistedEvents readAndClearStore = readAndClearStore();
            for (AccessTokenAppIdPair accessTokenAppIdPair : appEventCollection.keySet()) {
                readAndClearStore.addEvents(accessTokenAppIdPair, appEventCollection.get(accessTokenAppIdPair).getEventsToPersist());
            }
            saveEventsToDisk(readAndClearStore);
        }
    }
}
