package com.facebook;

import android.os.Handler;
import com.facebook.GraphRequest;

public class RequestProgress {
    public final Handler callbackHandler;
    public long lastReportedProgress;
    public long maxProgress;
    public long progress;
    public final GraphRequest request;
    public final long threshold = FacebookSdk.getOnProgressThreshold();

    public RequestProgress(Handler handler, GraphRequest graphRequest) {
        this.request = graphRequest;
        this.callbackHandler = handler;
    }

    public void addProgress(long j) {
        this.progress += j;
        long j2 = this.progress;
        if (j2 >= this.lastReportedProgress + this.threshold || j2 >= this.maxProgress) {
            reportProgress();
        }
    }

    public void addToMax(long j) {
        this.maxProgress += j;
    }

    public long getMaxProgress() {
        return this.maxProgress;
    }

    public long getProgress() {
        return this.progress;
    }

    public void reportProgress() {
        if (this.progress > this.lastReportedProgress) {
            GraphRequest.Callback callback = this.request.getCallback();
            final long j = this.maxProgress;
            if (j > 0 && (callback instanceof GraphRequest.OnProgressCallback)) {
                final long j2 = this.progress;
                final GraphRequest.OnProgressCallback onProgressCallback = (GraphRequest.OnProgressCallback) callback;
                Handler handler = this.callbackHandler;
                if (handler == null) {
                    onProgressCallback.onProgress(j2, j);
                } else {
                    handler.post(new Runnable() {
                        /* class com.facebook.RequestProgress.AnonymousClass1 */

                        public void run() {
                            onProgressCallback.onProgress(j2, j);
                        }
                    });
                }
                this.lastReportedProgress = this.progress;
            }
        }
    }
}
