package com.bumptech.glide.load.resource.bitmap;

import com.facebook.internal.NativeProtocol;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.AbstractC0967;
import ඓ.ῲ.K.ᕣ.ᨨ.ゎ.C0964;

public class RecyclableBufferedInputStream extends FilterInputStream {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f2251;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f2252 = -1;

    /* renamed from: ῲ  reason: contains not printable characters */
    public volatile byte[] f2253;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final AbstractC0967 f2254;

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f2255;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f2256;

    public static class InvalidMarkException extends IOException {
        public static final long serialVersionUID = -4338378848813561757L;

        public InvalidMarkException(String str) {
            super(str);
        }
    }

    public RecyclableBufferedInputStream(InputStream inputStream, AbstractC0967 r3) {
        super(inputStream);
        this.f2254 = r3;
        this.f2253 = (byte[]) ((C0964) r3).m2735(NativeProtocol.MESSAGE_GET_ACCESS_TOKEN_REQUEST, byte[].class);
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public static IOException m1327() throws IOException {
        throw new IOException("BufferedInputStream is closed");
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public synchronized int available() throws IOException {
        InputStream inputStream;
        inputStream = ((FilterInputStream) this).in;
        if (this.f2253 == null || inputStream == null) {
            m1327();
            throw null;
        }
        return (this.f2251 - this.f2255) + inputStream.available();
    }

    @Override // java.io.FilterInputStream, java.io.Closeable, java.lang.AutoCloseable, java.io.InputStream
    public void close() throws IOException {
        if (this.f2253 != null) {
            ((C0964) this.f2254).m2743(this.f2253);
            this.f2253 = null;
        }
        InputStream inputStream = ((FilterInputStream) this).in;
        ((FilterInputStream) this).in = null;
        if (inputStream != null) {
            inputStream.close();
        }
    }

    public synchronized void mark(int i) {
        this.f2256 = Math.max(this.f2256, i);
        this.f2252 = this.f2255;
    }

    public boolean markSupported() {
        return true;
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public synchronized int read() throws IOException {
        byte[] bArr = this.f2253;
        InputStream inputStream = ((FilterInputStream) this).in;
        if (bArr == null || inputStream == null) {
            m1327();
            throw null;
        } else if (this.f2255 >= this.f2251 && m1329(inputStream, bArr) == -1) {
            return -1;
        } else {
            if (bArr != this.f2253 && (bArr = this.f2253) == null) {
                m1327();
                throw null;
            } else if (this.f2251 - this.f2255 <= 0) {
                return -1;
            } else {
                int i = this.f2255;
                this.f2255 = i + 1;
                return bArr[i] & 255;
            }
        }
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public synchronized void reset() throws IOException {
        if (this.f2253 == null) {
            throw new IOException("Stream is closed");
        } else if (-1 != this.f2252) {
            this.f2255 = this.f2252;
        } else {
            throw new InvalidMarkException("Mark has been invalidated, pos: " + this.f2255 + " markLimit: " + this.f2256);
        }
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public synchronized long skip(long j) throws IOException {
        if (j < 1) {
            return 0;
        }
        byte[] bArr = this.f2253;
        if (bArr != null) {
            InputStream inputStream = ((FilterInputStream) this).in;
            if (inputStream == null) {
                m1327();
                throw null;
            } else if (((long) (this.f2251 - this.f2255)) >= j) {
                this.f2255 = (int) (((long) this.f2255) + j);
                return j;
            } else {
                long j2 = ((long) this.f2251) - ((long) this.f2255);
                this.f2255 = this.f2251;
                if (this.f2252 == -1 || j > ((long) this.f2256)) {
                    return j2 + inputStream.skip(j - j2);
                } else if (m1329(inputStream, bArr) == -1) {
                    return j2;
                } else {
                    if (((long) (this.f2251 - this.f2255)) >= j - j2) {
                        this.f2255 = (int) ((((long) this.f2255) + j) - j2);
                        return j;
                    }
                    long j3 = (j2 + ((long) this.f2251)) - ((long) this.f2255);
                    this.f2255 = this.f2251;
                    return j3;
                }
            }
        } else {
            m1327();
            throw null;
        }
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public synchronized void m1328() {
        this.f2256 = this.f2253.length;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m1329(InputStream inputStream, byte[] bArr) throws IOException {
        int i;
        int i2 = this.f2252;
        if (i2 == -1 || this.f2255 - i2 >= (i = this.f2256)) {
            int read = inputStream.read(bArr);
            if (read > 0) {
                this.f2252 = -1;
                this.f2255 = 0;
                this.f2251 = read;
            }
            return read;
        }
        if (i2 == 0 && i > bArr.length && this.f2251 == bArr.length) {
            int length = bArr.length * 2;
            if (length > i) {
                length = i;
            }
            byte[] bArr2 = (byte[]) ((C0964) this.f2254).m2735(length, byte[].class);
            System.arraycopy(bArr, 0, bArr2, 0, bArr.length);
            this.f2253 = bArr2;
            ((C0964) this.f2254).m2743(bArr);
            bArr = bArr2;
        } else {
            int i3 = this.f2252;
            if (i3 > 0) {
                System.arraycopy(bArr, i3, bArr, 0, bArr.length - i3);
            }
        }
        this.f2255 -= this.f2252;
        this.f2252 = 0;
        this.f2251 = 0;
        int i4 = this.f2255;
        int read2 = inputStream.read(bArr, i4, bArr.length - i4);
        int i5 = this.f2255;
        if (read2 > 0) {
            i5 += read2;
        }
        this.f2251 = i5;
        return read2;
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public synchronized void m1330() {
        if (this.f2253 != null) {
            ((C0964) this.f2254).m2743(this.f2253);
            this.f2253 = null;
        }
    }

    @Override // java.io.FilterInputStream, java.io.InputStream
    public synchronized int read(byte[] bArr, int i, int i2) throws IOException {
        int i3;
        int i4;
        byte[] bArr2 = this.f2253;
        if (bArr2 == null) {
            m1327();
            throw null;
        } else if (i2 == 0) {
            return 0;
        } else {
            InputStream inputStream = ((FilterInputStream) this).in;
            if (inputStream != null) {
                if (this.f2255 < this.f2251) {
                    int i5 = this.f2251 - this.f2255 >= i2 ? i2 : this.f2251 - this.f2255;
                    System.arraycopy(bArr2, this.f2255, bArr, i, i5);
                    this.f2255 += i5;
                    if (i5 == i2 || inputStream.available() == 0) {
                        return i5;
                    }
                    i += i5;
                    i3 = i2 - i5;
                } else {
                    i3 = i2;
                }
                while (true) {
                    int i6 = -1;
                    if (this.f2252 == -1 && i3 >= bArr2.length) {
                        i4 = inputStream.read(bArr, i, i3);
                        if (i4 == -1) {
                            if (i3 != i2) {
                                i6 = i2 - i3;
                            }
                            return i6;
                        }
                    } else if (m1329(inputStream, bArr2) == -1) {
                        if (i3 != i2) {
                            i6 = i2 - i3;
                        }
                        return i6;
                    } else if (bArr2 == this.f2253 || (bArr2 = this.f2253) != null) {
                        i4 = this.f2251 - this.f2255 >= i3 ? i3 : this.f2251 - this.f2255;
                        System.arraycopy(bArr2, this.f2255, bArr, i, i4);
                        this.f2255 += i4;
                    } else {
                        m1327();
                        throw null;
                    }
                    i3 -= i4;
                    if (i3 == 0) {
                        return i2;
                    }
                    if (inputStream.available() == 0) {
                        return i2 - i3;
                    }
                    i += i4;
                }
            } else {
                m1327();
                throw null;
            }
        }
    }
}
