package com.bumptech.glide.load.engine;

import android.util.Log;
import com.bumptech.glide.load.DataSource;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import ඓ.ῲ.K.ᕣ.AbstractC1029;
import ඓ.K.K.K.C1293;

public final class GlideException extends Exception {
    public static final long serialVersionUID = 1;

    /* renamed from: ῲ  reason: contains not printable characters */
    public static final StackTraceElement[] f2235 = new StackTraceElement[0];
    public final List<Throwable> causes;
    public Class<?> dataClass;
    public DataSource dataSource;
    public String detailMessage;
    public Exception exception;
    public AbstractC1029 key;

    public GlideException(String str) {
        this(str, Collections.emptyList());
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public static void m1294(List<Throwable> list, Appendable appendable) throws IOException {
        int size = list.size();
        int i = 0;
        while (i < size) {
            int i2 = i + 1;
            appendable.append("Cause (").append(String.valueOf(i2)).append(" of ").append(String.valueOf(size)).append("): ");
            Throwable th = list.get(i);
            if (th instanceof GlideException) {
                ((GlideException) th).m1297(appendable);
            } else {
                m1295(th, appendable);
            }
            i = i2;
        }
    }

    public Throwable fillInStackTrace() {
        return this;
    }

    public List<Throwable> getCauses() {
        return this.causes;
    }

    public String getMessage() {
        String str;
        String str2;
        StringBuilder sb = new StringBuilder(71);
        sb.append(this.detailMessage);
        String str3 = "";
        if (this.dataClass != null) {
            StringBuilder r1 = C1293.m3416(", ");
            r1.append(this.dataClass);
            str = r1.toString();
        } else {
            str = str3;
        }
        sb.append(str);
        if (this.dataSource != null) {
            StringBuilder r12 = C1293.m3416(", ");
            r12.append(this.dataSource);
            str2 = r12.toString();
        } else {
            str2 = str3;
        }
        sb.append(str2);
        if (this.key != null) {
            StringBuilder r13 = C1293.m3416(", ");
            r13.append(this.key);
            str3 = r13.toString();
        }
        sb.append(str3);
        List<Throwable> rootCauses = getRootCauses();
        if (rootCauses.isEmpty()) {
            return sb.toString();
        }
        if (rootCauses.size() == 1) {
            sb.append("\nThere was 1 cause:");
        } else {
            sb.append("\nThere were ");
            sb.append(rootCauses.size());
            sb.append(" causes:");
        }
        for (Throwable th : rootCauses) {
            sb.append('\n');
            sb.append(th.getClass().getName());
            sb.append('(');
            sb.append(th.getMessage());
            sb.append(')');
        }
        sb.append("\n call GlideException#logRootCauses(String) for more detail");
        return sb.toString();
    }

    public Exception getOrigin() {
        return this.exception;
    }

    public List<Throwable> getRootCauses() {
        ArrayList arrayList = new ArrayList();
        m1298(this, arrayList);
        return arrayList;
    }

    public void logRootCauses(String str) {
        List<Throwable> rootCauses = getRootCauses();
        int size = rootCauses.size();
        int i = 0;
        while (i < size) {
            StringBuilder r3 = C1293.m3416("Root cause (");
            int i2 = i + 1;
            r3.append(i2);
            r3.append(" of ");
            r3.append(size);
            r3.append(")");
            Log.i(str, r3.toString(), rootCauses.get(i));
            i = i2;
        }
    }

    public void printStackTrace() {
        printStackTrace(System.err);
    }

    public void setLoggingDetails(AbstractC1029 r2, DataSource dataSource2) {
        setLoggingDetails(r2, dataSource2, null);
    }

    public void setOrigin(Exception exc) {
        this.exception = exc;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1298(Throwable th, List<Throwable> list) {
        if (th instanceof GlideException) {
            for (Throwable th2 : ((GlideException) th).getCauses()) {
                m1298(th2, list);
            }
            return;
        }
        list.add(th);
    }

    public GlideException(String str, Throwable th) {
        this(str, Collections.singletonList(th));
    }

    @Override // java.lang.Throwable
    public void printStackTrace(PrintStream printStream) {
        m1297(printStream);
    }

    public void setLoggingDetails(AbstractC1029 r1, DataSource dataSource2, Class<?> cls) {
        this.key = r1;
        this.dataSource = dataSource2;
        this.dataClass = cls;
    }

    public GlideException(String str, List<Throwable> list) {
        this.detailMessage = str;
        setStackTrace(f2235);
        this.causes = list;
    }

    @Override // java.lang.Throwable
    public void printStackTrace(PrintWriter printWriter) {
        m1297(printWriter);
    }

    /* renamed from: com.bumptech.glide.load.engine.GlideException$K  reason: contains not printable characters */
    public static final class C0336 implements Appendable {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f2236 = true;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Appendable f2237;

        public C0336(Appendable appendable) {
            this.f2237 = appendable;
        }

        @Override // java.lang.Appendable
        public Appendable append(char c) throws IOException {
            boolean z = false;
            if (this.f2236) {
                this.f2236 = false;
                this.f2237.append("  ");
            }
            if (c == '\n') {
                z = true;
            }
            this.f2236 = z;
            this.f2237.append(c);
            return this;
        }

        @Override // java.lang.Appendable
        public Appendable append(CharSequence charSequence) throws IOException {
            if (charSequence == null) {
                charSequence = "";
            }
            append(charSequence, 0, charSequence.length());
            return this;
        }

        @Override // java.lang.Appendable
        public Appendable append(CharSequence charSequence, int i, int i2) throws IOException {
            if (charSequence == null) {
                charSequence = "";
            }
            boolean z = false;
            if (this.f2236) {
                this.f2236 = false;
                this.f2237.append("  ");
            }
            if (charSequence.length() > 0 && charSequence.charAt(i2 - 1) == '\n') {
                z = true;
            }
            this.f2236 = z;
            this.f2237.append(charSequence, i, i2);
            return this;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m1297(Appendable appendable) {
        m1295(this, appendable);
        m1296(getCauses(), new C0336(appendable));
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m1295(Throwable th, Appendable appendable) {
        try {
            appendable.append(th.getClass().toString()).append(": ").append(th.getMessage()).append('\n');
        } catch (IOException unused) {
            throw new RuntimeException(th);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m1296(List<Throwable> list, Appendable appendable) {
        try {
            m1294(list, appendable);
        } catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}
