package com.appsflyer.share;

import android.content.Context;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.CreateOneLinkHttpTask;
import com.appsflyer.ServerConfigHandler;
import com.facebook.appevents.AppEventsLoggerImpl;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import ඓ.K.K.K.C1293;

public class LinkGenerator {

    /* renamed from: ʻ  reason: contains not printable characters */
    public String f2165;

    /* renamed from: ʼ  reason: contains not printable characters */
    public String f2166;

    /* renamed from: ʽ  reason: contains not printable characters */
    public String f2167;

    /* renamed from: ˊ  reason: contains not printable characters */
    public String f2168;

    /* renamed from: ˊॱ  reason: contains not printable characters */
    public Map<String, String> f2169 = new HashMap();

    /* renamed from: ˋ  reason: contains not printable characters */
    public String f2170;

    /* renamed from: ˎ  reason: contains not printable characters */
    public String f2171;

    /* renamed from: ˏ  reason: contains not printable characters */
    public String f2172;

    /* renamed from: ˏॱ  reason: contains not printable characters */
    public Map<String, String> f2173 = new HashMap();

    /* renamed from: ͺ  reason: contains not printable characters */
    public String f2174;

    /* renamed from: ॱ  reason: contains not printable characters */
    public String f2175;

    /* renamed from: ॱॱ  reason: contains not printable characters */
    public String f2176;

    /* renamed from: ᐝ  reason: contains not printable characters */
    public String f2177;

    public LinkGenerator(String str) {
        this.f2168 = str;
    }

    /* renamed from: ˊ  reason: contains not printable characters */
    private StringBuilder m1261() {
        StringBuilder sb = new StringBuilder();
        String str = this.f2171;
        if (str == null || !str.startsWith("http")) {
            sb.append(ServerConfigHandler.getUrl(Constants.BASE_URL_APP_APPSFLYER_COM));
        } else {
            sb.append(this.f2171);
        }
        if (this.f2170 != null) {
            sb.append('/');
            sb.append(this.f2170);
        }
        this.f2173.put(Constants.URL_MEDIA_SOURCE, this.f2168);
        sb.append('?');
        sb.append("pid=");
        sb.append(m1262(this.f2168, "media source"));
        String str2 = this.f2177;
        if (str2 != null) {
            this.f2173.put(Constants.URL_REFERRER_UID, str2);
            sb.append('&');
            sb.append("af_referrer_uid=");
            sb.append(m1262(this.f2177, "referrerUID"));
        }
        String str3 = this.f2172;
        if (str3 != null) {
            this.f2173.put("af_channel", str3);
            sb.append('&');
            sb.append("af_channel=");
            sb.append(m1262(this.f2172, AppsFlyerProperties.CHANNEL));
        }
        String str4 = this.f2165;
        if (str4 != null) {
            this.f2173.put(Constants.URL_REFERRER_CUSTOMER_ID, str4);
            sb.append('&');
            sb.append("af_referrer_customer_id=");
            sb.append(m1262(this.f2165, "referrerCustomerId"));
        }
        String str5 = this.f2175;
        if (str5 != null) {
            this.f2173.put(Constants.URL_CAMPAIGN, str5);
            sb.append('&');
            sb.append("c=");
            sb.append(m1262(this.f2175, AppEventsLoggerImpl.PUSH_PAYLOAD_CAMPAIGN_KEY));
        }
        String str6 = this.f2176;
        if (str6 != null) {
            this.f2173.put(Constants.URL_REFERRER_NAME, str6);
            sb.append('&');
            sb.append("af_referrer_name=");
            sb.append(m1262(this.f2176, "referrerName"));
        }
        String str7 = this.f2167;
        if (str7 != null) {
            this.f2173.put(Constants.URL_REFERRER_IMAGE_URL, str7);
            sb.append('&');
            sb.append("af_referrer_image_url=");
            sb.append(m1262(this.f2167, "referrerImageURL"));
        }
        if (this.f2174 != null) {
            StringBuilder sb2 = new StringBuilder();
            sb2.append(this.f2174);
            String str8 = "";
            sb2.append(this.f2174.endsWith(Constants.URL_PATH_DELIMITER) ? str8 : Constants.URL_PATH_DELIMITER);
            String str9 = this.f2166;
            if (str9 != null) {
                sb2.append(str9);
            }
            this.f2173.put(Constants.URL_BASE_DEEPLINK, sb2.toString());
            sb.append('&');
            sb.append("af_dp=");
            sb.append(m1262(this.f2174, "baseDeeplink"));
            if (this.f2166 != null) {
                if (!this.f2174.endsWith(Constants.URL_PATH_DELIMITER)) {
                    str8 = "%2F";
                }
                sb.append(str8);
                sb.append(m1262(this.f2166, "deeplinkPath"));
            }
        }
        for (String str10 : this.f2169.keySet()) {
            String obj = sb.toString();
            StringBuilder r5 = C1293.m3402(str10, "=");
            r5.append(m1262(this.f2169.get(str10), str10));
            if (!obj.contains(r5.toString())) {
                sb.append('&');
                sb.append(str10);
                sb.append('=');
                sb.append(m1262(this.f2169.get(str10), str10));
            }
        }
        return sb;
    }

    /* renamed from: ˋ  reason: contains not printable characters */
    public static String m1262(String str, String str2) {
        try {
            return URLEncoder.encode(str, "utf8");
        } catch (UnsupportedEncodingException unused) {
            StringBuilder sb = new StringBuilder("Illegal ");
            sb.append(str2);
            sb.append(": ");
            sb.append(str);
            AFLogger.afInfoLog(sb.toString());
            return "";
        } catch (Throwable unused2) {
            return "";
        }
    }

    public LinkGenerator addParameter(String str, String str2) {
        this.f2169.put(str, str2);
        return this;
    }

    public LinkGenerator addParameters(Map<String, String> map) {
        if (map != null) {
            this.f2169.putAll(map);
        }
        return this;
    }

    public String generateLink() {
        return m1261().toString();
    }

    public String getCampaign() {
        return this.f2175;
    }

    public String getChannel() {
        return this.f2172;
    }

    public String getMediaSource() {
        return this.f2168;
    }

    public Map<String, String> getParameters() {
        return this.f2169;
    }

    public LinkGenerator setBaseDeeplink(String str) {
        this.f2174 = str;
        return this;
    }

    public LinkGenerator setBaseURL(String str, String str2, String str3) {
        if (str == null || str.length() <= 0) {
            this.f2171 = String.format(Constants.AF_BASE_URL_FORMAT, ServerConfigHandler.getUrl(Constants.APPSFLYER_DEFAULT_APP_DOMAIN), str3);
        } else {
            if (str2 == null || str2.length() < 5) {
                str2 = Constants.ONELINK_DEFAULT_DOMAIN;
            }
            this.f2171 = String.format(Constants.AF_BASE_URL_FORMAT, str2, str);
        }
        return this;
    }

    public LinkGenerator setCampaign(String str) {
        this.f2175 = str;
        return this;
    }

    public LinkGenerator setChannel(String str) {
        this.f2172 = str;
        return this;
    }

    public LinkGenerator setDeeplinkPath(String str) {
        this.f2166 = str;
        return this;
    }

    public LinkGenerator setReferrerCustomerId(String str) {
        this.f2165 = str;
        return this;
    }

    public LinkGenerator setReferrerImageURL(String str) {
        this.f2167 = str;
        return this;
    }

    public LinkGenerator setReferrerName(String str) {
        this.f2176 = str;
        return this;
    }

    public LinkGenerator setReferrerUID(String str) {
        this.f2177 = str;
        return this;
    }

    public void generateLink(Context context, CreateOneLinkHttpTask.ResponseListener responseListener) {
        String string = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.ONELINK_ID);
        if (!this.f2169.isEmpty()) {
            for (Map.Entry<String, String> entry : this.f2169.entrySet()) {
                this.f2173.put(entry.getKey(), entry.getValue());
            }
        }
        m1261();
        ShareInviteHelper.generateUserInviteLink(context, string, this.f2173, responseListener);
    }
}
