package com.appsflyer.share;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.AsyncTask;
import com.appsflyer.AFLogger;
import com.appsflyer.AppsFlyerLib;
import com.appsflyer.AppsFlyerProperties;
import com.appsflyer.ServerConfigHandler;
import com.appsflyer.ServerParameters;
import com.appsflyer.internal.ak;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class CrossPromotionHelper {

    public static class c extends AsyncTask<String, Void, Void> {

        /* renamed from: ˋ  reason: contains not printable characters */
        public ak f2162;

        /* renamed from: ˎ  reason: contains not printable characters */
        public boolean f2163;

        /* renamed from: ॱ  reason: contains not printable characters */
        public WeakReference<Context> f2164;

        public c(ak akVar, Context context, boolean z) {
            this.f2162 = akVar;
            this.f2164 = new WeakReference<>(context);
            this.f2163 = z;
        }

        /* access modifiers changed from: private */
        /* renamed from: ˏ  reason: contains not printable characters */
        public Void doInBackground(String... strArr) {
            HttpURLConnection httpURLConnection;
            Throwable th;
            if (this.f2163) {
                return null;
            }
            try {
                String str = strArr[0];
                httpURLConnection = (HttpURLConnection) new URL(str).openConnection();
                try {
                    httpURLConnection.setConnectTimeout(10000);
                    httpURLConnection.setInstanceFollowRedirects(false);
                    int responseCode = httpURLConnection.getResponseCode();
                    if (responseCode == 200) {
                        AFLogger.afInfoLog("Cross promotion impressions success: ".concat(String.valueOf(str)), false);
                    } else {
                        if (responseCode != 301) {
                            if (responseCode != 302) {
                                StringBuilder sb = new StringBuilder("call to ");
                                sb.append(str);
                                sb.append(" failed: ");
                                sb.append(responseCode);
                                AFLogger.afInfoLog(sb.toString());
                            }
                        }
                        AFLogger.afInfoLog("Cross promotion redirection success: ".concat(String.valueOf(str)), false);
                        if (!(this.f2162 == null || this.f2164.get() == null)) {
                            this.f2162.f2029 = httpURLConnection.getHeaderField(Constants.HTTP_REDIRECT_URL_HEADER_FIELD);
                            ak akVar = this.f2162;
                            Context context = this.f2164.get();
                            if (akVar.f2029 != null) {
                                context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse(akVar.f2029)).setFlags(268435456));
                            }
                        }
                    }
                } catch (Throwable th2) {
                    th = th2;
                    try {
                        AFLogger.afErrorLog(th.getMessage(), th, true);
                    } finally {
                        if (httpURLConnection != null) {
                            httpURLConnection.disconnect();
                        }
                    }
                }
            } catch (Throwable th3) {
                th = th3;
                httpURLConnection = null;
                AFLogger.afErrorLog(th.getMessage(), th, true);
            }
            return null;
        }
    }

    public static void trackAndOpenStore(Context context, String str, String str2) {
        trackAndOpenStore(context, str, str2, null);
    }

    public static void trackCrossPromoteImpression(Context context, String str, String str2) {
        if (AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.AF_WAITFOR_CUSTOMERID, false)) {
            AFLogger.afInfoLog("CustomerUserId not set, Promote Impression is disabled", true);
            return;
        }
        LinkGenerator r4 = m1259(context, str, str2, null, ServerConfigHandler.getUrl("https://%simpression.%s"));
        new c(null, null, AppsFlyerLib.getInstance().isTrackingStopped()).execute(r4.generateLink());
    }

    /* renamed from: ˊ  reason: contains not printable characters */
    public static LinkGenerator m1259(Context context, String str, String str2, Map<String, String> map, String str3) {
        LinkGenerator linkGenerator = new LinkGenerator("af_cross_promotion");
        linkGenerator.f2171 = str3;
        linkGenerator.f2170 = str;
        linkGenerator.addParameter(Constants.URL_SITE_ID, context.getPackageName());
        if (str2 != null) {
            linkGenerator.setCampaign(str2);
        }
        if (map != null) {
            linkGenerator.addParameters(map);
        }
        String string = AppsFlyerProperties.getInstance().getString(ServerParameters.ADVERTISING_ID_PARAM);
        if (string != null) {
            linkGenerator.addParameter(Constants.URL_ADVERTISING_ID, string);
        }
        return linkGenerator;
    }

    public static void trackAndOpenStore(Context context, String str, String str2, Map<String, String> map) {
        LinkGenerator r4 = m1259(context, str, str2, map, ServerConfigHandler.getUrl(Constants.BASE_URL_APP_APPSFLYER_COM));
        if (AppsFlyerProperties.getInstance().getBoolean(AppsFlyerProperties.AF_WAITFOR_CUSTOMERID, false)) {
            AFLogger.afInfoLog("CustomerUserId not set, track And Open Store is disabled", true);
            return;
        }
        HashMap hashMap = new HashMap();
        if (map != null) {
            hashMap.putAll(map);
        }
        hashMap.put("af_campaign", str2);
        AppsFlyerLib.getInstance().trackEvent(context, "af_cross_promotion", hashMap);
        new c(new ak(), context, AppsFlyerLib.getInstance().isTrackingStopped()).execute(r4.generateLink());
    }
}
