package com.appsflyer;

import android.text.TextUtils;
import com.appsflyer.internal.ai;
import java.io.IOException;
import java.net.URL;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;

public abstract class OneLinkHttpTask implements Runnable {

    /* renamed from: ˋ  reason: contains not printable characters */
    public AppsFlyerLibCore f1942;

    /* renamed from: ˏ  reason: contains not printable characters */
    public String f1943;

    /* renamed from: ॱ  reason: contains not printable characters */
    public HttpsUrlConnectionProvider f1944;

    public static class HttpsUrlConnectionProvider {
        /* renamed from: ˎ  reason: contains not printable characters */
        public static HttpsURLConnection m1160(String str) throws IOException {
            return (HttpsURLConnection) new URL(str).openConnection();
        }
    }

    public OneLinkHttpTask(AppsFlyerLibCore appsFlyerLibCore) {
        this.f1942 = appsFlyerLibCore;
    }

    /* JADX WARNING: Removed duplicated region for block: B:16:0x00b4  */
    /* JADX WARNING: Removed duplicated region for block: B:18:0x00c5  */
    public void run() {
        String str;
        Throwable th;
        String str2 = "";
        long currentTimeMillis = System.currentTimeMillis() / 1000;
        String r3 = m1159();
        AFLogger.afRDLog("oneLinkUrl: ".concat(String.valueOf(r3)));
        try {
            HttpsURLConnection r4 = HttpsUrlConnectionProvider.m1160(r3);
            r4.addRequestProperty("content-type", "application/json");
            StringBuilder sb = new StringBuilder();
            sb.append(AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.AF_KEY));
            sb.append(currentTimeMillis);
            r4.addRequestProperty("authorization", ai.m1197(sb.toString()));
            r4.addRequestProperty("af-timestamp", String.valueOf(currentTimeMillis));
            r4.setReadTimeout(3000);
            r4.setConnectTimeout(3000);
            m1158(r4);
            int responseCode = r4.getResponseCode();
            str = AppsFlyerLibCore.m1128(r4);
            if (responseCode == 200) {
                try {
                    AFLogger.afInfoLog("Status 200 ok");
                } catch (Throwable th2) {
                    th = th2;
                    AFLogger.afErrorLog("Error while calling ".concat(String.valueOf(r3)), th);
                    StringBuilder sb2 = new StringBuilder("Error while calling ");
                    sb2.append(r3);
                    sb2.append(" stacktrace: ");
                    sb2.append(th.toString());
                    str2 = sb2.toString();
                    if (TextUtils.isEmpty(str2)) {
                    }
                }
            } else {
                StringBuilder sb3 = new StringBuilder("Response code = ");
                sb3.append(responseCode);
                sb3.append(" content = ");
                sb3.append(str);
                str2 = sb3.toString();
            }
        } catch (Throwable th3) {
            th = th3;
            str = str2;
            AFLogger.afErrorLog("Error while calling ".concat(String.valueOf(r3)), th);
            StringBuilder sb22 = new StringBuilder("Error while calling ");
            sb22.append(r3);
            sb22.append(" stacktrace: ");
            sb22.append(th.toString());
            str2 = sb22.toString();
            if (TextUtils.isEmpty(str2)) {
            }
        }
        if (TextUtils.isEmpty(str2)) {
            AFLogger.afInfoLog("Connection call succeeded: ".concat(String.valueOf(str)));
            m1157(str);
            return;
        }
        AFLogger.afWarnLog("Connection error: ".concat(String.valueOf(str2)));
        m1156();
    }

    public void setConnProvider(HttpsUrlConnectionProvider httpsUrlConnectionProvider) {
        this.f1944 = httpsUrlConnectionProvider;
    }

    /* renamed from: ˋ  reason: contains not printable characters */
    public abstract void m1156();

    /* renamed from: ˎ  reason: contains not printable characters */
    public abstract void m1157(String str);

    /* renamed from: ˏ  reason: contains not printable characters */
    public abstract void m1158(HttpsURLConnection httpsURLConnection) throws JSONException, IOException;

    /* renamed from: ॱ  reason: contains not printable characters */
    public abstract String m1159();
}
