package com.appsflyer;

import android.content.Context;
import com.appsflyer.share.Constants;
import com.appsflyer.share.LinkGenerator;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;
import org.json.JSONException;
import org.json.JSONObject;

public class CreateOneLinkHttpTask extends OneLinkHttpTask {

    /* renamed from: ʻ  reason: contains not printable characters */
    public boolean f1936 = false;

    /* renamed from: ʼ  reason: contains not printable characters */
    public Context f1937;

    /* renamed from: ˊ  reason: contains not printable characters */
    public Map<String, String> f1938;

    /* renamed from: ˋ  reason: contains not printable characters */
    public String f1939;

    /* renamed from: ˎ  reason: contains not printable characters */
    public ResponseListener f1940;

    /* renamed from: ॱ  reason: contains not printable characters */
    public String f1941 = "";

    public interface ResponseListener {
        void onResponse(String str);

        void onResponseError(String str);
    }

    public CreateOneLinkHttpTask(String str, Map<String, String> map, AppsFlyerLibCore appsFlyerLibCore, Context context, boolean z) {
        super(appsFlyerLibCore);
        this.f1936 = z;
        this.f1937 = context;
        if (this.f1937 != null) {
            this.f1941 = context.getPackageName();
        } else {
            AFLogger.afWarnLog("CreateOneLinkHttpTask: context can't be null");
        }
        this.f1943 = str;
        this.f1939 = "-1";
        this.f1938 = map;
    }

    public void setListener(ResponseListener responseListener) {
        this.f1940 = responseListener;
    }

    @Override // com.appsflyer.OneLinkHttpTask
    /* renamed from: ˋ  reason: contains not printable characters */
    public final void m1152() {
        LinkGenerator addParameters = new LinkGenerator(Constants.USER_INVITE_LINK_TYPE).setBaseURL(this.f1943, AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.ONELINK_DOMAIN), this.f1941).addParameter(Constants.URL_SITE_ID, this.f1941).addParameters(this.f1938);
        String string = AppsFlyerProperties.getInstance().getString(AppsFlyerProperties.APP_USER_ID);
        if (string != null) {
            addParameters.setReferrerCustomerId(string);
        }
        this.f1940.onResponse(addParameters.generateLink());
    }

    @Override // com.appsflyer.OneLinkHttpTask
    /* renamed from: ˎ  reason: contains not printable characters */
    public final void m1153(String str) {
        try {
            JSONObject jSONObject = new JSONObject(str);
            Iterator<String> keys = jSONObject.keys();
            while (keys.hasNext()) {
                this.f1940.onResponse(jSONObject.optString(keys.next()));
            }
        } catch (JSONException e) {
            this.f1940.onResponseError("Can't parse one link data");
            AFLogger.afErrorLog("Error while parsing to json ".concat(String.valueOf(str)), e);
        }
    }

    @Override // com.appsflyer.OneLinkHttpTask
    /* renamed from: ˏ  reason: contains not printable characters */
    public final void m1154(HttpsURLConnection httpsURLConnection) throws JSONException, IOException {
        if (!this.f1936) {
            httpsURLConnection.setRequestMethod("POST");
            httpsURLConnection.setDoInput(true);
            httpsURLConnection.setDoOutput(true);
            httpsURLConnection.setUseCaches(false);
            JSONObject jSONObject = new JSONObject();
            JSONObject jSONObject2 = new JSONObject(this.f1938);
            jSONObject.put("ttl", this.f1939);
            jSONObject.put("data", jSONObject2);
            httpsURLConnection.connect();
            DataOutputStream dataOutputStream = new DataOutputStream(httpsURLConnection.getOutputStream());
            dataOutputStream.writeBytes(jSONObject.toString());
            dataOutputStream.flush();
            dataOutputStream.close();
        }
    }

    @Override // com.appsflyer.OneLinkHttpTask
    /* renamed from: ॱ  reason: contains not printable characters */
    public final String m1155() {
        StringBuilder sb = new StringBuilder();
        sb.append(ServerConfigHandler.getUrl("https://%sonelink.%s/shortlink-sdk/v1"));
        sb.append(Constants.URL_PATH_DELIMITER);
        sb.append(this.f1943);
        return sb.toString();
    }
}
