package com.appsflyer;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.SharedPreferences;
import com.adjust.sdk.Constants;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class AppsFlyerProperties {
    public static final String ADDITIONAL_CUSTOM_DATA = "additionalCustomData";
    public static final String AF_KEY = "AppsFlyerKey";
    public static final String AF_WAITFOR_CUSTOMERID = "waitForCustomerId";
    public static final String APP_ID = "appid";
    public static final String APP_USER_ID = "AppUserId";
    public static final String CHANNEL = "channel";
    public static final String COLLECT_ANDROID_ID = "collectAndroidId";
    public static final String COLLECT_ANDROID_ID_FORCE_BY_USER = "collectAndroidIdForceByUser";
    public static final String COLLECT_FACEBOOK_ATTR_ID = "collectFacebookAttrId";
    public static final String COLLECT_FINGER_PRINT = "collectFingerPrint";
    public static final String COLLECT_IMEI = "collectIMEI";
    public static final String COLLECT_IMEI_FORCE_BY_USER = "collectIMEIForceByUser";
    public static final String COLLECT_MAC = "collectMAC";
    public static final String COLLECT_OAID = "collectOAID";
    public static final String CURRENCY_CODE = "currencyCode";
    public static final String DEVICE_TRACKING_DISABLED = "deviceTrackingDisabled";
    public static final String DISABLE_KEYSTORE = "keyPropDisableAFKeystore";
    public static final String DISABLE_LOGS_COMPLETELY = "disableLogs";
    public static final String DISABLE_OTHER_SDK = "disableOtherSdk";
    public static final String DPM = "disableProxy";
    public static final String EMAIL_CRYPT_TYPE = "userEmailsCryptType";
    public static final String ENABLE_GPS_FALLBACK = "enableGpsFallback";
    public static final String EXTENSION = "sdkExtension";
    public static final String IS_UPDATE = "IS_UPDATE";
    public static final String LAUNCH_PROTECT_ENABLED = "launchProtectEnabled";
    public static final String NEW_REFERRER_SENT = "newGPReferrerSent";
    public static final String ONELINK_DOMAIN = "onelinkDomain";
    public static final String ONELINK_ID = "oneLinkSlug";
    public static final String ONELINK_SCHEME = "onelinkScheme";
    public static final String USER_EMAIL = "userEmail";
    public static final String USER_EMAILS = "userEmails";
    public static final String USE_HTTP_FALLBACK = "useHttpFallback";

    /* renamed from: ˎ  reason: contains not printable characters */
    public static AppsFlyerProperties f1928 = new AppsFlyerProperties();

    /* renamed from: ʼ  reason: contains not printable characters */
    public boolean f1929 = false;

    /* renamed from: ˊ  reason: contains not printable characters */
    public String f1930;

    /* renamed from: ˋ  reason: contains not printable characters */
    public Map<String, Object> f1931 = Collections.synchronizedMap(new HashMap());

    /* renamed from: ˏ  reason: contains not printable characters */
    public boolean f1932;

    /* renamed from: ॱ  reason: contains not printable characters */
    public boolean f1933;

    public enum EmailsCryptType {
        NONE(0),
        SHA256(3);
        

        /* renamed from: ˎ  reason: contains not printable characters */
        public final int f1935;

        /* access modifiers changed from: public */
        EmailsCryptType(int i) {
            this.f1935 = i;
        }

        public final int getValue() {
            return this.f1935;
        }
    }

    public static AppsFlyerProperties getInstance() {
        return f1928;
    }

    public boolean getBoolean(String str, boolean z) {
        String string = getString(str);
        if (string == null) {
            return z;
        }
        return Boolean.valueOf(string).booleanValue();
    }

    public int getInt(String str, int i) {
        String string = getString(str);
        if (string == null) {
            return i;
        }
        return Integer.valueOf(string).intValue();
    }

    public long getLong(String str, long j) {
        String string = getString(str);
        if (string == null) {
            return j;
        }
        return Long.valueOf(string).longValue();
    }

    public Object getObject(String str) {
        return this.f1931.get(str);
    }

    public String getReferrer(Context context) {
        String str = this.f1930;
        if (str != null) {
            return str;
        }
        if (getString("AF_REFERRER") != null) {
            return getString("AF_REFERRER");
        }
        if (context == null) {
            return null;
        }
        return AppsFlyerLibCore.m1100(context).getString(Constants.REFERRER, null);
    }

    public String getString(String str) {
        return (String) this.f1931.get(str);
    }

    public boolean isEnableLog() {
        return getBoolean("shouldLog", true);
    }

    public boolean isFirstLaunchCalled() {
        return this.f1932;
    }

    public boolean isLogsDisabledCompletely() {
        return getBoolean(DISABLE_LOGS_COMPLETELY, false);
    }

    public boolean isOnReceiveCalled() {
        return this.f1933;
    }

    public boolean isOtherSdkStringDisabled() {
        return getBoolean(DISABLE_OTHER_SDK, false);
    }

    public void loadProperties(Context context) {
        String string;
        if (!this.f1929 && (string = AppsFlyerLibCore.m1100(context).getString("savedProperties", null)) != null) {
            AFLogger.afDebugLog("Loading properties..");
            try {
                JSONObject jSONObject = new JSONObject(string);
                Iterator<String> keys = jSONObject.keys();
                while (keys.hasNext()) {
                    String next = keys.next();
                    if (this.f1931.get(next) == null) {
                        this.f1931.put(next, jSONObject.getString(next));
                    }
                }
                this.f1929 = true;
            } catch (JSONException e) {
                AFLogger.afErrorLog("Failed loading properties", e);
            }
            StringBuilder sb = new StringBuilder("Done loading properties: ");
            sb.append(this.f1929);
            AFLogger.afDebugLog(sb.toString());
        }
    }

    public void remove(String str) {
        this.f1931.remove(str);
    }

    @SuppressLint({"CommitPrefEdits"})
    public void saveProperties(SharedPreferences sharedPreferences) {
        String jSONObject = new JSONObject(this.f1931).toString();
        SharedPreferences.Editor edit = sharedPreferences.edit();
        edit.putString("savedProperties", jSONObject);
        edit.apply();
    }

    public void set(String str, String str2) {
        this.f1931.put(str, str2);
    }

    public void setCustomData(String str) {
        this.f1931.put(ADDITIONAL_CUSTOM_DATA, str);
    }

    public void setFirstLaunchCalled(boolean z) {
        this.f1932 = z;
    }

    public void setOnReceiveCalled() {
        this.f1933 = true;
    }

    public void setReferrer(String str) {
        set("AF_REFERRER", str);
        this.f1930 = str;
    }

    public void setUserEmails(String str) {
        this.f1931.put(USER_EMAILS, str);
    }

    public void set(String str, String[] strArr) {
        this.f1931.put(str, strArr);
    }

    public void setFirstLaunchCalled() {
        this.f1932 = true;
    }

    public void set(String str, int i) {
        this.f1931.put(str, Integer.toString(i));
    }

    public void set(String str, long j) {
        this.f1931.put(str, Long.toString(j));
    }

    public void set(String str, boolean z) {
        this.f1931.put(str, Boolean.toString(z));
    }
}
