package com.appsflyer;

import android.content.Context;
import android.os.Build;
import android.security.KeyPairGeneratorSpec;
import android.security.keystore.KeyGenParameterSpec;
import java.io.IOException;
import java.math.BigInteger;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Calendar;
import java.util.Enumeration;
import javax.security.auth.x500.X500Principal;
import ඓ.K.K.K.C1293;

public class AFKeystoreWrapper {

    /* renamed from: ˊ  reason: contains not printable characters */
    public Context f1862;

    /* renamed from: ˋ  reason: contains not printable characters */
    public String f1863;

    /* renamed from: ˎ  reason: contains not printable characters */
    public int f1864;

    /* renamed from: ˏ  reason: contains not printable characters */
    public KeyStore f1865;

    /* renamed from: ॱ  reason: contains not printable characters */
    public final Object f1866 = new Object();

    public AFKeystoreWrapper(Context context) {
        this.f1862 = context;
        this.f1863 = "";
        this.f1864 = 0;
        AFLogger.afInfoLog("Initialising KeyStore..");
        try {
            this.f1865 = KeyStore.getInstance("AndroidKeyStore");
            this.f1865.load(null);
        } catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            AFLogger.afErrorLog("Couldn't load keystore instance of type: AndroidKeyStore", e);
        }
    }

    /* renamed from: ˊ  reason: contains not printable characters */
    public final void m1077(String str) {
        AFLogger.afInfoLog("Creating a new key with alias: ".concat(String.valueOf(str)));
        try {
            Calendar instance = Calendar.getInstance();
            Calendar instance2 = Calendar.getInstance();
            instance2.add(1, 5);
            AlgorithmParameterSpec algorithmParameterSpec = null;
            synchronized (this.f1866) {
                if (!this.f1865.containsAlias(str)) {
                    if (Build.VERSION.SDK_INT >= 23) {
                        algorithmParameterSpec = new KeyGenParameterSpec.Builder(str, 3).setCertificateSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setCertificateSerialNumber(BigInteger.ONE).setCertificateNotBefore(instance.getTime()).setCertificateNotAfter(instance2.getTime()).build();
                    } else {
                        int i = Build.VERSION.SDK_INT;
                        if (!"OPPO".equals(Build.BRAND)) {
                            algorithmParameterSpec = new KeyPairGeneratorSpec.Builder(this.f1862).setAlias(str).setSubject(new X500Principal("CN=AndroidSDK, O=AppsFlyer")).setSerialNumber(BigInteger.ONE).setStartDate(instance.getTime()).setEndDate(instance2.getTime()).build();
                        }
                    }
                    KeyPairGenerator instance3 = KeyPairGenerator.getInstance("RSA", "AndroidKeyStore");
                    instance3.initialize(algorithmParameterSpec);
                    instance3.generateKeyPair();
                } else {
                    AFLogger.afInfoLog("Alias already exists: ".concat(String.valueOf(str)));
                }
            }
        } catch (Throwable th) {
            StringBuilder sb = new StringBuilder("Exception ");
            sb.append(th.getMessage());
            sb.append(" occurred");
            AFLogger.afErrorLog(sb.toString(), th);
        }
    }

    /* renamed from: ˎ  reason: contains not printable characters */
    public final int m1078() {
        int i;
        synchronized (this.f1866) {
            i = this.f1864;
        }
        return i;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:14:0x0025, code lost:
        r1 = r4.split(",");
     */
    /* JADX WARNING: Code restructure failed: missing block: B:15:0x002d, code lost:
        if (r1.length != 3) goto L_0x008a;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:16:0x002f, code lost:
        com.appsflyer.AFLogger.afInfoLog("Found a matching AF key with alias:\n".concat(r4));
     */
    /* JADX WARNING: Code restructure failed: missing block: B:18:?, code lost:
        r3 = r1[1].trim().split("=");
        r1 = r1[2].trim().split("=");
     */
    /* JADX WARNING: Code restructure failed: missing block: B:19:0x0052, code lost:
        if (r3.length != 2) goto L_0x008b;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:21:0x0055, code lost:
        if (r1.length != 2) goto L_0x008b;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:22:0x0057, code lost:
        r7.f1863 = r3[1].trim();
        r7.f1864 = java.lang.Integer.parseInt(r1[1].trim());
     */
    /* JADX WARNING: Code restructure failed: missing block: B:23:0x006c, code lost:
        r1 = th;
     */
    /* renamed from: ˏ  reason: contains not printable characters */
    public final boolean m1079() {
        boolean z;
        synchronized (this.f1866) {
            z = true;
            if (this.f1865 != null) {
                try {
                    Enumeration<String> aliases = this.f1865.aliases();
                    while (true) {
                        if (aliases.hasMoreElements()) {
                            String nextElement = aliases.nextElement();
                            if (nextElement != null && nextElement.startsWith("com.appsflyer")) {
                                break;
                            }
                        } else {
                            break;
                        }
                    }
                } catch (Throwable th) {
                    Throwable th2 = th;
                    z = false;
                    StringBuilder sb = new StringBuilder("Couldn't list KeyStore Aliases: ");
                    sb.append(th2.getClass().getName());
                    AFLogger.afErrorLog(sb.toString(), th2);
                    return z;
                }
            }
            z = false;
        }
        return z;
    }

    /* renamed from: ॱ  reason: contains not printable characters */
    public final String m1080() {
        String str;
        synchronized (this.f1866) {
            str = this.f1863;
        }
        return str;
    }

    /* renamed from: ˊ  reason: contains not printable characters */
    public final String m1076() {
        StringBuilder r0 = C1293.m3416("com.appsflyer,");
        synchronized (this.f1866) {
            r0.append("KSAppsFlyerId=");
            r0.append(this.f1863);
            r0.append(",");
            r0.append("KSAppsFlyerRICounter=");
            r0.append(this.f1864);
        }
        return r0.toString();
    }
}
