package com.android.installreferrer.api;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import com.android.installreferrer.commons.InstallReferrerCommons;
import com.google.android.finsky.externalreferrer.IGetInstallReferrerService;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.List;

public class InstallReferrerClientImpl extends InstallReferrerClient {

    /* renamed from: ʬ  reason: contains not printable characters */
    public IGetInstallReferrerService f1840;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final Context f1841;

    /* renamed from: K  reason: contains not printable characters */
    public int f1842 = 0;

    /* renamed from: 㸾  reason: contains not printable characters */
    public ServiceConnection f1843;

    @Retention(RetentionPolicy.SOURCE)
    public @interface ClientState {
        public static final int CLOSED = 3;
        public static final int CONNECTED = 2;
        public static final int CONNECTING = 1;
        public static final int DISCONNECTED = 0;
    }

    /* renamed from: com.android.installreferrer.api.InstallReferrerClientImpl$ῲ  reason: contains not printable characters */
    public final class ServiceConnectionC0326 implements ServiceConnection {

        /* renamed from: K  reason: contains not printable characters */
        public final InstallReferrerStateListener f1845;

        public /* synthetic */ ServiceConnectionC0326(InstallReferrerStateListener installReferrerStateListener, C0327 k) {
            if (installReferrerStateListener != null) {
                this.f1845 = installReferrerStateListener;
                return;
            }
            throw new RuntimeException("Please specify a listener to know when setup is done.");
        }

        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            InstallReferrerCommons.logVerbose("InstallReferrerClient", "Install Referrer service connected.");
            InstallReferrerClientImpl.this.f1840 = IGetInstallReferrerService.Stub.b(iBinder);
            InstallReferrerClientImpl.this.f1842 = 2;
            this.f1845.onInstallReferrerSetupFinished(0);
        }

        public void onServiceDisconnected(ComponentName componentName) {
            InstallReferrerCommons.logWarn("InstallReferrerClient", "Install Referrer service disconnected.");
            InstallReferrerClientImpl installReferrerClientImpl = InstallReferrerClientImpl.this;
            installReferrerClientImpl.f1840 = null;
            installReferrerClientImpl.f1842 = 0;
            this.f1845.onInstallReferrerServiceDisconnected();
        }
    }

    public InstallReferrerClientImpl(Context context) {
        this.f1841 = context.getApplicationContext();
    }

    @Override // com.android.installreferrer.api.InstallReferrerClient
    public void endConnection() {
        this.f1842 = 3;
        if (this.f1843 != null) {
            InstallReferrerCommons.logVerbose("InstallReferrerClient", "Unbinding from service.");
            this.f1841.unbindService(this.f1843);
            this.f1843 = null;
        }
        this.f1840 = null;
    }

    @Override // com.android.installreferrer.api.InstallReferrerClient
    public ReferrerDetails getInstallReferrer() throws RemoteException {
        if (isReady()) {
            Bundle bundle = new Bundle();
            bundle.putString("package_name", this.f1841.getPackageName());
            try {
                return new ReferrerDetails(this.f1840.c(bundle));
            } catch (RemoteException e) {
                InstallReferrerCommons.logWarn("InstallReferrerClient", "RemoteException getting install referrer information");
                this.f1842 = 0;
                throw e;
            }
        } else {
            throw new IllegalStateException("Service not connected. Please start a connection before using the service.");
        }
    }

    @Override // com.android.installreferrer.api.InstallReferrerClient
    public boolean isReady() {
        return (this.f1842 != 2 || this.f1840 == null || this.f1843 == null) ? false : true;
    }

    /* JADX WARNING: Removed duplicated region for block: B:29:0x0087  */
    @Override // com.android.installreferrer.api.InstallReferrerClient
    public void startConnection(InstallReferrerStateListener installReferrerStateListener) {
        ResolveInfo resolveInfo;
        ServiceInfo serviceInfo;
        boolean z;
        if (isReady()) {
            InstallReferrerCommons.logVerbose("InstallReferrerClient", "Service connection is valid. No need to re-initialize.");
            installReferrerStateListener.onInstallReferrerSetupFinished(0);
            return;
        }
        int i = this.f1842;
        if (i == 1) {
            InstallReferrerCommons.logWarn("InstallReferrerClient", "Client is already in the process of connecting to the service.");
            installReferrerStateListener.onInstallReferrerSetupFinished(3);
        } else if (i == 3) {
            InstallReferrerCommons.logWarn("InstallReferrerClient", "Client was already closed and can't be reused. Please create another instance.");
            installReferrerStateListener.onInstallReferrerSetupFinished(3);
        } else {
            InstallReferrerCommons.logVerbose("InstallReferrerClient", "Starting install referrer service setup.");
            Intent intent = new Intent("com.google.android.finsky.BIND_GET_INSTALL_REFERRER_SERVICE");
            intent.setComponent(new ComponentName("com.android.vending", "com.google.android.finsky.externalreferrer.GetInstallReferrerService"));
            List<ResolveInfo> queryIntentServices = this.f1841.getPackageManager().queryIntentServices(intent, 0);
            if (queryIntentServices == null || queryIntentServices.isEmpty() || (serviceInfo = (resolveInfo = queryIntentServices.get(0)).serviceInfo) == null) {
                this.f1842 = 0;
                InstallReferrerCommons.logVerbose("InstallReferrerClient", "Install Referrer service unavailable on device.");
                installReferrerStateListener.onInstallReferrerSetupFinished(2);
                return;
            }
            String str = serviceInfo.packageName;
            String str2 = resolveInfo.serviceInfo.name;
            if ("com.android.vending".equals(str) && str2 != null) {
                try {
                    if (this.f1841.getPackageManager().getPackageInfo("com.android.vending", 128).versionCode >= 80837300) {
                        z = true;
                        if (z) {
                            Intent intent2 = new Intent(intent);
                            this.f1843 = new ServiceConnectionC0326(installReferrerStateListener, null);
                            try {
                                if (this.f1841.bindService(intent2, this.f1843, 1)) {
                                    InstallReferrerCommons.logVerbose("InstallReferrerClient", "Service was bonded successfully.");
                                    return;
                                }
                                InstallReferrerCommons.logWarn("InstallReferrerClient", "Connection to service is blocked.");
                                this.f1842 = 0;
                                installReferrerStateListener.onInstallReferrerSetupFinished(1);
                                return;
                            } catch (SecurityException unused) {
                                InstallReferrerCommons.logWarn("InstallReferrerClient", "No permission to connect to service.");
                                this.f1842 = 0;
                                installReferrerStateListener.onInstallReferrerSetupFinished(4);
                                return;
                            }
                        }
                    }
                } catch (PackageManager.NameNotFoundException unused2) {
                }
                z = false;
                if (z) {
                }
            }
            InstallReferrerCommons.logWarn("InstallReferrerClient", "Play Store missing or incompatible. Version 8.3.73 or later required.");
            this.f1842 = 0;
            installReferrerStateListener.onInstallReferrerSetupFinished(2);
        }
    }
}
