package com.adjust.sdk;

import android.content.Context;
import android.content.SharedPreferences;
import android.net.Uri;
import org.json.JSONArray;
import org.json.JSONException;

public class SharedPreferencesManager {
    public static final int INDEX_CLICK_TIME = 1;
    public static final int INDEX_IS_SENDING = 2;
    public static final int INDEX_RAW_REFERRER = 0;
    public static final String PREFS_KEY_DEEPLINK_CLICK_TIME = "deeplink_click_time";
    public static final String PREFS_KEY_DEEPLINK_URL = "deeplink_url";
    public static final String PREFS_KEY_DISABLE_THIRD_PARTY_SHARING = "disable_third_party_sharing";
    public static final String PREFS_KEY_GDPR_FORGET_ME = "gdpr_forget_me";
    public static final String PREFS_KEY_INSTALL_TRACKED = "install_tracked";
    public static final String PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS = "preinstall_payload_read_status";
    public static final String PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER = "preinstall_system_installer_referrer";
    public static final String PREFS_KEY_PUSH_TOKEN = "push_token";
    public static final String PREFS_KEY_RAW_REFERRERS = "raw_referrers";
    public static final String PREFS_NAME = "adjust_preferences";
    public static final int REFERRERS_COUNT = 10;
    public static SharedPreferencesManager defaultInstance;
    public static SharedPreferences sharedPreferences;
    public static SharedPreferences.Editor sharedPreferencesEditor;

    public SharedPreferencesManager(Context context) {
        try {
            SharedPreferences sharedPreferences2 = context.getSharedPreferences(PREFS_NAME, 0);
            sharedPreferences = sharedPreferences2;
            sharedPreferencesEditor = sharedPreferences2.edit();
        } catch (Exception e) {
            AdjustFactory.getLogger().error("Cannot access to SharedPreferences", e.getMessage());
            sharedPreferences = null;
            sharedPreferencesEditor = null;
        }
    }

    private synchronized boolean getBoolean(String str, boolean z) {
        SharedPreferences sharedPreferences2 = sharedPreferences;
        if (sharedPreferences2 == null) {
            return z;
        }
        try {
            return sharedPreferences2.getBoolean(str, z);
        } catch (ClassCastException unused) {
            return z;
        }
    }

    public static synchronized SharedPreferencesManager getDefaultInstance(Context context) {
        SharedPreferencesManager sharedPreferencesManager;
        synchronized (SharedPreferencesManager.class) {
            if (defaultInstance == null) {
                defaultInstance = new SharedPreferencesManager(context);
            }
            sharedPreferencesManager = defaultInstance;
        }
        return sharedPreferencesManager;
    }

    private synchronized long getLong(String str, long j) {
        SharedPreferences sharedPreferences2 = sharedPreferences;
        if (sharedPreferences2 == null) {
            return j;
        }
        try {
            return sharedPreferences2.getLong(str, j);
        } catch (ClassCastException unused) {
            return j;
        }
    }

    /* JADX WARNING: Exception block dominator not found, dom blocks: [] */
    private synchronized int getRawReferrerIndex(String str, long j) {
        JSONArray rawReferrerArray = getRawReferrerArray();
        for (int i = 0; i < rawReferrerArray.length(); i++) {
            JSONArray jSONArray = rawReferrerArray.getJSONArray(i);
            String optString = jSONArray.optString(0, null);
            if (optString != null) {
                if (optString.equals(str)) {
                    if (jSONArray.optLong(1, -1) == j) {
                        return i;
                    }
                }
            }
        }
        return -1;
    }

    private synchronized String getString(String str) {
        SharedPreferences sharedPreferences2 = sharedPreferences;
        if (sharedPreferences2 == null) {
            return null;
        }
        try {
            return sharedPreferences2.getString(str, null);
        } catch (ClassCastException unused) {
            return null;
        } catch (Throwable unused2) {
            if (str.equals(PREFS_KEY_RAW_REFERRERS)) {
                remove(PREFS_KEY_RAW_REFERRERS);
            }
            return null;
        }
    }

    private synchronized void remove(String str) {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.remove(str).apply();
        }
    }

    private synchronized void saveBoolean(String str, boolean z) {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.putBoolean(str, z).apply();
        }
    }

    private synchronized void saveInteger(String str, int i) {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.putInt(str, i).apply();
        }
    }

    private synchronized void saveLong(String str, long j) {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.putLong(str, j).apply();
        }
    }

    private synchronized void saveString(String str, String str2) {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.putString(str, str2).apply();
        }
    }

    public synchronized void clear() {
        SharedPreferences.Editor editor = sharedPreferencesEditor;
        if (editor != null) {
            editor.clear().apply();
        }
    }

    public synchronized long getDeeplinkClickTime() {
        return getLong(PREFS_KEY_DEEPLINK_CLICK_TIME, -1);
    }

    public synchronized String getDeeplinkUrl() {
        return getString(PREFS_KEY_DEEPLINK_URL);
    }

    public synchronized boolean getDisableThirdPartySharing() {
        return getBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, false);
    }

    public synchronized boolean getGdprForgetMe() {
        return getBoolean(PREFS_KEY_GDPR_FORGET_ME, false);
    }

    public synchronized boolean getInstallTracked() {
        return getBoolean(PREFS_KEY_INSTALL_TRACKED, false);
    }

    public synchronized long getPreinstallPayloadReadStatus() {
        return getLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, 0);
    }

    public synchronized String getPreinstallReferrer() {
        return getString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized String getPushToken() {
        return getString(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized JSONArray getRawReferrer(String str, long j) {
        int rawReferrerIndex = getRawReferrerIndex(str, j);
        if (rawReferrerIndex >= 0) {
            try {
                return getRawReferrerArray().getJSONArray(rawReferrerIndex);
            } catch (JSONException unused) {
            }
        }
        return null;
    }

    public synchronized JSONArray getRawReferrerArray() {
        String string = getString(PREFS_KEY_RAW_REFERRERS);
        if (string != null) {
            JSONArray jSONArray = new JSONArray(string);
            if (jSONArray.length() > 10) {
                JSONArray jSONArray2 = new JSONArray();
                for (int i = 0; i < 10; i++) {
                    jSONArray2.put(jSONArray.get(i));
                }
                saveRawReferrerArray(jSONArray2);
                return jSONArray2;
            }
            try {
                return new JSONArray(string);
            } catch (JSONException unused) {
            }
        }
        return new JSONArray();
    }

    public synchronized void removeDeeplink() {
        remove(PREFS_KEY_DEEPLINK_URL);
        remove(PREFS_KEY_DEEPLINK_CLICK_TIME);
    }

    public synchronized void removeDisableThirdPartySharing() {
        remove(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING);
    }

    public synchronized void removeGdprForgetMe() {
        remove(PREFS_KEY_GDPR_FORGET_ME);
    }

    public synchronized void removePreinstallReferrer() {
        remove(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER);
    }

    public synchronized void removePushToken() {
        remove(PREFS_KEY_PUSH_TOKEN);
    }

    public synchronized void removeRawReferrer(String str, long j) {
        if (str != null) {
            if (str.length() != 0) {
                int rawReferrerIndex = getRawReferrerIndex(str, j);
                if (rawReferrerIndex >= 0) {
                    JSONArray rawReferrerArray = getRawReferrerArray();
                    JSONArray jSONArray = new JSONArray();
                    for (int i = 0; i < rawReferrerArray.length(); i++) {
                        if (i != rawReferrerIndex) {
                            try {
                                jSONArray.put(rawReferrerArray.getJSONArray(i));
                            } catch (JSONException unused) {
                            }
                        }
                    }
                    saveString(PREFS_KEY_RAW_REFERRERS, jSONArray.toString());
                }
            }
        }
    }

    public synchronized void saveDeeplink(Uri uri, long j) {
        if (uri != null) {
            saveString(PREFS_KEY_DEEPLINK_URL, uri.toString());
            saveLong(PREFS_KEY_DEEPLINK_CLICK_TIME, j);
        }
    }

    public synchronized void savePreinstallReferrer(String str) {
        saveString(PREFS_KEY_PREINSTALL_SYSTEM_INSTALLER_REFERRER, str);
    }

    public synchronized void savePushToken(String str) {
        saveString(PREFS_KEY_PUSH_TOKEN, str);
    }

    /* JADX WARNING: Exception block dominator not found, dom blocks: [] */
    public synchronized void saveRawReferrer(String str, long j) {
        if (getRawReferrer(str, j) == null) {
            JSONArray rawReferrerArray = getRawReferrerArray();
            if (rawReferrerArray.length() != 10) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put(0, str);
                jSONArray.put(1, j);
                jSONArray.put(2, 0);
                rawReferrerArray.put(jSONArray);
                saveRawReferrerArray(rawReferrerArray);
            }
        }
    }

    public synchronized void saveRawReferrerArray(JSONArray jSONArray) {
        try {
            saveString(PREFS_KEY_RAW_REFERRERS, jSONArray.toString());
        } catch (Throwable unused) {
            remove(PREFS_KEY_RAW_REFERRERS);
        }
        return;
    }

    public synchronized void setDisableThirdPartySharing() {
        saveBoolean(PREFS_KEY_DISABLE_THIRD_PARTY_SHARING, true);
    }

    public synchronized void setGdprForgetMe() {
        saveBoolean(PREFS_KEY_GDPR_FORGET_ME, true);
    }

    public synchronized void setInstallTracked() {
        saveBoolean(PREFS_KEY_INSTALL_TRACKED, true);
    }

    public synchronized void setPreinstallPayloadReadStatus(long j) {
        saveLong(PREFS_KEY_PREINSTALL_PAYLOAD_READ_STATUS, j);
    }

    /* JADX WARNING: Exception block dominator not found, dom blocks: [] */
    public synchronized void setSendingReferrersAsNotSent() {
        JSONArray rawReferrerArray = getRawReferrerArray();
        boolean z = false;
        for (int i = 0; i < rawReferrerArray.length(); i++) {
            JSONArray jSONArray = rawReferrerArray.getJSONArray(i);
            if (jSONArray.optInt(2, -1) == 1) {
                jSONArray.put(2, 0);
                z = true;
            }
        }
        if (z) {
            saveRawReferrerArray(rawReferrerArray);
        }
    }
}
