package com.adjust.sdk;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import java.io.IOException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class GooglePlayServicesClient {

    public static final class GooglePlayServicesInfo {
        public final String gpsAdid;
        public final Boolean trackingEnabled;

        public GooglePlayServicesInfo(String str, Boolean bool) {
            this.gpsAdid = str;
            this.trackingEnabled = bool;
        }

        public String getGpsAdid() {
            return this.gpsAdid;
        }

        public Boolean isTrackingEnabled() {
            return this.trackingEnabled;
        }
    }

    public static final class a implements ServiceConnection {
        public long a;
        public boolean b = false;
        public final LinkedBlockingQueue<IBinder> c = new LinkedBlockingQueue<>(1);

        public a(long j) {
            this.a = j;
        }

        public final IBinder a() {
            if (!this.b) {
                this.b = true;
                return this.c.poll(this.a, TimeUnit.MILLISECONDS);
            }
            throw new IllegalStateException();
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            try {
                this.c.put(iBinder);
            } catch (InterruptedException unused) {
            }
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }
    }

    /* JADX INFO: finally extract failed */
    public static GooglePlayServicesInfo getGooglePlayServicesInfo(Context context, long j) {
        if (Looper.myLooper() != Looper.getMainLooper()) {
            try {
                boolean z = false;
                context.getPackageManager().getPackageInfo("com.android.vending", 0);
                a aVar = new a(j);
                Intent intent = new Intent("com.google.android.gms.ads.identifier.service.START");
                intent.setPackage("com.google.android.gms");
                if (context.bindService(intent, aVar, 1)) {
                    try {
                        IBinder a2 = aVar.a();
                        Parcel obtain = Parcel.obtain();
                        Parcel obtain2 = Parcel.obtain();
                        try {
                            obtain.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                            a2.transact(1, obtain, obtain2, 0);
                            obtain2.readException();
                            String readString = obtain2.readString();
                            obtain2.recycle();
                            obtain.recycle();
                            Parcel obtain3 = Parcel.obtain();
                            Parcel obtain4 = Parcel.obtain();
                            try {
                                obtain3.writeInterfaceToken("com.google.android.gms.ads.identifier.internal.IAdvertisingIdService");
                                obtain3.writeInt(1);
                                a2.transact(2, obtain3, obtain4, 0);
                                obtain4.readException();
                                if (obtain4.readInt() != 0) {
                                    z = true;
                                }
                                Boolean valueOf = Boolean.valueOf(z);
                                GooglePlayServicesInfo googlePlayServicesInfo = new GooglePlayServicesInfo(readString, valueOf != null ? Boolean.valueOf(!valueOf.booleanValue()) : null);
                                context.unbindService(aVar);
                                return googlePlayServicesInfo;
                            } finally {
                                obtain4.recycle();
                                obtain3.recycle();
                            }
                        } catch (Throwable th) {
                            obtain2.recycle();
                            obtain.recycle();
                            throw th;
                        }
                    } catch (Exception e) {
                        throw e;
                    } catch (Throwable th2) {
                        context.unbindService(aVar);
                        throw th2;
                    }
                } else {
                    throw new IOException("Google Play connection failed");
                }
            } catch (Exception e2) {
                throw e2;
            }
        } else {
            throw new IllegalStateException("Google Play Services info can't be accessed from the main thread");
        }
    }
}
