package butterknife;

import android.app.Activity;
import android.view.View;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;
import ඓ.K.K.K.C1293;

public final class ButterKnife {

    /* renamed from: K  reason: contains not printable characters */
    public static final Map<Class<?>, Constructor<? extends Unbinder>> f1835 = new LinkedHashMap();

    public ButterKnife() {
        throw new AssertionError("No instances.");
    }

    /* renamed from: K  reason: contains not printable characters */
    public static Unbinder m1066(Activity activity) {
        return m1067(activity, activity.getWindow().getDecorView());
    }

    /* renamed from: K  reason: contains not printable characters */
    public static Unbinder m1067(Object obj, View view) {
        Constructor<? extends Unbinder> r1 = m1068(obj.getClass());
        if (r1 == null) {
            return Unbinder.f1839;
        }
        try {
            return (Unbinder) r1.newInstance(obj, view);
        } catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to invoke " + r1, e);
        } catch (InstantiationException e2) {
            throw new RuntimeException("Unable to invoke " + r1, e2);
        } catch (InvocationTargetException e3) {
            Throwable cause = e3.getCause();
            if (cause instanceof RuntimeException) {
                throw ((RuntimeException) cause);
            } else if (cause instanceof Error) {
                throw ((Error) cause);
            } else {
                throw new RuntimeException("Unable to create binding instance.", cause);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static Constructor<? extends Unbinder> m1068(Class<?> cls) {
        Constructor<? extends Unbinder> constructor;
        Constructor<? extends Unbinder> constructor2 = f1835.get(cls);
        if (constructor2 != null || f1835.containsKey(cls)) {
            return constructor2;
        }
        String name = cls.getName();
        if (name.startsWith("android.") || name.startsWith("java.") || name.startsWith("androidx.")) {
            return null;
        }
        try {
            ClassLoader classLoader = cls.getClassLoader();
            constructor = classLoader.loadClass(name + "_ViewBinding").getConstructor(cls, View.class);
        } catch (ClassNotFoundException unused) {
            constructor = m1068(cls.getSuperclass());
        } catch (NoSuchMethodException e) {
            throw new RuntimeException(C1293.m3412("Unable to find binding constructor for ", name), e);
        }
        f1835.put(cls, constructor);
        return constructor;
    }
}
