package androidx.viewpager.widget;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import ῲ.ᨨ.ῲ.C1806;

public class PagerTabStrip extends PagerTitleStrip {

    /* renamed from: Ԛ  reason: contains not printable characters */
    public int f1683;

    /* renamed from: ݜ  reason: contains not printable characters */
    public int f1684;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public float f1685;

    /* renamed from: ሽ  reason: contains not printable characters */
    public int f1686;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public final Rect f1687;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public int f1688;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public boolean f1689;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public float f1690;

    /* renamed from: ゎ  reason: contains not printable characters */
    public int f1691;

    /* renamed from: ト  reason: contains not printable characters */
    public boolean f1692;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f1693;

    /* renamed from: 㮔  reason: contains not printable characters */
    public boolean f1694;

    /* renamed from: 㴪  reason: contains not printable characters */
    public final Paint f1695;

    /* renamed from: 㶋  reason: contains not printable characters */
    public int f1696;

    /* renamed from: 䀟  reason: contains not printable characters */
    public int f1697;

    /* renamed from: 䃖  reason: contains not printable characters */
    public int f1698;

    /* renamed from: androidx.viewpager.widget.PagerTabStrip$ῲ  reason: contains not printable characters */
    public class View$OnClickListenerC0291 implements View.OnClickListener {
        public View$OnClickListenerC0291() {
        }

        public void onClick(View view) {
            ViewPager viewPager = PagerTabStrip.this.f1708;
            viewPager.setCurrentItem(viewPager.getCurrentItem() + 1);
        }
    }

    /* renamed from: androidx.viewpager.widget.PagerTabStrip$K  reason: contains not printable characters */
    public class View$OnClickListenerC0292 implements View.OnClickListener {
        public View$OnClickListenerC0292() {
        }

        public void onClick(View view) {
            ViewPager viewPager = PagerTabStrip.this.f1708;
            viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
        }
    }

    public PagerTabStrip(Context context) {
        this(context, null);
    }

    public boolean getDrawFullUnderline() {
        return this.f1692;
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    public int getMinHeight() {
        return Math.max(super.getMinHeight(), this.f1696);
    }

    public int getTabIndicatorColor() {
        return this.f1693;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        int height = getHeight();
        int left = this.f1714.getLeft() - this.f1688;
        int right = this.f1714.getRight() + this.f1688;
        this.f1695.setColor((this.f1691 << 24) | (this.f1693 & 16777215));
        float f = (float) height;
        canvas.drawRect((float) left, (float) (height - this.f1684), (float) right, f, this.f1695);
        if (this.f1692) {
            this.f1695.setColor(-16777216 | (this.f1693 & 16777215));
            canvas.drawRect((float) getPaddingLeft(), (float) (height - this.f1698), (float) (getWidth() - getPaddingRight()), f, this.f1695);
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action != 0 && this.f1689) {
            return false;
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        if (action == 0) {
            this.f1685 = x;
            this.f1690 = y;
            this.f1689 = false;
        } else if (action != 1) {
            if (action == 2 && (Math.abs(x - this.f1685) > ((float) this.f1686) || Math.abs(y - this.f1690) > ((float) this.f1686))) {
                this.f1689 = true;
            }
        } else if (x < ((float) (this.f1714.getLeft() - this.f1688))) {
            ViewPager viewPager = this.f1708;
            viewPager.setCurrentItem(viewPager.getCurrentItem() - 1);
        } else if (x > ((float) (this.f1714.getRight() + this.f1688))) {
            ViewPager viewPager2 = this.f1708;
            viewPager2.setCurrentItem(viewPager2.getCurrentItem() + 1);
        }
        return true;
    }

    public void setBackgroundColor(int i) {
        super.setBackgroundColor(i);
        if (!this.f1694) {
            this.f1692 = (i & -16777216) == 0;
        }
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        if (!this.f1694) {
            this.f1692 = drawable == null;
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        if (!this.f1694) {
            this.f1692 = i == 0;
        }
    }

    public void setDrawFullUnderline(boolean z) {
        this.f1692 = z;
        this.f1694 = true;
        invalidate();
    }

    public void setPadding(int i, int i2, int i3, int i4) {
        int i5 = this.f1697;
        if (i4 < i5) {
            i4 = i5;
        }
        super.setPadding(i, i2, i3, i4);
    }

    public void setTabIndicatorColor(int i) {
        this.f1693 = i;
        this.f1695.setColor(this.f1693);
        invalidate();
    }

    public void setTabIndicatorColorResource(int i) {
        setTabIndicatorColor(C1806.m4686(getContext(), i));
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    public void setTextSpacing(int i) {
        int i2 = this.f1683;
        if (i < i2) {
            i = i2;
        }
        super.setTextSpacing(i);
    }

    @Override // androidx.viewpager.widget.PagerTitleStrip
    /* renamed from: K  reason: contains not printable characters */
    public void m978(int i, float f, boolean z) {
        Rect rect = this.f1687;
        int height = getHeight();
        int left = this.f1714.getLeft() - this.f1688;
        int right = this.f1714.getRight() + this.f1688;
        int i2 = height - this.f1684;
        rect.set(left, i2, right, height);
        super.m980(i, f, z);
        this.f1691 = (int) (Math.abs(f - 0.5f) * 2.0f * 255.0f);
        rect.union(this.f1714.getLeft() - this.f1688, i2, this.f1714.getRight() + this.f1688, height);
        invalidate(rect);
    }

    public PagerTabStrip(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f1695 = new Paint();
        this.f1687 = new Rect();
        this.f1691 = BaseProgressIndicator.MAX_ALPHA;
        this.f1692 = false;
        this.f1694 = false;
        this.f1693 = this.f1711;
        this.f1695.setColor(this.f1693);
        float f = context.getResources().getDisplayMetrics().density;
        this.f1684 = (int) ((3.0f * f) + 0.5f);
        this.f1697 = (int) ((6.0f * f) + 0.5f);
        this.f1683 = (int) (64.0f * f);
        this.f1688 = (int) ((16.0f * f) + 0.5f);
        this.f1698 = (int) ((1.0f * f) + 0.5f);
        this.f1696 = (int) ((f * 32.0f) + 0.5f);
        this.f1686 = ViewConfiguration.get(context).getScaledTouchSlop();
        setPadding(getPaddingLeft(), getPaddingTop(), getPaddingRight(), getPaddingBottom());
        setTextSpacing(getTextSpacing());
        setWillNotDraw(false);
        this.f1703.setFocusable(true);
        this.f1703.setOnClickListener(new View$OnClickListenerC0292());
        this.f1705.setFocusable(true);
        this.f1705.setOnClickListener(new View$OnClickListenerC0291());
        if (getBackground() == null) {
            this.f1692 = true;
        }
    }
}
