package androidx.slidingpanelayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.customview.view.AbsSavedState;
import java.util.ArrayList;
import ῲ.ᕣ.K.C1698;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.ῲ.C1806;

public class SlidingPaneLayout extends ViewGroup {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f1603;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public float f1604;

    /* renamed from: ؿ  reason: contains not printable characters */
    public final C1698 f1605;

    /* renamed from: ݜ  reason: contains not printable characters */
    public final Rect f1606;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Drawable f1607;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public boolean f1608;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f1609;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public float f1610;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f1611;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean f1612;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f1613;

    /* renamed from: 㗗  reason: contains not printable characters */
    public float f1614;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f1615;

    /* renamed from: 㳳  reason: contains not printable characters */
    public float f1616;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final int f1617;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Drawable f1618;

    /* renamed from: 㿎  reason: contains not printable characters */
    public View f1619;

    /* renamed from: 䀟  reason: contains not printable characters */
    public final ArrayList<RunnableC0279> f1620;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f1621;

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0276();

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1622;

        /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$SavedState$K  reason: contains not printable characters */
        public static class C0276 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, null);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f1622 ? 1 : 0);
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1622 = parcel.readInt() != 0;
        }
    }

    /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$ʬ  reason: contains not printable characters */
    public class C0277 extends C1698.AbstractC1699 {
        public C0277() {
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int clampViewPositionHorizontal(View view, int i, int i2) {
            C0281 r2 = (C0281) SlidingPaneLayout.this.f1619.getLayoutParams();
            if (SlidingPaneLayout.this.m953()) {
                int width = SlidingPaneLayout.this.getWidth() - (SlidingPaneLayout.this.f1619.getWidth() + (SlidingPaneLayout.this.getPaddingRight() + ((ViewGroup.MarginLayoutParams) r2).rightMargin));
                return Math.max(Math.min(i, width), width - SlidingPaneLayout.this.f1609);
            }
            int paddingLeft = SlidingPaneLayout.this.getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r2).leftMargin;
            return Math.min(Math.max(i, paddingLeft), SlidingPaneLayout.this.f1609 + paddingLeft);
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int clampViewPositionVertical(View view, int i, int i2) {
            return view.getTop();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int getViewHorizontalDragRange(View view) {
            return SlidingPaneLayout.this.f1609;
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onEdgeDragStarted(int i, int i2) {
            SlidingPaneLayout slidingPaneLayout = SlidingPaneLayout.this;
            slidingPaneLayout.f1605.m4365(slidingPaneLayout.f1619, i2);
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewCaptured(View view, int i) {
            SlidingPaneLayout.this.m960();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewDragStateChanged(int i) {
            SlidingPaneLayout slidingPaneLayout = SlidingPaneLayout.this;
            if (slidingPaneLayout.f1605.f5982 != 0) {
                return;
            }
            if (slidingPaneLayout.f1610 == 0.0f) {
                slidingPaneLayout.m961(slidingPaneLayout.f1619);
                SlidingPaneLayout slidingPaneLayout2 = SlidingPaneLayout.this;
                slidingPaneLayout2.m956(slidingPaneLayout2.f1619);
                SlidingPaneLayout.this.f1608 = false;
                return;
            }
            slidingPaneLayout.m952(slidingPaneLayout.f1619);
            SlidingPaneLayout.this.f1608 = true;
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewPositionChanged(View view, int i, int i2, int i3, int i4) {
            SlidingPaneLayout.this.m951(i);
            SlidingPaneLayout.this.invalidate();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewReleased(View view, float f, float f2) {
            int i;
            C0281 r6 = (C0281) view.getLayoutParams();
            if (SlidingPaneLayout.this.m953()) {
                int paddingRight = SlidingPaneLayout.this.getPaddingRight() + ((ViewGroup.MarginLayoutParams) r6).rightMargin;
                if (f < 0.0f || (f == 0.0f && SlidingPaneLayout.this.f1610 > 0.5f)) {
                    paddingRight += SlidingPaneLayout.this.f1609;
                }
                i = (SlidingPaneLayout.this.getWidth() - paddingRight) - SlidingPaneLayout.this.f1619.getWidth();
            } else {
                i = ((ViewGroup.MarginLayoutParams) r6).leftMargin + SlidingPaneLayout.this.getPaddingLeft();
                int i2 = (f > 0.0f ? 1 : (f == 0.0f ? 0 : -1));
                if (i2 > 0 || (i2 == 0 && SlidingPaneLayout.this.f1610 > 0.5f)) {
                    i += SlidingPaneLayout.this.f1609;
                }
            }
            SlidingPaneLayout.this.f1605.m4354(i, view.getTop());
            SlidingPaneLayout.this.invalidate();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public boolean tryCaptureView(View view, int i) {
            if (SlidingPaneLayout.this.f1613) {
                return false;
            }
            return ((C0281) view.getLayoutParams()).f1630;
        }
    }

    /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$ඓ  reason: contains not printable characters */
    public interface AbstractC0278 {
    }

    /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$ῲ  reason: contains not printable characters */
    public class RunnableC0279 implements Runnable {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final View f1625;

        public RunnableC0279(View view) {
            this.f1625 = view;
        }

        public void run() {
            if (this.f1625.getParent() == SlidingPaneLayout.this) {
                this.f1625.setLayerType(0, null);
                SlidingPaneLayout.this.m962(this.f1625);
            }
            SlidingPaneLayout.this.f1620.remove(this);
        }
    }

    /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$K  reason: contains not printable characters */
    public class C0280 extends C1747 {

        /* renamed from: K  reason: contains not printable characters */
        public final Rect f1627 = new Rect();

        public C0280() {
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName(SlidingPaneLayout.class.getName());
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityNodeInfo(View view, C1782 r5) {
            C1782 r1 = new C1782(AccessibilityNodeInfo.obtain(r5.f6124));
            super.onInitializeAccessibilityNodeInfo(view, r1);
            Rect rect = this.f1627;
            r1.f6124.getBoundsInParent(rect);
            r5.f6124.setBoundsInParent(rect);
            r1.f6124.getBoundsInScreen(rect);
            r5.f6124.setBoundsInScreen(rect);
            int i = Build.VERSION.SDK_INT;
            r5.m4648(r1.f6124.isVisibleToUser());
            r5.f6124.setPackageName(r1.m4649());
            r5.f6124.setClassName(r1.m4652());
            r5.f6124.setContentDescription(r1.m4647());
            r5.f6124.setEnabled(r1.m4671());
            r5.f6124.setClickable(r1.m4657());
            r5.f6124.setFocusable(r1.m4651());
            r5.f6124.setFocused(r1.m4668());
            int i2 = Build.VERSION.SDK_INT;
            r5.m4665(r1.f6124.isAccessibilityFocused());
            r5.f6124.setSelected(r1.m4667());
            r5.f6124.setLongClickable(r1.m4650());
            r5.f6124.addAction(r1.m4658());
            int i3 = Build.VERSION.SDK_INT;
            int movementGranularities = r1.f6124.getMovementGranularities();
            int i4 = Build.VERSION.SDK_INT;
            r5.f6124.setMovementGranularities(movementGranularities);
            r1.f6124.recycle();
            r5.f6124.setClassName(SlidingPaneLayout.class.getName());
            r5.f6122 = -1;
            r5.f6124.setSource(view);
            ViewParent r4 = C1729.m4445(view);
            if (r4 instanceof View) {
                r5.m4653((View) r4);
            }
            int childCount = SlidingPaneLayout.this.getChildCount();
            for (int i5 = 0; i5 < childCount; i5++) {
                View childAt = SlidingPaneLayout.this.getChildAt(i5);
                if (!SlidingPaneLayout.this.m950(childAt) && childAt.getVisibility() == 0) {
                    int i6 = Build.VERSION.SDK_INT;
                    childAt.setImportantForAccessibility(1);
                    r5.f6124.addChild(childAt);
                }
            }
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            if (!SlidingPaneLayout.this.m950(view)) {
                return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
            }
            return false;
        }
    }

    public SlidingPaneLayout(Context context) {
        this(context, null);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0281) && super.checkLayoutParams(layoutParams);
    }

    public void computeScroll() {
        if (!this.f1605.m4370(true)) {
            return;
        }
        if (!this.f1612) {
            this.f1605.m4360();
        } else {
            C1729.m4449(this);
        }
    }

    public void draw(Canvas canvas) {
        Drawable drawable;
        int i;
        int i2;
        super.draw(canvas);
        if (m953()) {
            drawable = this.f1607;
        } else {
            drawable = this.f1618;
        }
        View childAt = getChildCount() > 1 ? getChildAt(1) : null;
        if (childAt != null && drawable != null) {
            int top2 = childAt.getTop();
            int bottom = childAt.getBottom();
            int intrinsicWidth = drawable.getIntrinsicWidth();
            if (m953()) {
                i2 = childAt.getRight();
                i = intrinsicWidth + i2;
            } else {
                int left = childAt.getLeft();
                int i3 = left - intrinsicWidth;
                i = left;
                i2 = i3;
            }
            drawable.setBounds(i2, top2, i, bottom);
            drawable.draw(canvas);
        }
    }

    public boolean drawChild(Canvas canvas, View view, long j) {
        C0281 r0 = (C0281) view.getLayoutParams();
        int save = canvas.save();
        if (this.f1612 && !r0.f1630 && this.f1619 != null) {
            canvas.getClipBounds(this.f1606);
            if (m953()) {
                Rect rect = this.f1606;
                rect.left = Math.max(rect.left, this.f1619.getRight());
            } else {
                Rect rect2 = this.f1606;
                rect2.right = Math.min(rect2.right, this.f1619.getLeft());
            }
            canvas.clipRect(this.f1606);
        }
        boolean drawChild = super.drawChild(canvas, view, j);
        canvas.restoreToCount(save);
        return drawChild;
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new C0281();
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof ViewGroup.MarginLayoutParams ? new C0281((ViewGroup.MarginLayoutParams) layoutParams) : new C0281(layoutParams);
    }

    public int getCoveredFadeColor() {
        return this.f1603;
    }

    public int getParallaxDistance() {
        return this.f1621;
    }

    public int getSliderFadeColor() {
        return this.f1611;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f1615 = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.f1615 = true;
        int size = this.f1620.size();
        for (int i = 0; i < size; i++) {
            this.f1620.get(i).run();
        }
        this.f1620.clear();
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z;
        View childAt;
        int actionMasked = motionEvent.getActionMasked();
        if (!this.f1612 && actionMasked == 0 && getChildCount() > 1 && (childAt = getChildAt(1)) != null) {
            this.f1608 = !this.f1605.m4369(childAt, (int) motionEvent.getX(), (int) motionEvent.getY());
        }
        if (!this.f1612 || (this.f1613 && actionMasked != 0)) {
            this.f1605.m4350();
            return super.onInterceptTouchEvent(motionEvent);
        } else if (actionMasked == 3 || actionMasked == 1) {
            this.f1605.m4350();
            return false;
        } else {
            if (actionMasked == 0) {
                this.f1613 = false;
                float x = motionEvent.getX();
                float y = motionEvent.getY();
                this.f1604 = x;
                this.f1614 = y;
                if (this.f1605.m4369(this.f1619, (int) x, (int) y) && m950(this.f1619)) {
                    z = true;
                    if (this.f1605.m4348(motionEvent) && !z) {
                        return false;
                    }
                }
            } else if (actionMasked == 2) {
                float x2 = motionEvent.getX();
                float y2 = motionEvent.getY();
                float abs = Math.abs(x2 - this.f1604);
                float abs2 = Math.abs(y2 - this.f1614);
                C1698 r4 = this.f1605;
                if (abs > ((float) r4.f5980) && abs2 > abs) {
                    r4.m4350();
                    this.f1613 = true;
                    return false;
                }
            }
            z = false;
            return this.f1605.m4348(motionEvent) ? true : true;
        }
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        boolean r1 = m953();
        if (r1) {
            this.f1605.f5974 = 2;
        } else {
            this.f1605.f5974 = 1;
        }
        int i10 = i3 - i;
        int paddingRight = r1 ? getPaddingRight() : getPaddingLeft();
        int paddingLeft = r1 ? getPaddingLeft() : getPaddingRight();
        int paddingTop = getPaddingTop();
        int childCount = getChildCount();
        if (this.f1615) {
            this.f1610 = (!this.f1612 || !this.f1608) ? 0.0f : 1.0f;
        }
        int i11 = paddingRight;
        int i12 = i11;
        for (int i13 = 0; i13 < childCount; i13++) {
            View childAt = getChildAt(i13);
            if (childAt.getVisibility() != 8) {
                C0281 r14 = (C0281) childAt.getLayoutParams();
                int measuredWidth = childAt.getMeasuredWidth();
                if (r14.f1630) {
                    int i14 = i10 - paddingLeft;
                    int min = (Math.min(i11, i14 - this.f1617) - i12) - (((ViewGroup.MarginLayoutParams) r14).leftMargin + ((ViewGroup.MarginLayoutParams) r14).rightMargin);
                    this.f1609 = min;
                    int i15 = r1 ? ((ViewGroup.MarginLayoutParams) r14).rightMargin : ((ViewGroup.MarginLayoutParams) r14).leftMargin;
                    r14.f1629 = (measuredWidth / 2) + ((i12 + i15) + min) > i14;
                    int i16 = (int) (((float) min) * this.f1610);
                    i6 = i15 + i16 + i12;
                    this.f1610 = ((float) i16) / ((float) this.f1609);
                    i5 = 0;
                } else if (!this.f1612 || (i9 = this.f1621) == 0) {
                    i6 = i11;
                    i5 = 0;
                } else {
                    i5 = (int) ((1.0f - this.f1610) * ((float) i9));
                    i6 = i11;
                }
                if (r1) {
                    i7 = (i10 - i6) + i5;
                    i8 = i7 - measuredWidth;
                } else {
                    i8 = i6 - i5;
                    i7 = i8 + measuredWidth;
                }
                childAt.layout(i8, paddingTop, i7, childAt.getMeasuredHeight() + paddingTop);
                i12 = i6;
                i11 = childAt.getWidth() + i11;
            }
        }
        if (this.f1615) {
            if (this.f1612) {
                if (this.f1621 != 0) {
                    m955(this.f1610);
                }
                if (((C0281) this.f1619.getLayoutParams()).f1629) {
                    m957(this.f1619, this.f1610, this.f1611);
                }
            } else {
                for (int i17 = 0; i17 < childCount; i17++) {
                    m957(getChildAt(i17), 0.0f, this.f1611);
                }
            }
            m961(this.f1619);
        }
        this.f1615 = false;
    }

    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        int i11;
        int i12;
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        if (mode != 1073741824) {
            if (!isInEditMode()) {
                throw new IllegalStateException("Width must have an exact value or MATCH_PARENT");
            } else if (mode != Integer.MIN_VALUE && mode == 0) {
                size = 300;
            }
        } else if (mode2 == 0) {
            if (!isInEditMode()) {
                throw new IllegalStateException("Height must not be UNSPECIFIED");
            } else if (mode2 == 0) {
                mode2 = Integer.MIN_VALUE;
                size2 = 300;
            }
        }
        boolean z = false;
        if (mode2 == Integer.MIN_VALUE) {
            i3 = (size2 - getPaddingTop()) - getPaddingBottom();
            i4 = 0;
        } else if (mode2 != 1073741824) {
            i4 = 0;
            i3 = 0;
        } else {
            i4 = (size2 - getPaddingTop()) - getPaddingBottom();
            i3 = i4;
        }
        int paddingLeft = (size - getPaddingLeft()) - getPaddingRight();
        int childCount = getChildCount();
        if (childCount > 2) {
            Log.e("SlidingPaneLayout", "onMeasure: More than two child views are not supported.");
        }
        this.f1619 = null;
        int i13 = i4;
        int i14 = paddingLeft;
        int i15 = 0;
        boolean z2 = false;
        float f = 0.0f;
        while (true) {
            i5 = 8;
            if (i15 >= childCount) {
                break;
            }
            View childAt = getChildAt(i15);
            C0281 r7 = (C0281) childAt.getLayoutParams();
            if (childAt.getVisibility() == 8) {
                r7.f1629 = z;
            } else {
                float f2 = r7.f1631;
                if (f2 > 0.0f) {
                    f += f2;
                    if (((ViewGroup.MarginLayoutParams) r7).width == 0) {
                    }
                }
                int i16 = ((ViewGroup.MarginLayoutParams) r7).leftMargin + ((ViewGroup.MarginLayoutParams) r7).rightMargin;
                if (((ViewGroup.MarginLayoutParams) r7).width == -2) {
                    i11 = View.MeasureSpec.makeMeasureSpec(paddingLeft - i16, Integer.MIN_VALUE);
                } else if (((ViewGroup.MarginLayoutParams) r7).width == -1) {
                    i11 = View.MeasureSpec.makeMeasureSpec(paddingLeft - i16, 1073741824);
                } else {
                    i11 = View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r7).width, 1073741824);
                }
                if (((ViewGroup.MarginLayoutParams) r7).height == -2) {
                    i12 = View.MeasureSpec.makeMeasureSpec(i3, Integer.MIN_VALUE);
                } else if (((ViewGroup.MarginLayoutParams) r7).height == -1) {
                    i12 = View.MeasureSpec.makeMeasureSpec(i3, 1073741824);
                } else {
                    i12 = View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r7).height, 1073741824);
                }
                childAt.measure(i11, i12);
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight = childAt.getMeasuredHeight();
                if (mode2 == Integer.MIN_VALUE && measuredHeight > i13) {
                    i13 = Math.min(measuredHeight, i3);
                }
                i14 -= measuredWidth;
                boolean z3 = i14 < 0;
                r7.f1630 = z3;
                boolean z4 = z3 | z2;
                if (r7.f1630) {
                    this.f1619 = childAt;
                }
                z2 = z4;
            }
            i15++;
            z = false;
        }
        if (z2 || f > 0.0f) {
            int i17 = paddingLeft - this.f1617;
            int i18 = 0;
            while (i18 < childCount) {
                View childAt2 = getChildAt(i18);
                if (childAt2.getVisibility() != i5) {
                    C0281 r6 = (C0281) childAt2.getLayoutParams();
                    if (childAt2.getVisibility() != i5) {
                        boolean z5 = ((ViewGroup.MarginLayoutParams) r6).width == 0 && r6.f1631 > 0.0f;
                        if (z5) {
                            i7 = 0;
                        } else {
                            i7 = childAt2.getMeasuredWidth();
                        }
                        if (!z2 || childAt2 == this.f1619) {
                            if (r6.f1631 > 0.0f) {
                                if (((ViewGroup.MarginLayoutParams) r6).width != 0) {
                                    i8 = View.MeasureSpec.makeMeasureSpec(childAt2.getMeasuredHeight(), 1073741824);
                                } else if (((ViewGroup.MarginLayoutParams) r6).height == -2) {
                                    i8 = View.MeasureSpec.makeMeasureSpec(i3, Integer.MIN_VALUE);
                                } else if (((ViewGroup.MarginLayoutParams) r6).height == -1) {
                                    i8 = View.MeasureSpec.makeMeasureSpec(i3, 1073741824);
                                } else {
                                    i8 = View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r6).height, 1073741824);
                                }
                                if (z2) {
                                    int i19 = paddingLeft - (((ViewGroup.MarginLayoutParams) r6).leftMargin + ((ViewGroup.MarginLayoutParams) r6).rightMargin);
                                    i6 = i17;
                                    int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i19, 1073741824);
                                    if (i7 != i19) {
                                        childAt2.measure(makeMeasureSpec, i8);
                                    }
                                    i18++;
                                    i17 = i6;
                                    i5 = 8;
                                } else {
                                    i6 = i17;
                                    childAt2.measure(View.MeasureSpec.makeMeasureSpec(i7 + ((int) ((r6.f1631 * ((float) Math.max(0, i14))) / f)), 1073741824), i8);
                                    i18++;
                                    i17 = i6;
                                    i5 = 8;
                                }
                            }
                        } else if (((ViewGroup.MarginLayoutParams) r6).width < 0 && (i7 > i17 || r6.f1631 > 0.0f)) {
                            if (!z5) {
                                i9 = 1073741824;
                                i10 = View.MeasureSpec.makeMeasureSpec(childAt2.getMeasuredHeight(), 1073741824);
                            } else if (((ViewGroup.MarginLayoutParams) r6).height == -2) {
                                i10 = View.MeasureSpec.makeMeasureSpec(i3, Integer.MIN_VALUE);
                                i9 = 1073741824;
                            } else if (((ViewGroup.MarginLayoutParams) r6).height == -1) {
                                i9 = 1073741824;
                                i10 = View.MeasureSpec.makeMeasureSpec(i3, 1073741824);
                            } else {
                                i9 = 1073741824;
                                i10 = View.MeasureSpec.makeMeasureSpec(((ViewGroup.MarginLayoutParams) r6).height, 1073741824);
                            }
                            childAt2.measure(View.MeasureSpec.makeMeasureSpec(i17, i9), i10);
                        }
                    }
                }
                i6 = i17;
                i18++;
                i17 = i6;
                i5 = 8;
            }
        }
        setMeasuredDimension(size, getPaddingBottom() + getPaddingTop() + i13);
        this.f1612 = z2;
        C1698 r1 = this.f1605;
        if (r1.f5982 != 0 && !z2) {
            r1.m4360();
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        if (savedState.f1622) {
            m949();
        } else {
            m958();
        }
        this.f1608 = savedState.f1622;
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        savedState.f1622 = m963() ? m947() : this.f1608;
        return savedState;
    }

    public void onSizeChanged(int i, int i2, int i3, int i4) {
        super.onSizeChanged(i, i2, i3, i4);
        if (i != i3) {
            this.f1615 = true;
        }
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!this.f1612) {
            return super.onTouchEvent(motionEvent);
        }
        this.f1605.m4364(motionEvent);
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            float x = motionEvent.getX();
            float y = motionEvent.getY();
            this.f1604 = x;
            this.f1614 = y;
        } else if (actionMasked == 1 && m950(this.f1619)) {
            float x2 = motionEvent.getX();
            float y2 = motionEvent.getY();
            float f = x2 - this.f1604;
            float f2 = y2 - this.f1614;
            C1698 r4 = this.f1605;
            int i = r4.f5980;
            if ((f2 * f2) + (f * f) < ((float) (i * i)) && r4.m4369(this.f1619, (int) x2, (int) y2)) {
                m959(0);
            }
        }
        return true;
    }

    public void requestChildFocus(View view, View view2) {
        super.requestChildFocus(view, view2);
        if (!isInTouchMode() && !this.f1612) {
            this.f1608 = view == this.f1619;
        }
    }

    public void setCoveredFadeColor(int i) {
        this.f1603 = i;
    }

    public void setPanelSlideListener(AbstractC0278 r1) {
    }

    public void setParallaxDistance(int i) {
        this.f1621 = i;
        requestLayout();
    }

    @Deprecated
    public void setShadowDrawable(Drawable drawable) {
        setShadowDrawableLeft(drawable);
    }

    public void setShadowDrawableLeft(Drawable drawable) {
        this.f1618 = drawable;
    }

    public void setShadowDrawableRight(Drawable drawable) {
        this.f1607 = drawable;
    }

    @Deprecated
    public void setShadowResource(int i) {
        setShadowDrawable(getResources().getDrawable(i));
    }

    public void setShadowResourceLeft(int i) {
        setShadowDrawableLeft(C1806.m4683(getContext(), i));
    }

    public void setShadowResourceRight(int i) {
        setShadowDrawableRight(C1806.m4683(getContext(), i));
    }

    public void setSliderFadeColor(int i) {
        this.f1611 = i;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m946(View view) {
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final boolean m948(int i) {
        if (!this.f1615 && !m954(1.0f)) {
            return false;
        }
        this.f1608 = true;
        return true;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m949() {
        return m948(0);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m952(View view) {
        sendAccessibilityEvent(32);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m956(View view) {
        sendAccessibilityEvent(32);
    }

    /* JADX WARNING: Removed duplicated region for block: B:23:0x006f  */
    /* JADX WARNING: Removed duplicated region for block: B:24:0x0072  */
    /* renamed from: 㴹  reason: contains not printable characters */
    public void m961(View view) {
        int i;
        int i2;
        int i3;
        int i4;
        int childCount;
        int i5;
        View childAt;
        boolean z;
        boolean z2;
        View view2 = view;
        boolean r1 = m953();
        int width = r1 ? getWidth() - getPaddingRight() : getPaddingLeft();
        int paddingLeft = r1 ? getPaddingLeft() : getWidth() - getPaddingRight();
        int paddingTop = getPaddingTop();
        int height = getHeight() - getPaddingBottom();
        if (view2 != null) {
            if (view.isOpaque()) {
                z2 = true;
            } else {
                int i6 = Build.VERSION.SDK_INT;
                z2 = false;
            }
            if (z2) {
                i4 = view.getLeft();
                i3 = view.getRight();
                i2 = view.getTop();
                i = view.getBottom();
                childCount = getChildCount();
                i5 = 0;
                while (i5 < childCount && (childAt = getChildAt(i5)) != view2) {
                    if (childAt.getVisibility() != 8) {
                        z = r1;
                    } else {
                        z = r1;
                        childAt.setVisibility((Math.max(r1 ? paddingLeft : width, childAt.getLeft()) < i4 || Math.max(paddingTop, childAt.getTop()) < i2 || Math.min(r1 ? width : paddingLeft, childAt.getRight()) > i3 || Math.min(height, childAt.getBottom()) > i) ? 0 : 4);
                    }
                    i5++;
                    view2 = view;
                    r1 = z;
                }
                return;
            }
        }
        i4 = 0;
        i3 = 0;
        i2 = 0;
        i = 0;
        childCount = getChildCount();
        i5 = 0;
        while (i5 < childCount) {
            if (childAt.getVisibility() != 8) {
            }
            i5++;
            view2 = view;
            r1 = z;
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m963() {
        return this.f1612;
    }

    /* renamed from: androidx.slidingpanelayout.widget.SlidingPaneLayout$㸾  reason: contains not printable characters */
    public static class C0281 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ඓ  reason: contains not printable characters */
        public static final int[] f1628 = {16843137};

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1629;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1630;

        /* renamed from: K  reason: contains not printable characters */
        public float f1631 = 0.0f;

        /* renamed from: 㸾  reason: contains not printable characters */
        public Paint f1632;

        public C0281() {
            super(-1, -1);
        }

        public C0281(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public C0281(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public C0281(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, f1628);
            this.f1631 = obtainStyledAttributes.getFloat(0, 0.0f);
            obtainStyledAttributes.recycle();
        }
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C0281(getContext(), attributeSet);
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m950(View view) {
        if (view == null) {
            return false;
        }
        C0281 r3 = (C0281) view.getLayoutParams();
        if (!this.f1612 || !r3.f1629 || this.f1610 <= 0.0f) {
            return false;
        }
        return true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m951(int i) {
        if (this.f1619 == null) {
            this.f1610 = 0.0f;
            return;
        }
        boolean r0 = m953();
        C0281 r1 = (C0281) this.f1619.getLayoutParams();
        int width = this.f1619.getWidth();
        if (r0) {
            i = (getWidth() - i) - width;
        }
        this.f1610 = ((float) (i - ((r0 ? getPaddingRight() : getPaddingLeft()) + (r0 ? ((ViewGroup.MarginLayoutParams) r1).rightMargin : ((ViewGroup.MarginLayoutParams) r1).leftMargin)))) / ((float) this.f1609);
        if (this.f1621 != 0) {
            m955(this.f1610);
        }
        if (r1.f1629) {
            m957(this.f1619, this.f1610, this.f1611);
        }
        m946(this.f1619);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m959(int i) {
        if (!this.f1615 && !m954(0.0f)) {
            return false;
        }
        this.f1608 = false;
        return true;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public void m962(View view) {
        int i = Build.VERSION.SDK_INT;
        C1729.m4476(view, ((C0281) view.getLayoutParams()).f1632);
    }

    public SlidingPaneLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f1611 = -858993460;
        this.f1615 = true;
        this.f1606 = new Rect();
        this.f1620 = new ArrayList<>();
        float f = context.getResources().getDisplayMetrics().density;
        this.f1617 = (int) ((32.0f * f) + 0.5f);
        setWillNotDraw(false);
        C1729.m4482(this, new C0280());
        int i2 = Build.VERSION.SDK_INT;
        setImportantForAccessibility(1);
        this.f1605 = C1698.m4345(this, 0.5f, new C0277());
        this.f1605.f5972 = f * 400.0f;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m947() {
        return !this.f1612 || this.f1610 == 1.0f;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m958() {
        return m959(0);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m957(View view, float f, int i) {
        C0281 r0 = (C0281) view.getLayoutParams();
        if (f > 0.0f && i != 0) {
            int i2 = (((int) (((float) ((-16777216 & i) >>> 24)) * f)) << 24) | (i & 16777215);
            if (r0.f1632 == null) {
                r0.f1632 = new Paint();
            }
            r0.f1632.setColorFilter(new PorterDuffColorFilter(i2, PorterDuff.Mode.SRC_OVER));
            if (view.getLayerType() != 2) {
                view.setLayerType(2, r0.f1632);
            }
            m962(view);
        } else if (view.getLayerType() != 0) {
            Paint paint = r0.f1632;
            if (paint != null) {
                paint.setColorFilter(null);
            }
            RunnableC0279 r5 = new RunnableC0279(view);
            this.f1620.add(r5);
            C1729.m4479(this, r5);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m954(float f) {
        int i;
        if (!this.f1612) {
            return false;
        }
        boolean r0 = m953();
        C0281 r2 = (C0281) this.f1619.getLayoutParams();
        if (r0) {
            int paddingRight = getPaddingRight() + ((ViewGroup.MarginLayoutParams) r2).rightMargin;
            int width = this.f1619.getWidth();
            i = (int) (((float) getWidth()) - (((f * ((float) this.f1609)) + ((float) paddingRight)) + ((float) width)));
        } else {
            i = (int) ((f * ((float) this.f1609)) + ((float) (getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r2).leftMargin)));
        }
        C1698 r02 = this.f1605;
        View view = this.f1619;
        if (!r02.m4356(view, i, view.getTop())) {
            return false;
        }
        m960();
        C1729.m4449(this);
        return true;
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0023  */
    /* renamed from: K  reason: contains not printable characters */
    public final void m955(float f) {
        boolean z;
        int childCount;
        boolean r0 = m953();
        C0281 r1 = (C0281) this.f1619.getLayoutParams();
        if (r1.f1629) {
            if ((r0 ? ((ViewGroup.MarginLayoutParams) r1).rightMargin : ((ViewGroup.MarginLayoutParams) r1).leftMargin) <= 0) {
                z = true;
                childCount = getChildCount();
                for (int i = 0; i < childCount; i++) {
                    View childAt = getChildAt(i);
                    if (childAt != this.f1619) {
                        int i2 = this.f1621;
                        this.f1616 = f;
                        int i3 = ((int) ((1.0f - this.f1616) * ((float) i2))) - ((int) ((1.0f - f) * ((float) i2)));
                        if (r0) {
                            i3 = -i3;
                        }
                        childAt.offsetLeftAndRight(i3);
                        if (z) {
                            float f2 = this.f1616;
                            m957(childAt, r0 ? f2 - 1.0f : 1.0f - f2, this.f1603);
                        }
                    }
                }
            }
        }
        z = false;
        childCount = getChildCount();
        while (i < childCount) {
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m960() {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() == 4) {
                childAt.setVisibility(0);
            }
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m953() {
        return C1729.m4511(this) == 1;
    }
}
