package androidx.recyclerview.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.view.accessibility.AccessibilityEvent;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.㳳.C1841;
import ῲ.䀟.K.AbstractC2303;
import ῲ.䀟.K.C2311;
import ῲ.䀟.K.C2329;
import ῲ.䀟.K.RunnableC2312;

public class StaggeredGridLayoutManager extends RecyclerView.AbstractC0254 implements RecyclerView.AbstractC0238.AbstractC0239 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public AbstractC2303 f1545;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f1546 = 2;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public boolean f1547 = false;

    /* renamed from: ؿ  reason: contains not printable characters */
    public boolean f1548;

    /* renamed from: ݜ  reason: contains not printable characters */
    public final Rect f1549 = new Rect();

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f1550;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public int[] f1551;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public SavedState f1552;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f1553 = -1;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f1554 = false;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C0275[] f1555;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public final C2311 f1556;

    /* renamed from: K  reason: contains not printable characters */
    public int f1557 = -1;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f1558 = Integer.MIN_VALUE;

    /* renamed from: 㗗  reason: contains not printable characters */
    public boolean f1559;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f1560;

    /* renamed from: 㳳  reason: contains not printable characters */
    public BitSet f1561;

    /* renamed from: 㴪  reason: contains not printable characters */
    public final Runnable f1562 = new RunnableC0274();

    /* renamed from: 㴹  reason: contains not printable characters */
    public int f1563;

    /* renamed from: 㶋  reason: contains not printable characters */
    public boolean f1564 = true;

    /* renamed from: 㸾  reason: contains not printable characters */
    public AbstractC2303 f1565;

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean f1566 = false;

    /* renamed from: 䀟  reason: contains not printable characters */
    public final C0273 f1567 = new C0273();

    /* renamed from: 䁗  reason: contains not printable characters */
    public LazySpanLookup f1568 = new LazySpanLookup();

    @SuppressLint({"BanParcelableUsage"})
    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0271();

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1575;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int[] f1576;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public boolean f1577;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public boolean f1578;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1579;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int[] f1580;

        /* renamed from: 㳳  reason: contains not printable characters */
        public boolean f1581;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1582;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1583;

        /* renamed from: 㿎  reason: contains not printable characters */
        public List<LazySpanLookup.FullSpanItem> f1584;

        /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$SavedState$K  reason: contains not printable characters */
        public static class C0271 implements Parcelable.Creator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* Return type fixed from 'java.lang.Object[]' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.f1579);
            parcel.writeInt(this.f1575);
            parcel.writeInt(this.f1583);
            if (this.f1583 > 0) {
                parcel.writeIntArray(this.f1576);
            }
            parcel.writeInt(this.f1582);
            if (this.f1582 > 0) {
                parcel.writeIntArray(this.f1580);
            }
            parcel.writeInt(this.f1578 ? 1 : 0);
            parcel.writeInt(this.f1581 ? 1 : 0);
            parcel.writeInt(this.f1577 ? 1 : 0);
            parcel.writeList(this.f1584);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m923() {
            this.f1576 = null;
            this.f1583 = 0;
            this.f1582 = 0;
            this.f1580 = null;
            this.f1584 = null;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m924() {
            this.f1576 = null;
            this.f1583 = 0;
            this.f1579 = -1;
            this.f1575 = -1;
        }

        public SavedState(Parcel parcel) {
            this.f1579 = parcel.readInt();
            this.f1575 = parcel.readInt();
            this.f1583 = parcel.readInt();
            int i = this.f1583;
            if (i > 0) {
                this.f1576 = new int[i];
                parcel.readIntArray(this.f1576);
            }
            this.f1582 = parcel.readInt();
            int i2 = this.f1582;
            if (i2 > 0) {
                this.f1580 = new int[i2];
                parcel.readIntArray(this.f1580);
            }
            boolean z = false;
            this.f1578 = parcel.readInt() == 1;
            this.f1581 = parcel.readInt() == 1;
            this.f1577 = parcel.readInt() == 1 ? true : z;
            this.f1584 = parcel.readArrayList(LazySpanLookup.FullSpanItem.class.getClassLoader());
        }

        public SavedState(SavedState savedState) {
            this.f1583 = savedState.f1583;
            this.f1579 = savedState.f1579;
            this.f1575 = savedState.f1575;
            this.f1576 = savedState.f1576;
            this.f1582 = savedState.f1582;
            this.f1580 = savedState.f1580;
            this.f1578 = savedState.f1578;
            this.f1581 = savedState.f1581;
            this.f1577 = savedState.f1577;
            this.f1584 = savedState.f1584;
        }
    }

    /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$ʬ  reason: contains not printable characters */
    public static class C0272 extends RecyclerView.C0235 {

        /* renamed from: ඓ  reason: contains not printable characters */
        public C0275 f1585;

        /* renamed from: 㴹  reason: contains not printable characters */
        public boolean f1586;

        public C0272(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0272(int i, int i2) {
            super(i, i2);
        }

        public C0272(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public C0272(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$K  reason: contains not printable characters */
    public class RunnableC0274 implements Runnable {
        public RunnableC0274() {
        }

        public void run() {
            StaggeredGridLayoutManager.this.m882();
        }
    }

    public StaggeredGridLayoutManager(Context context, AttributeSet attributeSet, int i, int i2) {
        RecyclerView.AbstractC0254.C0258 properties = RecyclerView.AbstractC0254.getProperties(context, attributeSet, i, i2);
        setOrientation(properties.f1524);
        m909(properties.f1523);
        setReverseLayout(properties.f1522);
        this.f1556 = new C2311();
        this.f1545 = AbstractC2303.m6013(this, this.f1550);
        this.f1565 = AbstractC2303.m6013(this, 1 - this.f1550);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void assertNotInLayoutOrScroll(String str) {
        if (this.f1552 == null) {
            super.assertNotInLayoutOrScroll(str);
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean canScrollHorizontally() {
        return this.f1550 == 0;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean canScrollVertically() {
        return this.f1550 == 1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean checkLayoutParams(RecyclerView.C0235 r1) {
        return r1 instanceof C0272;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void collectAdjacentPrefetchPositions(int i, int i2, RecyclerView.C0248 r7, RecyclerView.AbstractC0254.AbstractC0255 r8) {
        int i3;
        int i4;
        if (this.f1550 != 0) {
            i = i2;
        }
        if (!(getChildCount() == 0 || i == 0)) {
            m900(i, r7);
            int[] iArr = this.f1551;
            if (iArr == null || iArr.length < this.f1557) {
                this.f1551 = new int[this.f1557];
            }
            int i5 = 0;
            for (int i6 = 0; i6 < this.f1557; i6++) {
                C2311 r1 = this.f1556;
                if (r1.f7982 == -1) {
                    i4 = r1.f7981;
                    i3 = this.f1555[i6].m932(i4);
                } else {
                    i4 = this.f1555[i6].m936(r1.f7979);
                    i3 = this.f1556.f7979;
                }
                int i7 = i4 - i3;
                if (i7 >= 0) {
                    this.f1551[i5] = i7;
                    i5++;
                }
            }
            Arrays.sort(this.f1551, 0, i5);
            for (int i8 = 0; i8 < i5; i8++) {
                int i9 = this.f1556.f7975;
                if (i9 >= 0 && i9 < r7.m823()) {
                    ((RunnableC2312.C2314) r8).m6043(this.f1556.f7975, this.f1551[i8]);
                    C2311 r12 = this.f1556;
                    r12.f7975 += r12.f7982;
                } else {
                    return;
                }
            }
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollExtent(RecyclerView.C0248 r1) {
        return computeScrollExtent(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollOffset(RecyclerView.C0248 r1) {
        return computeScrollOffset(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollRange(RecyclerView.C0248 r1) {
        return computeScrollRange(r1);
    }

    public final int computeScrollExtent(RecyclerView.C0248 r7) {
        if (getChildCount() == 0) {
            return 0;
        }
        return C1841.m4769(r7, this.f1545, m887(!this.f1564), m897(!this.f1564), this, this.f1564);
    }

    public final int computeScrollOffset(RecyclerView.C0248 r8) {
        if (getChildCount() == 0) {
            return 0;
        }
        return C1841.m4770(r8, this.f1545, m887(!this.f1564), m897(!this.f1564), this, this.f1564, this.f1554);
    }

    public final int computeScrollRange(RecyclerView.C0248 r7) {
        if (getChildCount() == 0) {
            return 0;
        }
        return C1841.m4754(r7, this.f1545, m887(!this.f1564), m897(!this.f1564), this, this.f1564);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0238.AbstractC0239
    public PointF computeScrollVectorForPosition(int i) {
        int r4 = m895(i);
        PointF pointF = new PointF();
        if (r4 == 0) {
            return null;
        }
        if (this.f1550 == 0) {
            pointF.x = (float) r4;
            pointF.y = 0.0f;
        } else {
            pointF.x = 0.0f;
            pointF.y = (float) r4;
        }
        return pointF;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollExtent(RecyclerView.C0248 r1) {
        return computeScrollExtent(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollOffset(RecyclerView.C0248 r1) {
        return computeScrollOffset(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollRange(RecyclerView.C0248 r1) {
        return computeScrollRange(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateDefaultLayoutParams() {
        if (this.f1550 == 0) {
            return new C0272(-2, -1);
        }
        return new C0272(-1, -2);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateLayoutParams(Context context, AttributeSet attributeSet) {
        return new C0272(context, attributeSet);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int getColumnCountForAccessibility(RecyclerView.C0264 r3, RecyclerView.C0248 r4) {
        if (this.f1550 == 1) {
            return this.f1557;
        }
        return super.getColumnCountForAccessibility(r3, r4);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int getRowCountForAccessibility(RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        if (this.f1550 == 0) {
            return this.f1557;
        }
        return super.getRowCountForAccessibility(r2, r3);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean isAutoMeasureEnabled() {
        return this.f1546 != 0;
    }

    public boolean isLayoutRTL() {
        return getLayoutDirection() == 1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void offsetChildrenHorizontal(int i) {
        super.offsetChildrenHorizontal(i);
        for (int i2 = 0; i2 < this.f1557; i2++) {
            C0275 r1 = this.f1555[i2];
            int i3 = r1.f1597;
            if (i3 != Integer.MIN_VALUE) {
                r1.f1597 = i3 + i;
            }
            int i4 = r1.f1595;
            if (i4 != Integer.MIN_VALUE) {
                r1.f1595 = i4 + i;
            }
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void offsetChildrenVertical(int i) {
        super.offsetChildrenVertical(i);
        for (int i2 = 0; i2 < this.f1557; i2++) {
            C0275 r1 = this.f1555[i2];
            int i3 = r1.f1597;
            if (i3 != Integer.MIN_VALUE) {
                r1.f1597 = i3 + i;
            }
            int i4 = r1.f1595;
            if (i4 != Integer.MIN_VALUE) {
                r1.f1595 = i4 + i;
            }
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onDetachedFromWindow(RecyclerView recyclerView, RecyclerView.C0264 r3) {
        super.onDetachedFromWindow(recyclerView, r3);
        removeCallbacks(this.f1562);
        for (int i = 0; i < this.f1557; i++) {
            this.f1555[i].m928();
        }
        recyclerView.requestLayout();
    }

    /* JADX WARNING: Code restructure failed: missing block: B:25:0x003c, code lost:
        if (r9.f1550 == 1) goto L_0x003e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:28:0x0042, code lost:
        if (r9.f1550 == 0) goto L_0x003e;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:32:0x004e, code lost:
        if (isLayoutRTL() == false) goto L_0x0030;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:36:0x005a, code lost:
        if (isLayoutRTL() == false) goto L_0x003e;
     */
    /* JADX WARNING: Removed duplicated region for block: B:38:0x005f A[RETURN] */
    /* JADX WARNING: Removed duplicated region for block: B:39:0x0060  */
    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public View onFocusSearchFailed(View view, int i, RecyclerView.C0264 r12, RecyclerView.C0248 r13) {
        View findContainingItemView;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        View r122;
        if (getChildCount() == 0 || (findContainingItemView = findContainingItemView(view)) == null) {
            return null;
        }
        resolveShouldLayoutReverse();
        if (i == 1) {
            if (this.f1550 != 1) {
            }
            i2 = -1;
            if (i2 == Integer.MIN_VALUE) {
            }
        } else if (i != 2) {
            if (i != 17) {
                if (i != 33) {
                    if (i == 66) {
                    }
                }
            }
            i2 = Integer.MIN_VALUE;
            if (i2 == Integer.MIN_VALUE) {
                return null;
            }
            C0272 r2 = (C0272) findContainingItemView.getLayoutParams();
            boolean z = r2.f1586;
            C0275 r22 = r2.f1585;
            if (i2 == 1) {
                i3 = m908();
            } else {
                i3 = m883();
            }
            m888(i3, r13);
            m884(i2);
            C2311 r6 = this.f1556;
            r6.f7975 = r6.f7982 + i3;
            r6.f7978 = (int) (((float) this.f1545.m6020()) * 0.33333334f);
            C2311 r62 = this.f1556;
            r62.f7983 = true;
            r62.f7980 = false;
            m896(r12, r62, r13);
            this.f1559 = this.f1554;
            if (!(z || (r122 = r22.m938(i3, i2)) == null || r122 == findContainingItemView)) {
                return r122;
            }
            if (m911(i2)) {
                for (int i7 = this.f1557 - 1; i7 >= 0; i7--) {
                    View r132 = this.f1555[i7].m938(i3, i2);
                    if (!(r132 == null || r132 == findContainingItemView)) {
                        return r132;
                    }
                }
            } else {
                for (int i8 = 0; i8 < this.f1557; i8++) {
                    View r133 = this.f1555[i8].m938(i3, i2);
                    if (!(r133 == null || r133 == findContainingItemView)) {
                        return r133;
                    }
                }
            }
            boolean z2 = (this.f1566 ^ true) == (i2 == -1);
            if (!z) {
                if (z2) {
                    i6 = r22.m942();
                } else {
                    i6 = r22.m930();
                }
                View findViewByPosition = findViewByPosition(i6);
                if (!(findViewByPosition == null || findViewByPosition == findContainingItemView)) {
                    return findViewByPosition;
                }
            }
            if (m911(i2)) {
                for (int i9 = this.f1557 - 1; i9 >= 0; i9--) {
                    if (i9 != r22.f1596) {
                        if (z2) {
                            i5 = this.f1555[i9].m942();
                        } else {
                            i5 = this.f1555[i9].m930();
                        }
                        View findViewByPosition2 = findViewByPosition(i5);
                        if (!(findViewByPosition2 == null || findViewByPosition2 == findContainingItemView)) {
                            return findViewByPosition2;
                        }
                    }
                }
            } else {
                for (int i10 = 0; i10 < this.f1557; i10++) {
                    if (z2) {
                        i4 = this.f1555[i10].m942();
                    } else {
                        i4 = this.f1555[i10].m930();
                    }
                    View findViewByPosition3 = findViewByPosition(i4);
                    if (!(findViewByPosition3 == null || findViewByPosition3 == findContainingItemView)) {
                        return findViewByPosition3;
                    }
                }
            }
            return null;
        } else if (this.f1550 != 1) {
        }
        i2 = 1;
        if (i2 == Integer.MIN_VALUE) {
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        if (getChildCount() > 0) {
            View r1 = m887(false);
            View r0 = m897(false);
            if (r1 != null && r0 != null) {
                int position = getPosition(r1);
                int position2 = getPosition(r0);
                if (position < position2) {
                    accessibilityEvent.setFromIndex(position);
                    accessibilityEvent.setToIndex(position2);
                    return;
                }
                accessibilityEvent.setFromIndex(position2);
                accessibilityEvent.setToIndex(position);
            }
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.C0264 r8, RecyclerView.C0248 r9, View view, C1782 r11) {
        int i;
        int i2;
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (!(layoutParams instanceof C0272)) {
            super.onInitializeAccessibilityNodeInfoForItem(view, r11);
            return;
        }
        C0272 r82 = (C0272) layoutParams;
        if (this.f1550 == 0) {
            C0275 r92 = r82.f1585;
            if (r92 == null) {
                i2 = -1;
            } else {
                i2 = r92.f1596;
            }
            r11.m4654(C1782.C1783.m4672(i2, r82.f1586 ? this.f1557 : 1, -1, -1, false, false));
            return;
        }
        C0275 r2 = r82.f1585;
        if (r2 == null) {
            i = -1;
        } else {
            i = r2.f1596;
        }
        r11.m4654(C1782.C1783.m4672(-1, -1, i, r82.f1586 ? this.f1557 : 1, false, false));
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsAdded(RecyclerView recyclerView, int i, int i2) {
        m899(i, i2, 1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsChanged(RecyclerView recyclerView) {
        this.f1568.m917();
        requestLayout();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsMoved(RecyclerView recyclerView, int i, int i2, int i3) {
        m899(i, i2, 8);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsRemoved(RecyclerView recyclerView, int i, int i2) {
        m899(i, i2, 2);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsUpdated(RecyclerView recyclerView, int i, int i2, Object obj) {
        m899(i, i2, 4);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutChildren(RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        m881(r2, r3, true);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutCompleted(RecyclerView.C0248 r1) {
        super.onLayoutCompleted(r1);
        this.f1553 = -1;
        this.f1558 = Integer.MIN_VALUE;
        this.f1552 = null;
        this.f1567.m925();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            this.f1552 = (SavedState) parcelable;
            requestLayout();
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public Parcelable onSaveInstanceState() {
        int i;
        int i2;
        int i3;
        int[] iArr;
        SavedState savedState = this.f1552;
        if (savedState != null) {
            return new SavedState(savedState);
        }
        SavedState savedState2 = new SavedState();
        savedState2.f1578 = this.f1566;
        savedState2.f1581 = this.f1559;
        savedState2.f1577 = this.f1548;
        LazySpanLookup lazySpanLookup = this.f1568;
        if (lazySpanLookup == null || (iArr = lazySpanLookup.f1570) == null) {
            savedState2.f1582 = 0;
        } else {
            savedState2.f1580 = iArr;
            savedState2.f1582 = savedState2.f1580.length;
            savedState2.f1584 = lazySpanLookup.f1569;
        }
        if (getChildCount() > 0) {
            if (this.f1559) {
                i = m908();
            } else {
                i = m883();
            }
            savedState2.f1579 = i;
            savedState2.f1575 = m910();
            int i4 = this.f1557;
            savedState2.f1583 = i4;
            savedState2.f1576 = new int[i4];
            for (int i5 = 0; i5 < this.f1557; i5++) {
                if (this.f1559) {
                    i2 = this.f1555[i5].m936(Integer.MIN_VALUE);
                    if (i2 != Integer.MIN_VALUE) {
                        i3 = this.f1545.m6018();
                    } else {
                        savedState2.f1576[i5] = i2;
                    }
                } else {
                    i2 = this.f1555[i5].m932(Integer.MIN_VALUE);
                    if (i2 != Integer.MIN_VALUE) {
                        i3 = this.f1545.m6024();
                    } else {
                        savedState2.f1576[i5] = i2;
                    }
                }
                i2 -= i3;
                savedState2.f1576[i5] = i2;
            }
        } else {
            savedState2.f1579 = -1;
            savedState2.f1575 = -1;
            savedState2.f1583 = 0;
        }
        return savedState2;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onScrollStateChanged(int i) {
        if (i == 0) {
            m882();
        }
    }

    public final void resolveShouldLayoutReverse() {
        if (this.f1550 == 1 || !isLayoutRTL()) {
            this.f1554 = this.f1566;
        } else {
            this.f1554 = !this.f1566;
        }
    }

    public int scrollBy(int i, RecyclerView.C0264 r4, RecyclerView.C0248 r5) {
        if (getChildCount() == 0 || i == 0) {
            return 0;
        }
        m900(i, r5);
        int r52 = m896(r4, this.f1556, r5);
        if (this.f1556.f7978 >= r52) {
            i = i < 0 ? -r52 : r52;
        }
        this.f1545.m6023(-i);
        this.f1559 = this.f1554;
        C2311 r53 = this.f1556;
        r53.f7978 = 0;
        m904(r4, r53);
        return i;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollHorizontallyBy(int i, RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        return scrollBy(i, r2, r3);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void scrollToPosition(int i) {
        SavedState savedState = this.f1552;
        if (!(savedState == null || savedState.f1579 == i)) {
            savedState.m924();
        }
        this.f1553 = i;
        this.f1558 = Integer.MIN_VALUE;
        requestLayout();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollVerticallyBy(int i, RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        return scrollBy(i, r2, r3);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void setMeasuredDimension(Rect rect, int i, int i2) {
        int i3;
        int i4;
        int paddingRight = getPaddingRight() + getPaddingLeft();
        int paddingBottom = getPaddingBottom() + getPaddingTop();
        if (this.f1550 == 1) {
            i4 = RecyclerView.AbstractC0254.chooseSize(i2, rect.height() + paddingBottom, getMinimumHeight());
            i3 = RecyclerView.AbstractC0254.chooseSize(i, (this.f1563 * this.f1557) + paddingRight, getMinimumWidth());
        } else {
            i3 = RecyclerView.AbstractC0254.chooseSize(i, rect.width() + paddingRight, getMinimumWidth());
            i4 = RecyclerView.AbstractC0254.chooseSize(i2, (this.f1563 * this.f1557) + paddingBottom, getMinimumHeight());
        }
        setMeasuredDimension(i3, i4);
    }

    public void setOrientation(int i) {
        if (i == 0 || i == 1) {
            assertNotInLayoutOrScroll(null);
            if (i != this.f1550) {
                this.f1550 = i;
                AbstractC2303 r2 = this.f1545;
                this.f1545 = this.f1565;
                this.f1565 = r2;
                requestLayout();
                return;
            }
            return;
        }
        throw new IllegalArgumentException("invalid orientation.");
    }

    public void setReverseLayout(boolean z) {
        assertNotInLayoutOrScroll(null);
        SavedState savedState = this.f1552;
        if (!(savedState == null || savedState.f1578 == z)) {
            savedState.f1578 = z;
        }
        this.f1566 = z;
        requestLayout();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.C0248 r2, int i) {
        C2329 r22 = new C2329(recyclerView.getContext());
        r22.setTargetPosition(i);
        startSmoothScroll(r22);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean supportsPredictiveItemAnimations() {
        return this.f1552 == null;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m882() {
        int i;
        int i2;
        if (getChildCount() == 0 || this.f1546 == 0 || !isAttachedToWindow()) {
            return false;
        }
        if (this.f1554) {
            i2 = m908();
            i = m883();
        } else {
            i2 = m883();
            i = m908();
        }
        if (i2 == 0 && m893() != null) {
            this.f1568.m917();
            requestSimpleAnimationsInNextLayout();
            requestLayout();
            return true;
        } else if (!this.f1547) {
            return false;
        } else {
            int i3 = this.f1554 ? -1 : 1;
            int i4 = i + 1;
            LazySpanLookup.FullSpanItem r6 = this.f1568.m916(i2, i4, i3, true);
            if (r6 == null) {
                this.f1547 = false;
                this.f1568.m914(i4);
                return false;
            }
            LazySpanLookup.FullSpanItem r0 = this.f1568.m916(i2, r6.f1573, i3 * -1, true);
            if (r0 == null) {
                this.f1568.m914(r6.f1573);
            } else {
                this.f1568.m914(r0.f1573 + 1);
            }
            requestSimpleAnimationsInNextLayout();
            requestLayout();
            return true;
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m884(int i) {
        C2311 r0 = this.f1556;
        r0.f7976 = i;
        int i2 = 1;
        if (this.f1554 != (i == -1)) {
            i2 = -1;
        }
        r0.f7982 = i2;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m889(RecyclerView.C0248 r5, C0273 r6) {
        if (!m907(r5, r6)) {
            int i = 0;
            if (!this.f1559) {
                int r52 = r5.m823();
                int childCount = getChildCount();
                int i2 = 0;
                while (true) {
                    if (i2 < childCount) {
                        int position = getPosition(getChildAt(i2));
                        if (position >= 0 && position < r52) {
                            i = position;
                            break;
                        }
                        i2++;
                    } else {
                        break;
                    }
                }
            } else {
                int r53 = r5.m823();
                int childCount2 = getChildCount();
                while (true) {
                    childCount2--;
                    if (childCount2 >= 0) {
                        int position2 = getPosition(getChildAt(childCount2));
                        if (position2 >= 0 && position2 < r53) {
                            i = position2;
                            break;
                        }
                    } else {
                        break;
                    }
                }
            }
            r6.f1591 = i;
            r6.f1589 = Integer.MIN_VALUE;
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:38:0x00b3, code lost:
        if (r11 == r12) goto L_0x00c7;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:42:0x00c5, code lost:
        if (r11 == r12) goto L_0x00c7;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:44:0x00c9, code lost:
        r11 = false;
     */
    /* JADX WARNING: Removed duplicated region for block: B:28:0x008c  */
    /* JADX WARNING: Removed duplicated region for block: B:58:0x008b A[SYNTHETIC] */
    /* renamed from: ⁱ  reason: contains not printable characters */
    public View m893() {
        int i;
        int i2;
        boolean z;
        boolean z2;
        int childCount = getChildCount() - 1;
        BitSet bitSet = new BitSet(this.f1557);
        bitSet.set(0, this.f1557, true);
        char c = (this.f1550 != 1 || !isLayoutRTL()) ? (char) 65535 : 1;
        if (this.f1554) {
            i = -1;
        } else {
            i = childCount + 1;
            childCount = 0;
        }
        int i3 = childCount < i ? 1 : -1;
        while (childCount != i) {
            View childAt = getChildAt(childCount);
            C0272 r9 = (C0272) childAt.getLayoutParams();
            if (bitSet.get(r9.f1585.f1596)) {
                C0275 r10 = r9.f1585;
                if (this.f1554) {
                    if (r10.m941() < this.f1545.m6018()) {
                        ArrayList<View> arrayList = r10.f1598;
                        z2 = r10.m933(arrayList.get(arrayList.size() - 1)).f1586;
                    }
                    z = false;
                    if (z) {
                        return childAt;
                    }
                    bitSet.clear(r9.f1585.f1596);
                } else {
                    if (r10.m935() > this.f1545.m6024()) {
                        z2 = r10.m933(r10.f1598.get(0)).f1586;
                    }
                    z = false;
                    if (z) {
                    }
                }
                z = !z2;
                if (z) {
                }
            }
            if (!r9.f1586 && (i2 = childCount + i3) != i) {
                View childAt2 = getChildAt(i2);
                if (this.f1554) {
                    int r11 = this.f1545.m6022(childAt);
                    int r12 = this.f1545.m6022(childAt2);
                    if (r11 < r12) {
                        return childAt;
                    }
                } else {
                    int r112 = this.f1545.m6027(childAt);
                    int r122 = this.f1545.m6027(childAt2);
                    if (r112 > r122) {
                        return childAt;
                    }
                }
                boolean z3 = true;
                if (!z3) {
                    continue;
                } else {
                    if ((r9.f1585.f1596 - ((C0272) childAt2.getLayoutParams()).f1585.f1596 < 0) != (c < 0)) {
                        return childAt;
                    }
                }
            }
            childCount += i3;
        }
        return null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m901(View view, int i, int i2, boolean z) {
        boolean z2;
        calculateItemDecorationsForChild(view, this.f1549);
        C0272 r0 = (C0272) view.getLayoutParams();
        int i3 = ((ViewGroup.MarginLayoutParams) r0).leftMargin;
        Rect rect = this.f1549;
        int r6 = m886(i, i3 + rect.left, ((ViewGroup.MarginLayoutParams) r0).rightMargin + rect.right);
        int i4 = ((ViewGroup.MarginLayoutParams) r0).topMargin;
        Rect rect2 = this.f1549;
        int r7 = m886(i2, i4 + rect2.top, ((ViewGroup.MarginLayoutParams) r0).bottomMargin + rect2.bottom);
        if (z) {
            z2 = shouldReMeasureChild(view, r6, r7, r0);
        } else {
            z2 = shouldMeasureChild(view, r6, r7, r0);
        }
        if (z2) {
            view.measure(r6, r7);
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m909(int i) {
        assertNotInLayoutOrScroll(null);
        if (i != this.f1557) {
            m912();
            this.f1557 = i;
            this.f1561 = new BitSet(this.f1557);
            this.f1555 = new C0275[this.f1557];
            for (int i2 = 0; i2 < this.f1557; i2++) {
                this.f1555[i2] = new C0275(i2);
            }
            requestLayout();
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public int m910() {
        View view;
        if (this.f1554) {
            view = m897(true);
        } else {
            view = m887(true);
        }
        if (view == null) {
            return -1;
        }
        return getPosition(view);
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m912() {
        this.f1568.m917();
        requestLayout();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new C0272((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new C0272(layoutParams);
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public int m883() {
        if (getChildCount() == 0) {
            return 0;
        }
        return getPosition(getChildAt(0));
    }

    /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$ῲ  reason: contains not printable characters */
    public class C0273 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1587;

        /* renamed from: ඓ  reason: contains not printable characters */
        public boolean f1588;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1589;

        /* renamed from: K  reason: contains not printable characters */
        public int f1591;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int[] f1592;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1593;

        public C0273() {
            m925();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m925() {
            this.f1591 = -1;
            this.f1589 = Integer.MIN_VALUE;
            this.f1587 = false;
            this.f1593 = false;
            this.f1588 = false;
            int[] iArr = this.f1592;
            if (iArr != null) {
                Arrays.fill(iArr, -1);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m927(C0275[] r6) {
            int length = r6.length;
            int[] iArr = this.f1592;
            if (iArr == null || iArr.length < length) {
                this.f1592 = new int[StaggeredGridLayoutManager.this.f1555.length];
            }
            for (int i = 0; i < length; i++) {
                this.f1592[i] = r6[i].m932(Integer.MIN_VALUE);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m926() {
            int i;
            if (this.f1587) {
                i = StaggeredGridLayoutManager.this.f1545.m6018();
            } else {
                i = StaggeredGridLayoutManager.this.f1545.m6024();
            }
            this.f1589 = i;
        }
    }

    /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$㸾  reason: contains not printable characters */
    public class C0275 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1595 = Integer.MIN_VALUE;

        /* renamed from: ඓ  reason: contains not printable characters */
        public final int f1596;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1597 = Integer.MIN_VALUE;

        /* renamed from: K  reason: contains not printable characters */
        public ArrayList<View> f1598 = new ArrayList<>();

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1600 = 0;

        public C0275(int i) {
            this.f1596 = i;
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m929(View view) {
            C0272 r0 = m933(view);
            r0.f1585 = this;
            this.f1598.add(0, view);
            this.f1597 = Integer.MIN_VALUE;
            if (this.f1598.size() == 1) {
                this.f1595 = Integer.MIN_VALUE;
            }
            if (r0.m809() || r0.m810()) {
                this.f1600 = StaggeredGridLayoutManager.this.f1545.m6019(view) + this.f1600;
            }
        }

        /* renamed from: ඓ  reason: contains not printable characters */
        public int m930() {
            if (StaggeredGridLayoutManager.this.f1566) {
                return m937(0, this.f1598.size(), true);
            }
            return m937(this.f1598.size() - 1, -1, true);
        }

        /* renamed from: ᨨ  reason: contains not printable characters */
        public void m931() {
            View remove = this.f1598.remove(0);
            C0272 r1 = m933(remove);
            r1.f1585 = null;
            if (this.f1598.size() == 0) {
                this.f1595 = Integer.MIN_VALUE;
            }
            if (r1.m809() || r1.m810()) {
                this.f1600 -= StaggeredGridLayoutManager.this.f1545.m6019(remove);
            }
            this.f1597 = Integer.MIN_VALUE;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public int m932(int i) {
            int i2 = this.f1597;
            if (i2 != Integer.MIN_VALUE) {
                return i2;
            }
            if (this.f1598.size() == 0) {
                return i;
            }
            m934();
            return this.f1597;
        }

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int m935() {
            int i = this.f1597;
            if (i != Integer.MIN_VALUE) {
                return i;
            }
            m934();
            return this.f1597;
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m936(int i) {
            int i2 = this.f1595;
            if (i2 != Integer.MIN_VALUE) {
                return i2;
            }
            if (this.f1598.size() == 0) {
                return i;
            }
            m939();
            return this.f1595;
        }

        /* renamed from: 㴹  reason: contains not printable characters */
        public int m941() {
            int i = this.f1595;
            if (i != Integer.MIN_VALUE) {
                return i;
            }
            m939();
            return this.f1595;
        }

        /* renamed from: 㸾  reason: contains not printable characters */
        public int m942() {
            if (StaggeredGridLayoutManager.this.f1566) {
                return m937(this.f1598.size() - 1, -1, true);
            }
            return m937(0, this.f1598.size(), true);
        }

        /* renamed from: 㿎  reason: contains not printable characters */
        public void m943() {
            int size = this.f1598.size();
            View remove = this.f1598.remove(size - 1);
            C0272 r2 = m933(remove);
            r2.f1585 = null;
            if (r2.m809() || r2.m810()) {
                this.f1600 -= StaggeredGridLayoutManager.this.f1545.m6019(remove);
            }
            if (size == 1) {
                this.f1597 = Integer.MIN_VALUE;
            }
            this.f1595 = Integer.MIN_VALUE;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m934() {
            LazySpanLookup.FullSpanItem r0;
            View view = this.f1598.get(0);
            C0272 r1 = m933(view);
            this.f1597 = StaggeredGridLayoutManager.this.f1545.m6027(view);
            if (r1.f1586 && (r0 = StaggeredGridLayoutManager.this.f1568.m913(r1.m811())) != null && r0.f1571 == -1) {
                this.f1597 -= r0.m922(this.f1596);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m939() {
            LazySpanLookup.FullSpanItem r0;
            ArrayList<View> arrayList = this.f1598;
            View view = arrayList.get(arrayList.size() - 1);
            C0272 r1 = m933(view);
            this.f1595 = StaggeredGridLayoutManager.this.f1545.m6022(view);
            if (r1.f1586 && (r0 = StaggeredGridLayoutManager.this.f1568.m913(r1.m811())) != null && r0.f1571 == 1) {
                this.f1595 = r0.m922(this.f1596) + this.f1595;
            }
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public void m928() {
            this.f1598.clear();
            this.f1597 = Integer.MIN_VALUE;
            this.f1595 = Integer.MIN_VALUE;
            this.f1600 = 0;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public C0272 m933(View view) {
            return (C0272) view.getLayoutParams();
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m940(View view) {
            C0272 r0 = m933(view);
            r0.f1585 = this;
            this.f1598.add(view);
            this.f1595 = Integer.MIN_VALUE;
            if (this.f1598.size() == 1) {
                this.f1597 = Integer.MIN_VALUE;
            }
            if (r0.m809() || r0.m810()) {
                this.f1600 = StaggeredGridLayoutManager.this.f1545.m6019(view) + this.f1600;
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m937(int i, int i2, boolean z) {
            int r0 = StaggeredGridLayoutManager.this.f1545.m6024();
            int r1 = StaggeredGridLayoutManager.this.f1545.m6018();
            int i3 = i2 > i ? 1 : -1;
            while (i != i2) {
                View view = this.f1598.get(i);
                int r6 = StaggeredGridLayoutManager.this.f1545.m6027(view);
                int r7 = StaggeredGridLayoutManager.this.f1545.m6022(view);
                boolean z2 = false;
                boolean z3 = !z ? r6 < r1 : r6 <= r1;
                if (!z ? r7 > r0 : r7 >= r0) {
                    z2 = true;
                }
                if (z3 && z2 && (r6 < r0 || r7 > r1)) {
                    return StaggeredGridLayoutManager.this.getPosition(view);
                }
                i += i3;
            }
            return -1;
        }

        /* renamed from: K  reason: contains not printable characters */
        public View m938(int i, int i2) {
            View view = null;
            if (i2 != -1) {
                int size = this.f1598.size() - 1;
                while (size >= 0) {
                    View view2 = this.f1598.get(size);
                    StaggeredGridLayoutManager staggeredGridLayoutManager = StaggeredGridLayoutManager.this;
                    if (staggeredGridLayoutManager.f1566 && staggeredGridLayoutManager.getPosition(view2) >= i) {
                        break;
                    }
                    StaggeredGridLayoutManager staggeredGridLayoutManager2 = StaggeredGridLayoutManager.this;
                    if ((!staggeredGridLayoutManager2.f1566 && staggeredGridLayoutManager2.getPosition(view2) <= i) || !view2.hasFocusable()) {
                        break;
                    }
                    size--;
                    view = view2;
                }
            } else {
                int size2 = this.f1598.size();
                int i3 = 0;
                while (i3 < size2) {
                    View view3 = this.f1598.get(i3);
                    StaggeredGridLayoutManager staggeredGridLayoutManager3 = StaggeredGridLayoutManager.this;
                    if (staggeredGridLayoutManager3.f1566 && staggeredGridLayoutManager3.getPosition(view3) <= i) {
                        break;
                    }
                    StaggeredGridLayoutManager staggeredGridLayoutManager4 = StaggeredGridLayoutManager.this;
                    if ((!staggeredGridLayoutManager4.f1566 && staggeredGridLayoutManager4.getPosition(view3) >= i) || !view3.hasFocusable()) {
                        break;
                    }
                    i3++;
                    view = view3;
                }
            }
            return view;
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean m911(int i) {
        if (this.f1550 == 0) {
            if ((i == -1) != this.f1554) {
                return true;
            }
            return false;
        }
        if (((i == -1) == this.f1554) == isLayoutRTL()) {
            return true;
        }
        return false;
    }

    public static class LazySpanLookup {

        /* renamed from: ῲ  reason: contains not printable characters */
        public List<FullSpanItem> f1569;

        /* renamed from: K  reason: contains not printable characters */
        public int[] f1570;

        /* renamed from: ʬ  reason: contains not printable characters */
        public FullSpanItem m913(int i) {
            List<FullSpanItem> list = this.f1569;
            if (list == null) {
                return null;
            }
            for (int size = list.size() - 1; size >= 0; size--) {
                FullSpanItem fullSpanItem = this.f1569.get(size);
                if (fullSpanItem.f1573 == i) {
                    return fullSpanItem;
                }
            }
            return null;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public int m914(int i) {
            List<FullSpanItem> list = this.f1569;
            if (list != null) {
                for (int size = list.size() - 1; size >= 0; size--) {
                    if (this.f1569.get(size).f1573 >= i) {
                        this.f1569.remove(size);
                    }
                }
            }
            return m921(i);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m918(int i) {
            int[] iArr = this.f1570;
            if (iArr == null) {
                this.f1570 = new int[(Math.max(i, 10) + 1)];
                Arrays.fill(this.f1570, -1);
            } else if (i >= iArr.length) {
                int length = iArr.length;
                while (length <= i) {
                    length *= 2;
                }
                this.f1570 = new int[length];
                System.arraycopy(iArr, 0, this.f1570, 0, iArr.length);
                int[] iArr2 = this.f1570;
                Arrays.fill(iArr2, iArr.length, iArr2.length, -1);
            }
        }

        /* JADX WARNING: Removed duplicated region for block: B:21:0x0048  */
        /* JADX WARNING: Removed duplicated region for block: B:23:0x0052  */
        /* renamed from: 㸾  reason: contains not printable characters */
        public int m921(int i) {
            int i2;
            int[] iArr = this.f1570;
            if (iArr == null || i >= iArr.length) {
                return -1;
            }
            if (this.f1569 != null) {
                FullSpanItem r0 = m913(i);
                if (r0 != null) {
                    this.f1569.remove(r0);
                }
                int size = this.f1569.size();
                int i3 = 0;
                while (true) {
                    if (i3 >= size) {
                        i3 = -1;
                        break;
                    } else if (this.f1569.get(i3).f1573 >= i) {
                        break;
                    } else {
                        i3++;
                    }
                }
                if (i3 != -1) {
                    this.f1569.remove(i3);
                    i2 = this.f1569.get(i3).f1573;
                    if (i2 != -1) {
                        int[] iArr2 = this.f1570;
                        Arrays.fill(iArr2, i, iArr2.length, -1);
                        return this.f1570.length;
                    }
                    int i4 = i2 + 1;
                    Arrays.fill(this.f1570, i, i4, -1);
                    return i4;
                }
            }
            i2 = -1;
            if (i2 != -1) {
            }
        }

        @SuppressLint({"BanParcelableUsage"})
        public static class FullSpanItem implements Parcelable {
            public static final Parcelable.Creator<FullSpanItem> CREATOR = new C0270();

            /* renamed from: ʬ  reason: contains not printable characters */
            public int f1571;

            /* renamed from: ඓ  reason: contains not printable characters */
            public boolean f1572;

            /* renamed from: ῲ  reason: contains not printable characters */
            public int f1573;

            /* renamed from: 㸾  reason: contains not printable characters */
            public int[] f1574;

            /* renamed from: androidx.recyclerview.widget.StaggeredGridLayoutManager$LazySpanLookup$FullSpanItem$K  reason: contains not printable characters */
            public static class C0270 implements Parcelable.Creator<FullSpanItem> {
                /* Return type fixed from 'java.lang.Object' to match base method */
                @Override // android.os.Parcelable.Creator
                public FullSpanItem createFromParcel(Parcel parcel) {
                    return new FullSpanItem(parcel);
                }

                /* Return type fixed from 'java.lang.Object[]' to match base method */
                @Override // android.os.Parcelable.Creator
                public FullSpanItem[] newArray(int i) {
                    return new FullSpanItem[i];
                }
            }

            public FullSpanItem(Parcel parcel) {
                this.f1573 = parcel.readInt();
                this.f1571 = parcel.readInt();
                this.f1572 = parcel.readInt() != 1 ? false : true;
                int readInt = parcel.readInt();
                if (readInt > 0) {
                    this.f1574 = new int[readInt];
                    parcel.readIntArray(this.f1574);
                }
            }

            public int describeContents() {
                return 0;
            }

            public String toString() {
                StringBuilder r0 = C1293.m3416("FullSpanItem{mPosition=");
                r0.append(this.f1573);
                r0.append(", mGapDir=");
                r0.append(this.f1571);
                r0.append(", mHasUnwantedGapAfter=");
                r0.append(this.f1572);
                r0.append(", mGapPerSpan=");
                r0.append(Arrays.toString(this.f1574));
                r0.append('}');
                return r0.toString();
            }

            public void writeToParcel(Parcel parcel, int i) {
                parcel.writeInt(this.f1573);
                parcel.writeInt(this.f1571);
                parcel.writeInt(this.f1572 ? 1 : 0);
                int[] iArr = this.f1574;
                if (iArr == null || iArr.length <= 0) {
                    parcel.writeInt(0);
                    return;
                }
                parcel.writeInt(iArr.length);
                parcel.writeIntArray(this.f1574);
            }

            /* renamed from: K  reason: contains not printable characters */
            public int m922(int i) {
                int[] iArr = this.f1574;
                if (iArr == null) {
                    return 0;
                }
                return iArr[i];
            }

            public FullSpanItem() {
            }
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m915(int i, int i2) {
            int[] iArr = this.f1570;
            if (iArr != null && i < iArr.length) {
                int i3 = i + i2;
                m918(i3);
                int[] iArr2 = this.f1570;
                System.arraycopy(iArr2, i3, iArr2, i, (iArr2.length - i) - i2);
                int[] iArr3 = this.f1570;
                Arrays.fill(iArr3, iArr3.length - i2, iArr3.length, -1);
                List<FullSpanItem> list = this.f1569;
                if (list != null) {
                    for (int size = list.size() - 1; size >= 0; size--) {
                        FullSpanItem fullSpanItem = this.f1569.get(size);
                        int i4 = fullSpanItem.f1573;
                        if (i4 >= i) {
                            if (i4 < i3) {
                                this.f1569.remove(size);
                            } else {
                                fullSpanItem.f1573 = i4 - i2;
                            }
                        }
                    }
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m917() {
            int[] iArr = this.f1570;
            if (iArr != null) {
                Arrays.fill(iArr, -1);
            }
            this.f1569 = null;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m919(int i, int i2) {
            int[] iArr = this.f1570;
            if (iArr != null && i < iArr.length) {
                int i3 = i + i2;
                m918(i3);
                int[] iArr2 = this.f1570;
                System.arraycopy(iArr2, i, iArr2, i3, (iArr2.length - i) - i2);
                Arrays.fill(this.f1570, i, i3, -1);
                List<FullSpanItem> list = this.f1569;
                if (list != null) {
                    for (int size = list.size() - 1; size >= 0; size--) {
                        FullSpanItem fullSpanItem = this.f1569.get(size);
                        int i4 = fullSpanItem.f1573;
                        if (i4 >= i) {
                            fullSpanItem.f1573 = i4 + i2;
                        }
                    }
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m920(FullSpanItem fullSpanItem) {
            if (this.f1569 == null) {
                this.f1569 = new ArrayList();
            }
            int size = this.f1569.size();
            for (int i = 0; i < size; i++) {
                FullSpanItem fullSpanItem2 = this.f1569.get(i);
                if (fullSpanItem2.f1573 == fullSpanItem.f1573) {
                    this.f1569.remove(i);
                }
                if (fullSpanItem2.f1573 >= fullSpanItem.f1573) {
                    this.f1569.add(i, fullSpanItem);
                    return;
                }
            }
            this.f1569.add(fullSpanItem);
        }

        /* renamed from: K  reason: contains not printable characters */
        public FullSpanItem m916(int i, int i2, int i3, boolean z) {
            List<FullSpanItem> list = this.f1569;
            if (list == null) {
                return null;
            }
            int size = list.size();
            for (int i4 = 0; i4 < size; i4++) {
                FullSpanItem fullSpanItem = this.f1569.get(i4);
                int i5 = fullSpanItem.f1573;
                if (i5 >= i2) {
                    return null;
                }
                if (i5 >= i && (i3 == 0 || fullSpanItem.f1571 == i3 || (z && fullSpanItem.f1572))) {
                    return fullSpanItem;
                }
            }
            return null;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public View m897(boolean z) {
        int r0 = this.f1545.m6024();
        int r1 = this.f1545.m6018();
        View view = null;
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            View childAt = getChildAt(childCount);
            int r5 = this.f1545.m6027(childAt);
            int r6 = this.f1545.m6022(childAt);
            if (r6 > r0 && r5 < r1) {
                if (r6 <= r1 || !z) {
                    return childAt;
                }
                if (view == null) {
                    view = childAt;
                }
            }
        }
        return view;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public int m908() {
        int childCount = getChildCount();
        if (childCount == 0) {
            return 0;
        }
        return getPosition(getChildAt(childCount - 1));
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m886(int i, int i2, int i3) {
        if (i2 == 0 && i3 == 0) {
            return i;
        }
        int mode = View.MeasureSpec.getMode(i);
        if (mode == Integer.MIN_VALUE || mode == 1073741824) {
            return View.MeasureSpec.makeMeasureSpec(Math.max(0, (View.MeasureSpec.getSize(i) - i2) - i3), mode);
        }
        return i;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m903(RecyclerView.C0264 r3, RecyclerView.C0248 r4, boolean z) {
        int r0;
        int r1 = m885(Integer.MIN_VALUE);
        if (r1 != Integer.MIN_VALUE && (r0 = this.f1545.m6018() - r1) > 0) {
            int i = r0 - (-scrollBy(-r0, r3, r4));
            if (z && i > 0) {
                this.f1545.m6023(i);
            }
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public View m887(boolean z) {
        int r0 = this.f1545.m6024();
        int r1 = this.f1545.m6018();
        int childCount = getChildCount();
        View view = null;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int r6 = this.f1545.m6027(childAt);
            if (this.f1545.m6022(childAt) > r0 && r6 < r1) {
                if (r6 >= r0 || !z) {
                    return childAt;
                }
                if (view == null) {
                    view = childAt;
                }
            }
        }
        return view;
    }

    /* JADX WARNING: Removed duplicated region for block: B:13:0x0027  */
    /* JADX WARNING: Removed duplicated region for block: B:18:0x003e  */
    /* JADX WARNING: Removed duplicated region for block: B:20:0x0045 A[RETURN] */
    /* JADX WARNING: Removed duplicated region for block: B:21:0x0046  */
    /* renamed from: K  reason: contains not printable characters */
    public final void m899(int i, int i2, int i3) {
        int i4;
        int i5;
        int i6;
        int r0 = this.f1554 ? m908() : m883();
        if (i3 != 8) {
            i6 = i + i2;
        } else if (i < i2) {
            i6 = i2 + 1;
        } else {
            i4 = i + 1;
            i5 = i2;
            this.f1568.m921(i5);
            if (i3 != 1) {
                this.f1568.m919(i, i2);
            } else if (i3 == 2) {
                this.f1568.m915(i, i2);
            } else if (i3 == 8) {
                this.f1568.m915(i, 1);
                this.f1568.m919(i2, 1);
            }
            if (i4 <= r0) {
                if (i5 <= (this.f1554 ? m883() : m908())) {
                    requestLayout();
                    return;
                }
                return;
            }
            return;
        }
        i4 = i6;
        i5 = i;
        this.f1568.m921(i5);
        if (i3 != 1) {
        }
        if (i4 <= r0) {
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m891(RecyclerView.C0264 r3, RecyclerView.C0248 r4, boolean z) {
        int r1;
        int r12 = m880(Integer.MAX_VALUE);
        if (r12 != Integer.MAX_VALUE && (r1 = r12 - this.f1545.m6024()) > 0) {
            int scrollBy = r1 - scrollBy(r1, r3, r4);
            if (z && scrollBy > 0) {
                this.f1545.m6023(-scrollBy);
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:151:0x02a1, code lost:
        if (m882() != false) goto L_0x02a5;
     */
    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m881(RecyclerView.C0264 r12, RecyclerView.C0248 r13, boolean z) {
        SavedState savedState;
        int i;
        int i2;
        C0273 r0 = this.f1567;
        if (!(this.f1552 == null && this.f1553 == -1) && r13.m823() == 0) {
            removeAndRecycleAllViews(r12);
            r0.m925();
            return;
        }
        boolean z2 = true;
        boolean z3 = (r0.f1588 && this.f1553 == -1 && this.f1552 == null) ? false : true;
        if (z3) {
            r0.m925();
            SavedState savedState2 = this.f1552;
            if (savedState2 != null) {
                int i3 = savedState2.f1583;
                if (i3 > 0) {
                    if (i3 == this.f1557) {
                        for (int i4 = 0; i4 < this.f1557; i4++) {
                            this.f1555[i4].m928();
                            SavedState savedState3 = this.f1552;
                            int i5 = savedState3.f1576[i4];
                            if (i5 != Integer.MIN_VALUE) {
                                if (savedState3.f1581) {
                                    i2 = this.f1545.m6018();
                                } else {
                                    i2 = this.f1545.m6024();
                                }
                                i5 += i2;
                            }
                            C0275 r7 = this.f1555[i4];
                            r7.f1597 = i5;
                            r7.f1595 = i5;
                        }
                    } else {
                        savedState2.m923();
                        SavedState savedState4 = this.f1552;
                        savedState4.f1579 = savedState4.f1575;
                    }
                }
                SavedState savedState5 = this.f1552;
                this.f1548 = savedState5.f1577;
                setReverseLayout(savedState5.f1578);
                resolveShouldLayoutReverse();
                SavedState savedState6 = this.f1552;
                int i6 = savedState6.f1579;
                if (i6 != -1) {
                    this.f1553 = i6;
                    r0.f1587 = savedState6.f1581;
                } else {
                    r0.f1587 = this.f1554;
                }
                SavedState savedState7 = this.f1552;
                if (savedState7.f1582 > 1) {
                    LazySpanLookup lazySpanLookup = this.f1568;
                    lazySpanLookup.f1570 = savedState7.f1580;
                    lazySpanLookup.f1569 = savedState7.f1584;
                }
            } else {
                resolveShouldLayoutReverse();
                r0.f1587 = this.f1554;
            }
            m889(r13, r0);
            r0.f1588 = true;
        }
        if (this.f1552 == null && this.f1553 == -1 && !(r0.f1587 == this.f1559 && isLayoutRTL() == this.f1548)) {
            this.f1568.m917();
            r0.f1593 = true;
        }
        if (getChildCount() > 0 && ((savedState = this.f1552) == null || savedState.f1583 < 1)) {
            if (r0.f1593) {
                for (int i7 = 0; i7 < this.f1557; i7++) {
                    this.f1555[i7].m928();
                    int i8 = r0.f1589;
                    if (i8 != Integer.MIN_VALUE) {
                        C0275 r72 = this.f1555[i7];
                        r72.f1597 = i8;
                        r72.f1595 = i8;
                    }
                }
            } else if (z3 || this.f1567.f1592 == null) {
                for (int i9 = 0; i9 < this.f1557; i9++) {
                    C0275 r6 = this.f1555[i9];
                    boolean z4 = this.f1554;
                    int i10 = r0.f1589;
                    if (z4) {
                        i = r6.m936(Integer.MIN_VALUE);
                    } else {
                        i = r6.m932(Integer.MIN_VALUE);
                    }
                    r6.m928();
                    if (i != Integer.MIN_VALUE && ((!z4 || i >= StaggeredGridLayoutManager.this.f1545.m6018()) && (z4 || i <= StaggeredGridLayoutManager.this.f1545.m6024()))) {
                        if (i10 != Integer.MIN_VALUE) {
                            i += i10;
                        }
                        r6.f1595 = i;
                        r6.f1597 = i;
                    }
                }
                this.f1567.m927(this.f1555);
            } else {
                for (int i11 = 0; i11 < this.f1557; i11++) {
                    C0275 r62 = this.f1555[i11];
                    r62.m928();
                    int i12 = this.f1567.f1592[i11];
                    r62.f1597 = i12;
                    r62.f1595 = i12;
                }
            }
        }
        detachAndScrapAttachedViews(r12);
        this.f1556.f7980 = false;
        this.f1547 = false;
        m894(this.f1565.m6020());
        m888(r0.f1591, r13);
        if (r0.f1587) {
            m884(-1);
            m896(r12, this.f1556, r13);
            m884(1);
            C2311 r1 = this.f1556;
            r1.f7975 = r0.f1591 + r1.f7982;
            m896(r12, r1, r13);
        } else {
            m884(1);
            m896(r12, this.f1556, r13);
            m884(-1);
            C2311 r14 = this.f1556;
            r14.f7975 = r0.f1591 + r14.f7982;
            m896(r12, r14, r13);
        }
        if (this.f1565.m6026() != 1073741824) {
            int childCount = getChildCount();
            float f = 0.0f;
            for (int i13 = 0; i13 < childCount; i13++) {
                View childAt = getChildAt(i13);
                float r8 = (float) this.f1565.m6019(childAt);
                if (r8 >= f) {
                    if (((C0272) childAt.getLayoutParams()).f1586) {
                        r8 = (r8 * 1.0f) / ((float) this.f1557);
                    }
                    f = Math.max(f, r8);
                }
            }
            int i14 = this.f1563;
            int round = Math.round(f * ((float) this.f1557));
            if (this.f1565.m6026() == Integer.MIN_VALUE) {
                round = Math.min(round, this.f1565.m6020());
            }
            m894(round);
            if (this.f1563 != i14) {
                for (int i15 = 0; i15 < childCount; i15++) {
                    View childAt2 = getChildAt(i15);
                    C0272 r73 = (C0272) childAt2.getLayoutParams();
                    if (!r73.f1586) {
                        if (!isLayoutRTL() || this.f1550 != 1) {
                            int i16 = r73.f1585.f1596;
                            int i17 = this.f1563 * i16;
                            int i18 = i16 * i14;
                            if (this.f1550 == 1) {
                                childAt2.offsetLeftAndRight(i17 - i18);
                            } else {
                                childAt2.offsetTopAndBottom(i17 - i18);
                            }
                        } else {
                            int i19 = this.f1557;
                            int i20 = r73.f1585.f1596;
                            childAt2.offsetLeftAndRight(((-((i19 - 1) - i20)) * this.f1563) - ((-((i19 - 1) - i20)) * i14));
                        }
                    }
                }
            }
        }
        if (getChildCount() > 0) {
            if (this.f1554) {
                m903(r12, r13, true);
                m891(r12, r13, false);
            } else {
                m891(r12, r13, true);
                m903(r12, r13, false);
            }
        }
        if (z && !r13.f1510) {
            if (this.f1546 != 0 && getChildCount() > 0 && (this.f1547 || m893() != null)) {
                removeCallbacks(this.f1562);
            }
        }
        z2 = false;
        if (r13.f1510) {
            this.f1567.m925();
        }
        this.f1559 = r0.f1587;
        this.f1548 = isLayoutRTL();
        if (z2) {
            this.f1567.m925();
            m881(r12, r13, false);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:15:0x0034  */
    /* JADX WARNING: Removed duplicated region for block: B:16:0x004b  */
    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m888(int i, RecyclerView.C0248 r6) {
        int i2;
        int i3;
        int i4;
        C2311 r0 = this.f1556;
        boolean z = false;
        r0.f7978 = 0;
        r0.f7975 = i;
        if (!isSmoothScrolling() || (i4 = r6.f1504) == -1) {
            i3 = 0;
        } else {
            if (this.f1554 == (i4 < i)) {
                i3 = this.f1545.m6020();
            } else {
                i2 = this.f1545.m6020();
                i3 = 0;
                if (!getClipToPadding()) {
                    this.f1556.f7981 = this.f1545.m6024() - i2;
                    this.f1556.f7979 = this.f1545.m6018() + i3;
                } else {
                    this.f1556.f7979 = this.f1545.m6021() + i3;
                    this.f1556.f7981 = -i2;
                }
                C2311 r5 = this.f1556;
                r5.f7983 = false;
                r5.f7980 = true;
                if (this.f1545.m6026() == 0 && this.f1545.m6021() == 0) {
                    z = true;
                }
                r5.f7977 = z;
            }
        }
        i2 = 0;
        if (!getClipToPadding()) {
        }
        C2311 r52 = this.f1556;
        r52.f7983 = false;
        r52.f7980 = true;
        z = true;
        r52.f7977 = z;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m896(RecyclerView.C0264 r19, C2311 r20, RecyclerView.C0248 r21) {
        int i;
        int i2;
        int i3;
        C0275 r1;
        int i4;
        int i5;
        int i6;
        int i7;
        C0272 r12;
        int i8;
        int i9;
        boolean z;
        int i10;
        int i11;
        int i12;
        int i13;
        int i14;
        int i15;
        RecyclerView.C0264 r7 = r19;
        boolean z2 = false;
        this.f1561.set(0, this.f1557, true);
        if (this.f1556.f7977) {
            i = r20.f7976 == 1 ? Integer.MAX_VALUE : Integer.MIN_VALUE;
        } else {
            if (r20.f7976 == 1) {
                i15 = r20.f7979 + r20.f7978;
            } else {
                i15 = r20.f7981 - r20.f7978;
            }
            i = i15;
        }
        m898(r20.f7976, i);
        if (this.f1554) {
            i2 = this.f1545.m6018();
        } else {
            i2 = this.f1545.m6024();
        }
        boolean z3 = false;
        while (true) {
            int i16 = r20.f7975;
            if ((i16 >= 0 && i16 < r21.m823()) && (this.f1556.f7977 || !this.f1561.isEmpty())) {
                View view = r7.m864(r20.f7975, z2, RecyclerView.FOREVER_NS).itemView;
                r20.f7975 += r20.f7982;
                C0272 r5 = (C0272) view.getLayoutParams();
                int r0 = r5.m811();
                int[] iArr = this.f1568.f1570;
                int i17 = (iArr == null || r0 >= iArr.length) ? -1 : iArr[r0];
                boolean z4 = i17 == -1;
                if (z4) {
                    if (r5.f1586) {
                        C0275[] r13 = this.f1555;
                        char c = z2 ? 1 : 0;
                        char c2 = z2 ? 1 : 0;
                        char c3 = z2 ? 1 : 0;
                        r1 = r13[c];
                    } else {
                        if (m911(r20.f7976)) {
                            i14 = this.f1557 - 1;
                            i13 = -1;
                            i12 = -1;
                        } else {
                            i13 = this.f1557;
                            i14 = 0;
                            i12 = 1;
                        }
                        C0275 r17 = null;
                        if (r20.f7976 == 1) {
                            int r11 = this.f1545.m6024();
                            int i18 = Integer.MAX_VALUE;
                            while (i14 != i13) {
                                C0275 r2 = this.f1555[i14];
                                int r10 = r2.m936(r11);
                                if (r10 < i18) {
                                    r17 = r2;
                                    i18 = r10;
                                }
                                i14 += i12;
                            }
                        } else {
                            int r22 = this.f1545.m6018();
                            int i19 = Integer.MIN_VALUE;
                            while (i14 != i13) {
                                C0275 r112 = this.f1555[i14];
                                int r122 = r112.m932(r22);
                                if (r122 > i19) {
                                    r17 = r112;
                                    i19 = r122;
                                }
                                i14 += i12;
                            }
                        }
                        r1 = r17;
                    }
                    LazySpanLookup lazySpanLookup = this.f1568;
                    lazySpanLookup.m918(r0);
                    lazySpanLookup.f1570[r0] = r1.f1596;
                } else {
                    r1 = this.f1555[i17];
                }
                r5.f1585 = r1;
                if (r20.f7976 == 1) {
                    addView(view);
                } else {
                    addView(view, 0);
                }
                if (r5.f1586) {
                    if (this.f1550 == 1) {
                        m901(view, this.f1560, RecyclerView.AbstractC0254.getChildMeasureSpec(getHeight(), getHeightMode(), getPaddingBottom() + getPaddingTop(), ((ViewGroup.MarginLayoutParams) r5).height, true), false);
                    } else {
                        m901(view, RecyclerView.AbstractC0254.getChildMeasureSpec(getWidth(), getWidthMode(), getPaddingRight() + getPaddingLeft(), ((ViewGroup.MarginLayoutParams) r5).width, true), this.f1560, false);
                    }
                } else if (this.f1550 == 1) {
                    m901(view, RecyclerView.AbstractC0254.getChildMeasureSpec(this.f1563, getWidthMode(), 0, ((ViewGroup.MarginLayoutParams) r5).width, false), RecyclerView.AbstractC0254.getChildMeasureSpec(getHeight(), getHeightMode(), getPaddingBottom() + getPaddingTop(), ((ViewGroup.MarginLayoutParams) r5).height, true), false);
                } else {
                    m901(view, RecyclerView.AbstractC0254.getChildMeasureSpec(getWidth(), getWidthMode(), getPaddingRight() + getPaddingLeft(), ((ViewGroup.MarginLayoutParams) r5).width, true), RecyclerView.AbstractC0254.getChildMeasureSpec(this.f1563, getHeightMode(), 0, ((ViewGroup.MarginLayoutParams) r5).height, false), false);
                }
                if (r20.f7976 == 1) {
                    if (r5.f1586) {
                        i11 = m885(i2);
                    } else {
                        i11 = r1.m936(i2);
                    }
                    int r23 = this.f1545.m6019(view) + i11;
                    if (z4 && r5.f1586) {
                        LazySpanLookup.FullSpanItem fullSpanItem = new LazySpanLookup.FullSpanItem();
                        fullSpanItem.f1574 = new int[this.f1557];
                        for (int i20 = 0; i20 < this.f1557; i20++) {
                            fullSpanItem.f1574[i20] = i11 - this.f1555[i20].m936(i11);
                        }
                        fullSpanItem.f1571 = -1;
                        fullSpanItem.f1573 = r0;
                        this.f1568.m920(fullSpanItem);
                    }
                    i5 = i11;
                    i4 = r23;
                } else {
                    if (r5.f1586) {
                        i10 = m880(i2);
                    } else {
                        i10 = r1.m932(i2);
                    }
                    int r24 = i10 - this.f1545.m6019(view);
                    if (z4 && r5.f1586) {
                        LazySpanLookup.FullSpanItem fullSpanItem2 = new LazySpanLookup.FullSpanItem();
                        fullSpanItem2.f1574 = new int[this.f1557];
                        for (int i21 = 0; i21 < this.f1557; i21++) {
                            fullSpanItem2.f1574[i21] = this.f1555[i21].m932(i10) - i10;
                        }
                        fullSpanItem2.f1571 = 1;
                        fullSpanItem2.f1573 = r0;
                        this.f1568.m920(fullSpanItem2);
                    }
                    i4 = i10;
                    i5 = r24;
                }
                if (r5.f1586 && r20.f7982 == -1) {
                    if (z4) {
                        this.f1547 = true;
                    } else {
                        if (r20.f7976 == 1) {
                            z = m906();
                        } else {
                            z = m892();
                        }
                        if (!z) {
                            LazySpanLookup.FullSpanItem r02 = this.f1568.m913(r0);
                            if (r02 != null) {
                                r02.f1572 = true;
                            }
                            this.f1547 = true;
                        }
                    }
                }
                if (r20.f7976 == 1) {
                    if (r5.f1586) {
                        int i22 = this.f1557;
                        while (true) {
                            i22--;
                            if (i22 < 0) {
                                break;
                            }
                            this.f1555[i22].m940(view);
                        }
                    } else {
                        r5.f1585.m940(view);
                    }
                } else if (r5.f1586) {
                    int i23 = this.f1557;
                    while (true) {
                        i23--;
                        if (i23 < 0) {
                            break;
                        }
                        this.f1555[i23].m929(view);
                    }
                } else {
                    r5.f1585.m929(view);
                }
                if (!isLayoutRTL() || this.f1550 != 1) {
                    if (r5.f1586) {
                        i8 = this.f1565.m6024();
                    } else {
                        i8 = (r1.f1596 * this.f1563) + this.f1565.m6024();
                    }
                    i7 = i8;
                    i6 = this.f1565.m6019(view) + i8;
                } else {
                    if (r5.f1586) {
                        i9 = this.f1565.m6018();
                    } else {
                        i9 = this.f1565.m6018() - (((this.f1557 - 1) - r1.f1596) * this.f1563);
                    }
                    i6 = i9;
                    i7 = i9 - this.f1565.m6019(view);
                }
                if (this.f1550 == 1) {
                    r12 = r5;
                    layoutDecoratedWithMargins(view, i7, i5, i6, i4);
                } else {
                    r12 = r5;
                    layoutDecoratedWithMargins(view, i5, i7, i4, i6);
                }
                if (r12.f1586) {
                    m898(this.f1556.f7976, i);
                } else {
                    m905(r1, this.f1556.f7976, i);
                }
                m904(r19, this.f1556);
                if (this.f1556.f7983 && view.hasFocusable()) {
                    if (r12.f1586) {
                        this.f1561.clear();
                    } else {
                        this.f1561.set(r1.f1596, false);
                        r7 = r19;
                        z3 = true;
                        z2 = false;
                    }
                }
                r7 = r19;
                z3 = true;
                z2 = false;
            }
        }
        if (!z3) {
            m904(r7, this.f1556);
        }
        if (this.f1556.f7976 == -1) {
            i3 = this.f1545.m6024() - m880(this.f1545.m6024());
        } else {
            i3 = m885(this.f1545.m6018()) - this.f1545.m6018();
        }
        if (i3 > 0) {
            return Math.min(r20.f7978, i3);
        }
        return 0;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m894(int i) {
        this.f1563 = i / this.f1557;
        this.f1560 = View.MeasureSpec.makeMeasureSpec(i, this.f1565.m6026());
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m892() {
        int r0 = this.f1555[0].m932(Integer.MIN_VALUE);
        for (int i = 1; i < this.f1557; i++) {
            if (this.f1555[i].m932(Integer.MIN_VALUE) != r0) {
                return false;
            }
        }
        return true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m885(int i) {
        int r0 = this.f1555[0].m936(i);
        for (int i2 = 1; i2 < this.f1557; i2++) {
            int r2 = this.f1555[i2].m936(i);
            if (r2 > r0) {
                r0 = r2;
            }
        }
        return r0;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final void m890(RecyclerView.C0264 r6, int i) {
        while (getChildCount() > 0) {
            View childAt = getChildAt(0);
            if (this.f1545.m6022(childAt) <= i && this.f1545.m6017(childAt) <= i) {
                C0272 r2 = (C0272) childAt.getLayoutParams();
                if (r2.f1586) {
                    for (int i2 = 0; i2 < this.f1557; i2++) {
                        if (this.f1555[i2].f1598.size() == 1) {
                            return;
                        }
                    }
                    for (int i3 = 0; i3 < this.f1557; i3++) {
                        this.f1555[i3].m931();
                    }
                } else if (r2.f1585.f1598.size() != 1) {
                    r2.f1585.m931();
                } else {
                    return;
                }
                removeAndRecycleView(childAt, r6);
            } else {
                return;
            }
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final int m880(int i) {
        int r0 = this.f1555[0].m932(i);
        for (int i2 = 1; i2 < this.f1557; i2++) {
            int r2 = this.f1555[i2].m932(i);
            if (r2 < r0) {
                r0 = r2;
            }
        }
        return r0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m904(RecyclerView.C0264 r5, C2311 r6) {
        int i;
        int i2;
        if (r6.f7980 && !r6.f7977) {
            if (r6.f7978 != 0) {
                int i3 = 1;
                if (r6.f7976 == -1) {
                    int i4 = r6.f7981;
                    int r1 = this.f1555[0].m932(i4);
                    while (i3 < this.f1557) {
                        int r2 = this.f1555[i3].m932(i4);
                        if (r2 > r1) {
                            r1 = r2;
                        }
                        i3++;
                    }
                    int i5 = i4 - r1;
                    if (i5 < 0) {
                        i2 = r6.f7979;
                    } else {
                        i2 = r6.f7979 - Math.min(i5, r6.f7978);
                    }
                    m902(r5, i2);
                    return;
                }
                int i6 = r6.f7979;
                int r12 = this.f1555[0].m936(i6);
                while (i3 < this.f1557) {
                    int r22 = this.f1555[i3].m936(i6);
                    if (r22 < r12) {
                        r12 = r22;
                    }
                    i3++;
                }
                int i7 = r12 - r6.f7979;
                if (i7 < 0) {
                    i = r6.f7981;
                } else {
                    i = Math.min(i7, r6.f7978) + r6.f7981;
                }
                m890(r5, i);
            } else if (r6.f7976 == -1) {
                m902(r5, r6.f7979);
            } else {
                m890(r5, r6.f7981);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m898(int i, int i2) {
        for (int i3 = 0; i3 < this.f1557; i3++) {
            if (!this.f1555[i3].f1598.isEmpty()) {
                m905(this.f1555[i3], i, i2);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m906() {
        int r0 = this.f1555[0].m936(Integer.MIN_VALUE);
        for (int i = 1; i < this.f1557; i++) {
            if (this.f1555[i].m936(Integer.MIN_VALUE) != r0) {
                return false;
            }
        }
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m902(RecyclerView.C0264 r7, int i) {
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            View childAt = getChildAt(childCount);
            if (this.f1545.m6027(childAt) >= i && this.f1545.m6025(childAt) >= i) {
                C0272 r3 = (C0272) childAt.getLayoutParams();
                if (r3.f1586) {
                    for (int i2 = 0; i2 < this.f1557; i2++) {
                        if (this.f1555[i2].f1598.size() == 1) {
                            return;
                        }
                    }
                    for (int i3 = 0; i3 < this.f1557; i3++) {
                        this.f1555[i3].m943();
                    }
                } else if (r3.f1585.f1598.size() != 1) {
                    r3.f1585.m943();
                } else {
                    return;
                }
                removeAndRecycleView(childAt, r7);
            } else {
                return;
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m895(int i) {
        if (getChildCount() != 0) {
            if ((i < m883()) != this.f1554) {
                return -1;
            }
            return 1;
        } else if (this.f1554) {
            return 1;
        } else {
            return -1;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m900(int i, RecyclerView.C0248 r6) {
        int i2;
        int i3;
        if (i > 0) {
            i3 = m908();
            i2 = 1;
        } else {
            i3 = m883();
            i2 = -1;
        }
        this.f1556.f7980 = true;
        m888(i3, r6);
        m884(i2);
        C2311 r62 = this.f1556;
        r62.f7975 = i3 + r62.f7982;
        r62.f7978 = Math.abs(i);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m905(C0275 r5, int i, int i2) {
        int i3 = r5.f1600;
        if (i == -1) {
            int i4 = r5.f1597;
            if (i4 == Integer.MIN_VALUE) {
                r5.m934();
                i4 = r5.f1597;
            }
            if (i4 + i3 <= i2) {
                this.f1561.set(r5.f1596, false);
                return;
            }
            return;
        }
        int i5 = r5.f1595;
        if (i5 == Integer.MIN_VALUE) {
            r5.m939();
            i5 = r5.f1595;
        }
        if (i5 - i3 >= i2) {
            this.f1561.set(r5.f1596, false);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m907(RecyclerView.C0248 r6, C0273 r7) {
        int i;
        int i2;
        int i3;
        boolean z = false;
        if (!r6.f1510 && (i = this.f1553) != -1) {
            if (i < 0 || i >= r6.m823()) {
                this.f1553 = -1;
                this.f1558 = Integer.MIN_VALUE;
            } else {
                SavedState savedState = this.f1552;
                if (savedState == null || savedState.f1579 == -1 || savedState.f1583 < 1) {
                    View findViewByPosition = findViewByPosition(this.f1553);
                    if (findViewByPosition != null) {
                        if (this.f1554) {
                            i2 = m908();
                        } else {
                            i2 = m883();
                        }
                        r7.f1591 = i2;
                        if (this.f1558 != Integer.MIN_VALUE) {
                            if (r7.f1587) {
                                r7.f1589 = (this.f1545.m6018() - this.f1558) - this.f1545.m6022(findViewByPosition);
                            } else {
                                r7.f1589 = (this.f1545.m6024() + this.f1558) - this.f1545.m6027(findViewByPosition);
                            }
                            return true;
                        } else if (this.f1545.m6019(findViewByPosition) > this.f1545.m6020()) {
                            if (r7.f1587) {
                                i3 = this.f1545.m6018();
                            } else {
                                i3 = this.f1545.m6024();
                            }
                            r7.f1589 = i3;
                            return true;
                        } else {
                            int r1 = this.f1545.m6027(findViewByPosition) - this.f1545.m6024();
                            if (r1 < 0) {
                                r7.f1589 = -r1;
                                return true;
                            }
                            int r12 = this.f1545.m6018() - this.f1545.m6022(findViewByPosition);
                            if (r12 < 0) {
                                r7.f1589 = r12;
                                return true;
                            }
                            r7.f1589 = Integer.MIN_VALUE;
                        }
                    } else {
                        r7.f1591 = this.f1553;
                        int i4 = this.f1558;
                        if (i4 == Integer.MIN_VALUE) {
                            if (m895(r7.f1591) == 1) {
                                z = true;
                            }
                            r7.f1587 = z;
                            r7.m926();
                        } else if (r7.f1587) {
                            r7.f1589 = StaggeredGridLayoutManager.this.f1545.m6018() - i4;
                        } else {
                            r7.f1589 = StaggeredGridLayoutManager.this.f1545.m6024() + i4;
                        }
                        r7.f1593 = true;
                    }
                } else {
                    r7.f1589 = Integer.MIN_VALUE;
                    r7.f1591 = this.f1553;
                }
                return true;
            }
        }
        return false;
    }
}
