package androidx.recyclerview.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.PointF;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.v4.media.session.MediaSessionCompat;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.accessibility.AccessibilityEvent;
import androidx.recyclerview.widget.RecyclerView;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.㳳.C1841;
import ῲ.䀟.K.AbstractC2303;
import ῲ.䀟.K.AbstractC2332;
import ῲ.䀟.K.C2329;
import ῲ.䀟.K.RunnableC2312;

public class LinearLayoutManager extends RecyclerView.AbstractC0254 implements AbstractC2332, RecyclerView.AbstractC0238.AbstractC0239 {
    public static final boolean DEBUG = false;
    public static final int HORIZONTAL = 0;
    public static final int INVALID_OFFSET = Integer.MIN_VALUE;
    public static final float MAX_SCROLL_FACTOR = 0.33333334f;
    public static final String TAG = "LinearLayoutManager";
    public static final int VERTICAL = 1;
    public final C0229 mAnchorInfo;
    public int mInitialPrefetchItemCount;
    public boolean mLastStackFromEnd;
    public final C0228 mLayoutChunkResult;
    public C0227 mLayoutState;
    public int mOrientation;
    public AbstractC2303 mOrientationHelper;
    public SavedState mPendingSavedState;
    public int mPendingScrollPosition;
    public int mPendingScrollPositionOffset;
    public boolean mRecycleChildrenOnDetach;
    public int[] mReusableIntPair;
    public boolean mReverseLayout;
    public boolean mShouldReverseLayout;
    public boolean mSmoothScrollbarEnabled;
    public boolean mStackFromEnd;

    @SuppressLint({"BanParcelableUsage"})
    public static class SavedState implements Parcelable {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0226();

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1449;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1450;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1451;

        /* renamed from: androidx.recyclerview.widget.LinearLayoutManager$SavedState$K  reason: contains not printable characters */
        public static class C0226 implements Parcelable.Creator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState createFromParcel(Parcel parcel) {
                return new SavedState(parcel);
            }

            /* Return type fixed from 'java.lang.Object[]' to match base method */
            @Override // android.os.Parcelable.Creator
            public SavedState[] newArray(int i) {
                return new SavedState[i];
            }
        }

        public SavedState() {
        }

        public int describeContents() {
            return 0;
        }

        public void writeToParcel(Parcel parcel, int i) {
            parcel.writeInt(this.f1450);
            parcel.writeInt(this.f1449);
            parcel.writeInt(this.f1451 ? 1 : 0);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m792() {
            this.f1450 = -1;
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m793() {
            return this.f1450 >= 0;
        }

        public SavedState(Parcel parcel) {
            this.f1450 = parcel.readInt();
            this.f1449 = parcel.readInt();
            this.f1451 = parcel.readInt() != 1 ? false : true;
        }

        public SavedState(SavedState savedState) {
            this.f1450 = savedState.f1450;
            this.f1449 = savedState.f1449;
            this.f1451 = savedState.f1451;
        }
    }

    /* renamed from: androidx.recyclerview.widget.LinearLayoutManager$ʬ  reason: contains not printable characters */
    public static class C0227 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1452;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1453;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public int f1454;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public int f1455 = 0;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1456;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int f1457;

        /* renamed from: K  reason: contains not printable characters */
        public boolean f1458 = true;

        /* renamed from: 㑃  reason: contains not printable characters */
        public List<RecyclerView.AbstractC0269> f1459 = null;

        /* renamed from: 㳳  reason: contains not printable characters */
        public boolean f1460;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1461;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1462;

        /* renamed from: 㿎  reason: contains not printable characters */
        public int f1463 = 0;

        /* renamed from: 䁗  reason: contains not printable characters */
        public boolean f1464;

        /* renamed from: K  reason: contains not printable characters */
        public boolean m796(RecyclerView.C0248 r2) {
            int i = this.f1462;
            return i >= 0 && i < r2.m823();
        }

        /* renamed from: K  reason: contains not printable characters */
        public View m794(RecyclerView.C0264 r5) {
            List<RecyclerView.AbstractC0269> list = this.f1459;
            if (list != null) {
                int size = list.size();
                for (int i = 0; i < size; i++) {
                    View view = this.f1459.get(i).itemView;
                    RecyclerView.C0235 r2 = (RecyclerView.C0235) view.getLayoutParams();
                    if (!r2.m809() && this.f1462 == r2.m811()) {
                        m795(view);
                        return view;
                    }
                }
                return null;
            }
            View view2 = r5.m864(this.f1462, false, RecyclerView.FOREVER_NS).itemView;
            this.f1462 += this.f1453;
            return view2;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m795(View view) {
            int r5;
            int size = this.f1459.size();
            View view2 = null;
            int i = Integer.MAX_VALUE;
            for (int i2 = 0; i2 < size; i2++) {
                View view3 = this.f1459.get(i2).itemView;
                RecyclerView.C0235 r52 = (RecyclerView.C0235) view3.getLayoutParams();
                if (view3 != view && !r52.m809() && (r5 = (r52.m811() - this.f1462) * this.f1453) >= 0 && r5 < i) {
                    view2 = view3;
                    if (r5 == 0) {
                        break;
                    }
                    i = r5;
                }
            }
            if (view2 == null) {
                this.f1462 = -1;
            } else {
                this.f1462 = ((RecyclerView.C0235) view2.getLayoutParams()).m811();
            }
        }
    }

    /* renamed from: androidx.recyclerview.widget.LinearLayoutManager$ῲ  reason: contains not printable characters */
    public static class C0228 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1465;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1466;

        /* renamed from: K  reason: contains not printable characters */
        public int f1467;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1468;
    }

    public LinearLayoutManager(Context context) {
        this(context, 1, false);
    }

    private int computeScrollExtent(RecyclerView.C0248 r7) {
        if (getChildCount() == 0) {
            return 0;
        }
        ensureLayoutState();
        return C1841.m4769(r7, this.mOrientationHelper, findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    private int computeScrollOffset(RecyclerView.C0248 r8) {
        if (getChildCount() == 0) {
            return 0;
        }
        ensureLayoutState();
        return C1841.m4770(r8, this.mOrientationHelper, findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled, this.mShouldReverseLayout);
    }

    private int computeScrollRange(RecyclerView.C0248 r7) {
        if (getChildCount() == 0) {
            return 0;
        }
        ensureLayoutState();
        return C1841.m4754(r7, this.mOrientationHelper, findFirstVisibleChildClosestToStart(!this.mSmoothScrollbarEnabled, true), findFirstVisibleChildClosestToEnd(!this.mSmoothScrollbarEnabled, true), this, this.mSmoothScrollbarEnabled);
    }

    private View findFirstPartiallyOrCompletelyInvisibleChild() {
        return findOnePartiallyOrCompletelyInvisibleChild(0, getChildCount());
    }

    private View findFirstReferenceChild(RecyclerView.C0264 r7, RecyclerView.C0248 r8) {
        return findReferenceChild(r7, r8, 0, getChildCount(), r8.m823());
    }

    private View findLastPartiallyOrCompletelyInvisibleChild() {
        return findOnePartiallyOrCompletelyInvisibleChild(getChildCount() - 1, -1);
    }

    private View findLastReferenceChild(RecyclerView.C0264 r8, RecyclerView.C0248 r9) {
        return findReferenceChild(r8, r9, getChildCount() - 1, -1, r9.m823());
    }

    private View findPartiallyOrCompletelyInvisibleChildClosestToEnd() {
        if (this.mShouldReverseLayout) {
            return findFirstPartiallyOrCompletelyInvisibleChild();
        }
        return findLastPartiallyOrCompletelyInvisibleChild();
    }

    private View findPartiallyOrCompletelyInvisibleChildClosestToStart() {
        if (this.mShouldReverseLayout) {
            return findLastPartiallyOrCompletelyInvisibleChild();
        }
        return findFirstPartiallyOrCompletelyInvisibleChild();
    }

    private View findReferenceChildClosestToEnd(RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        if (this.mShouldReverseLayout) {
            return findFirstReferenceChild(r2, r3);
        }
        return findLastReferenceChild(r2, r3);
    }

    private View findReferenceChildClosestToStart(RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        if (this.mShouldReverseLayout) {
            return findLastReferenceChild(r2, r3);
        }
        return findFirstReferenceChild(r2, r3);
    }

    private int fixLayoutEndGap(int i, RecyclerView.C0264 r3, RecyclerView.C0248 r4, boolean z) {
        int r42;
        int r0 = this.mOrientationHelper.m6018() - i;
        if (r0 <= 0) {
            return 0;
        }
        int i2 = -scrollBy(-r0, r3, r4);
        int i3 = i + i2;
        if (!z || (r42 = this.mOrientationHelper.m6018() - i3) <= 0) {
            return i2;
        }
        this.mOrientationHelper.m6023(r42);
        return r42 + i2;
    }

    private int fixLayoutStartGap(int i, RecyclerView.C0264 r3, RecyclerView.C0248 r4, boolean z) {
        int r2;
        int r0 = i - this.mOrientationHelper.m6024();
        if (r0 <= 0) {
            return 0;
        }
        int i2 = -scrollBy(r0, r3, r4);
        int i3 = i + i2;
        if (!z || (r2 = i3 - this.mOrientationHelper.m6024()) <= 0) {
            return i2;
        }
        this.mOrientationHelper.m6023(-r2);
        return i2 - r2;
    }

    private View getChildClosestToEnd() {
        return getChildAt(this.mShouldReverseLayout ? 0 : getChildCount() - 1);
    }

    private View getChildClosestToStart() {
        return getChildAt(this.mShouldReverseLayout ? getChildCount() - 1 : 0);
    }

    private void layoutForPredictiveAnimations(RecyclerView.C0264 r16, RecyclerView.C0248 r17, int i, int i2) {
        if (r17.f1505 && getChildCount() != 0 && !r17.f1510 && supportsPredictiveItemAnimations()) {
            List<RecyclerView.AbstractC0269> list = r16.f1541;
            int size = list.size();
            int position = getPosition(getChildAt(0));
            int i3 = 0;
            int i4 = 0;
            for (int i5 = 0; i5 < size; i5++) {
                RecyclerView.AbstractC0269 r10 = list.get(i5);
                if (!r10.isRemoved()) {
                    char c = 1;
                    if ((r10.getLayoutPosition() < position) != this.mShouldReverseLayout) {
                        c = 65535;
                    }
                    if (c == 65535) {
                        i3 = this.mOrientationHelper.m6019(r10.itemView) + i3;
                    } else {
                        i4 = this.mOrientationHelper.m6019(r10.itemView) + i4;
                    }
                }
            }
            this.mLayoutState.f1459 = list;
            if (i3 > 0) {
                updateLayoutStateToFillStart(getPosition(getChildClosestToStart()), i);
                C0227 r4 = this.mLayoutState;
                r4.f1463 = i3;
                r4.f1452 = 0;
                r4.m795((View) null);
                fill(r16, this.mLayoutState, r17, false);
            }
            if (i4 > 0) {
                updateLayoutStateToFillEnd(getPosition(getChildClosestToEnd()), i2);
                C0227 r42 = this.mLayoutState;
                r42.f1463 = i4;
                r42.f1452 = 0;
                r42.m795((View) null);
                fill(r16, this.mLayoutState, r17, false);
            }
            this.mLayoutState.f1459 = null;
        }
    }

    private void logChildren() {
        Log.d(TAG, "internal representation of views on the screen");
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            StringBuilder r3 = C1293.m3416("item ");
            r3.append(getPosition(childAt));
            r3.append(", coord:");
            r3.append(this.mOrientationHelper.m6027(childAt));
            Log.d(TAG, r3.toString());
        }
        Log.d(TAG, "==============");
    }

    private void recycleByLayoutState(RecyclerView.C0264 r4, C0227 r5) {
        if (r5.f1458 && !r5.f1464) {
            int i = r5.f1457;
            int i2 = r5.f1455;
            if (r5.f1461 == -1) {
                recycleViewsFromEnd(r4, i, i2);
            } else {
                recycleViewsFromStart(r4, i, i2);
            }
        }
    }

    private void recycleChildren(RecyclerView.C0264 r1, int i, int i2) {
        if (i != i2) {
            if (i2 > i) {
                for (int i3 = i2 - 1; i3 >= i; i3--) {
                    removeAndRecycleViewAt(i3, r1);
                }
                return;
            }
            while (i > i2) {
                removeAndRecycleViewAt(i, r1);
                i--;
            }
        }
    }

    private void recycleViewsFromEnd(RecyclerView.C0264 r5, int i, int i2) {
        int childCount = getChildCount();
        if (i >= 0) {
            int r1 = (this.mOrientationHelper.m6021() - i) + i2;
            if (this.mShouldReverseLayout) {
                for (int i3 = 0; i3 < childCount; i3++) {
                    View childAt = getChildAt(i3);
                    if (this.mOrientationHelper.m6027(childAt) < r1 || this.mOrientationHelper.m6025(childAt) < r1) {
                        recycleChildren(r5, 0, i3);
                        return;
                    }
                }
                return;
            }
            int i4 = childCount - 1;
            for (int i5 = i4; i5 >= 0; i5--) {
                View childAt2 = getChildAt(i5);
                if (this.mOrientationHelper.m6027(childAt2) < r1 || this.mOrientationHelper.m6025(childAt2) < r1) {
                    recycleChildren(r5, i4, i5);
                    return;
                }
            }
        }
    }

    private void recycleViewsFromStart(RecyclerView.C0264 r5, int i, int i2) {
        if (i >= 0) {
            int i3 = i - i2;
            int childCount = getChildCount();
            if (this.mShouldReverseLayout) {
                int i4 = childCount - 1;
                for (int i5 = i4; i5 >= 0; i5--) {
                    View childAt = getChildAt(i5);
                    if (this.mOrientationHelper.m6022(childAt) > i3 || this.mOrientationHelper.m6017(childAt) > i3) {
                        recycleChildren(r5, i4, i5);
                        return;
                    }
                }
                return;
            }
            for (int i6 = 0; i6 < childCount; i6++) {
                View childAt2 = getChildAt(i6);
                if (this.mOrientationHelper.m6022(childAt2) > i3 || this.mOrientationHelper.m6017(childAt2) > i3) {
                    recycleChildren(r5, 0, i6);
                    return;
                }
            }
        }
    }

    private void resolveShouldLayoutReverse() {
        if (this.mOrientation == 1 || !isLayoutRTL()) {
            this.mShouldReverseLayout = this.mReverseLayout;
        } else {
            this.mShouldReverseLayout = !this.mReverseLayout;
        }
    }

    private boolean updateAnchorFromChildren(RecyclerView.C0264 r5, RecyclerView.C0248 r6, C0229 k) {
        View view;
        int i;
        boolean z = false;
        if (getChildCount() == 0) {
            return false;
        }
        View focusedChild = getFocusedChild();
        if (focusedChild != null && k.m801(focusedChild, r6)) {
            k.m798(focusedChild, getPosition(focusedChild));
            return true;
        } else if (this.mLastStackFromEnd != this.mStackFromEnd) {
            return false;
        } else {
            if (k.f1473) {
                view = findReferenceChildClosestToEnd(r5, r6);
            } else {
                view = findReferenceChildClosestToStart(r5, r6);
            }
            if (view == null) {
                return false;
            }
            k.m800(view, getPosition(view));
            if (!r6.f1510 && supportsPredictiveItemAnimations()) {
                if (this.mOrientationHelper.m6027(view) >= this.mOrientationHelper.m6018() || this.mOrientationHelper.m6022(view) < this.mOrientationHelper.m6024()) {
                    z = true;
                }
                if (z) {
                    if (k.f1473) {
                        i = this.mOrientationHelper.m6018();
                    } else {
                        i = this.mOrientationHelper.m6024();
                    }
                    k.f1469 = i;
                }
            }
            return true;
        }
    }

    private boolean updateAnchorFromPendingData(RecyclerView.C0248 r5, C0229 k) {
        int i;
        int i2;
        boolean z = false;
        if (!r5.f1510 && (i = this.mPendingScrollPosition) != -1) {
            if (i < 0 || i >= r5.m823()) {
                this.mPendingScrollPosition = -1;
                this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
            } else {
                k.f1471 = this.mPendingScrollPosition;
                SavedState savedState = this.mPendingSavedState;
                if (savedState != null && savedState.m793()) {
                    k.f1473 = this.mPendingSavedState.f1451;
                    if (k.f1473) {
                        k.f1469 = this.mOrientationHelper.m6018() - this.mPendingSavedState.f1449;
                    } else {
                        k.f1469 = this.mOrientationHelper.m6024() + this.mPendingSavedState.f1449;
                    }
                    return true;
                } else if (this.mPendingScrollPositionOffset == Integer.MIN_VALUE) {
                    View findViewByPosition = findViewByPosition(this.mPendingScrollPosition);
                    if (findViewByPosition == null) {
                        if (getChildCount() > 0) {
                            if ((this.mPendingScrollPosition < getPosition(getChildAt(0))) == this.mShouldReverseLayout) {
                                z = true;
                            }
                            k.f1473 = z;
                        }
                        k.m799();
                    } else if (this.mOrientationHelper.m6019(findViewByPosition) > this.mOrientationHelper.m6020()) {
                        k.m799();
                        return true;
                    } else if (this.mOrientationHelper.m6027(findViewByPosition) - this.mOrientationHelper.m6024() < 0) {
                        k.f1469 = this.mOrientationHelper.m6024();
                        k.f1473 = false;
                        return true;
                    } else if (this.mOrientationHelper.m6018() - this.mOrientationHelper.m6022(findViewByPosition) < 0) {
                        k.f1469 = this.mOrientationHelper.m6018();
                        k.f1473 = true;
                        return true;
                    } else {
                        if (k.f1473) {
                            i2 = this.mOrientationHelper.m6028() + this.mOrientationHelper.m6022(findViewByPosition);
                        } else {
                            i2 = this.mOrientationHelper.m6027(findViewByPosition);
                        }
                        k.f1469 = i2;
                    }
                    return true;
                } else {
                    boolean z2 = this.mShouldReverseLayout;
                    k.f1473 = z2;
                    if (z2) {
                        k.f1469 = this.mOrientationHelper.m6018() - this.mPendingScrollPositionOffset;
                    } else {
                        k.f1469 = this.mOrientationHelper.m6024() + this.mPendingScrollPositionOffset;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private void updateAnchorInfoForLayout(RecyclerView.C0264 r2, RecyclerView.C0248 r3, C0229 k) {
        if (!updateAnchorFromPendingData(r3, k) && !updateAnchorFromChildren(r2, r3, k)) {
            k.m799();
            k.f1471 = this.mStackFromEnd ? r3.m823() - 1 : 0;
        }
    }

    private void updateLayoutState(int i, int i2, boolean z, RecyclerView.C0248 r8) {
        int i3;
        this.mLayoutState.f1464 = resolveIsInfinite();
        this.mLayoutState.f1461 = i;
        int[] iArr = this.mReusableIntPair;
        boolean z2 = false;
        iArr[0] = 0;
        iArr[1] = 0;
        calculateExtraLayoutSpace(r8, iArr);
        int max = Math.max(0, this.mReusableIntPair[0]);
        int max2 = Math.max(0, this.mReusableIntPair[1]);
        if (i == 1) {
            z2 = true;
        }
        this.mLayoutState.f1463 = z2 ? max2 : max;
        C0227 r5 = this.mLayoutState;
        if (!z2) {
            max = max2;
        }
        r5.f1455 = max;
        int i4 = -1;
        if (z2) {
            C0227 r82 = this.mLayoutState;
            r82.f1463 = this.mOrientationHelper.m6014() + r82.f1463;
            View childClosestToEnd = getChildClosestToEnd();
            C0227 r0 = this.mLayoutState;
            if (!this.mShouldReverseLayout) {
                i4 = 1;
            }
            r0.f1453 = i4;
            C0227 r52 = this.mLayoutState;
            int position = getPosition(childClosestToEnd);
            C0227 r1 = this.mLayoutState;
            r52.f1462 = position + r1.f1453;
            r1.f1456 = this.mOrientationHelper.m6022(childClosestToEnd);
            i3 = this.mOrientationHelper.m6022(childClosestToEnd) - this.mOrientationHelper.m6018();
        } else {
            View childClosestToStart = getChildClosestToStart();
            C0227 r02 = this.mLayoutState;
            r02.f1463 = this.mOrientationHelper.m6024() + r02.f1463;
            C0227 r03 = this.mLayoutState;
            if (this.mShouldReverseLayout) {
                i4 = 1;
            }
            r03.f1453 = i4;
            C0227 r53 = this.mLayoutState;
            int position2 = getPosition(childClosestToStart);
            C0227 r12 = this.mLayoutState;
            r53.f1462 = position2 + r12.f1453;
            r12.f1456 = this.mOrientationHelper.m6027(childClosestToStart);
            i3 = (-this.mOrientationHelper.m6027(childClosestToStart)) + this.mOrientationHelper.m6024();
        }
        C0227 r83 = this.mLayoutState;
        r83.f1452 = i2;
        if (z) {
            r83.f1452 -= i3;
        }
        this.mLayoutState.f1457 = i3;
    }

    private void updateLayoutStateToFillEnd(C0229 k) {
        updateLayoutStateToFillEnd(k.f1471, k.f1469);
    }

    private void updateLayoutStateToFillStart(C0229 k) {
        updateLayoutStateToFillStart(k.f1471, k.f1469);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void assertNotInLayoutOrScroll(String str) {
        if (this.mPendingSavedState == null) {
            super.assertNotInLayoutOrScroll(str);
        }
    }

    public void calculateExtraLayoutSpace(RecyclerView.C0248 r4, int[] iArr) {
        int i;
        int extraLayoutSpace = getExtraLayoutSpace(r4);
        if (this.mLayoutState.f1461 == -1) {
            i = 0;
        } else {
            i = extraLayoutSpace;
            extraLayoutSpace = 0;
        }
        iArr[0] = extraLayoutSpace;
        iArr[1] = i;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean canScrollHorizontally() {
        return this.mOrientation == 0;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean canScrollVertically() {
        return this.mOrientation == 1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void collectAdjacentPrefetchPositions(int i, int i2, RecyclerView.C0248 r4, RecyclerView.AbstractC0254.AbstractC0255 r5) {
        if (this.mOrientation != 0) {
            i = i2;
        }
        if (getChildCount() != 0 && i != 0) {
            ensureLayoutState();
            updateLayoutState(i > 0 ? 1 : -1, Math.abs(i), true, r4);
            collectPrefetchPositionsForLayoutState(r4, this.mLayoutState, r5);
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void collectInitialPrefetchPositions(int i, RecyclerView.AbstractC0254.AbstractC0255 r7) {
        boolean z;
        int i2;
        SavedState savedState = this.mPendingSavedState;
        int i3 = -1;
        if (savedState == null || !savedState.m793()) {
            resolveShouldLayoutReverse();
            z = this.mShouldReverseLayout;
            i2 = this.mPendingScrollPosition;
            if (i2 == -1) {
                i2 = z ? i - 1 : 0;
            }
        } else {
            SavedState savedState2 = this.mPendingSavedState;
            z = savedState2.f1451;
            i2 = savedState2.f1450;
        }
        if (!z) {
            i3 = 1;
        }
        int i4 = i2;
        for (int i5 = 0; i5 < this.mInitialPrefetchItemCount && i4 >= 0 && i4 < i; i5++) {
            ((RunnableC2312.C2314) r7).m6043(i4, 0);
            i4 += i3;
        }
    }

    public void collectPrefetchPositionsForLayoutState(RecyclerView.C0248 r2, C0227 r3, RecyclerView.AbstractC0254.AbstractC0255 r4) {
        int i = r3.f1462;
        if (i >= 0 && i < r2.m823()) {
            ((RunnableC2312.C2314) r4).m6043(i, Math.max(0, r3.f1457));
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollExtent(RecyclerView.C0248 r1) {
        return computeScrollExtent(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollOffset(RecyclerView.C0248 r1) {
        return computeScrollOffset(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollRange(RecyclerView.C0248 r1) {
        return computeScrollRange(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0238.AbstractC0239
    public PointF computeScrollVectorForPosition(int i) {
        if (getChildCount() == 0) {
            return null;
        }
        boolean z = false;
        int i2 = 1;
        if (i < getPosition(getChildAt(0))) {
            z = true;
        }
        if (z != this.mShouldReverseLayout) {
            i2 = -1;
        }
        if (this.mOrientation == 0) {
            return new PointF((float) i2, 0.0f);
        }
        return new PointF(0.0f, (float) i2);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollExtent(RecyclerView.C0248 r1) {
        return computeScrollExtent(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollOffset(RecyclerView.C0248 r1) {
        return computeScrollOffset(r1);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollRange(RecyclerView.C0248 r1) {
        return computeScrollRange(r1);
    }

    public int convertFocusDirectionToLayoutDirection(int i) {
        if (i == 1) {
            return (this.mOrientation != 1 && isLayoutRTL()) ? 1 : -1;
        }
        if (i == 2) {
            return (this.mOrientation != 1 && isLayoutRTL()) ? -1 : 1;
        }
        if (i != 17) {
            if (i != 33) {
                if (i != 66) {
                    return (i == 130 && this.mOrientation == 1) ? 1 : Integer.MIN_VALUE;
                }
                if (this.mOrientation == 0) {
                    return 1;
                }
                return Integer.MIN_VALUE;
            } else if (this.mOrientation == 1) {
                return -1;
            } else {
                return Integer.MIN_VALUE;
            }
        } else if (this.mOrientation == 0) {
            return -1;
        } else {
            return Integer.MIN_VALUE;
        }
    }

    public C0227 createLayoutState() {
        return new C0227();
    }

    public void ensureLayoutState() {
        if (this.mLayoutState == null) {
            this.mLayoutState = createLayoutState();
        }
    }

    public int fill(RecyclerView.C0264 r8, C0227 r9, RecyclerView.C0248 r10, boolean z) {
        int i = r9.f1452;
        int i2 = r9.f1457;
        if (i2 != Integer.MIN_VALUE) {
            if (i < 0) {
                r9.f1457 = i2 + i;
            }
            recycleByLayoutState(r8, r9);
        }
        int i3 = r9.f1452 + r9.f1463;
        C0228 r3 = this.mLayoutChunkResult;
        while (true) {
            if ((!r9.f1464 && i3 <= 0) || !r9.m796(r10)) {
                break;
            }
            r3.f1467 = 0;
            r3.f1466 = false;
            r3.f1465 = false;
            r3.f1468 = false;
            layoutChunk(r8, r10, r9, r3);
            if (!r3.f1466) {
                r9.f1456 = (r3.f1467 * r9.f1461) + r9.f1456;
                if (!r3.f1465 || r9.f1459 != null || !r10.f1510) {
                    int i4 = r9.f1452;
                    int i5 = r3.f1467;
                    r9.f1452 = i4 - i5;
                    i3 -= i5;
                }
                int i6 = r9.f1457;
                if (i6 != Integer.MIN_VALUE) {
                    r9.f1457 = i6 + r3.f1467;
                    int i7 = r9.f1452;
                    if (i7 < 0) {
                        r9.f1457 += i7;
                    }
                    recycleByLayoutState(r8, r9);
                }
                if (z && r3.f1468) {
                    break;
                }
            } else {
                break;
            }
        }
        return i - r9.f1452;
    }

    public int findFirstCompletelyVisibleItemPosition() {
        View findOneVisibleChild = findOneVisibleChild(0, getChildCount(), true, false);
        if (findOneVisibleChild == null) {
            return -1;
        }
        return getPosition(findOneVisibleChild);
    }

    public View findFirstVisibleChildClosestToEnd(boolean z, boolean z2) {
        if (this.mShouldReverseLayout) {
            return findOneVisibleChild(0, getChildCount(), z, z2);
        }
        return findOneVisibleChild(getChildCount() - 1, -1, z, z2);
    }

    public View findFirstVisibleChildClosestToStart(boolean z, boolean z2) {
        if (this.mShouldReverseLayout) {
            return findOneVisibleChild(getChildCount() - 1, -1, z, z2);
        }
        return findOneVisibleChild(0, getChildCount(), z, z2);
    }

    public int findFirstVisibleItemPosition() {
        View findOneVisibleChild = findOneVisibleChild(0, getChildCount(), false, true);
        if (findOneVisibleChild == null) {
            return -1;
        }
        return getPosition(findOneVisibleChild);
    }

    public int findLastCompletelyVisibleItemPosition() {
        View findOneVisibleChild = findOneVisibleChild(getChildCount() - 1, -1, true, false);
        if (findOneVisibleChild == null) {
            return -1;
        }
        return getPosition(findOneVisibleChild);
    }

    public int findLastVisibleItemPosition() {
        View findOneVisibleChild = findOneVisibleChild(getChildCount() - 1, -1, false, true);
        if (findOneVisibleChild == null) {
            return -1;
        }
        return getPosition(findOneVisibleChild);
    }

    public View findOnePartiallyOrCompletelyInvisibleChild(int i, int i2) {
        int i3;
        int i4;
        ensureLayoutState();
        if ((i2 > i ? 1 : i2 < i ? (char) 65535 : 0) == 0) {
            return getChildAt(i);
        }
        if (this.mOrientationHelper.m6027(getChildAt(i)) < this.mOrientationHelper.m6024()) {
            i4 = 16644;
            i3 = 16388;
        } else {
            i4 = 4161;
            i3 = 4097;
        }
        if (this.mOrientation == 0) {
            return this.mHorizontalBoundCheck.m6116(i, i2, i4, i3);
        }
        return this.mVerticalBoundCheck.m6116(i, i2, i4, i3);
    }

    public View findOneVisibleChild(int i, int i2, boolean z, boolean z2) {
        ensureLayoutState();
        int i3 = MediaSessionCompat.MAX_BITMAP_SIZE_IN_DP;
        int i4 = z ? 24579 : MediaSessionCompat.MAX_BITMAP_SIZE_IN_DP;
        if (!z2) {
            i3 = 0;
        }
        if (this.mOrientation == 0) {
            return this.mHorizontalBoundCheck.m6116(i, i2, i4, i3);
        }
        return this.mVerticalBoundCheck.m6116(i, i2, i4, i3);
    }

    public View findReferenceChild(RecyclerView.C0264 r6, RecyclerView.C0248 r7, int i, int i2, int i3) {
        ensureLayoutState();
        int r62 = this.mOrientationHelper.m6024();
        int r72 = this.mOrientationHelper.m6018();
        int i4 = i2 > i ? 1 : -1;
        View view = null;
        View view2 = null;
        while (i != i2) {
            View childAt = getChildAt(i);
            int position = getPosition(childAt);
            if (position >= 0 && position < i3) {
                if (((RecyclerView.C0235) childAt.getLayoutParams()).m809()) {
                    if (view2 == null) {
                        view2 = childAt;
                    }
                } else if (this.mOrientationHelper.m6027(childAt) < r72 && this.mOrientationHelper.m6022(childAt) >= r62) {
                    return childAt;
                } else {
                    if (view == null) {
                        view = childAt;
                    }
                }
            }
            i += i4;
        }
        return view != null ? view : view2;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public View findViewByPosition(int i) {
        int childCount = getChildCount();
        if (childCount == 0) {
            return null;
        }
        int position = i - getPosition(getChildAt(0));
        if (position >= 0 && position < childCount) {
            View childAt = getChildAt(position);
            if (getPosition(childAt) == i) {
                return childAt;
            }
        }
        return super.findViewByPosition(i);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateDefaultLayoutParams() {
        return new RecyclerView.C0235(-2, -2);
    }

    @Deprecated
    public int getExtraLayoutSpace(RecyclerView.C0248 r3) {
        if (r3.f1504 != -1) {
            return this.mOrientationHelper.m6020();
        }
        return 0;
    }

    public int getInitialPrefetchItemCount() {
        return this.mInitialPrefetchItemCount;
    }

    public int getOrientation() {
        return this.mOrientation;
    }

    public boolean getRecycleChildrenOnDetach() {
        return this.mRecycleChildrenOnDetach;
    }

    public boolean getReverseLayout() {
        return this.mReverseLayout;
    }

    public boolean getStackFromEnd() {
        return this.mStackFromEnd;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean isAutoMeasureEnabled() {
        return true;
    }

    public boolean isLayoutRTL() {
        return getLayoutDirection() == 1;
    }

    public boolean isSmoothScrollbarEnabled() {
        return this.mSmoothScrollbarEnabled;
    }

    public void layoutChunk(RecyclerView.C0264 r8, RecyclerView.C0248 r9, C0227 r10, C0228 r11) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        View r82 = r10.m794(r8);
        if (r82 == null) {
            r11.f1466 = true;
            return;
        }
        RecyclerView.C0235 r6 = (RecyclerView.C0235) r82.getLayoutParams();
        if (r10.f1459 == null) {
            if (this.mShouldReverseLayout == (r10.f1461 == -1)) {
                addView(r82);
            } else {
                addView(r82, 0);
            }
        } else {
            if (this.mShouldReverseLayout == (r10.f1461 == -1)) {
                addDisappearingView(r82);
            } else {
                addDisappearingView(r82, 0);
            }
        }
        measureChildWithMargins(r82, 0, 0);
        r11.f1467 = this.mOrientationHelper.m6019(r82);
        if (this.mOrientation == 1) {
            if (isLayoutRTL()) {
                i5 = getWidth() - getPaddingRight();
                i4 = i5 - this.mOrientationHelper.m6015(r82);
            } else {
                i4 = getPaddingLeft();
                i5 = this.mOrientationHelper.m6015(r82) + i4;
            }
            if (r10.f1461 == -1) {
                int i6 = r10.f1456;
                i = i6;
                i2 = i5;
                i3 = i6 - r11.f1467;
            } else {
                int i7 = r10.f1456;
                i3 = i7;
                i2 = i5;
                i = r11.f1467 + i7;
            }
        } else {
            int paddingTop = getPaddingTop();
            int r2 = this.mOrientationHelper.m6015(r82) + paddingTop;
            if (r10.f1461 == -1) {
                int i8 = r10.f1456;
                i2 = i8;
                i3 = paddingTop;
                i = r2;
                i4 = i8 - r11.f1467;
            } else {
                int i9 = r10.f1456;
                i3 = paddingTop;
                i2 = r11.f1467 + i9;
                i = r2;
                i4 = i9;
            }
        }
        layoutDecoratedWithMargins(r82, i4, i3, i2, i);
        if (r6.m809() || r6.m810()) {
            r11.f1465 = true;
        }
        r11.f1468 = r82.hasFocusable();
    }

    public void onAnchorReady(RecyclerView.C0264 r1, RecyclerView.C0248 r2, C0229 k, int i) {
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onDetachedFromWindow(RecyclerView recyclerView, RecyclerView.C0264 r2) {
        super.onDetachedFromWindow(recyclerView, r2);
        if (this.mRecycleChildrenOnDetach) {
            removeAndRecycleAllViews(r2);
            r2.m865();
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public View onFocusSearchFailed(View view, int i, RecyclerView.C0264 r6, RecyclerView.C0248 r7) {
        int convertFocusDirectionToLayoutDirection;
        View view2;
        View view3;
        resolveShouldLayoutReverse();
        if (getChildCount() == 0 || (convertFocusDirectionToLayoutDirection = convertFocusDirectionToLayoutDirection(i)) == Integer.MIN_VALUE) {
            return null;
        }
        ensureLayoutState();
        updateLayoutState(convertFocusDirectionToLayoutDirection, (int) (((float) this.mOrientationHelper.m6020()) * 0.33333334f), false, r7);
        C0227 r1 = this.mLayoutState;
        r1.f1457 = Integer.MIN_VALUE;
        r1.f1458 = false;
        fill(r6, r1, r7, true);
        if (convertFocusDirectionToLayoutDirection == -1) {
            view2 = findPartiallyOrCompletelyInvisibleChildClosestToStart();
        } else {
            view2 = findPartiallyOrCompletelyInvisibleChildClosestToEnd();
        }
        if (convertFocusDirectionToLayoutDirection == -1) {
            view3 = getChildClosestToStart();
        } else {
            view3 = getChildClosestToEnd();
        }
        if (!view3.hasFocusable()) {
            return view2;
        }
        if (view2 == null) {
            return null;
        }
        return view3;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
        super.onInitializeAccessibilityEvent(accessibilityEvent);
        if (getChildCount() > 0) {
            accessibilityEvent.setFromIndex(findFirstVisibleItemPosition());
            accessibilityEvent.setToIndex(findLastVisibleItemPosition());
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutChildren(RecyclerView.C0264 r9, RecyclerView.C0248 r10) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        View findViewByPosition;
        int i7;
        int i8;
        int i9 = -1;
        if (!(this.mPendingSavedState == null && this.mPendingScrollPosition == -1) && r10.m823() == 0) {
            removeAndRecycleAllViews(r9);
            return;
        }
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null && savedState.m793()) {
            this.mPendingScrollPosition = this.mPendingSavedState.f1450;
        }
        ensureLayoutState();
        this.mLayoutState.f1458 = false;
        resolveShouldLayoutReverse();
        View focusedChild = getFocusedChild();
        if (!this.mAnchorInfo.f1470 || this.mPendingScrollPosition != -1 || this.mPendingSavedState != null) {
            this.mAnchorInfo.m797();
            C0229 k = this.mAnchorInfo;
            k.f1473 = this.mShouldReverseLayout ^ this.mStackFromEnd;
            updateAnchorInfoForLayout(r9, r10, k);
            this.mAnchorInfo.f1470 = true;
        } else if (focusedChild != null && (this.mOrientationHelper.m6027(focusedChild) >= this.mOrientationHelper.m6018() || this.mOrientationHelper.m6022(focusedChild) <= this.mOrientationHelper.m6024())) {
            this.mAnchorInfo.m798(focusedChild, getPosition(focusedChild));
        }
        C0227 r0 = this.mLayoutState;
        r0.f1461 = r0.f1454 >= 0 ? 1 : -1;
        int[] iArr = this.mReusableIntPair;
        iArr[0] = 0;
        iArr[1] = 0;
        calculateExtraLayoutSpace(r10, iArr);
        int r3 = this.mOrientationHelper.m6024() + Math.max(0, this.mReusableIntPair[0]);
        int r5 = this.mOrientationHelper.m6014() + Math.max(0, this.mReusableIntPair[1]);
        if (!(!r10.f1510 || (i6 = this.mPendingScrollPosition) == -1 || this.mPendingScrollPositionOffset == Integer.MIN_VALUE || (findViewByPosition = findViewByPosition(i6)) == null)) {
            if (this.mShouldReverseLayout) {
                i7 = this.mOrientationHelper.m6018() - this.mOrientationHelper.m6022(findViewByPosition);
                i8 = this.mPendingScrollPositionOffset;
            } else {
                i8 = this.mOrientationHelper.m6027(findViewByPosition) - this.mOrientationHelper.m6024();
                i7 = this.mPendingScrollPositionOffset;
            }
            int i10 = i7 - i8;
            if (i10 > 0) {
                r3 += i10;
            } else {
                r5 -= i10;
            }
        }
        if (!this.mAnchorInfo.f1473 ? !this.mShouldReverseLayout : this.mShouldReverseLayout) {
            i9 = 1;
        }
        onAnchorReady(r9, r10, this.mAnchorInfo, i9);
        detachAndScrapAttachedViews(r9);
        this.mLayoutState.f1464 = resolveIsInfinite();
        C0227 r02 = this.mLayoutState;
        r02.f1460 = r10.f1510;
        r02.f1455 = 0;
        C0229 k2 = this.mAnchorInfo;
        if (k2.f1473) {
            updateLayoutStateToFillStart(k2);
            C0227 r03 = this.mLayoutState;
            r03.f1463 = r3;
            fill(r9, r03, r10, false);
            C0227 r04 = this.mLayoutState;
            int i11 = r04.f1456;
            int i12 = r04.f1462;
            int i13 = r04.f1452;
            if (i13 > 0) {
                r5 += i13;
            }
            updateLayoutStateToFillEnd(this.mAnchorInfo);
            C0227 r05 = this.mLayoutState;
            r05.f1463 = r5;
            r05.f1462 += r05.f1453;
            fill(r9, r05, r10, false);
            C0227 r06 = this.mLayoutState;
            i = r06.f1456;
            int i14 = r06.f1452;
            if (i14 > 0) {
                updateLayoutStateToFillStart(i12, i11);
                C0227 r1 = this.mLayoutState;
                r1.f1463 = i14;
                fill(r9, r1, r10, false);
                i11 = this.mLayoutState.f1456;
            }
            i2 = i11;
        } else {
            updateLayoutStateToFillEnd(k2);
            C0227 r07 = this.mLayoutState;
            r07.f1463 = r5;
            fill(r9, r07, r10, false);
            C0227 r08 = this.mLayoutState;
            i = r08.f1456;
            int i15 = r08.f1462;
            int i16 = r08.f1452;
            if (i16 > 0) {
                r3 += i16;
            }
            updateLayoutStateToFillStart(this.mAnchorInfo);
            C0227 r09 = this.mLayoutState;
            r09.f1463 = r3;
            r09.f1462 += r09.f1453;
            fill(r9, r09, r10, false);
            C0227 r010 = this.mLayoutState;
            i2 = r010.f1456;
            int i17 = r010.f1452;
            if (i17 > 0) {
                updateLayoutStateToFillEnd(i15, i);
                C0227 r12 = this.mLayoutState;
                r12.f1463 = i17;
                fill(r9, r12, r10, false);
                i = this.mLayoutState.f1456;
            }
        }
        if (getChildCount() > 0) {
            if (this.mShouldReverseLayout ^ this.mStackFromEnd) {
                int fixLayoutEndGap = fixLayoutEndGap(i, r9, r10, true);
                i4 = i2 + fixLayoutEndGap;
                i3 = i + fixLayoutEndGap;
                i5 = fixLayoutStartGap(i4, r9, r10, false);
            } else {
                int fixLayoutStartGap = fixLayoutStartGap(i2, r9, r10, true);
                i4 = i2 + fixLayoutStartGap;
                i3 = i + fixLayoutStartGap;
                i5 = fixLayoutEndGap(i3, r9, r10, false);
            }
            i2 = i4 + i5;
            i = i3 + i5;
        }
        layoutForPredictiveAnimations(r9, r10, i2, i);
        if (!r10.f1510) {
            AbstractC2303 r92 = this.mOrientationHelper;
            r92.f7962 = r92.m6020();
        } else {
            this.mAnchorInfo.m797();
        }
        this.mLastStackFromEnd = this.mStackFromEnd;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutCompleted(RecyclerView.C0248 r1) {
        super.onLayoutCompleted(r1);
        this.mPendingSavedState = null;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mAnchorInfo.m797();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onRestoreInstanceState(Parcelable parcelable) {
        if (parcelable instanceof SavedState) {
            this.mPendingSavedState = (SavedState) parcelable;
            requestLayout();
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public Parcelable onSaveInstanceState() {
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            return new SavedState(savedState);
        }
        SavedState savedState2 = new SavedState();
        if (getChildCount() > 0) {
            ensureLayoutState();
            boolean z = this.mLastStackFromEnd ^ this.mShouldReverseLayout;
            savedState2.f1451 = z;
            if (z) {
                View childClosestToEnd = getChildClosestToEnd();
                savedState2.f1449 = this.mOrientationHelper.m6018() - this.mOrientationHelper.m6022(childClosestToEnd);
                savedState2.f1450 = getPosition(childClosestToEnd);
            } else {
                View childClosestToStart = getChildClosestToStart();
                savedState2.f1450 = getPosition(childClosestToStart);
                savedState2.f1449 = this.mOrientationHelper.m6027(childClosestToStart) - this.mOrientationHelper.m6024();
            }
        } else {
            savedState2.m792();
        }
        return savedState2;
    }

    public void prepareForDrop(View view, View view2, int i, int i2) {
        assertNotInLayoutOrScroll("Cannot drop a view during a scroll or layout calculation");
        ensureLayoutState();
        resolveShouldLayoutReverse();
        int position = getPosition(view);
        int position2 = getPosition(view2);
        char c = position < position2 ? (char) 1 : 65535;
        if (this.mShouldReverseLayout) {
            if (c == 1) {
                scrollToPositionWithOffset(position2, this.mOrientationHelper.m6018() - (this.mOrientationHelper.m6019(view) + this.mOrientationHelper.m6027(view2)));
            } else {
                scrollToPositionWithOffset(position2, this.mOrientationHelper.m6018() - this.mOrientationHelper.m6022(view2));
            }
        } else if (c == 65535) {
            scrollToPositionWithOffset(position2, this.mOrientationHelper.m6027(view2));
        } else {
            scrollToPositionWithOffset(position2, this.mOrientationHelper.m6022(view2) - this.mOrientationHelper.m6019(view));
        }
    }

    public boolean resolveIsInfinite() {
        return this.mOrientationHelper.m6026() == 0 && this.mOrientationHelper.m6021() == 0;
    }

    public int scrollBy(int i, RecyclerView.C0264 r7, RecyclerView.C0248 r8) {
        if (getChildCount() == 0 || i == 0) {
            return 0;
        }
        ensureLayoutState();
        this.mLayoutState.f1458 = true;
        int i2 = i > 0 ? 1 : -1;
        int abs = Math.abs(i);
        updateLayoutState(i2, abs, true, r8);
        C0227 r2 = this.mLayoutState;
        int fill = fill(r7, r2, r8, false) + r2.f1457;
        if (fill < 0) {
            return 0;
        }
        if (abs > fill) {
            i = i2 * fill;
        }
        this.mOrientationHelper.m6023(-i);
        this.mLayoutState.f1454 = i;
        return i;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollHorizontallyBy(int i, RecyclerView.C0264 r4, RecyclerView.C0248 r5) {
        if (this.mOrientation == 1) {
            return 0;
        }
        return scrollBy(i, r4, r5);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void scrollToPosition(int i) {
        this.mPendingScrollPosition = i;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            savedState.m792();
        }
        requestLayout();
    }

    public void scrollToPositionWithOffset(int i, int i2) {
        this.mPendingScrollPosition = i;
        this.mPendingScrollPositionOffset = i2;
        SavedState savedState = this.mPendingSavedState;
        if (savedState != null) {
            savedState.m792();
        }
        requestLayout();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollVerticallyBy(int i, RecyclerView.C0264 r3, RecyclerView.C0248 r4) {
        if (this.mOrientation == 0) {
            return 0;
        }
        return scrollBy(i, r3, r4);
    }

    public void setInitialPrefetchItemCount(int i) {
        this.mInitialPrefetchItemCount = i;
    }

    public void setOrientation(int i) {
        if (i == 0 || i == 1) {
            assertNotInLayoutOrScroll(null);
            if (i != this.mOrientation || this.mOrientationHelper == null) {
                this.mOrientationHelper = AbstractC2303.m6013(this, i);
                this.mAnchorInfo.f1472 = this.mOrientationHelper;
                this.mOrientation = i;
                requestLayout();
                return;
            }
            return;
        }
        throw new IllegalArgumentException(C1293.m3408("invalid orientation:", i));
    }

    public void setRecycleChildrenOnDetach(boolean z) {
        this.mRecycleChildrenOnDetach = z;
    }

    public void setReverseLayout(boolean z) {
        assertNotInLayoutOrScroll(null);
        if (z != this.mReverseLayout) {
            this.mReverseLayout = z;
            requestLayout();
        }
    }

    public void setSmoothScrollbarEnabled(boolean z) {
        this.mSmoothScrollbarEnabled = z;
    }

    public void setStackFromEnd(boolean z) {
        assertNotInLayoutOrScroll(null);
        if (this.mStackFromEnd != z) {
            this.mStackFromEnd = z;
            requestLayout();
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean shouldMeasureTwice() {
        return (getHeightMode() == 1073741824 || getWidthMode() == 1073741824 || !hasFlexibleChildInBothOrientations()) ? false : true;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void smoothScrollToPosition(RecyclerView recyclerView, RecyclerView.C0248 r2, int i) {
        C2329 r22 = new C2329(recyclerView.getContext());
        r22.setTargetPosition(i);
        startSmoothScroll(r22);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && this.mLastStackFromEnd == this.mStackFromEnd;
    }

    public void validateChildOrder() {
        StringBuilder r0 = C1293.m3416("validating child count ");
        r0.append(getChildCount());
        Log.d(TAG, r0.toString());
        if (getChildCount() >= 1) {
            boolean z = false;
            int position = getPosition(getChildAt(0));
            int r2 = this.mOrientationHelper.m6027(getChildAt(0));
            if (this.mShouldReverseLayout) {
                for (int i = 1; i < getChildCount(); i++) {
                    View childAt = getChildAt(i);
                    int position2 = getPosition(childAt);
                    int r6 = this.mOrientationHelper.m6027(childAt);
                    if (position2 < position) {
                        logChildren();
                        StringBuilder r3 = C1293.m3416("detected invalid position. loc invalid? ");
                        if (r6 < r2) {
                            z = true;
                        }
                        r3.append(z);
                        throw new RuntimeException(r3.toString());
                    } else if (r6 > r2) {
                        logChildren();
                        throw new RuntimeException("detected invalid location");
                    }
                }
                return;
            }
            for (int i2 = 1; i2 < getChildCount(); i2++) {
                View childAt2 = getChildAt(i2);
                int position3 = getPosition(childAt2);
                int r62 = this.mOrientationHelper.m6027(childAt2);
                if (position3 < position) {
                    logChildren();
                    StringBuilder r32 = C1293.m3416("detected invalid position. loc invalid? ");
                    if (r62 < r2) {
                        z = true;
                    }
                    r32.append(z);
                    throw new RuntimeException(r32.toString());
                } else if (r62 < r2) {
                    logChildren();
                    throw new RuntimeException("detected invalid location");
                }
            }
        }
    }

    public LinearLayoutManager(Context context, int i, boolean z) {
        this.mOrientation = 1;
        this.mReverseLayout = false;
        this.mShouldReverseLayout = false;
        this.mStackFromEnd = false;
        this.mSmoothScrollbarEnabled = true;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mPendingSavedState = null;
        this.mAnchorInfo = new C0229();
        this.mLayoutChunkResult = new C0228();
        this.mInitialPrefetchItemCount = 2;
        this.mReusableIntPair = new int[2];
        setOrientation(i);
        setReverseLayout(z);
    }

    private void updateLayoutStateToFillEnd(int i, int i2) {
        this.mLayoutState.f1452 = this.mOrientationHelper.m6018() - i2;
        this.mLayoutState.f1453 = this.mShouldReverseLayout ? -1 : 1;
        C0227 r0 = this.mLayoutState;
        r0.f1462 = i;
        r0.f1461 = 1;
        r0.f1456 = i2;
        r0.f1457 = Integer.MIN_VALUE;
    }

    private void updateLayoutStateToFillStart(int i, int i2) {
        this.mLayoutState.f1452 = i2 - this.mOrientationHelper.m6024();
        C0227 r0 = this.mLayoutState;
        r0.f1462 = i;
        r0.f1453 = this.mShouldReverseLayout ? 1 : -1;
        C0227 r3 = this.mLayoutState;
        r3.f1461 = -1;
        r3.f1456 = i2;
        r3.f1457 = Integer.MIN_VALUE;
    }

    /* renamed from: androidx.recyclerview.widget.LinearLayoutManager$K  reason: contains not printable characters */
    public static class C0229 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1469;

        /* renamed from: ඓ  reason: contains not printable characters */
        public boolean f1470;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1471;

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC2303 f1472;

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1473;

        public C0229() {
            m797();
        }

        public String toString() {
            StringBuilder r0 = C1293.m3416("AnchorInfo{mPosition=");
            r0.append(this.f1471);
            r0.append(", mCoordinate=");
            r0.append(this.f1469);
            r0.append(", mLayoutFromEnd=");
            r0.append(this.f1473);
            r0.append(", mValid=");
            r0.append(this.f1470);
            r0.append('}');
            return r0.toString();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m797() {
            this.f1471 = -1;
            this.f1469 = Integer.MIN_VALUE;
            this.f1473 = false;
            this.f1470 = false;
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m799() {
            int i;
            if (this.f1473) {
                i = this.f1472.m6018();
            } else {
                i = this.f1472.m6024();
            }
            this.f1469 = i;
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m801(View view, RecyclerView.C0248 r3) {
            RecyclerView.C0235 r2 = (RecyclerView.C0235) view.getLayoutParams();
            return !r2.m809() && r2.m811() >= 0 && r2.m811() < r3.m823();
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m798(View view, int i) {
            int r0 = this.f1472.m6028();
            if (r0 >= 0) {
                m800(view, i);
                return;
            }
            this.f1471 = i;
            if (this.f1473) {
                int r6 = (this.f1472.m6018() - r0) - this.f1472.m6022(view);
                this.f1469 = this.f1472.m6018() - r6;
                if (r6 > 0) {
                    int r2 = this.f1469 - this.f1472.m6019(view);
                    int r02 = this.f1472.m6024();
                    int min = r2 - (Math.min(this.f1472.m6027(view) - r02, 0) + r02);
                    if (min < 0) {
                        this.f1469 = Math.min(r6, -min) + this.f1469;
                        return;
                    }
                    return;
                }
                return;
            }
            int r62 = this.f1472.m6027(view);
            int r22 = r62 - this.f1472.m6024();
            this.f1469 = r62;
            if (r22 > 0) {
                int r5 = (this.f1472.m6018() - Math.min(0, (this.f1472.m6018() - r0) - this.f1472.m6022(view))) - (this.f1472.m6019(view) + r62);
                if (r5 < 0) {
                    this.f1469 -= Math.min(r22, -r5);
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m800(View view, int i) {
            if (this.f1473) {
                this.f1469 = this.f1472.m6028() + this.f1472.m6022(view);
            } else {
                this.f1469 = this.f1472.m6027(view);
            }
            this.f1471 = i;
        }
    }

    public LinearLayoutManager(Context context, AttributeSet attributeSet, int i, int i2) {
        this.mOrientation = 1;
        this.mReverseLayout = false;
        this.mShouldReverseLayout = false;
        this.mStackFromEnd = false;
        this.mSmoothScrollbarEnabled = true;
        this.mPendingScrollPosition = -1;
        this.mPendingScrollPositionOffset = Integer.MIN_VALUE;
        this.mPendingSavedState = null;
        this.mAnchorInfo = new C0229();
        this.mLayoutChunkResult = new C0228();
        this.mInitialPrefetchItemCount = 2;
        this.mReusableIntPair = new int[2];
        RecyclerView.AbstractC0254.C0258 properties = RecyclerView.AbstractC0254.getProperties(context, attributeSet, i, i2);
        setOrientation(properties.f1524);
        setReverseLayout(properties.f1522);
        setStackFromEnd(properties.f1525);
    }
}
