package androidx.recyclerview.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.Arrays;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.䀟.K.RunnableC2312;

public class GridLayoutManager extends LinearLayoutManager {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int[] f1434;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final SparseIntArray f1435 = new SparseIntArray();

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f1436;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f1437 = -1;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public AbstractC0223 f1438 = new C0225();

    /* renamed from: K  reason: contains not printable characters */
    public boolean f1439 = false;

    /* renamed from: 㴹  reason: contains not printable characters */
    public final SparseIntArray f1440 = new SparseIntArray();

    /* renamed from: 㸾  reason: contains not printable characters */
    public View[] f1441;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final Rect f1442 = new Rect();

    /* renamed from: androidx.recyclerview.widget.GridLayoutManager$K  reason: contains not printable characters */
    public static final class C0225 extends AbstractC0223 {
        @Override // androidx.recyclerview.widget.GridLayoutManager.AbstractC0223
        /* renamed from: K  reason: contains not printable characters */
        public int m790(int i) {
            return 1;
        }

        @Override // androidx.recyclerview.widget.GridLayoutManager.AbstractC0223
        /* renamed from: 㸾  reason: contains not printable characters */
        public int m791(int i, int i2) {
            return i % i2;
        }
    }

    public GridLayoutManager(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
        m775(RecyclerView.AbstractC0254.getProperties(context, attributeSet, i, i2).f1523);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean checkLayoutParams(RecyclerView.C0235 r1) {
        return r1 instanceof C0224;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void collectPrefetchPositionsForLayoutState(RecyclerView.C0248 r7, LinearLayoutManager.C0227 r8, RecyclerView.AbstractC0254.AbstractC0255 r9) {
        int i = this.f1437;
        for (int i2 = 0; i2 < this.f1437 && r8.m796(r7) && i > 0; i2++) {
            int i3 = r8.f1462;
            ((RunnableC2312.C2314) r9).m6043(i3, Math.max(0, r8.f1457));
            i -= this.f1438.m787(i3);
            r8.f1462 += r8.f1453;
        }
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollOffset(RecyclerView.C0248 r2) {
        if (this.f1436) {
            return m777(r2);
        }
        return super.computeHorizontalScrollOffset(r2);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeHorizontalScrollRange(RecyclerView.C0248 r2) {
        if (this.f1436) {
            return m773(r2);
        }
        return super.computeHorizontalScrollRange(r2);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollOffset(RecyclerView.C0248 r2) {
        if (this.f1436) {
            return m777(r2);
        }
        return super.computeVerticalScrollOffset(r2);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int computeVerticalScrollRange(RecyclerView.C0248 r2) {
        if (this.f1436) {
            return m773(r2);
        }
        return super.computeVerticalScrollRange(r2);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public View findReferenceChild(RecyclerView.C0264 r8, RecyclerView.C0248 r9, int i, int i2, int i3) {
        ensureLayoutState();
        int r0 = this.mOrientationHelper.m6024();
        int r1 = this.mOrientationHelper.m6018();
        int i4 = i2 > i ? 1 : -1;
        View view = null;
        View view2 = null;
        while (i != i2) {
            View childAt = getChildAt(i);
            int position = getPosition(childAt);
            if (position >= 0 && position < i3 && m774(r8, r9, position) == 0) {
                if (((RecyclerView.C0235) childAt.getLayoutParams()).m809()) {
                    if (view2 == null) {
                        view2 = childAt;
                    }
                } else if (this.mOrientationHelper.m6027(childAt) < r1 && this.mOrientationHelper.m6022(childAt) >= r0) {
                    return childAt;
                } else {
                    if (view == null) {
                        view = childAt;
                    }
                }
            }
            i += i4;
        }
        return view != null ? view : view2;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateDefaultLayoutParams() {
        if (this.mOrientation == 0) {
            return new C0224(-2, -1);
        }
        return new C0224(-1, -2);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateLayoutParams(Context context, AttributeSet attributeSet) {
        return new C0224(context, attributeSet);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int getColumnCountForAccessibility(RecyclerView.C0264 r3, RecyclerView.C0248 r4) {
        if (this.mOrientation == 1) {
            return this.f1437;
        }
        if (r4.m823() < 1) {
            return 0;
        }
        return m778(r3, r4, r4.m823() - 1) + 1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int getRowCountForAccessibility(RecyclerView.C0264 r3, RecyclerView.C0248 r4) {
        if (this.mOrientation == 0) {
            return this.f1437;
        }
        if (r4.m823() < 1) {
            return 0;
        }
        return m778(r3, r4, r4.m823() - 1) + 1;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void layoutChunk(RecyclerView.C0264 r21, RecyclerView.C0248 r22, LinearLayoutManager.C0227 r23, LinearLayoutManager.C0228 r24) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int i10;
        int i11;
        int i12;
        View r4;
        int r3 = this.mOrientationHelper.m6016();
        boolean z = r3 != 1073741824;
        int i13 = getChildCount() > 0 ? this.f1434[this.f1437] : 0;
        if (z) {
            m771();
        }
        boolean z2 = r23.f1453 == 1;
        int i14 = this.f1437;
        if (!z2) {
            i14 = m774(r21, r22, r23.f1462) + m770(r21, r22, r23.f1462);
        }
        int i15 = i14;
        int i16 = 0;
        while (i16 < this.f1437 && r23.m796(r22) && i15 > 0) {
            int i17 = r23.f1462;
            int r15 = m770(r21, r22, i17);
            if (r15 <= this.f1437) {
                i15 -= r15;
                if (i15 < 0 || (r4 = r23.m794(r21)) == null) {
                    break;
                }
                this.f1441[i16] = r4;
                i16++;
            } else {
                throw new IllegalArgumentException("Item at position " + i17 + " requires " + r15 + " spans but GridLayoutManager has only " + this.f1437 + " spans.");
            }
        }
        if (i16 == 0) {
            r24.f1466 = true;
            return;
        }
        if (z2) {
            i2 = i16;
            i4 = 0;
            i3 = 0;
            i = 1;
        } else {
            i3 = i16 - 1;
            i4 = 0;
            i2 = -1;
            i = -1;
        }
        while (i3 != i2) {
            View view = this.f1441[i3];
            C0224 r8 = (C0224) view.getLayoutParams();
            r8.f1448 = m770(r21, r22, getPosition(view));
            r8.f1447 = i4;
            i4 += r8.f1448;
            i3 += i;
        }
        int i18 = 0;
        float f = 0.0f;
        for (int i19 = 0; i19 < i16; i19++) {
            View view2 = this.f1441[i19];
            if (r23.f1459 == null) {
                if (z2) {
                    addView(view2);
                } else {
                    addView(view2, 0);
                }
            } else if (z2) {
                addDisappearingView(view2);
            } else {
                addDisappearingView(view2, 0);
            }
            calculateItemDecorationsForChild(view2, this.f1442);
            m782(view2, r3, false);
            int r82 = this.mOrientationHelper.m6019(view2);
            if (r82 > i18) {
                i18 = r82;
            }
            float r42 = (((float) this.mOrientationHelper.m6015(view2)) * 1.0f) / ((float) ((C0224) view2.getLayoutParams()).f1448);
            if (r42 > f) {
                f = r42;
            }
        }
        if (z) {
            m780(Math.max(Math.round(f * ((float) this.f1437)), i13));
            i18 = 0;
            for (int i20 = 0; i20 < i16; i20++) {
                View view3 = this.f1441[i20];
                m782(view3, 1073741824, true);
                int r32 = this.mOrientationHelper.m6019(view3);
                if (r32 > i18) {
                    i18 = r32;
                }
            }
        }
        for (int i21 = 0; i21 < i16; i21++) {
            View view4 = this.f1441[i21];
            if (this.mOrientationHelper.m6019(view4) != i18) {
                C0224 r43 = (C0224) view4.getLayoutParams();
                Rect rect = r43.f1482;
                int i22 = rect.top + rect.bottom + ((ViewGroup.MarginLayoutParams) r43).topMargin + ((ViewGroup.MarginLayoutParams) r43).bottomMargin;
                int i23 = rect.left + rect.right + ((ViewGroup.MarginLayoutParams) r43).leftMargin + ((ViewGroup.MarginLayoutParams) r43).rightMargin;
                int r83 = m776(r43.f1447, r43.f1448);
                if (this.mOrientation == 1) {
                    i12 = RecyclerView.AbstractC0254.getChildMeasureSpec(r83, 1073741824, i23, ((ViewGroup.MarginLayoutParams) r43).width, false);
                    i11 = View.MeasureSpec.makeMeasureSpec(i18 - i22, 1073741824);
                } else {
                    int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i18 - i23, 1073741824);
                    i11 = RecyclerView.AbstractC0254.getChildMeasureSpec(r83, 1073741824, i22, ((ViewGroup.MarginLayoutParams) r43).height, false);
                    i12 = makeMeasureSpec;
                }
                m781(view4, i12, i11, true);
            }
        }
        r24.f1467 = i18;
        if (this.mOrientation == 1) {
            if (r23.f1461 == -1) {
                int i24 = r23.f1456;
                i5 = i24;
                i6 = i24 - i18;
            } else {
                int i25 = r23.f1456;
                i6 = i25;
                i5 = i18 + i25;
            }
            i8 = 0;
            i7 = 0;
        } else if (r23.f1461 == -1) {
            int i26 = r23.f1456;
            int i27 = i26 - i18;
            i6 = 0;
            i5 = 0;
            i7 = i26;
            i8 = i27;
        } else {
            i8 = r23.f1456;
            i7 = i18 + i8;
            i6 = 0;
            i5 = 0;
        }
        int i28 = 0;
        while (i28 < i16) {
            View view5 = this.f1441[i28];
            C0224 r10 = (C0224) view5.getLayoutParams();
            if (this.mOrientation != 1) {
                i6 = getPaddingTop() + this.f1434[r10.f1447];
                i5 = this.mOrientationHelper.m6015(view5) + i6;
            } else if (isLayoutRTL()) {
                int paddingLeft = getPaddingLeft() + this.f1434[this.f1437 - r10.f1447];
                i9 = paddingLeft;
                i10 = paddingLeft - this.mOrientationHelper.m6015(view5);
                layoutDecoratedWithMargins(view5, i10, i6, i9, i5);
                if (!r10.m809() || r10.m810()) {
                    r24.f1465 = true;
                }
                r24.f1468 |= view5.hasFocusable();
                i28++;
                i8 = i10;
                i6 = i6;
                i7 = i9;
                i5 = i5;
            } else {
                i8 = getPaddingLeft() + this.f1434[r10.f1447];
                i7 = this.mOrientationHelper.m6015(view5) + i8;
            }
            i10 = i8;
            i9 = i7;
            layoutDecoratedWithMargins(view5, i10, i6, i9, i5);
            if (!r10.m809()) {
            }
            r24.f1465 = true;
            r24.f1468 |= view5.hasFocusable();
            i28++;
            i8 = i10;
            i6 = i6;
            i7 = i9;
            i5 = i5;
        }
        Arrays.fill(this.f1441, (Object) null);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void onAnchorReady(RecyclerView.C0264 r5, RecyclerView.C0248 r6, LinearLayoutManager.C0229 k, int i) {
        super.onAnchorReady(r5, r6, k, i);
        m771();
        if (r6.m823() > 0 && !r6.f1510) {
            boolean z = i == 1;
            int r1 = m774(r5, r6, k.f1471);
            if (z) {
                while (r1 > 0) {
                    int i2 = k.f1471;
                    if (i2 <= 0) {
                        break;
                    }
                    k.f1471 = i2 - 1;
                    r1 = m774(r5, r6, k.f1471);
                }
            } else {
                int r8 = r6.m823() - 1;
                int i3 = k.f1471;
                while (i3 < r8) {
                    int i4 = i3 + 1;
                    int r3 = m774(r5, r6, i4);
                    if (r3 <= r1) {
                        break;
                    }
                    i3 = i4;
                    r1 = r3;
                }
                k.f1471 = i3;
            }
        }
        m779();
    }

    /* JADX WARNING: Code restructure failed: missing block: B:55:0x00d7, code lost:
        if (r13 == (r2 > r8)) goto L_0x00cd;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:65:0x00f7, code lost:
        if (r13 == r11) goto L_0x00b7;
     */
    /* JADX WARNING: Removed duplicated region for block: B:70:0x0105  */
    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public View onFocusSearchFailed(View view, int i, RecyclerView.C0264 r26, RecyclerView.C0248 r27) {
        int i2;
        int i3;
        int i4;
        int i5;
        View view2;
        View view3;
        int i6;
        int i7;
        int i8;
        boolean z;
        RecyclerView.C0264 r1 = r26;
        RecyclerView.C0248 r2 = r27;
        View findContainingItemView = findContainingItemView(view);
        View view4 = null;
        if (findContainingItemView == null) {
            return null;
        }
        C0224 r5 = (C0224) findContainingItemView.getLayoutParams();
        int i9 = r5.f1447;
        int i10 = r5.f1448 + i9;
        if (super.onFocusSearchFailed(view, i, r26, r27) == null) {
            return null;
        }
        if ((convertFocusDirectionToLayoutDirection(i) == 1) != this.mShouldReverseLayout) {
            i4 = getChildCount() - 1;
            i3 = -1;
            i2 = -1;
        } else {
            i3 = getChildCount();
            i4 = 0;
            i2 = 1;
        }
        boolean z2 = this.mOrientation == 1 && isLayoutRTL();
        int r14 = m778(r1, r2, i4);
        View view5 = null;
        int i11 = -1;
        int i12 = 0;
        int i13 = 0;
        int i14 = -1;
        while (i4 != i3) {
            int r9 = m778(r1, r2, i4);
            View childAt = getChildAt(i4);
            if (childAt == findContainingItemView) {
                break;
            }
            if (!childAt.hasFocusable() || r9 == r14) {
                C0224 r92 = (C0224) childAt.getLayoutParams();
                int i15 = r92.f1447;
                view2 = findContainingItemView;
                int i16 = r92.f1448 + i15;
                if (childAt.hasFocusable() && i15 == i9 && i16 == i10) {
                    return childAt;
                }
                if ((!childAt.hasFocusable() || view4 != null) && (childAt.hasFocusable() || view5 != null)) {
                    view3 = view5;
                    int min = Math.min(i16, i10) - Math.max(i15, i9);
                    if (childAt.hasFocusable()) {
                        if (min <= i12) {
                            if (min == i12) {
                            }
                        }
                        i6 = i11;
                    } else if (view4 == null) {
                        i6 = i11;
                        i5 = i3;
                        z = true;
                        i8 = i13;
                        if (isViewPartiallyVisible(childAt, false, true)) {
                            if (min > i8) {
                                i7 = i14;
                                if (z) {
                                    if (childAt.hasFocusable()) {
                                        int i17 = r92.f1447;
                                        i12 = Math.min(i16, i10) - Math.max(i15, i9);
                                        i13 = i8;
                                        i14 = i7;
                                        view5 = view3;
                                        i11 = i17;
                                        view4 = childAt;
                                    } else {
                                        int i18 = r92.f1447;
                                        view5 = childAt;
                                        i13 = Math.min(i16, i10) - Math.max(i15, i9);
                                        i14 = i18;
                                        i11 = i6;
                                    }
                                    i4 += i2;
                                    r1 = r26;
                                    r2 = r27;
                                    findContainingItemView = view2;
                                    i3 = i5;
                                }
                            } else if (min == i8) {
                                i7 = i14;
                                if (i15 <= i7) {
                                    z = false;
                                }
                            }
                        }
                        i7 = i14;
                        z = false;
                        if (z) {
                        }
                    }
                    i6 = i11;
                    i5 = i3;
                    i8 = i13;
                    i7 = i14;
                    z = false;
                    if (z) {
                    }
                } else {
                    i6 = i11;
                    view3 = view5;
                }
                i5 = i3;
                i8 = i13;
                i7 = i14;
                z = true;
                if (z) {
                }
            } else if (view4 != null) {
                break;
            } else {
                view2 = findContainingItemView;
                i6 = i11;
                view3 = view5;
                i5 = i3;
                i8 = i13;
                i7 = i14;
            }
            i13 = i8;
            i14 = i7;
            i11 = i6;
            view5 = view3;
            i4 += i2;
            r1 = r26;
            r2 = r27;
            findContainingItemView = view2;
            i3 = i5;
        }
        return view4 != null ? view4 : view5;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onInitializeAccessibilityNodeInfoForItem(RecyclerView.C0264 r8, RecyclerView.C0248 r9, View view, C1782 r11) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (!(layoutParams instanceof C0224)) {
            super.onInitializeAccessibilityNodeInfoForItem(view, r11);
            return;
        }
        C0224 r0 = (C0224) layoutParams;
        int r82 = m778(r8, r9, r0.m811());
        if (this.mOrientation == 0) {
            r11.m4654(C1782.C1783.m4672(r0.f1447, r0.f1448, r82, 1, false, false));
        } else {
            r11.m4654(C1782.C1783.m4672(r82, 1, r0.f1447, r0.f1448, false, false));
        }
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsAdded(RecyclerView recyclerView, int i, int i2) {
        this.f1438.f1445.clear();
        this.f1438.f1444.clear();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsChanged(RecyclerView recyclerView) {
        this.f1438.f1445.clear();
        this.f1438.f1444.clear();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsMoved(RecyclerView recyclerView, int i, int i2, int i3) {
        this.f1438.f1445.clear();
        this.f1438.f1444.clear();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsRemoved(RecyclerView recyclerView, int i, int i2) {
        this.f1438.f1445.clear();
        this.f1438.f1444.clear();
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onItemsUpdated(RecyclerView recyclerView, int i, int i2, Object obj) {
        this.f1438.f1445.clear();
        this.f1438.f1444.clear();
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutChildren(RecyclerView.C0264 r7, RecyclerView.C0248 r8) {
        if (r8.f1510) {
            int childCount = getChildCount();
            for (int i = 0; i < childCount; i++) {
                C0224 r2 = (C0224) getChildAt(i).getLayoutParams();
                int r3 = r2.m811();
                this.f1435.put(r3, r2.f1448);
                this.f1440.put(r3, r2.f1447);
            }
        }
        super.onLayoutChildren(r7, r8);
        this.f1435.clear();
        this.f1440.clear();
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void onLayoutCompleted(RecyclerView.C0248 r1) {
        super.onLayoutCompleted(r1);
        this.f1439 = false;
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollHorizontallyBy(int i, RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        m771();
        m779();
        return super.scrollHorizontallyBy(i, r2, r3);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public int scrollVerticallyBy(int i, RecyclerView.C0264 r2, RecyclerView.C0248 r3) {
        m771();
        m779();
        return super.scrollVerticallyBy(i, r2, r3);
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public void setMeasuredDimension(Rect rect, int i, int i2) {
        int i3;
        int i4;
        if (this.f1434 == null) {
            super.setMeasuredDimension(rect, i, i2);
        }
        int paddingRight = getPaddingRight() + getPaddingLeft();
        int paddingBottom = getPaddingBottom() + getPaddingTop();
        if (this.mOrientation == 1) {
            i4 = RecyclerView.AbstractC0254.chooseSize(i2, rect.height() + paddingBottom, getMinimumHeight());
            int[] iArr = this.f1434;
            i3 = RecyclerView.AbstractC0254.chooseSize(i, iArr[iArr.length - 1] + paddingRight, getMinimumWidth());
        } else {
            i3 = RecyclerView.AbstractC0254.chooseSize(i, rect.width() + paddingRight, getMinimumWidth());
            int[] iArr2 = this.f1434;
            i4 = RecyclerView.AbstractC0254.chooseSize(i2, iArr2[iArr2.length - 1] + paddingBottom, getMinimumHeight());
        }
        setMeasuredDimension(i3, i4);
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager
    public void setStackFromEnd(boolean z) {
        if (!z) {
            super.setStackFromEnd(false);
            return;
        }
        throw new UnsupportedOperationException("GridLayoutManager does not support stack from end. Consider using reverse layout");
    }

    @Override // androidx.recyclerview.widget.LinearLayoutManager, androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public boolean supportsPredictiveItemAnimations() {
        return this.mPendingSavedState == null && !this.f1439;
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m771() {
        int i;
        int i2;
        if (getOrientation() == 1) {
            i2 = getWidth() - getPaddingRight();
            i = getPaddingLeft();
        } else {
            i2 = getHeight() - getPaddingBottom();
            i = getPaddingTop();
        }
        m780(i2 - i);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public int m772() {
        return this.f1437;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m783(AbstractC0223 r1) {
        this.f1438 = r1;
    }

    @Override // androidx.recyclerview.widget.RecyclerView.AbstractC0254
    public RecyclerView.C0235 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new C0224((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new C0224(layoutParams);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m775(int i) {
        if (i != this.f1437) {
            this.f1439 = true;
            if (i >= 1) {
                this.f1437 = i;
                this.f1438.f1445.clear();
                requestLayout();
                return;
            }
            throw new IllegalArgumentException(C1293.m3408("Span count should be at least 1. Provided ", i));
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m780(int i) {
        int i2;
        int[] iArr = this.f1434;
        int i3 = this.f1437;
        if (!(iArr != null && iArr.length == i3 + 1 && iArr[iArr.length - 1] == i)) {
            iArr = new int[(i3 + 1)];
        }
        int i4 = 0;
        iArr[0] = 0;
        int i5 = i / i3;
        int i6 = i % i3;
        int i7 = 0;
        for (int i8 = 1; i8 <= i3; i8++) {
            i4 += i6;
            if (i4 <= 0 || i3 - i4 >= i6) {
                i2 = i5;
            } else {
                i2 = i5 + 1;
                i4 -= i3;
            }
            i7 += i2;
            iArr[i8] = i7;
        }
        this.f1434 = iArr;
    }

    /* renamed from: androidx.recyclerview.widget.GridLayoutManager$ῲ  reason: contains not printable characters */
    public static class C0224 extends RecyclerView.C0235 {

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1447 = -1;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1448 = 0;

        public C0224(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0224(int i, int i2) {
            super(i, i2);
        }

        public C0224(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public C0224(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    /* renamed from: androidx.recyclerview.widget.GridLayoutManager$ʬ  reason: contains not printable characters */
    public static abstract class AbstractC0223 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1443 = false;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final SparseIntArray f1444 = new SparseIntArray();

        /* renamed from: K  reason: contains not printable characters */
        public final SparseIntArray f1445 = new SparseIntArray();

        /* renamed from: 㸾  reason: contains not printable characters */
        public boolean f1446 = false;

        /* renamed from: ʬ  reason: contains not printable characters */
        public int m785(int i, int i2) {
            int i3;
            int i4;
            int i5;
            int r0;
            if (!this.f1446 || (r0 = m784(this.f1444, i)) == -1) {
                i5 = 0;
                i4 = 0;
                i3 = 0;
            } else {
                i4 = this.f1444.get(r0);
                i3 = r0 + 1;
                i5 = m787(r0) + m786(r0, i2);
                if (i5 == i2) {
                    i4++;
                    i5 = 0;
                }
            }
            int r4 = m787(i);
            while (i3 < i) {
                int r5 = m787(i3);
                i5 += r5;
                if (i5 == i2) {
                    i4++;
                    i5 = 0;
                } else if (i5 > i2) {
                    i4++;
                    i5 = r5;
                }
                i3++;
            }
            return i5 + r4 > i2 ? i4 + 1 : i4;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public int m786(int i, int i2) {
            if (!this.f1443) {
                return m789(i, i2);
            }
            int i3 = this.f1445.get(i, -1);
            if (i3 != -1) {
                return i3;
            }
            int r4 = m789(i, i2);
            this.f1445.put(i, r4);
            return r4;
        }

        /* renamed from: K  reason: contains not printable characters */
        public abstract int m787(int i);

        /* renamed from: K  reason: contains not printable characters */
        public int m788(int i, int i2) {
            if (!this.f1446) {
                return m785(i, i2);
            }
            int i3 = this.f1444.get(i, -1);
            if (i3 != -1) {
                return i3;
            }
            int r4 = m785(i, i2);
            this.f1444.put(i, r4);
            return r4;
        }

        /* JADX WARNING: Removed duplicated region for block: B:10:0x0024  */
        /* renamed from: 㸾  reason: contains not printable characters */
        public int m789(int i, int i2) {
            int i3;
            int i4;
            int r0 = m787(i);
            if (r0 == i2) {
                return 0;
            }
            if (!this.f1443 || (i4 = m784(this.f1445, i)) < 0) {
                i4 = 0;
                i3 = 0;
            } else {
                i3 = this.f1445.get(i4) + m787(i4);
                i4++;
            }
            if (i4 < i) {
                int r4 = m787(i4);
                i3 += r4;
                if (i3 == i2) {
                    i3 = 0;
                } else if (i3 > i2) {
                    i3 = r4;
                }
                i4++;
                if (i4 < i) {
                }
            }
            if (r0 + i3 <= i2) {
                return i3;
            }
            return 0;
        }

        /* renamed from: K  reason: contains not printable characters */
        public static int m784(SparseIntArray sparseIntArray, int i) {
            int size = sparseIntArray.size() - 1;
            int i2 = 0;
            while (i2 <= size) {
                int i3 = (i2 + size) >>> 1;
                if (sparseIntArray.keyAt(i3) < i) {
                    i2 = i3 + 1;
                } else {
                    size = i3 - 1;
                }
            }
            int i4 = i2 - 1;
            if (i4 < 0 || i4 >= sparseIntArray.size()) {
                return -1;
            }
            return sparseIntArray.keyAt(i4);
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final int m770(RecyclerView.C0264 r2, RecyclerView.C0248 r3, int i) {
        if (!r3.f1510) {
            return this.f1438.m787(i);
        }
        int i2 = this.f1435.get(i, -1);
        if (i2 != -1) {
            return i2;
        }
        int r22 = r2.m863(i);
        if (r22 != -1) {
            return this.f1438.m787(r22);
        }
        Log.w("GridLayoutManager", "Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + i);
        return 1;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m773(RecyclerView.C0248 r7) {
        if (!(getChildCount() == 0 || r7.m823() == 0)) {
            ensureLayoutState();
            View findFirstVisibleChildClosestToStart = findFirstVisibleChildClosestToStart(!isSmoothScrollbarEnabled(), true);
            View findFirstVisibleChildClosestToEnd = findFirstVisibleChildClosestToEnd(!isSmoothScrollbarEnabled(), true);
            if (!(findFirstVisibleChildClosestToStart == null || findFirstVisibleChildClosestToEnd == null)) {
                if (!isSmoothScrollbarEnabled()) {
                    return this.f1438.m788(r7.m823() - 1, this.f1437) + 1;
                }
                int r1 = this.mOrientationHelper.m6022(findFirstVisibleChildClosestToEnd) - this.mOrientationHelper.m6027(findFirstVisibleChildClosestToStart);
                int r0 = this.f1438.m788(getPosition(findFirstVisibleChildClosestToStart), this.f1437);
                return (int) ((((float) r1) / ((float) ((this.f1438.m788(getPosition(findFirstVisibleChildClosestToEnd), this.f1437) - r0) + 1))) * ((float) (this.f1438.m788(r7.m823() - 1, this.f1437) + 1)));
            }
        }
        return 0;
    }

    public GridLayoutManager(Context context, int i) {
        super(context);
        m775(i);
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m776(int i, int i2) {
        if (this.mOrientation != 1 || !isLayoutRTL()) {
            int[] iArr = this.f1434;
            return iArr[i2 + i] - iArr[i];
        }
        int[] iArr2 = this.f1434;
        int i3 = this.f1437;
        return iArr2[i3 - i] - iArr2[(i3 - i) - i2];
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m779() {
        View[] viewArr = this.f1441;
        if (viewArr == null || viewArr.length != this.f1437) {
            this.f1441 = new View[this.f1437];
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m782(View view, int i, boolean z) {
        int i2;
        int i3;
        C0224 r0 = (C0224) view.getLayoutParams();
        Rect rect = r0.f1482;
        int i4 = rect.top + rect.bottom + ((ViewGroup.MarginLayoutParams) r0).topMargin + ((ViewGroup.MarginLayoutParams) r0).bottomMargin;
        int i5 = rect.left + rect.right + ((ViewGroup.MarginLayoutParams) r0).leftMargin + ((ViewGroup.MarginLayoutParams) r0).rightMargin;
        int r1 = m776(r0.f1447, r0.f1448);
        if (this.mOrientation == 1) {
            i2 = RecyclerView.AbstractC0254.getChildMeasureSpec(r1, i, i5, ((ViewGroup.MarginLayoutParams) r0).width, false);
            i3 = RecyclerView.AbstractC0254.getChildMeasureSpec(this.mOrientationHelper.m6020(), getHeightMode(), i4, ((ViewGroup.MarginLayoutParams) r0).height, true);
        } else {
            int childMeasureSpec = RecyclerView.AbstractC0254.getChildMeasureSpec(r1, i, i4, ((ViewGroup.MarginLayoutParams) r0).height, false);
            int childMeasureSpec2 = RecyclerView.AbstractC0254.getChildMeasureSpec(this.mOrientationHelper.m6020(), getWidthMode(), i5, ((ViewGroup.MarginLayoutParams) r0).width, true);
            i3 = childMeasureSpec;
            i2 = childMeasureSpec2;
        }
        m781(view, i2, i3, z);
    }

    public GridLayoutManager(Context context, int i, int i2, boolean z) {
        super(context, i2, z);
        m775(i);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final int m774(RecyclerView.C0264 r2, RecyclerView.C0248 r3, int i) {
        if (!r3.f1510) {
            return this.f1438.m786(i, this.f1437);
        }
        int i2 = this.f1440.get(i, -1);
        if (i2 != -1) {
            return i2;
        }
        int r22 = r2.m863(i);
        if (r22 != -1) {
            return this.f1438.m786(r22, this.f1437);
        }
        Log.w("GridLayoutManager", "Cannot find span size for pre layout position. It is not cached, not in the adapter. Pos:" + i);
        return 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m781(View view, int i, int i2, boolean z) {
        boolean z2;
        RecyclerView.C0235 r0 = (RecyclerView.C0235) view.getLayoutParams();
        if (z) {
            z2 = shouldReMeasureChild(view, i, i2, r0);
        } else {
            z2 = shouldMeasureChild(view, i, i2, r0);
        }
        if (z2) {
            view.measure(i, i2);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m777(RecyclerView.C0248 r10) {
        int i;
        if (!(getChildCount() == 0 || r10.m823() == 0)) {
            ensureLayoutState();
            boolean isSmoothScrollbarEnabled = isSmoothScrollbarEnabled();
            View findFirstVisibleChildClosestToStart = findFirstVisibleChildClosestToStart(!isSmoothScrollbarEnabled, true);
            View findFirstVisibleChildClosestToEnd = findFirstVisibleChildClosestToEnd(!isSmoothScrollbarEnabled, true);
            if (!(findFirstVisibleChildClosestToStart == null || findFirstVisibleChildClosestToEnd == null)) {
                int r5 = this.f1438.m788(getPosition(findFirstVisibleChildClosestToStart), this.f1437);
                int r6 = this.f1438.m788(getPosition(findFirstVisibleChildClosestToEnd), this.f1437);
                int min = Math.min(r5, r6);
                int max = Math.max(r5, r6);
                int r102 = this.f1438.m788(r10.m823() - 1, this.f1437) + 1;
                if (this.mShouldReverseLayout) {
                    i = Math.max(0, (r102 - max) - 1);
                } else {
                    i = Math.max(0, min);
                }
                if (!isSmoothScrollbarEnabled) {
                    return i;
                }
                return Math.round((((float) i) * (((float) Math.abs(this.mOrientationHelper.m6022(findFirstVisibleChildClosestToEnd) - this.mOrientationHelper.m6027(findFirstVisibleChildClosestToStart))) / ((float) ((this.f1438.m788(getPosition(findFirstVisibleChildClosestToEnd), this.f1437) - this.f1438.m788(getPosition(findFirstVisibleChildClosestToStart), this.f1437)) + 1)))) + ((float) (this.mOrientationHelper.m6024() - this.mOrientationHelper.m6027(findFirstVisibleChildClosestToStart))));
            }
        }
        return 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final int m778(RecyclerView.C0264 r1, RecyclerView.C0248 r2, int i) {
        if (!r2.f1510) {
            return this.f1438.m788(i, this.f1437);
        }
        int r12 = r1.m863(i);
        if (r12 != -1) {
            return this.f1438.m788(r12, this.f1437);
        }
        Log.w("GridLayoutManager", "Cannot find span size for pre layout position. " + i);
        return 0;
    }
}
