package androidx.loader.content;

import android.os.Binder;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.util.Log;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import ඓ.K.K.K.C1293;
import ῲ.ᓣ.ῲ.AbstractC1688;

public abstract class ModernAsyncTask<Params, Progress, Result> {

    /* renamed from: ᨨ  reason: contains not printable characters */
    public static final Executor f1354 = new ThreadPoolExecutor(5, 128, 1, TimeUnit.SECONDS, f1357, f1355);

    /* renamed from: ⁱ  reason: contains not printable characters */
    public static final ThreadFactory f1355 = new ThreadFactoryC0196();

    /* renamed from: 㳳  reason: contains not printable characters */
    public static HandlerC0194 f1356;

    /* renamed from: 㿎  reason: contains not printable characters */
    public static final BlockingQueue<Runnable> f1357 = new LinkedBlockingQueue(10);

    /* renamed from: ʬ  reason: contains not printable characters */
    public final FutureTask<Result> f1358 = new C0193(this.f1360);

    /* renamed from: ඓ  reason: contains not printable characters */
    public final AtomicBoolean f1359 = new AtomicBoolean();

    /* renamed from: ῲ  reason: contains not printable characters */
    public final AbstractCallableC0197<Params, Result> f1360 = new C0195();

    /* renamed from: 㴹  reason: contains not printable characters */
    public final AtomicBoolean f1361 = new AtomicBoolean();

    /* renamed from: 㸾  reason: contains not printable characters */
    public volatile Status f1362 = Status.PENDING;

    public enum Status {
        PENDING,
        RUNNING,
        FINISHED
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$ʬ  reason: contains not printable characters */
    public class C0193 extends FutureTask<Result> {
        public C0193(Callable callable) {
            super(callable);
        }

        /* JADX DEBUG: Multi-variable search result rejected for r2v4, resolved type: androidx.loader.content.ModernAsyncTask */
        /* JADX WARN: Multi-variable type inference failed */
        public void done() {
            try {
                Object obj = get();
                ModernAsyncTask modernAsyncTask = ModernAsyncTask.this;
                if (!modernAsyncTask.f1361.get()) {
                    modernAsyncTask.m713(obj);
                }
            } catch (InterruptedException e) {
                Log.w("AsyncTask", e);
            } catch (ExecutionException e2) {
                throw new RuntimeException("An error occurred while executing doInBackground()", e2.getCause());
            } catch (CancellationException unused) {
                ModernAsyncTask modernAsyncTask2 = ModernAsyncTask.this;
                if (!modernAsyncTask2.f1361.get()) {
                    modernAsyncTask2.m713((Object) null);
                }
            } catch (Throwable th) {
                throw new RuntimeException("An error occurred while executing doInBackground()", th);
            }
        }
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$ඓ  reason: contains not printable characters */
    public static class HandlerC0194 extends Handler {
        public HandlerC0194() {
            super(Looper.getMainLooper());
        }

        public void handleMessage(Message message) {
            C0198 r0 = (C0198) message.obj;
            int i = message.what;
            if (i == 1) {
                ModernAsyncTask modernAsyncTask = r0.f1369;
                Data data = r0.f1368[0];
                if (modernAsyncTask.m715()) {
                    AbstractC1688<D>.RunnableC1689 k = (AbstractC1688.RunnableC1689) modernAsyncTask;
                    try {
                        AbstractC1688.this.m4312(k, data);
                    } finally {
                        k.f5953.countDown();
                    }
                } else {
                    AbstractC1688<D>.RunnableC1689 k2 = (AbstractC1688.RunnableC1689) modernAsyncTask;
                    try {
                        AbstractC1688.this.m4310(k2, data);
                    } finally {
                        k2.f5953.countDown();
                    }
                }
                modernAsyncTask.f1362 = Status.FINISHED;
            } else if (i == 2) {
                ModernAsyncTask modernAsyncTask2 = r0.f1369;
                Data[] dataArr = r0.f1368;
                modernAsyncTask2.m712();
            }
        }
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$ῲ  reason: contains not printable characters */
    public class C0195 extends AbstractCallableC0197<Params, Result> {
        public C0195() {
        }

        @Override // java.util.concurrent.Callable
        public Result call() throws Exception {
            ModernAsyncTask.this.f1361.set(true);
            Result result = null;
            try {
                Process.setThreadPriority(10);
                result = (Result) ModernAsyncTask.this.m714((Object[]) this.f1367);
                Binder.flushPendingCommands();
                ModernAsyncTask.this.m713(result);
                return result;
            } catch (Throwable th) {
                ModernAsyncTask.this.m713(result);
                throw th;
            }
        }
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$K  reason: contains not printable characters */
    public static class ThreadFactoryC0196 implements ThreadFactory {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final AtomicInteger f1366 = new AtomicInteger(1);

        public Thread newThread(Runnable runnable) {
            StringBuilder r1 = C1293.m3416("ModernAsyncTask #");
            r1.append(this.f1366.getAndIncrement());
            return new Thread(runnable, r1.toString());
        }
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$㴹  reason: contains not printable characters */
    public static abstract class AbstractCallableC0197<Params, Result> implements Callable<Result> {

        /* renamed from: ῲ  reason: contains not printable characters */
        public Params[] f1367;
    }

    /* renamed from: androidx.loader.content.ModernAsyncTask$㸾  reason: contains not printable characters */
    public static class C0198<Data> {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final Data[] f1368;

        /* renamed from: K  reason: contains not printable characters */
        public final ModernAsyncTask f1369;

        public C0198(ModernAsyncTask modernAsyncTask, Data... dataArr) {
            this.f1369 = modernAsyncTask;
            this.f1368 = dataArr;
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public static Handler m711() {
        HandlerC0194 r1;
        synchronized (ModernAsyncTask.class) {
            if (f1356 == null) {
                f1356 = new HandlerC0194();
            }
            r1 = f1356;
        }
        return r1;
    }

    /* JADX WARN: Incorrect args count in method signature: ([TProgress;)V */
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m712() {
    }

    /* renamed from: K  reason: contains not printable characters */
    public Result m713(Result result) {
        m711().obtainMessage(1, new C0198(this, result)).sendToTarget();
        return result;
    }

    /* renamed from: K  reason: contains not printable characters */
    public abstract Result m714(Params... paramsArr);

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m715() {
        return this.f1359.get();
    }
}
