package androidx.fragment.app;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.Window;
import androidx.activity.ComponentActivity;
import androidx.activity.OnBackPressedDispatcher;
import androidx.lifecycle.Lifecycle;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import ῲ.Ԕ.K.AbstractC1531;
import ῲ.Ԕ.K.AbstractC1542;
import ῲ.Ԕ.K.C1544;
import ῲ.ؿ.AbstractC1586;
import ῲ.ؿ.C1568;
import ῲ.ؿ.C1584;
import ῲ.ᓣ.K.AbstractC1695;
import ῲ.ᓣ.K.C1690;
import ῲ.ᨨ.K.AbstractC1820;
import ῲ.ᨨ.K.C1826;
import ῲ.K.AbstractC2195;
import ῲ.㴹.C2276;
import ῲ.㴹.C2287;
import K.K.K.ʬ.C2369;

public class FragmentActivity extends ComponentActivity implements C1826.AbstractC1827, C1826.AbstractC1830 {
    public static final String ALLOCATED_REQUEST_INDICIES_TAG = "android:support:request_indicies";
    public static final String FRAGMENTS_TAG = "android:support:fragments";
    public static final int MAX_NUM_PENDING_FRAGMENT_ACTIVITY_RESULTS = 65534;
    public static final String NEXT_CANDIDATE_REQUEST_INDEX_TAG = "android:support:next_request_index";
    public static final String REQUEST_FRAGMENT_WHO_TAG = "android:support:request_fragment_who";
    public static final String TAG = "FragmentActivity";
    public boolean mCreated;
    public final C1584 mFragmentLifecycleRegistry = new C1584(this);
    public final C1544 mFragments;
    public int mNextCandidateRequestIndex;
    public C2276<String> mPendingFragmentActivityResults;
    public boolean mRequestedPermissionsFromFragment;
    public boolean mResumed;
    public boolean mStartedActivityFromFragment;
    public boolean mStartedIntentSenderFromFragment;
    public boolean mStopped = true;

    /* renamed from: androidx.fragment.app.FragmentActivity$K  reason: contains not printable characters */
    public class C0186 extends AbstractC1542<FragmentActivity> implements AbstractC1586, AbstractC2195 {
        public C0186() {
            super(FragmentActivity.this);
        }

        @Override // ῲ.ؿ.AbstractC1574
        public Lifecycle getLifecycle() {
            return FragmentActivity.this.mFragmentLifecycleRegistry;
        }

        @Override // ῲ.K.AbstractC2195
        public OnBackPressedDispatcher getOnBackPressedDispatcher() {
            return FragmentActivity.this.getOnBackPressedDispatcher();
        }

        @Override // ῲ.ؿ.AbstractC1586
        public C1568 getViewModelStore() {
            return FragmentActivity.this.getViewModelStore();
        }

        @Override // ῲ.Ԕ.K.AbstractC1513
        /* renamed from: K  reason: contains not printable characters */
        public View m682(int i) {
            return FragmentActivity.this.findViewById(i);
        }

        @Override // ῲ.Ԕ.K.AbstractC1513
        /* renamed from: K  reason: contains not printable characters */
        public boolean m683() {
            Window window = FragmentActivity.this.getWindow();
            return (window == null || window.peekDecorView() == null) ? false : true;
        }
    }

    public FragmentActivity() {
        C0186 k = new C0186();
        C2369.m6312(k, "callbacks == null");
        this.mFragments = new C1544(k);
    }

    private int allocateRequestIndex(Fragment fragment) {
        if (this.mPendingFragmentActivityResults.m5923() < 65534) {
            while (true) {
                C2276<String> r0 = this.mPendingFragmentActivityResults;
                int i = this.mNextCandidateRequestIndex;
                if (r0.f7873) {
                    r0.m5927();
                }
                if (C2287.m5968(r0.f7871, r0.f7872, i) >= 0) {
                    this.mNextCandidateRequestIndex = (this.mNextCandidateRequestIndex + 1) % MAX_NUM_PENDING_FRAGMENT_ACTIVITY_RESULTS;
                } else {
                    int i2 = this.mNextCandidateRequestIndex;
                    this.mPendingFragmentActivityResults.m5922(i2, fragment.mWho);
                    this.mNextCandidateRequestIndex = (this.mNextCandidateRequestIndex + 1) % MAX_NUM_PENDING_FRAGMENT_ACTIVITY_RESULTS;
                    return i2;
                }
            }
        } else {
            throw new IllegalStateException("Too many pending Fragment activity results.");
        }
    }

    public static void checkForValidRequestCode(int i) {
        if ((i & -65536) != 0) {
            throw new IllegalArgumentException("Can only use lower 16 bits for requestCode");
        }
    }

    private void markFragmentsCreated() {
        do {
        } while (markState(getSupportFragmentManager(), Lifecycle.State.CREATED));
    }

    public static boolean markState(AbstractC1531 r4, Lifecycle.State state) {
        boolean z = false;
        for (Fragment fragment : r4.m3919()) {
            if (fragment != null) {
                if (((C1584) fragment.getLifecycle()).f5751.isAtLeast(Lifecycle.State.STARTED)) {
                    fragment.mLifecycleRegistry.m4145(state);
                    z = true;
                }
                if (fragment.getHost() != null) {
                    z |= markState(fragment.getChildFragmentManager(), state);
                }
            }
        }
        return z;
    }

    public final View dispatchFragmentsOnCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        return this.mFragments.f5645.f5641.onCreateView(view, str, context, attributeSet);
    }

    public void dump(String str, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] strArr) {
        super.dump(str, fileDescriptor, printWriter, strArr);
        printWriter.print(str);
        printWriter.print("Local FragmentActivity ");
        printWriter.print(Integer.toHexString(System.identityHashCode(this)));
        printWriter.println(" State:");
        String str2 = str + "  ";
        printWriter.print(str2);
        printWriter.print("mCreated=");
        printWriter.print(this.mCreated);
        printWriter.print(" mResumed=");
        printWriter.print(this.mResumed);
        printWriter.print(" mStopped=");
        printWriter.print(this.mStopped);
        if (getApplication() != null) {
            ((C1690) AbstractC1695.m4339(this)).f5956.m4326(str2, fileDescriptor, printWriter, strArr);
        }
        this.mFragments.f5645.f5641.m3917(str, fileDescriptor, printWriter, strArr);
    }

    public AbstractC1531 getSupportFragmentManager() {
        return this.mFragments.f5645.f5641;
    }

    @Deprecated
    public AbstractC1695 getSupportLoaderManager() {
        return AbstractC1695.m4339(this);
    }

    public void onActivityResult(int i, int i2, Intent intent) {
        this.mFragments.m3971();
        int i3 = i >> 16;
        if (i3 != 0) {
            int i4 = i3 - 1;
            String r1 = this.mPendingFragmentActivityResults.m5926(i4);
            this.mPendingFragmentActivityResults.m5921(i4);
            if (r1 == null) {
                Log.w(TAG, "Activity result delivered for unknown Fragment.");
                return;
            }
            Fragment r2 = this.mFragments.f5645.f5641.m4006(r1);
            if (r2 == null) {
                Log.w(TAG, "Activity result no fragment exists for who: " + r1);
                return;
            }
            r2.onActivityResult(i & 65535, i2, intent);
            return;
        }
        C1826.m4718();
        super.onActivityResult(i, i2, intent);
    }

    public void onAttachFragment(Fragment fragment) {
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mFragments.m3971();
        this.mFragments.f5645.f5641.m4028(configuration);
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity
    public void onCreate(Bundle bundle) {
        AbstractC1542<?> r0 = this.mFragments.f5645;
        r0.f5641.m4045(r0, r0, (Fragment) null);
        if (bundle != null) {
            Parcelable parcelable = bundle.getParcelable(FRAGMENTS_TAG);
            AbstractC1542<?> r2 = this.mFragments.f5645;
            if (r2 instanceof AbstractC1586) {
                r2.f5641.m4030(parcelable);
                if (bundle.containsKey(NEXT_CANDIDATE_REQUEST_INDEX_TAG)) {
                    this.mNextCandidateRequestIndex = bundle.getInt(NEXT_CANDIDATE_REQUEST_INDEX_TAG);
                    int[] intArray = bundle.getIntArray(ALLOCATED_REQUEST_INDICIES_TAG);
                    String[] stringArray = bundle.getStringArray(REQUEST_FRAGMENT_WHO_TAG);
                    if (intArray == null || stringArray == null || intArray.length != stringArray.length) {
                        Log.w(TAG, "Invalid requestCode mapping in savedInstanceState.");
                    } else {
                        this.mPendingFragmentActivityResults = new C2276<>(intArray.length);
                        for (int i = 0; i < intArray.length; i++) {
                            this.mPendingFragmentActivityResults.m5922(intArray[i], stringArray[i]);
                        }
                    }
                }
            } else {
                throw new IllegalStateException("Your FragmentHostCallback must implement ViewModelStoreOwner to call restoreSaveState(). Call restoreAllState()  if you're still using retainNestedNonConfig().");
            }
        }
        if (this.mPendingFragmentActivityResults == null) {
            this.mPendingFragmentActivityResults = new C2276<>(10);
            this.mNextCandidateRequestIndex = 0;
        }
        super.onCreate(bundle);
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_CREATE);
        this.mFragments.f5645.f5641.m3999();
    }

    public boolean onCreatePanelMenu(int i, Menu menu) {
        if (i != 0) {
            return super.onCreatePanelMenu(i, menu);
        }
        boolean onCreatePanelMenu = super.onCreatePanelMenu(i, menu);
        C1544 r0 = this.mFragments;
        return onCreatePanelMenu | r0.f5645.f5641.m4049(menu, getMenuInflater());
    }

    public View onCreateView(View view, String str, Context context, AttributeSet attributeSet) {
        View dispatchFragmentsOnCreateView = dispatchFragmentsOnCreateView(view, str, context, attributeSet);
        return dispatchFragmentsOnCreateView == null ? super.onCreateView(view, str, context, attributeSet) : dispatchFragmentsOnCreateView;
    }

    public void onDestroy() {
        super.onDestroy();
        this.mFragments.f5645.f5641.m4055();
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_DESTROY);
    }

    public void onLowMemory() {
        super.onLowMemory();
        this.mFragments.f5645.f5641.m3981();
    }

    public boolean onMenuItemSelected(int i, MenuItem menuItem) {
        if (super.onMenuItemSelected(i, menuItem)) {
            return true;
        }
        if (i == 0) {
            return this.mFragments.f5645.f5641.m4015(menuItem);
        }
        if (i != 6) {
            return false;
        }
        return this.mFragments.f5645.f5641.m4050(menuItem);
    }

    public void onMultiWindowModeChanged(boolean z) {
        this.mFragments.f5645.f5641.m4048(z);
    }

    public void onNewIntent(@SuppressLint({"UnknownNullness"}) Intent intent) {
        super.onNewIntent(intent);
        this.mFragments.m3971();
    }

    public void onPanelClosed(int i, Menu menu) {
        if (i == 0) {
            this.mFragments.f5645.f5641.m4031(menu);
        }
        super.onPanelClosed(i, menu);
    }

    public void onPause() {
        super.onPause();
        this.mResumed = false;
        this.mFragments.f5645.f5641.m4057();
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_PAUSE);
    }

    public void onPictureInPictureModeChanged(boolean z) {
        this.mFragments.f5645.f5641.m4012(z);
    }

    public void onPostResume() {
        super.onPostResume();
        onResumeFragments();
    }

    @Deprecated
    public boolean onPrepareOptionsPanel(View view, Menu menu) {
        return super.onPreparePanel(0, view, menu);
    }

    public boolean onPreparePanel(int i, View view, Menu menu) {
        if (i == 0) {
            return onPrepareOptionsPanel(view, menu) | this.mFragments.f5645.f5641.m4014(menu);
        }
        return super.onPreparePanel(i, view, menu);
    }

    @Override // ῲ.ᨨ.K.C1826.AbstractC1827
    public void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        this.mFragments.m3971();
        int i2 = (i >> 16) & 65535;
        if (i2 != 0) {
            int i3 = i2 - 1;
            String r2 = this.mPendingFragmentActivityResults.m5926(i3);
            this.mPendingFragmentActivityResults.m5921(i3);
            if (r2 == null) {
                Log.w(TAG, "Activity result delivered for unknown Fragment.");
                return;
            }
            Fragment r3 = this.mFragments.f5645.f5641.m4006(r2);
            if (r3 == null) {
                Log.w(TAG, "Activity result no fragment exists for who: " + r2);
                return;
            }
            r3.onRequestPermissionsResult(i & 65535, strArr, iArr);
        }
    }

    public void onResume() {
        super.onResume();
        this.mResumed = true;
        this.mFragments.m3971();
        this.mFragments.f5645.f5641.m3984();
    }

    public void onResumeFragments() {
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_RESUME);
        this.mFragments.f5645.f5641.m3997();
    }

    @Override // androidx.activity.ComponentActivity, androidx.core.app.ComponentActivity
    public void onSaveInstanceState(Bundle bundle) {
        super.onSaveInstanceState(bundle);
        markFragmentsCreated();
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_STOP);
        Parcelable r0 = this.mFragments.f5645.f5641.m3992();
        if (r0 != null) {
            bundle.putParcelable(FRAGMENTS_TAG, r0);
        }
        if (this.mPendingFragmentActivityResults.m5923() > 0) {
            bundle.putInt(NEXT_CANDIDATE_REQUEST_INDEX_TAG, this.mNextCandidateRequestIndex);
            int[] iArr = new int[this.mPendingFragmentActivityResults.m5923()];
            String[] strArr = new String[this.mPendingFragmentActivityResults.m5923()];
            for (int i = 0; i < this.mPendingFragmentActivityResults.m5923(); i++) {
                iArr[i] = this.mPendingFragmentActivityResults.m5924(i);
                strArr[i] = this.mPendingFragmentActivityResults.m5929(i);
            }
            bundle.putIntArray(ALLOCATED_REQUEST_INDICIES_TAG, iArr);
            bundle.putStringArray(REQUEST_FRAGMENT_WHO_TAG, strArr);
        }
    }

    public void onStart() {
        super.onStart();
        this.mStopped = false;
        if (!this.mCreated) {
            this.mCreated = true;
            this.mFragments.f5645.f5641.m4062();
        }
        this.mFragments.m3971();
        this.mFragments.f5645.f5641.m3984();
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_START);
        this.mFragments.f5645.f5641.m4059();
    }

    public void onStateNotSaved() {
        this.mFragments.m3971();
    }

    public void onStop() {
        super.onStop();
        this.mStopped = true;
        markFragmentsCreated();
        this.mFragments.f5645.f5641.m3988();
        this.mFragmentLifecycleRegistry.m4144(Lifecycle.Event.ON_STOP);
    }

    /* JADX INFO: finally extract failed */
    public void requestPermissionsFromFragment(Fragment fragment, String[] strArr, int i) {
        if (i == -1) {
            C1826.m4722(this, strArr, i);
            return;
        }
        checkForValidRequestCode(i);
        try {
            this.mRequestedPermissionsFromFragment = true;
            C1826.m4722(this, strArr, ((allocateRequestIndex(fragment) + 1) << 16) + (i & 65535));
            this.mRequestedPermissionsFromFragment = false;
        } catch (Throwable th) {
            this.mRequestedPermissionsFromFragment = false;
            throw th;
        }
    }

    public void setEnterSharedElementCallback(AbstractC1820 r1) {
        C1826.m4724(this);
    }

    public void setExitSharedElementCallback(AbstractC1820 r1) {
        C1826.m4717(this);
    }

    public void startActivityForResult(@SuppressLint({"UnknownNullness"}) Intent intent, int i) {
        if (!this.mStartedActivityFromFragment && i != -1) {
            checkForValidRequestCode(i);
        }
        super.startActivityForResult(intent, i);
    }

    public void startActivityFromFragment(Fragment fragment, @SuppressLint({"UnknownNullness"}) Intent intent, int i) {
        startActivityFromFragment(fragment, intent, i, null);
    }

    @Override // android.app.Activity
    public void startIntentSenderForResult(@SuppressLint({"UnknownNullness"}) IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4) throws IntentSender.SendIntentException {
        if (!this.mStartedIntentSenderFromFragment && i != -1) {
            checkForValidRequestCode(i);
        }
        super.startIntentSenderForResult(intentSender, i, intent, i2, i3, i4);
    }

    public void startIntentSenderFromFragment(Fragment fragment, @SuppressLint({"UnknownNullness"}) IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4, Bundle bundle) throws IntentSender.SendIntentException {
        this.mStartedIntentSenderFromFragment = true;
        if (i == -1) {
            try {
                C1826.m4721(this, intentSender, i, intent, i2, i3, i4, bundle);
            } finally {
                this.mStartedIntentSenderFromFragment = false;
            }
        } else {
            checkForValidRequestCode(i);
            C1826.m4721(this, intentSender, ((allocateRequestIndex(fragment) + 1) << 16) + (i & 65535), intent, i2, i3, i4, bundle);
            this.mStartedIntentSenderFromFragment = false;
        }
    }

    public void supportFinishAfterTransition() {
        C1826.m4716(this);
    }

    @Deprecated
    public void supportInvalidateOptionsMenu() {
        invalidateOptionsMenu();
    }

    public void supportPostponeEnterTransition() {
        C1826.m4725(this);
    }

    public void supportStartPostponedEnterTransition() {
        C1826.m4726(this);
    }

    @Override // ῲ.ᨨ.K.C1826.AbstractC1830
    public final void validateRequestPermissionsRequestCode(int i) {
        if (!this.mRequestedPermissionsFromFragment && i != -1) {
            checkForValidRequestCode(i);
        }
    }

    public void startActivityFromFragment(Fragment fragment, @SuppressLint({"UnknownNullness"}) Intent intent, int i, Bundle bundle) {
        this.mStartedActivityFromFragment = true;
        if (i == -1) {
            try {
                C1826.m4720(this, intent, -1, bundle);
            } finally {
                this.mStartedActivityFromFragment = false;
            }
        } else {
            checkForValidRequestCode(i);
            C1826.m4720(this, intent, ((allocateRequestIndex(fragment) + 1) << 16) + (i & 65535), bundle);
            this.mStartedActivityFromFragment = false;
        }
    }

    public View onCreateView(String str, Context context, AttributeSet attributeSet) {
        View dispatchFragmentsOnCreateView = dispatchFragmentsOnCreateView(null, str, context, attributeSet);
        return dispatchFragmentsOnCreateView == null ? super.onCreateView(str, context, attributeSet) : dispatchFragmentsOnCreateView;
    }

    public void startActivityForResult(@SuppressLint({"UnknownNullness"}) Intent intent, int i, Bundle bundle) {
        if (!this.mStartedActivityFromFragment && i != -1) {
            checkForValidRequestCode(i);
        }
        super.startActivityForResult(intent, i, bundle);
    }

    @Override // android.app.Activity
    public void startIntentSenderForResult(@SuppressLint({"UnknownNullness"}) IntentSender intentSender, int i, Intent intent, int i2, int i3, int i4, Bundle bundle) throws IntentSender.SendIntentException {
        if (!this.mStartedIntentSenderFromFragment && i != -1) {
            checkForValidRequestCode(i);
        }
        super.startIntentSenderForResult(intentSender, i, intent, i2, i3, i4, bundle);
    }

    public FragmentActivity(int i) {
        super(i);
        C0186 k = new C0186();
        C2369.m6312(k, "callbacks == null");
        this.mFragments = new C1544(k);
    }
}
