package androidx.drawerlayout.widget;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import androidx.customview.view.AbsSavedState;
import com.facebook.internal.WebDialog;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.util.ArrayList;
import java.util.List;
import ඓ.K.K.K.C1293;
import ῲ.ᕣ.K.C1698;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1747;
import ῲ.ᨨ.ᨨ.䃖.C1782;
import ῲ.ᨨ.ῲ.C1806;
import K.K.K.ʬ.C2369;

public class DrawerLayout extends ViewGroup {

    /* renamed from: ጒ  reason: contains not printable characters */
    public static final int[] f1202 = {16843828};

    /* renamed from: 㒁  reason: contains not printable characters */
    public static final boolean f1203 = true;

    /* renamed from: 㷛  reason: contains not printable characters */
    public static final boolean f1204 = true;

    /* renamed from: 㹎  reason: contains not printable characters */
    public static final int[] f1205 = {16842931};

    /* renamed from: ʬ  reason: contains not printable characters */
    public float f1206;

    /* renamed from: В  reason: contains not printable characters */
    public final ArrayList<View> f1207;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f1208;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public List<AbstractC0178> f1209;

    /* renamed from: ؿ  reason: contains not printable characters */
    public int f1210;

    /* renamed from: ݜ  reason: contains not printable characters */
    public boolean f1211;

    /* renamed from: ಯ  reason: contains not printable characters */
    public Matrix f1212;

    /* renamed from: ඓ  reason: contains not printable characters */
    public int f1213;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public Drawable f1214;

    /* renamed from: ሽ  reason: contains not printable characters */
    public Drawable f1215;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public Drawable f1216;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public Drawable f1217;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public float f1218;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f1219;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public final C0176 f1220;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public boolean f1221;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public final C1698 f1222;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final C0172 f1223;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Paint f1224;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public Drawable f1225;

    /* renamed from: ゎ  reason: contains not printable characters */
    public Drawable f1226;

    /* renamed from: ト  reason: contains not printable characters */
    public CharSequence f1227;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f1228;

    /* renamed from: 㗗  reason: contains not printable characters */
    public int f1229;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f1230;

    /* renamed from: 㮔  reason: contains not printable characters */
    public CharSequence f1231;

    /* renamed from: 㮝  reason: contains not printable characters */
    public Rect f1232;

    /* renamed from: 㳳  reason: contains not printable characters */
    public final C0176 f1233;

    /* renamed from: 㴪  reason: contains not printable characters */
    public Drawable f1234;

    /* renamed from: 㴹  reason: contains not printable characters */
    public float f1235;

    /* renamed from: 㶋  reason: contains not printable characters */
    public float f1236;

    /* renamed from: 㸾  reason: contains not printable characters */
    public int f1237;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final C1698 f1238;

    /* renamed from: 䀟  reason: contains not printable characters */
    public AbstractC0178 f1239;

    /* renamed from: 䁗  reason: contains not printable characters */
    public boolean f1240;

    /* renamed from: 䃖  reason: contains not printable characters */
    public Object f1241;

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$ʬ  reason: contains not printable characters */
    public static final class C0172 extends C1747 {
        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityNodeInfo(View view, C1782 r2) {
            super.onInitializeAccessibilityNodeInfo(view, r2);
            if (!DrawerLayout.m639(view)) {
                r2.m4653((View) null);
            }
        }
    }

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$ῲ  reason: contains not printable characters */
    public class C0174 extends C1747 {

        /* renamed from: K  reason: contains not printable characters */
        public final Rect f1252 = new Rect();

        public C0174() {
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public boolean dispatchPopulateAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            CharSequence r4;
            if (accessibilityEvent.getEventType() != 32) {
                return super.dispatchPopulateAccessibilityEvent(view, accessibilityEvent);
            }
            List<CharSequence> text = accessibilityEvent.getText();
            View r42 = DrawerLayout.this.m670();
            if (r42 == null || (r4 = DrawerLayout.this.m641(DrawerLayout.this.m645(r42))) == null) {
                return true;
            }
            text.add(r4);
            return true;
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityEvent(View view, AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(view, accessibilityEvent);
            accessibilityEvent.setClassName(DrawerLayout.class.getName());
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public void onInitializeAccessibilityNodeInfo(View view, C1782 r7) {
            if (DrawerLayout.f1203) {
                super.onInitializeAccessibilityNodeInfo(view, r7);
            } else {
                C1782 r2 = new C1782(AccessibilityNodeInfo.obtain(r7.f6124));
                super.onInitializeAccessibilityNodeInfo(view, r2);
                r7.f6122 = -1;
                r7.f6124.setSource(view);
                ViewParent r0 = C1729.m4445(view);
                if (r0 instanceof View) {
                    r7.m4653((View) r0);
                }
                Rect rect = this.f1252;
                r2.f6124.getBoundsInParent(rect);
                r7.f6124.setBoundsInParent(rect);
                r2.f6124.getBoundsInScreen(rect);
                r7.f6124.setBoundsInScreen(rect);
                int i = Build.VERSION.SDK_INT;
                r7.m4648(r2.f6124.isVisibleToUser());
                r7.f6124.setPackageName(r2.m4649());
                r7.f6124.setClassName(r2.m4652());
                r7.f6124.setContentDescription(r2.m4647());
                r7.f6124.setEnabled(r2.m4671());
                r7.f6124.setClickable(r2.m4657());
                r7.f6124.setFocusable(r2.m4651());
                r7.f6124.setFocused(r2.m4668());
                int i2 = Build.VERSION.SDK_INT;
                r7.m4665(r2.f6124.isAccessibilityFocused());
                r7.f6124.setSelected(r2.m4667());
                r7.f6124.setLongClickable(r2.m4650());
                r7.f6124.addAction(r2.m4658());
                r2.f6124.recycle();
                ViewGroup viewGroup = (ViewGroup) view;
                int childCount = viewGroup.getChildCount();
                for (int i3 = 0; i3 < childCount; i3++) {
                    View childAt = viewGroup.getChildAt(i3);
                    if (DrawerLayout.m639(childAt)) {
                        r7.f6124.addChild(childAt);
                    }
                }
            }
            r7.f6124.setClassName(DrawerLayout.class.getName());
            r7.f6124.setFocusable(false);
            r7.f6124.setFocused(false);
            r7.m4656(C1782.C1785.f6128);
            r7.m4656(C1782.C1785.f6135);
        }

        @Override // ῲ.ᨨ.ᨨ.C1747
        public boolean onRequestSendAccessibilityEvent(ViewGroup viewGroup, View view, AccessibilityEvent accessibilityEvent) {
            if (DrawerLayout.f1203 || DrawerLayout.m639(view)) {
                return super.onRequestSendAccessibilityEvent(viewGroup, view, accessibilityEvent);
            }
            return false;
        }
    }

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$K  reason: contains not printable characters */
    public class View$OnApplyWindowInsetsListenerC0175 implements View.OnApplyWindowInsetsListener {
        public View$OnApplyWindowInsetsListenerC0175(DrawerLayout drawerLayout) {
        }

        public WindowInsets onApplyWindowInsets(View view, WindowInsets windowInsets) {
            ((DrawerLayout) view).m663(windowInsets, windowInsets.getSystemWindowInsetTop() > 0);
            return windowInsets.consumeSystemWindowInsets();
        }
    }

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$㴹  reason: contains not printable characters */
    public class C0176 extends C1698.AbstractC1699 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final Runnable f1253 = new RunnableC0177();

        /* renamed from: ῲ  reason: contains not printable characters */
        public C1698 f1254;

        /* renamed from: K  reason: contains not printable characters */
        public final int f1255;

        /* renamed from: androidx.drawerlayout.widget.DrawerLayout$㴹$K  reason: contains not printable characters */
        public class RunnableC0177 implements Runnable {
            public RunnableC0177() {
            }

            public void run() {
                int i;
                View view;
                C0176 r0 = C0176.this;
                int i2 = r0.f1254.f5984;
                int i3 = 0;
                boolean z = r0.f1255 == 3;
                if (z) {
                    view = DrawerLayout.this.m655(3);
                    if (view != null) {
                        i3 = -view.getWidth();
                    }
                    i = i3 + i2;
                } else {
                    view = DrawerLayout.this.m655(5);
                    i = DrawerLayout.this.getWidth() - i2;
                }
                if (view == null) {
                    return;
                }
                if (((z && view.getLeft() < i) || (!z && view.getLeft() > i)) && DrawerLayout.this.m669(view) == 0) {
                    r0.f1254.m4356(view, i, view.getTop());
                    ((C0173) view.getLayoutParams()).f1247 = true;
                    DrawerLayout.this.invalidate();
                    r0.m673();
                    DrawerLayout.this.m656();
                }
            }
        }

        public C0176(int i) {
            this.f1255 = i;
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int clampViewPositionHorizontal(View view, int i, int i2) {
            if (DrawerLayout.this.m666(view, 3)) {
                return Math.max(-view.getWidth(), Math.min(i, 0));
            }
            int width = DrawerLayout.this.getWidth();
            return Math.max(width - view.getWidth(), Math.min(i, width));
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int clampViewPositionVertical(View view, int i, int i2) {
            return view.getTop();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public int getViewHorizontalDragRange(View view) {
            if (DrawerLayout.this.m647(view)) {
                return view.getWidth();
            }
            return 0;
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onEdgeDragStarted(int i, int i2) {
            View view;
            if ((i & 1) == 1) {
                view = DrawerLayout.this.m655(3);
            } else {
                view = DrawerLayout.this.m655(5);
            }
            if (view != null && DrawerLayout.this.m669(view) == 0) {
                this.f1254.m4365(view, i2);
            }
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public boolean onEdgeLock(int i) {
            return false;
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onEdgeTouched(int i, int i2) {
            DrawerLayout.this.postDelayed(this.f1253, 160);
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewCaptured(View view, int i) {
            ((C0173) view.getLayoutParams()).f1247 = false;
            m673();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewDragStateChanged(int i) {
            DrawerLayout.this.m658(i, this.f1254.f5975);
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewPositionChanged(View view, int i, int i2, int i3, int i4) {
            float f;
            int width = view.getWidth();
            if (DrawerLayout.this.m666(view, 3)) {
                f = (float) (i + width);
            } else {
                f = (float) (DrawerLayout.this.getWidth() - i);
            }
            float f2 = f / ((float) width);
            DrawerLayout.this.m643(view, f2);
            view.setVisibility(f2 == 0.0f ? 4 : 0);
            DrawerLayout.this.invalidate();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public void onViewReleased(View view, float f, float f2) {
            int i;
            float r8 = DrawerLayout.this.m668(view);
            int width = view.getWidth();
            if (DrawerLayout.this.m666(view, 3)) {
                int i2 = (f > 0.0f ? 1 : (f == 0.0f ? 0 : -1));
                i = (i2 > 0 || (i2 == 0 && r8 > 0.5f)) ? 0 : -width;
            } else {
                int width2 = DrawerLayout.this.getWidth();
                if (f < 0.0f || (f == 0.0f && r8 > 0.5f)) {
                    width2 -= width;
                }
                i = width2;
            }
            this.f1254.m4354(i, view.getTop());
            DrawerLayout.this.invalidate();
        }

        @Override // ῲ.ᕣ.K.C1698.AbstractC1699
        public boolean tryCaptureView(View view, int i) {
            return DrawerLayout.this.m647(view) && DrawerLayout.this.m666(view, this.f1255) && DrawerLayout.this.m669(view) == 0;
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public void m672() {
            DrawerLayout.this.removeCallbacks(this.f1253);
        }

        /* renamed from: K  reason: contains not printable characters */
        public final void m673() {
            int i = 3;
            if (this.f1255 == 3) {
                i = 5;
            }
            View r0 = DrawerLayout.this.m655(i);
            if (r0 != null) {
                DrawerLayout.this.m659(r0);
            }
        }
    }

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$㸾  reason: contains not printable characters */
    public interface AbstractC0178 {
        /* renamed from: ῲ  reason: contains not printable characters */
        void m674(View view);

        /* renamed from: K  reason: contains not printable characters */
        void m675(int i);

        /* renamed from: K  reason: contains not printable characters */
        void m676(View view);

        /* renamed from: K  reason: contains not printable characters */
        void m677(View view, float f);
    }

    static {
        int i = Build.VERSION.SDK_INT;
    }

    public DrawerLayout(Context context) {
        this(context, null);
    }

    /* renamed from: 㑃  reason: contains not printable characters */
    public static boolean m639(View view) {
        return (C1729.m4454(view) == 4 || C1729.m4454(view) == 2) ? false : true;
    }

    @Override // android.view.View, android.view.ViewGroup
    public void addFocusables(ArrayList<View> arrayList, int i, int i2) {
        if (getDescendantFocusability() != 393216) {
            int childCount = getChildCount();
            boolean z = false;
            for (int i3 = 0; i3 < childCount; i3++) {
                View childAt = getChildAt(i3);
                if (!m647(childAt)) {
                    this.f1207.add(childAt);
                } else if (m671(childAt)) {
                    childAt.addFocusables(arrayList, i, i2);
                    z = true;
                }
            }
            if (!z) {
                int size = this.f1207.size();
                for (int i4 = 0; i4 < size; i4++) {
                    View view = this.f1207.get(i4);
                    if (view.getVisibility() == 0) {
                        view.addFocusables(arrayList, i, i2);
                    }
                }
            }
            this.f1207.clear();
        }
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, i, layoutParams);
        if (m640() != null || m647(view)) {
            C1729.m4457(view, 4);
        } else {
            C1729.m4457(view, 1);
        }
        if (!f1203) {
            C1729.m4482(view, this.f1223);
        }
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0173) && super.checkLayoutParams(layoutParams);
    }

    public void computeScroll() {
        int childCount = getChildCount();
        float f = 0.0f;
        for (int i = 0; i < childCount; i++) {
            f = Math.max(f, ((C0173) getChildAt(i).getLayoutParams()).f1248);
        }
        this.f1235 = f;
        boolean r0 = this.f1238.m4370(true);
        boolean r1 = this.f1222.m4370(true);
        if (r0 || r1) {
            C1729.m4449(this);
        }
    }

    public boolean dispatchGenericMotionEvent(MotionEvent motionEvent) {
        boolean z;
        if ((motionEvent.getSource() & 2) == 0 || motionEvent.getAction() == 10 || this.f1235 <= 0.0f) {
            return super.dispatchGenericMotionEvent(motionEvent);
        }
        int childCount = getChildCount();
        if (childCount == 0) {
            return false;
        }
        float x = motionEvent.getX();
        float y = motionEvent.getY();
        for (int i = childCount - 1; i >= 0; i--) {
            View childAt = getChildAt(i);
            if (this.f1232 == null) {
                this.f1232 = new Rect();
            }
            childAt.getHitRect(this.f1232);
            if (this.f1232.contains((int) x, (int) y) && !m654(childAt)) {
                if (!childAt.getMatrix().isIdentity()) {
                    MotionEvent obtain = MotionEvent.obtain(motionEvent);
                    obtain.offsetLocation((float) (getScrollX() - childAt.getLeft()), (float) (getScrollY() - childAt.getTop()));
                    Matrix matrix = childAt.getMatrix();
                    if (!matrix.isIdentity()) {
                        if (this.f1212 == null) {
                            this.f1212 = new Matrix();
                        }
                        matrix.invert(this.f1212);
                        obtain.transform(this.f1212);
                    }
                    z = childAt.dispatchGenericMotionEvent(obtain);
                    obtain.recycle();
                } else {
                    float scrollX = (float) (getScrollX() - childAt.getLeft());
                    float scrollY = (float) (getScrollY() - childAt.getTop());
                    motionEvent.offsetLocation(scrollX, scrollY);
                    z = childAt.dispatchGenericMotionEvent(motionEvent);
                    motionEvent.offsetLocation(-scrollX, -scrollY);
                }
                if (z) {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean drawChild(Canvas canvas, View view, long j) {
        int i;
        int height = getHeight();
        boolean r4 = m654(view);
        int width = getWidth();
        int save = canvas.save();
        int i2 = 0;
        if (r4) {
            int childCount = getChildCount();
            i = width;
            int i3 = 0;
            for (int i4 = 0; i4 < childCount; i4++) {
                View childAt = getChildAt(i4);
                if (childAt != view && childAt.getVisibility() == 0) {
                    Drawable background = childAt.getBackground();
                    if ((background != null && background.getOpacity() == -1) && m647(childAt) && childAt.getHeight() >= height) {
                        if (m666(childAt, 3)) {
                            int right = childAt.getRight();
                            if (right > i3) {
                                i3 = right;
                            }
                        } else {
                            int left = childAt.getLeft();
                            if (left < i) {
                                i = left;
                            }
                        }
                    }
                }
            }
            canvas.clipRect(i3, 0, i, getHeight());
            i2 = i3;
        } else {
            i = width;
        }
        boolean drawChild = super.drawChild(canvas, view, j);
        canvas.restoreToCount(save);
        float f = this.f1235;
        if (f > 0.0f && r4) {
            int i5 = this.f1213;
            this.f1224.setColor((i5 & 16777215) | (((int) (((float) ((-16777216 & i5) >>> 24)) * f)) << 24));
            canvas.drawRect((float) i2, 0.0f, (float) i, (float) getHeight(), this.f1224);
        } else if (this.f1216 != null && m666(view, 3)) {
            int intrinsicWidth = this.f1216.getIntrinsicWidth();
            int right2 = view.getRight();
            float max = Math.max(0.0f, Math.min(((float) right2) / ((float) this.f1238.f5984), 1.0f));
            this.f1216.setBounds(right2, view.getTop(), intrinsicWidth + right2, view.getBottom());
            this.f1216.setAlpha((int) (max * 255.0f));
            this.f1216.draw(canvas);
        } else if (this.f1226 != null && m666(view, 5)) {
            int intrinsicWidth2 = this.f1226.getIntrinsicWidth();
            int left2 = view.getLeft();
            float max2 = Math.max(0.0f, Math.min(((float) (getWidth() - left2)) / ((float) this.f1222.f5984), 1.0f));
            this.f1226.setBounds(left2 - intrinsicWidth2, view.getTop(), left2, view.getBottom());
            this.f1226.setAlpha((int) (max2 * 255.0f));
            this.f1226.draw(canvas);
        }
        return drawChild;
    }

    public ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new C0173(-1, -1);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof C0173) {
            return new C0173((C0173) layoutParams);
        }
        return layoutParams instanceof ViewGroup.MarginLayoutParams ? new C0173((ViewGroup.MarginLayoutParams) layoutParams) : new C0173(layoutParams);
    }

    public float getDrawerElevation() {
        if (f1204) {
            return this.f1206;
        }
        return 0.0f;
    }

    public Drawable getStatusBarBackgroundDrawable() {
        return this.f1234;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.f1208 = true;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.f1208 = true;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.f1221 && this.f1234 != null) {
            int i = Build.VERSION.SDK_INT;
            Object obj = this.f1241;
            int systemWindowInsetTop = obj != null ? ((WindowInsets) obj).getSystemWindowInsetTop() : 0;
            if (systemWindowInsetTop > 0) {
                this.f1234.setBounds(0, 0, getWidth(), systemWindowInsetTop);
                this.f1234.draw(canvas);
            }
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:6:0x001b, code lost:
        if (r0 != 3) goto L_0x006a;
     */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x0054 A[LOOP:0: B:8:0x0024->B:17:0x0054, LOOP_END] */
    /* JADX WARNING: Removed duplicated region for block: B:45:0x0052 A[SYNTHETIC] */
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        boolean z;
        boolean z2;
        View r9;
        boolean z3;
        boolean z4;
        int actionMasked = motionEvent.getActionMasked();
        boolean r1 = this.f1238.m4348(motionEvent) | this.f1222.m4348(motionEvent);
        if (actionMasked != 0) {
            if (actionMasked != 1) {
                if (actionMasked == 2) {
                    C1698 r92 = this.f1238;
                    int length = r92.f5989.length;
                    int i = 0;
                    while (true) {
                        if (i >= length) {
                            z3 = false;
                            break;
                        }
                        if (r92.m4353(i)) {
                            float f = r92.f5987[i] - r92.f5989[i];
                            float f2 = r92.f5981[i] - r92.f5976[i];
                            float f3 = (f2 * f2) + (f * f);
                            int i2 = r92.f5980;
                            if (f3 > ((float) (i2 * i2))) {
                                z4 = true;
                                if (!z4) {
                                    z3 = true;
                                    break;
                                }
                                i++;
                            }
                        }
                        z4 = false;
                        if (!z4) {
                        }
                    }
                    if (z3) {
                        this.f1233.m672();
                        this.f1220.m672();
                    }
                }
                z = false;
            }
            m664(true);
            this.f1211 = false;
            z = false;
        } else {
            float x = motionEvent.getX();
            float y = motionEvent.getY();
            this.f1236 = x;
            this.f1218 = y;
            z = this.f1235 > 0.0f && (r9 = this.f1238.m4359((int) x, (int) y)) != null && m654(r9);
            this.f1211 = false;
        }
        if (r1 || z) {
            return true;
        }
        int childCount = getChildCount();
        int i3 = 0;
        while (true) {
            if (i3 >= childCount) {
                z2 = false;
                break;
            } else if (((C0173) getChildAt(i3).getLayoutParams()).f1247) {
                z2 = true;
                break;
            } else {
                i3++;
            }
        }
        if (z2 || this.f1211) {
            return true;
        }
        return false;
    }

    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        if (i == 4) {
            if (m670() != null) {
                keyEvent.startTracking();
                return true;
            }
        }
        return super.onKeyDown(i, keyEvent);
    }

    public boolean onKeyUp(int i, KeyEvent keyEvent) {
        if (i != 4) {
            return super.onKeyUp(i, keyEvent);
        }
        View r2 = m670();
        if (r2 != null && m669(r2) == 0) {
            m649();
        }
        return r2 != null;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        float f;
        int i5;
        this.f1240 = true;
        int i6 = i3 - i;
        int childCount = getChildCount();
        for (int i7 = 0; i7 < childCount; i7++) {
            View childAt = getChildAt(i7);
            if (childAt.getVisibility() != 8) {
                C0173 r7 = (C0173) childAt.getLayoutParams();
                if (m654(childAt)) {
                    int i8 = ((ViewGroup.MarginLayoutParams) r7).leftMargin;
                    childAt.layout(i8, ((ViewGroup.MarginLayoutParams) r7).topMargin, childAt.getMeasuredWidth() + i8, childAt.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r7).topMargin);
                } else {
                    int measuredWidth = childAt.getMeasuredWidth();
                    int measuredHeight = childAt.getMeasuredHeight();
                    if (m666(childAt, 3)) {
                        float f2 = (float) measuredWidth;
                        i5 = (-measuredWidth) + ((int) (r7.f1248 * f2));
                        f = ((float) (measuredWidth + i5)) / f2;
                    } else {
                        float f3 = (float) measuredWidth;
                        int i9 = i6 - ((int) (r7.f1248 * f3));
                        f = ((float) (i6 - i9)) / f3;
                        i5 = i9;
                    }
                    boolean z2 = f != r7.f1248;
                    int i10 = r7.f1249 & 112;
                    if (i10 == 16) {
                        int i11 = i4 - i2;
                        int i12 = (i11 - measuredHeight) / 2;
                        int i13 = ((ViewGroup.MarginLayoutParams) r7).topMargin;
                        if (i12 < i13) {
                            i12 = i13;
                        } else {
                            int i14 = i12 + measuredHeight;
                            int i15 = ((ViewGroup.MarginLayoutParams) r7).bottomMargin;
                            if (i14 > i11 - i15) {
                                i12 = (i11 - i15) - measuredHeight;
                            }
                        }
                        childAt.layout(i5, i12, measuredWidth + i5, measuredHeight + i12);
                    } else if (i10 != 80) {
                        int i16 = ((ViewGroup.MarginLayoutParams) r7).topMargin;
                        childAt.layout(i5, i16, measuredWidth + i5, measuredHeight + i16);
                    } else {
                        int i17 = i4 - i2;
                        childAt.layout(i5, (i17 - ((ViewGroup.MarginLayoutParams) r7).bottomMargin) - childAt.getMeasuredHeight(), measuredWidth + i5, i17 - ((ViewGroup.MarginLayoutParams) r7).bottomMargin);
                    }
                    if (z2) {
                        m643(childAt, f);
                    }
                    int i18 = r7.f1248 > 0.0f ? 0 : 4;
                    if (childAt.getVisibility() != i18) {
                        childAt.setVisibility(i18);
                    }
                }
            }
        }
        this.f1240 = false;
        this.f1208 = false;
    }

    @SuppressLint({"WrongConstant"})
    public void onMeasure(int i, int i2) {
        String str;
        int mode = View.MeasureSpec.getMode(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int size = View.MeasureSpec.getSize(i);
        int size2 = View.MeasureSpec.getSize(i2);
        if (!(mode == 1073741824 && mode2 == 1073741824)) {
            if (isInEditMode()) {
                if (mode != Integer.MIN_VALUE && mode == 0) {
                    size = 300;
                }
                if (mode2 != Integer.MIN_VALUE && mode2 == 0) {
                    size2 = 300;
                }
            } else {
                throw new IllegalArgumentException("DrawerLayout must be measured with MeasureSpec.EXACTLY.");
            }
        }
        setMeasuredDimension(size, size2);
        int i3 = 0;
        boolean z = this.f1241 != null && C1729.m4500(this);
        int r5 = C1729.m4511(this);
        int childCount = getChildCount();
        int i4 = 0;
        boolean z2 = false;
        boolean z3 = false;
        while (i4 < childCount) {
            View childAt = getChildAt(i4);
            if (childAt.getVisibility() != 8) {
                C0173 r11 = (C0173) childAt.getLayoutParams();
                if (z) {
                    int r13 = C2369.m6293(r11.f1249, r5);
                    if (C1729.m4500(childAt)) {
                        int i5 = Build.VERSION.SDK_INT;
                        WindowInsets windowInsets = (WindowInsets) this.f1241;
                        if (r13 == 3) {
                            windowInsets = windowInsets.replaceSystemWindowInsets(windowInsets.getSystemWindowInsetLeft(), windowInsets.getSystemWindowInsetTop(), i3, windowInsets.getSystemWindowInsetBottom());
                        } else if (r13 == 5) {
                            windowInsets = windowInsets.replaceSystemWindowInsets(i3, windowInsets.getSystemWindowInsetTop(), windowInsets.getSystemWindowInsetRight(), windowInsets.getSystemWindowInsetBottom());
                        }
                        childAt.dispatchApplyWindowInsets(windowInsets);
                    } else {
                        int i6 = Build.VERSION.SDK_INT;
                        WindowInsets windowInsets2 = (WindowInsets) this.f1241;
                        if (r13 == 3) {
                            windowInsets2 = windowInsets2.replaceSystemWindowInsets(windowInsets2.getSystemWindowInsetLeft(), windowInsets2.getSystemWindowInsetTop(), i3, windowInsets2.getSystemWindowInsetBottom());
                        } else if (r13 == 5) {
                            windowInsets2 = windowInsets2.replaceSystemWindowInsets(i3, windowInsets2.getSystemWindowInsetTop(), windowInsets2.getSystemWindowInsetRight(), windowInsets2.getSystemWindowInsetBottom());
                        }
                        ((ViewGroup.MarginLayoutParams) r11).leftMargin = windowInsets2.getSystemWindowInsetLeft();
                        ((ViewGroup.MarginLayoutParams) r11).topMargin = windowInsets2.getSystemWindowInsetTop();
                        ((ViewGroup.MarginLayoutParams) r11).rightMargin = windowInsets2.getSystemWindowInsetRight();
                        ((ViewGroup.MarginLayoutParams) r11).bottomMargin = windowInsets2.getSystemWindowInsetBottom();
                    }
                }
                if (m654(childAt)) {
                    childAt.measure(View.MeasureSpec.makeMeasureSpec((size - ((ViewGroup.MarginLayoutParams) r11).leftMargin) - ((ViewGroup.MarginLayoutParams) r11).rightMargin, 1073741824), View.MeasureSpec.makeMeasureSpec((size2 - ((ViewGroup.MarginLayoutParams) r11).topMargin) - ((ViewGroup.MarginLayoutParams) r11).bottomMargin, 1073741824));
                } else if (m647(childAt)) {
                    if (f1204) {
                        float r2 = C1729.m4456(childAt);
                        float f = this.f1206;
                        if (r2 != f) {
                            int i7 = Build.VERSION.SDK_INT;
                            childAt.setElevation(f);
                        }
                    }
                    int r22 = m645(childAt) & 7;
                    boolean z4 = r22 == 3;
                    if ((!z4 || !z2) && (z4 || !z3)) {
                        if (z4) {
                            z2 = true;
                        } else {
                            z3 = true;
                        }
                        childAt.measure(ViewGroup.getChildMeasureSpec(i, this.f1237 + ((ViewGroup.MarginLayoutParams) r11).leftMargin + ((ViewGroup.MarginLayoutParams) r11).rightMargin, ((ViewGroup.MarginLayoutParams) r11).width), ViewGroup.getChildMeasureSpec(i2, ((ViewGroup.MarginLayoutParams) r11).topMargin + ((ViewGroup.MarginLayoutParams) r11).bottomMargin, ((ViewGroup.MarginLayoutParams) r11).height));
                        i4++;
                        i3 = 0;
                    } else {
                        StringBuilder r3 = C1293.m3416("Child drawer has absolute gravity ");
                        if ((r22 & 3) != 3) {
                            str = (r22 & 5) == 5 ? "RIGHT" : Integer.toHexString(r22);
                        } else {
                            str = "LEFT";
                        }
                        r3.append(str);
                        r3.append(" but this ");
                        r3.append("DrawerLayout");
                        r3.append(" already has a ");
                        r3.append("drawer view along that edge");
                        throw new IllegalStateException(r3.toString());
                    }
                } else {
                    throw new IllegalStateException("Child " + childAt + " at index " + i4 + " does not have a valid layout_gravity - must be Gravity.LEFT, " + "Gravity.RIGHT or Gravity.NO_GRAVITY");
                }
            }
            i4++;
            i3 = 0;
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        View r0;
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        int i = savedState.f1244;
        if (!(i == 0 || (r0 = m655(i)) == null)) {
            m646(r0);
        }
        int i2 = savedState.f1242;
        if (i2 != 3) {
            m657(i2, 3);
        }
        int i3 = savedState.f1246;
        if (i3 != 3) {
            m657(i3, 5);
        }
        int i4 = savedState.f1243;
        if (i4 != 3) {
            m657(i4, 8388611);
        }
        int i5 = savedState.f1245;
        if (i5 != 3) {
            m657(i5, 8388613);
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:13:0x0029  */
    /* JADX WARNING: Removed duplicated region for block: B:16:0x0033  */
    public void onRtlPropertiesChanged(int i) {
        Drawable drawable;
        int r2;
        Drawable drawable2;
        if (!f1204) {
            int r22 = C1729.m4511(this);
            if (r22 == 0) {
                Drawable drawable3 = this.f1214;
                if (drawable3 != null) {
                    m665(drawable3, r22);
                    drawable = this.f1214;
                    this.f1216 = drawable;
                    r2 = C1729.m4511(this);
                    if (r2 == 0) {
                        Drawable drawable4 = this.f1225;
                        if (drawable4 != null) {
                            m665(drawable4, r2);
                            drawable2 = this.f1225;
                            this.f1226 = drawable2;
                        }
                    } else {
                        Drawable drawable5 = this.f1214;
                        if (drawable5 != null) {
                            m665(drawable5, r2);
                            drawable2 = this.f1214;
                            this.f1226 = drawable2;
                        }
                    }
                    drawable2 = this.f1217;
                    this.f1226 = drawable2;
                }
            } else {
                Drawable drawable6 = this.f1225;
                if (drawable6 != null) {
                    m665(drawable6, r22);
                    drawable = this.f1225;
                    this.f1216 = drawable;
                    r2 = C1729.m4511(this);
                    if (r2 == 0) {
                    }
                    drawable2 = this.f1217;
                    this.f1226 = drawable2;
                }
            }
            drawable = this.f1215;
            this.f1216 = drawable;
            r2 = C1729.m4511(this);
            if (r2 == 0) {
            }
            drawable2 = this.f1217;
            this.f1226 = drawable2;
        }
    }

    public Parcelable onSaveInstanceState() {
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        int childCount = getChildCount();
        int i = 0;
        while (true) {
            if (i >= childCount) {
                break;
            }
            C0173 r4 = (C0173) getChildAt(i).getLayoutParams();
            boolean z = true;
            boolean z2 = r4.f1250 == 1;
            if (r4.f1250 != 2) {
                z = false;
            }
            if (z2 || z) {
                savedState.f1244 = r4.f1249;
            } else {
                i++;
            }
        }
        savedState.f1242 = this.f1229;
        savedState.f1246 = this.f1210;
        savedState.f1243 = this.f1219;
        savedState.f1245 = this.f1230;
        return savedState;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:15:0x0059, code lost:
        if (m669(r7) != 2) goto L_0x005c;
     */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        this.f1238.m4364(motionEvent);
        this.f1222.m4364(motionEvent);
        int action = motionEvent.getAction() & BaseProgressIndicator.MAX_ALPHA;
        boolean z = false;
        if (action == 0) {
            float x = motionEvent.getX();
            float y = motionEvent.getY();
            this.f1236 = x;
            this.f1218 = y;
            this.f1211 = false;
        } else if (action == 1) {
            float x2 = motionEvent.getX();
            float y2 = motionEvent.getY();
            View r3 = this.f1238.m4359((int) x2, (int) y2);
            if (r3 != null && m654(r3)) {
                float f = x2 - this.f1236;
                float f2 = y2 - this.f1218;
                int i = this.f1238.f5980;
                if ((f2 * f2) + (f * f) < ((float) (i * i))) {
                    View r7 = m640();
                    if (r7 != null) {
                    }
                }
            }
            z = true;
            m664(z);
        } else if (action == 3) {
            m664(true);
            this.f1211 = false;
        }
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        super.requestDisallowInterceptTouchEvent(z);
        if (z) {
            m664(true);
        }
    }

    public void requestLayout() {
        if (!this.f1240) {
            super.requestLayout();
        }
    }

    public void setDrawerElevation(float f) {
        this.f1206 = f;
        for (int i = 0; i < getChildCount(); i++) {
            View childAt = getChildAt(i);
            if (m647(childAt)) {
                C1729.m4472(childAt, this.f1206);
            }
        }
    }

    @Deprecated
    public void setDrawerListener(AbstractC0178 r2) {
        AbstractC0178 r0 = this.f1239;
        if (r0 != null) {
            m653(r0);
        }
        if (r2 != null) {
            m662(r2);
        }
        this.f1239 = r2;
    }

    public void setDrawerLockMode(int i) {
        m657(i, 3);
        m657(i, 5);
    }

    public void setScrimColor(int i) {
        this.f1213 = i;
        invalidate();
    }

    public void setStatusBarBackground(Drawable drawable) {
        this.f1234 = drawable;
        invalidate();
    }

    public void setStatusBarBackgroundColor(int i) {
        this.f1234 = new ColorDrawable(i);
        invalidate();
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public CharSequence m641(int i) {
        int r2 = C2369.m6293(i, C1729.m4511(this));
        if (r2 == 3) {
            return this.f1227;
        }
        if (r2 == 5) {
            return this.f1231;
        }
        return null;
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public int m645(View view) {
        return C2369.m6293(((C0173) view.getLayoutParams()).f1249, C1729.m4511(this));
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public void m646(View view) {
        m652(view, true);
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean m647(View view) {
        int r3 = C2369.m6293(((C0173) view.getLayoutParams()).f1249, C1729.m4511(view));
        return ((r3 & 3) == 0 && (r3 & 5) == 0) ? false : true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m653(AbstractC0178 r2) {
        List<AbstractC0178> list;
        if (r2 != null && (list = this.f1209) != null) {
            list.remove(r2);
        }
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean m654(View view) {
        return ((C0173) view.getLayoutParams()).f1249 == 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m663(Object obj, boolean z) {
        this.f1241 = obj;
        this.f1221 = z;
        setWillNotDraw(!z && getBackground() == null);
        requestLayout();
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean m667(View view) {
        if (m647(view)) {
            return ((C0173) view.getLayoutParams()).f1248 > 0.0f;
        }
        throw new IllegalArgumentException("View " + view + " is not a drawer");
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public float m668(View view) {
        return ((C0173) view.getLayoutParams()).f1248;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public int m669(View view) {
        if (m647(view)) {
            return m648(((C0173) view.getLayoutParams()).f1249);
        }
        throw new IllegalArgumentException("View " + view + " is not a drawer");
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean m671(View view) {
        if (m647(view)) {
            return (((C0173) view.getLayoutParams()).f1250 & 1) == 1;
        }
        throw new IllegalArgumentException("View " + view + " is not a drawer");
    }

    public DrawerLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attributeSet) {
        return new C0173(getContext(), attributeSet);
    }

    public DrawerLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f1223 = new C0172();
        this.f1213 = -1728053248;
        this.f1224 = new Paint();
        this.f1208 = true;
        this.f1229 = 3;
        this.f1210 = 3;
        this.f1219 = 3;
        this.f1230 = 3;
        this.f1214 = null;
        this.f1225 = null;
        this.f1215 = null;
        this.f1217 = null;
        setDescendantFocusability(262144);
        float f = getResources().getDisplayMetrics().density;
        this.f1237 = (int) ((64.0f * f) + 0.5f);
        float f2 = 400.0f * f;
        this.f1233 = new C0176(3);
        this.f1220 = new C0176(5);
        this.f1238 = C1698.m4345(this, 1.0f, this.f1233);
        C1698 r7 = this.f1238;
        r7.f5974 = 1;
        r7.f5972 = f2;
        this.f1233.f1254 = r7;
        this.f1222 = C1698.m4345(this, 1.0f, this.f1220);
        C1698 r72 = this.f1222;
        r72.f5974 = 2;
        r72.f5972 = f2;
        this.f1220.f1254 = r72;
        setFocusableInTouchMode(true);
        C1729.m4457(this, 1);
        C1729.m4482(this, new C0174());
        setMotionEventSplittingEnabled(false);
        if (C1729.m4500(this)) {
            int i2 = Build.VERSION.SDK_INT;
            setOnApplyWindowInsetsListener(new View$OnApplyWindowInsetsListenerC0175(this));
            setSystemUiVisibility(WebDialog.MAX_PADDING_SCREEN_HEIGHT);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(f1202);
            try {
                this.f1234 = obtainStyledAttributes.getDrawable(0);
            } finally {
                obtainStyledAttributes.recycle();
            }
        }
        this.f1206 = f * 10.0f;
        this.f1207 = new ArrayList<>();
    }

    public void setStatusBarBackground(int i) {
        this.f1234 = i != 0 ? C1806.m4683(getContext(), i) : null;
        invalidate();
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public int m648(int i) {
        int r0 = C1729.m4511(this);
        if (i == 3) {
            int i2 = this.f1229;
            if (i2 != 3) {
                return i2;
            }
            int i3 = r0 == 0 ? this.f1219 : this.f1230;
            if (i3 != 3) {
                return i3;
            }
            return 0;
        } else if (i == 5) {
            int i4 = this.f1210;
            if (i4 != 3) {
                return i4;
            }
            int i5 = r0 == 0 ? this.f1230 : this.f1219;
            if (i5 != 3) {
                return i5;
            }
            return 0;
        } else if (i == 8388611) {
            int i6 = this.f1219;
            if (i6 != 3) {
                return i6;
            }
            int i7 = r0 == 0 ? this.f1229 : this.f1210;
            if (i7 != 3) {
                return i7;
            }
            return 0;
        } else if (i != 8388613) {
            return 0;
        } else {
            int i8 = this.f1230;
            if (i8 != 3) {
                return i8;
            }
            int i9 = r0 == 0 ? this.f1210 : this.f1229;
            if (i9 != 3) {
                return i9;
            }
            return 0;
        }
    }

    /* renamed from: androidx.drawerlayout.widget.DrawerLayout$ඓ  reason: contains not printable characters */
    public static class C0173 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f1247;

        /* renamed from: ῲ  reason: contains not printable characters */
        public float f1248;

        /* renamed from: K  reason: contains not printable characters */
        public int f1249 = 0;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1250;

        public C0173(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, DrawerLayout.f1205);
            this.f1249 = obtainStyledAttributes.getInt(0, 0);
            obtainStyledAttributes.recycle();
        }

        public C0173(int i, int i2) {
            super(i, i2);
        }

        public C0173(C0173 r2) {
            super((ViewGroup.MarginLayoutParams) r2);
            this.f1249 = r2.f1249;
        }

        public C0173(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }

        public C0173(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m642(View view) {
        C0173 r0 = (C0173) view.getLayoutParams();
        if ((r0.f1250 & 1) == 0) {
            r0.f1250 = 1;
            List<AbstractC0178> list = this.f1209;
            if (list != null) {
                for (int size = list.size() - 1; size >= 0; size--) {
                    this.f1209.get(size).m676(view);
                }
            }
            m644(view, true);
            if (hasWindowFocus()) {
                sendAccessibilityEvent(32);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m662(AbstractC0178 r2) {
        if (r2 != null) {
            if (this.f1209 == null) {
                this.f1209 = new ArrayList();
            }
            this.f1209.add(r2);
        }
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public View m670() {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (m647(childAt) && m667(childAt)) {
                return childAt;
            }
        }
        return null;
    }

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0171();

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1242;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1243;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1244 = 0;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1245;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1246;

        /* renamed from: androidx.drawerlayout.widget.DrawerLayout$SavedState$K  reason: contains not printable characters */
        public static class C0171 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f1244 = parcel.readInt();
            this.f1242 = parcel.readInt();
            this.f1246 = parcel.readInt();
            this.f1243 = parcel.readInt();
            this.f1245 = parcel.readInt();
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f1244);
            parcel.writeInt(this.f1242);
            parcel.writeInt(this.f1246);
            parcel.writeInt(this.f1243);
            parcel.writeInt(this.f1245);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m657(int i, int i2) {
        View r4;
        int r0 = C2369.m6293(i2, C1729.m4511(this));
        if (i2 == 3) {
            this.f1229 = i;
        } else if (i2 == 5) {
            this.f1210 = i;
        } else if (i2 == 8388611) {
            this.f1219 = i;
        } else if (i2 == 8388613) {
            this.f1230 = i;
        }
        if (i != 0) {
            (r0 == 3 ? this.f1238 : this.f1222).m4350();
        }
        if (i == 1) {
            View r42 = m655(r0);
            if (r42 != null) {
                m659(r42);
            }
        } else if (i == 2 && (r4 = m655(r0)) != null) {
            m646(r4);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m650(View view) {
        View rootView;
        C0173 r0 = (C0173) view.getLayoutParams();
        if ((r0.f1250 & 1) == 1) {
            r0.f1250 = 0;
            List<AbstractC0178> list = this.f1209;
            if (list != null) {
                for (int size = list.size() - 1; size >= 0; size--) {
                    this.f1209.get(size).m674(view);
                }
            }
            m644(view, false);
            if (hasWindowFocus() && (rootView = getRootView()) != null) {
                rootView.sendAccessibilityEvent(32);
            }
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final void m644(View view, boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if ((z || m647(childAt)) && (!z || childAt != view)) {
                C1729.m4457(childAt, 4);
            } else {
                C1729.m4457(childAt, 1);
            }
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m643(View view, float f) {
        C0173 r0 = (C0173) view.getLayoutParams();
        if (f != r0.f1248) {
            r0.f1248 = f;
            m660(view, f);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m658(int i, View view) {
        int i2 = this.f1238.f5982;
        int i3 = this.f1222.f5982;
        int i4 = 2;
        if (i2 == 1 || i3 == 1) {
            i4 = 1;
        } else if (!(i2 == 2 || i3 == 2)) {
            i4 = 0;
        }
        if (view != null && i == 0) {
            float f = ((C0173) view.getLayoutParams()).f1248;
            if (f == 0.0f) {
                m650(view);
            } else if (f == 1.0f) {
                m642(view);
            }
        }
        if (i4 != this.f1228) {
            this.f1228 = i4;
            List<AbstractC0178> list = this.f1209;
            if (list != null) {
                for (int size = list.size() - 1; size >= 0; size--) {
                    this.f1209.get(size).m675(i4);
                }
            }
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m651(View view, float f) {
        float r0 = m668(view);
        float width = (float) view.getWidth();
        int i = ((int) (width * f)) - ((int) (r0 * width));
        if (!m666(view, 3)) {
            i = -i;
        }
        view.offsetLeftAndRight(i);
        m643(view, f);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public View m640() {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if ((((C0173) childAt.getLayoutParams()).f1250 & 1) == 1) {
                return childAt;
            }
        }
        return null;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m649() {
        m664(false);
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m652(View view, boolean z) {
        if (m647(view)) {
            C0173 r0 = (C0173) view.getLayoutParams();
            if (this.f1208) {
                r0.f1248 = 1.0f;
                r0.f1250 = 1;
                m644(view, true);
            } else if (z) {
                r0.f1250 |= 2;
                if (m666(view, 3)) {
                    this.f1238.m4356(view, 0, view.getTop());
                } else {
                    this.f1222.m4356(view, getWidth() - view.getWidth(), view.getTop());
                }
            } else {
                m651(view, 1.0f);
                int i = r0.f1249;
                m658(0, view);
                view.setVisibility(0);
            }
            invalidate();
            return;
        }
        throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m660(View view, float f) {
        List<AbstractC0178> list = this.f1209;
        if (list != null) {
            for (int size = list.size() - 1; size >= 0; size--) {
                this.f1209.get(size).m677(view, f);
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m666(View view, int i) {
        return (m645(view) & i) == i;
    }

    /* renamed from: K  reason: contains not printable characters */
    public View m655(int i) {
        int r5 = C2369.m6293(i, C1729.m4511(this)) & 7;
        int childCount = getChildCount();
        for (int i2 = 0; i2 < childCount; i2++) {
            View childAt = getChildAt(i2);
            if ((m645(childAt) & 7) == r5) {
                return childAt;
            }
        }
        return null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m665(Drawable drawable, int i) {
        if (drawable == null || !C2369.m6271(drawable)) {
            return false;
        }
        C2369.m6340(drawable, i);
        return true;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m664(boolean z) {
        boolean z2;
        int childCount = getChildCount();
        boolean z3 = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            C0173 r5 = (C0173) childAt.getLayoutParams();
            if (m647(childAt) && (!z || r5.f1247)) {
                int width = childAt.getWidth();
                if (m666(childAt, 3)) {
                    z2 = this.f1238.m4356(childAt, -width, childAt.getTop());
                } else {
                    z2 = this.f1222.m4356(childAt, getWidth(), childAt.getTop());
                }
                z3 |= z2;
                r5.f1247 = false;
            }
        }
        this.f1233.m672();
        this.f1220.m672();
        if (z3) {
            invalidate();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m659(View view) {
        m661(view, true);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m661(View view, boolean z) {
        if (m647(view)) {
            C0173 r0 = (C0173) view.getLayoutParams();
            if (this.f1208) {
                r0.f1248 = 0.0f;
                r0.f1250 = 0;
            } else if (z) {
                r0.f1250 |= 4;
                if (m666(view, 3)) {
                    this.f1238.m4356(view, -view.getWidth(), view.getTop());
                } else {
                    this.f1222.m4356(view, getWidth(), view.getTop());
                }
            } else {
                m651(view, 0.0f);
                int i = r0.f1249;
                m658(0, view);
                view.setVisibility(4);
            }
            invalidate();
            return;
        }
        throw new IllegalArgumentException("View " + view + " is not a sliding drawer");
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m656() {
        if (!this.f1211) {
            long uptimeMillis = SystemClock.uptimeMillis();
            MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
            int childCount = getChildCount();
            for (int i = 0; i < childCount; i++) {
                getChildAt(i).dispatchTouchEvent(obtain);
            }
            obtain.recycle();
            this.f1211 = true;
        }
    }
}
