package androidx.coordinatorlayout.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.Region;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.view.Gravity;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewTreeObserver;
import androidx.coordinatorlayout.R$attr;
import androidx.coordinatorlayout.R$style;
import androidx.coordinatorlayout.R$styleable;
import androidx.customview.view.AbsSavedState;
import com.facebook.appevents.codeless.CodelessMatcher;
import com.facebook.internal.WebDialog;
import com.google.android.material.badge.BadgeDrawable;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ᨨ.AbstractC1742;
import ῲ.ᨨ.ᨨ.AbstractC1767;
import ῲ.ᨨ.ᨨ.AbstractC1777;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1751;
import ῲ.ᨨ.ᨨ.C1754;
import ῲ.ᨨ.ῲ.C1806;
import ῲ.ᨨ.㿎.AbstractC1871;
import ῲ.ᨨ.㿎.C1870;
import ῲ.㿎.K.C2297;
import ῲ.㿎.K.C2298;
import K.K.K.ʬ.C2369;

public class CoordinatorLayout extends ViewGroup implements AbstractC1742, AbstractC1767 {
    public static final Class<?>[] CONSTRUCTOR_PARAMS = {Context.class, AttributeSet.class};
    public static final int EVENT_NESTED_SCROLL = 1;
    public static final int EVENT_PRE_DRAW = 0;
    public static final int EVENT_VIEW_REMOVED = 2;
    public static final String TAG = "CoordinatorLayout";
    public static final Comparator<View> TOP_SORTED_CHILDREN_COMPARATOR = new C0151();
    public static final int TYPE_ON_INTERCEPT = 0;
    public static final int TYPE_ON_TOUCH = 1;
    public static final String WIDGET_PACKAGE_NAME;
    public static final ThreadLocal<Map<String, Constructor<AbstractC0144>>> sConstructors = new ThreadLocal<>();
    public static final AbstractC1871<Rect> sRectPool = new C1870(12);
    public AbstractC1777 mApplyWindowInsetsListener;
    public final int[] mBehaviorConsumed;
    public View mBehaviorTouchView;
    public final C2298<View> mChildDag;
    public final List<View> mDependencySortedChildren;
    public boolean mDisallowInterceptReset;
    public boolean mDrawStatusBarBackground;
    public boolean mIsAttachedToWindow;
    public int[] mKeylines;
    public C1754 mLastInsets;
    public boolean mNeedsPreDrawListener;
    public final C1751 mNestedScrollingParentHelper;
    public View mNestedScrollingTarget;
    public final int[] mNestedScrollingV2ConsumedCompat;
    public ViewGroup.OnHierarchyChangeListener mOnHierarchyChangeListener;
    public ViewTreeObserver$OnPreDrawListenerC0147 mOnPreDrawListener;
    public Paint mScrimPaint;
    public Drawable mStatusBarBackground;
    public final List<View> mTempDependenciesList;
    public final List<View> mTempList1;

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$ʬ  reason: contains not printable characters */
    public static abstract class AbstractC0144<V extends View> {
        public AbstractC0144() {
        }

        public static Object getTag(View view) {
            return ((C0149) view.getLayoutParams()).f1108;
        }

        public static void setTag(View view, Object obj) {
            ((C0149) view.getLayoutParams()).f1108 = obj;
        }

        public boolean blocksInteractionBelow(CoordinatorLayout coordinatorLayout, V v) {
            return getScrimOpacity(coordinatorLayout, v) > 0.0f;
        }

        public boolean getInsetDodgeRect(CoordinatorLayout coordinatorLayout, V v, Rect rect) {
            return false;
        }

        public int getScrimColor(CoordinatorLayout coordinatorLayout, V v) {
            return -16777216;
        }

        public float getScrimOpacity(CoordinatorLayout coordinatorLayout, V v) {
            return 0.0f;
        }

        public boolean layoutDependsOn(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public C1754 onApplyWindowInsets(CoordinatorLayout coordinatorLayout, V v, C1754 r3) {
            return r3;
        }

        public void onAttachedToLayoutParams(C0149 r1) {
        }

        public boolean onDependentViewChanged(CoordinatorLayout coordinatorLayout, V v, View view) {
            return false;
        }

        public void onDependentViewRemoved(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onDetachedFromLayoutParams() {
        }

        public boolean onInterceptTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }

        public boolean onLayoutChild(CoordinatorLayout coordinatorLayout, V v, int i) {
            return false;
        }

        public boolean onMeasureChild(CoordinatorLayout coordinatorLayout, V v, int i, int i2, int i3, int i4) {
            return false;
        }

        public boolean onNestedFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2, boolean z) {
            return false;
        }

        public boolean onNestedPreFling(CoordinatorLayout coordinatorLayout, V v, View view, float f, float f2) {
            return false;
        }

        @Deprecated
        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int[] iArr) {
        }

        public void onNestedPreScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int[] iArr, int i3) {
            if (i3 == 0) {
                onNestedPreScroll(coordinatorLayout, v, view, i, i2, iArr);
            }
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int i3, int i4) {
        }

        @Deprecated
        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int i3, int i4, int i5) {
            if (i5 == 0) {
                onNestedScroll(coordinatorLayout, v, view, i, i2, i3, i4);
            }
        }

        @Deprecated
        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i) {
        }

        public void onNestedScrollAccepted(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i, int i2) {
            if (i2 == 0) {
                onNestedScrollAccepted(coordinatorLayout, v, view, view2, i);
            }
        }

        public boolean onRequestChildRectangleOnScreen(CoordinatorLayout coordinatorLayout, V v, Rect rect, boolean z) {
            return false;
        }

        public void onRestoreInstanceState(CoordinatorLayout coordinatorLayout, V v, Parcelable parcelable) {
        }

        public Parcelable onSaveInstanceState(CoordinatorLayout coordinatorLayout, V v) {
            return View.BaseSavedState.EMPTY_STATE;
        }

        @Deprecated
        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i) {
            return false;
        }

        public boolean onStartNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, View view2, int i, int i2) {
            if (i2 == 0) {
                return onStartNestedScroll(coordinatorLayout, v, view, view2, i);
            }
            return false;
        }

        @Deprecated
        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view) {
        }

        public void onStopNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i) {
            if (i == 0) {
                onStopNestedScroll(coordinatorLayout, v, view);
            }
        }

        public boolean onTouchEvent(CoordinatorLayout coordinatorLayout, V v, MotionEvent motionEvent) {
            return false;
        }

        public AbstractC0144(Context context, AttributeSet attributeSet) {
        }

        public void onNestedScroll(CoordinatorLayout coordinatorLayout, V v, View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
            iArr[0] = iArr[0] + i3;
            iArr[1] = iArr[1] + i4;
            onNestedScroll(coordinatorLayout, v, view, i, i2, i3, i4, i5);
        }
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$ඓ  reason: contains not printable characters */
    public class ViewGroup$OnHierarchyChangeListenerC0145 implements ViewGroup.OnHierarchyChangeListener {
        public ViewGroup$OnHierarchyChangeListenerC0145() {
        }

        public void onChildViewAdded(View view, View view2) {
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.mOnHierarchyChangeListener;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewAdded(view, view2);
            }
        }

        public void onChildViewRemoved(View view, View view2) {
            CoordinatorLayout.this.onChildViewsChanged(2);
            ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener = CoordinatorLayout.this.mOnHierarchyChangeListener;
            if (onHierarchyChangeListener != null) {
                onHierarchyChangeListener.onChildViewRemoved(view, view2);
            }
        }
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$ῲ  reason: contains not printable characters */
    public interface AbstractC0146 {
        AbstractC0144 getBehavior();
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$ⁱ  reason: contains not printable characters */
    public class ViewTreeObserver$OnPreDrawListenerC0147 implements ViewTreeObserver.OnPreDrawListener {
        public ViewTreeObserver$OnPreDrawListenerC0147() {
        }

        public boolean onPreDraw() {
            CoordinatorLayout.this.onChildViewsChanged(0);
            return true;
        }
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$K  reason: contains not printable characters */
    public class C0148 implements AbstractC1777 {
        public C0148() {
        }

        @Override // ῲ.ᨨ.ᨨ.AbstractC1777
        public C1754 onApplyWindowInsets(View view, C1754 r2) {
            return CoordinatorLayout.this.setWindowInsets(r2);
        }
    }

    @Deprecated
    @Retention(RetentionPolicy.RUNTIME)
    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$㸾  reason: contains not printable characters */
    public @interface AbstractC0150 {
        Class<? extends AbstractC0144> value();
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$㿎  reason: contains not printable characters */
    public static class C0151 implements Comparator<View> {
        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, java.lang.Object] */
        @Override // java.util.Comparator
        public int compare(View view, View view2) {
            float r2 = C1729.m4501(view);
            float r3 = C1729.m4501(view2);
            if (r2 > r3) {
                return -1;
            }
            return r2 < r3 ? 1 : 0;
        }
    }

    static {
        Package r0 = CoordinatorLayout.class.getPackage();
        WIDGET_PACKAGE_NAME = r0 != null ? r0.getName() : null;
        int i = Build.VERSION.SDK_INT;
    }

    public CoordinatorLayout(Context context) {
        this(context, null);
    }

    public static Rect acquireTempRect() {
        Rect r0 = sRectPool.m4835();
        return r0 == null ? new Rect() : r0;
    }

    public static int clamp(int i, int i2, int i3) {
        return i < i2 ? i2 : i > i3 ? i3 : i;
    }

    private void constrainChildRect(C0149 r6, Rect rect, int i, int i2) {
        int width = getWidth();
        int height = getHeight();
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r6).leftMargin, Math.min(rect.left, ((width - getPaddingRight()) - i) - ((ViewGroup.MarginLayoutParams) r6).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) r6).topMargin, Math.min(rect.top, ((height - getPaddingBottom()) - i2) - ((ViewGroup.MarginLayoutParams) r6).bottomMargin));
        rect.set(max, max2, i + max, i2 + max2);
    }

    private C1754 dispatchApplyWindowInsetsToBehaviors(C1754 r5) {
        AbstractC0144 r3;
        if (r5.m4562()) {
            return r5;
        }
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (C1729.m4500(childAt) && (r3 = ((C0149) childAt.getLayoutParams()).f1105) != null) {
                r5 = r3.onApplyWindowInsets(this, childAt, r5);
                if (r5.m4562()) {
                    break;
                }
            }
        }
        return r5;
    }

    private void getDesiredAnchoredChildRectWithoutConstraints(View view, int i, Rect rect, Rect rect2, C0149 r10, int i2, int i3) {
        int i4;
        int i5;
        int r6 = C2369.m6293(resolveAnchoredChildGravity(r10.f1096), i);
        int r7 = C2369.m6293(resolveGravity(r10.f1111), i);
        int i6 = r6 & 7;
        int i7 = r6 & 112;
        int i8 = r7 & 7;
        int i9 = r7 & 112;
        if (i8 == 1) {
            i4 = rect.left + (rect.width() / 2);
        } else if (i8 != 5) {
            i4 = rect.left;
        } else {
            i4 = rect.right;
        }
        if (i9 == 16) {
            i5 = rect.top + (rect.height() / 2);
        } else if (i9 != 80) {
            i5 = rect.top;
        } else {
            i5 = rect.bottom;
        }
        if (i6 == 1) {
            i4 -= i2 / 2;
        } else if (i6 != 5) {
            i4 -= i2;
        }
        if (i7 == 16) {
            i5 -= i3 / 2;
        } else if (i7 != 80) {
            i5 -= i3;
        }
        rect2.set(i4, i5, i2 + i4, i3 + i5);
    }

    private int getKeyline(int i) {
        int[] iArr = this.mKeylines;
        if (iArr == null) {
            Log.e(TAG, "No keylines defined for " + this + " - attempted index lookup " + i);
            return 0;
        } else if (i >= 0 && i < iArr.length) {
            return iArr[i];
        } else {
            Log.e(TAG, "Keyline index " + i + " out of range for " + this);
            return 0;
        }
    }

    private void getTopSortedChildren(List<View> list) {
        list.clear();
        boolean isChildrenDrawingOrderEnabled = isChildrenDrawingOrderEnabled();
        int childCount = getChildCount();
        for (int i = childCount - 1; i >= 0; i--) {
            list.add(getChildAt(isChildrenDrawingOrderEnabled ? getChildDrawingOrder(childCount, i) : i));
        }
        Comparator<View> comparator = TOP_SORTED_CHILDREN_COMPARATOR;
        if (comparator != null) {
            Collections.sort(list, comparator);
        }
    }

    private boolean hasDependencies(View view) {
        C2298<View> k = this.mChildDag;
        int i = k.f7952.f7909;
        for (int i2 = 0; i2 < i; i2++) {
            ArrayList<T> r4 = k.f7952.m5973(i2);
            if (r4 != null && r4.contains(view)) {
                return true;
            }
        }
        return false;
    }

    private void layoutChild(View view, int i) {
        C0149 r0 = (C0149) view.getLayoutParams();
        Rect acquireTempRect = acquireTempRect();
        acquireTempRect.set(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r0).leftMargin, getPaddingTop() + ((ViewGroup.MarginLayoutParams) r0).topMargin, (getWidth() - getPaddingRight()) - ((ViewGroup.MarginLayoutParams) r0).rightMargin, (getHeight() - getPaddingBottom()) - ((ViewGroup.MarginLayoutParams) r0).bottomMargin);
        if (this.mLastInsets != null && C1729.m4500(this) && !C1729.m4500(view)) {
            acquireTempRect.left = this.mLastInsets.m4556() + acquireTempRect.left;
            acquireTempRect.top = this.mLastInsets.m4557() + acquireTempRect.top;
            acquireTempRect.right -= this.mLastInsets.m4563();
            acquireTempRect.bottom -= this.mLastInsets.m4558();
        }
        Rect acquireTempRect2 = acquireTempRect();
        int resolveGravity = resolveGravity(r0.f1096);
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        int i2 = Build.VERSION.SDK_INT;
        Gravity.apply(resolveGravity, measuredWidth, measuredHeight, acquireTempRect, acquireTempRect2, i);
        view.layout(acquireTempRect2.left, acquireTempRect2.top, acquireTempRect2.right, acquireTempRect2.bottom);
        releaseTempRect(acquireTempRect);
        releaseTempRect(acquireTempRect2);
    }

    private void layoutChildWithAnchor(View view, View view2, int i) {
        Rect acquireTempRect = acquireTempRect();
        Rect acquireTempRect2 = acquireTempRect();
        try {
            getDescendantRect(view2, acquireTempRect);
            getDesiredAnchoredChildRect(view, i, acquireTempRect, acquireTempRect2);
            view.layout(acquireTempRect2.left, acquireTempRect2.top, acquireTempRect2.right, acquireTempRect2.bottom);
        } finally {
            releaseTempRect(acquireTempRect);
            releaseTempRect(acquireTempRect2);
        }
    }

    private void layoutChildWithKeyline(View view, int i, int i2) {
        C0149 r0 = (C0149) view.getLayoutParams();
        int r1 = C2369.m6293(resolveKeylineGravity(r0.f1096), i2);
        int i3 = r1 & 7;
        int i4 = r1 & 112;
        int width = getWidth();
        int height = getHeight();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        if (i2 == 1) {
            i = width - i;
        }
        int keyline = getKeyline(i) - measuredWidth;
        int i5 = 0;
        if (i3 == 1) {
            keyline += measuredWidth / 2;
        } else if (i3 == 5) {
            keyline += measuredWidth;
        }
        if (i4 == 16) {
            i5 = 0 + (measuredHeight / 2);
        } else if (i4 == 80) {
            i5 = measuredHeight + 0;
        }
        int max = Math.max(getPaddingLeft() + ((ViewGroup.MarginLayoutParams) r0).leftMargin, Math.min(keyline, ((width - getPaddingRight()) - measuredWidth) - ((ViewGroup.MarginLayoutParams) r0).rightMargin));
        int max2 = Math.max(getPaddingTop() + ((ViewGroup.MarginLayoutParams) r0).topMargin, Math.min(i5, ((height - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) r0).bottomMargin));
        view.layout(max, max2, measuredWidth + max, measuredHeight + max2);
    }

    private void offsetChildByInset(View view, Rect rect, int i) {
        boolean z;
        boolean z2;
        int width;
        int i2;
        int i3;
        int i4;
        int height;
        int i5;
        int i6;
        int i7;
        if (C1729.m4512(view) && view.getWidth() > 0 && view.getHeight() > 0) {
            C0149 r0 = (C0149) view.getLayoutParams();
            AbstractC0144 r1 = r0.f1105;
            Rect acquireTempRect = acquireTempRect();
            Rect acquireTempRect2 = acquireTempRect();
            acquireTempRect2.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
            if (r1 == null || !r1.getInsetDodgeRect(this, view, acquireTempRect)) {
                acquireTempRect.set(acquireTempRect2);
            } else if (!acquireTempRect2.contains(acquireTempRect)) {
                StringBuilder r10 = C1293.m3416("Rect should be within the child's bounds. Rect:");
                r10.append(acquireTempRect.toShortString());
                r10.append(" | Bounds:");
                r10.append(acquireTempRect2.toShortString());
                throw new IllegalArgumentException(r10.toString());
            }
            releaseTempRect(acquireTempRect2);
            if (acquireTempRect.isEmpty()) {
                releaseTempRect(acquireTempRect);
                return;
            }
            int r11 = C2369.m6293(r0.f1112, i);
            if ((r11 & 48) != 48 || (i6 = (acquireTempRect.top - ((ViewGroup.MarginLayoutParams) r0).topMargin) - r0.f1109) >= (i7 = rect.top)) {
                z = false;
            } else {
                setInsetOffsetY(view, i7 - i6);
                z = true;
            }
            if ((r11 & 80) == 80 && (height = ((getHeight() - acquireTempRect.bottom) - ((ViewGroup.MarginLayoutParams) r0).bottomMargin) + r0.f1109) < (i5 = rect.bottom)) {
                setInsetOffsetY(view, height - i5);
                z = true;
            }
            if (!z) {
                setInsetOffsetY(view, 0);
            }
            if ((r11 & 3) != 3 || (i3 = (acquireTempRect.left - ((ViewGroup.MarginLayoutParams) r0).leftMargin) - r0.f1102) >= (i4 = rect.left)) {
                z2 = false;
            } else {
                setInsetOffsetX(view, i4 - i3);
                z2 = true;
            }
            if ((r11 & 5) == 5 && (width = ((getWidth() - acquireTempRect.right) - ((ViewGroup.MarginLayoutParams) r0).rightMargin) + r0.f1102) < (i2 = rect.right)) {
                setInsetOffsetX(view, width - i2);
                z2 = true;
            }
            if (!z2) {
                setInsetOffsetX(view, 0);
            }
            releaseTempRect(acquireTempRect);
        }
    }

    /* JADX DEBUG: Multi-variable search result rejected for r1v4, resolved type: java.lang.Class<?> */
    /* JADX WARN: Multi-variable type inference failed */
    public static AbstractC0144 parseBehavior(Context context, AttributeSet attributeSet, String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        if (str.startsWith(CodelessMatcher.CURRENT_CLASS_NAME)) {
            str = context.getPackageName() + str;
        } else if (str.indexOf(46) < 0 && !TextUtils.isEmpty(WIDGET_PACKAGE_NAME)) {
            str = WIDGET_PACKAGE_NAME + '.' + str;
        }
        try {
            Map<String, Constructor<AbstractC0144>> map = sConstructors.get();
            if (map == null) {
                map = new HashMap<>();
                sConstructors.set(map);
            }
            Constructor<AbstractC0144> constructor = map.get(str);
            if (constructor == null) {
                constructor = Class.forName(str, false, context.getClassLoader()).getConstructor(CONSTRUCTOR_PARAMS);
                constructor.setAccessible(true);
                map.put(str, constructor);
            }
            return constructor.newInstance(context, attributeSet);
        } catch (Exception e) {
            throw new RuntimeException(C1293.m3412("Could not inflate Behavior subclass ", str), e);
        }
    }

    private boolean performIntercept(MotionEvent motionEvent, int i) {
        boolean z;
        int actionMasked = motionEvent.getActionMasked();
        List<View> list = this.mTempList1;
        getTopSortedChildren(list);
        int size = list.size();
        MotionEvent motionEvent2 = null;
        boolean z2 = false;
        boolean z3 = false;
        for (int i2 = 0; i2 < size; i2++) {
            View view = list.get(i2);
            C0149 r12 = (C0149) view.getLayoutParams();
            AbstractC0144 r13 = r12.f1105;
            boolean z4 = true;
            if (!(z2 || z3) || actionMasked == 0) {
                if (!z2 && r13 != null) {
                    if (i == 0) {
                        z2 = r13.onInterceptTouchEvent(this, view, motionEvent);
                    } else if (i == 1) {
                        z2 = r13.onTouchEvent(this, view, motionEvent);
                    }
                    if (z2) {
                        this.mBehaviorTouchView = view;
                    }
                }
                if (r12.f1105 == null) {
                    r12.f1113 = false;
                }
                boolean z5 = r12.f1113;
                if (z5) {
                    z = true;
                } else {
                    AbstractC0144 r132 = r12.f1105;
                    z = (r132 != null ? r132.blocksInteractionBelow(this, view) : false) | z5;
                    r12.f1113 = z;
                }
                if (!z || z5) {
                    z4 = false;
                }
                if (z && !z4) {
                    break;
                }
                z3 = z4;
            } else if (r13 != null) {
                if (motionEvent2 == null) {
                    long uptimeMillis = SystemClock.uptimeMillis();
                    motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                }
                if (i == 0) {
                    r13.onInterceptTouchEvent(this, view, motionEvent2);
                } else if (i == 1) {
                    r13.onTouchEvent(this, view, motionEvent2);
                }
            }
        }
        list.clear();
        return z2;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:26:0x0073, code lost:
        if (r5 != false) goto L_0x00cc;
     */
    /* JADX WARNING: Removed duplicated region for block: B:126:0x016c A[SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:72:0x0112  */
    private void prepareChildren() {
        boolean z;
        AbstractC0144 r8;
        boolean z2;
        this.mDependencySortedChildren.clear();
        C2298<View> k = this.mChildDag;
        int i = k.f7952.f7909;
        for (int i2 = 0; i2 < i; i2++) {
            ArrayList<T> r4 = k.f7952.m5973(i2);
            if (r4 != null) {
                r4.clear();
                k.f7953.m4836(r4);
            }
        }
        k.f7952.clear();
        int childCount = getChildCount();
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            C0149 resolvedLayoutParams = getResolvedLayoutParams(childAt);
            if (resolvedLayoutParams.f1110 == -1) {
                resolvedLayoutParams.f1106 = null;
                resolvedLayoutParams.f1101 = null;
            } else {
                View view = resolvedLayoutParams.f1101;
                if (view != null) {
                    if (view.getId() == resolvedLayoutParams.f1110) {
                        View view2 = resolvedLayoutParams.f1101;
                        for (ViewParent parent = view2.getParent(); parent != this; parent = parent.getParent()) {
                            if (parent == null || parent == childAt) {
                                resolvedLayoutParams.f1106 = null;
                                resolvedLayoutParams.f1101 = null;
                            } else {
                                if (parent instanceof View) {
                                    view2 = (View) parent;
                                }
                            }
                        }
                        resolvedLayoutParams.f1106 = view2;
                        z2 = true;
                    }
                    z2 = false;
                    break;
                }
                resolvedLayoutParams.f1101 = findViewById(resolvedLayoutParams.f1110);
                View view3 = resolvedLayoutParams.f1101;
                if (view3 != null) {
                    if (view3 != this) {
                        ViewParent parent2 = view3.getParent();
                        while (true) {
                            if (parent2 == this || parent2 == null) {
                                resolvedLayoutParams.f1106 = view3;
                            } else if (parent2 != childAt) {
                                if (parent2 instanceof View) {
                                    view3 = (View) parent2;
                                }
                                parent2 = parent2.getParent();
                            } else if (isInEditMode()) {
                                resolvedLayoutParams.f1106 = null;
                                resolvedLayoutParams.f1101 = null;
                            } else {
                                throw new IllegalStateException("Anchor must not be a descendant of the anchored view");
                            }
                        }
                    } else if (isInEditMode()) {
                        resolvedLayoutParams.f1106 = null;
                        resolvedLayoutParams.f1101 = null;
                    } else {
                        throw new IllegalStateException("View can not be anchored to the the parent CoordinatorLayout");
                    }
                } else if (isInEditMode()) {
                    resolvedLayoutParams.f1106 = null;
                    resolvedLayoutParams.f1101 = null;
                } else {
                    StringBuilder r1 = C1293.m3416("Could not find CoordinatorLayout descendant view with id ");
                    r1.append(getResources().getResourceName(resolvedLayoutParams.f1110));
                    r1.append(" to anchor view ");
                    r1.append(childAt);
                    throw new IllegalStateException(r1.toString());
                }
                View view4 = resolvedLayoutParams.f1101;
            }
            this.mChildDag.m5993(childAt);
            for (int i4 = 0; i4 < childCount; i4++) {
                if (i4 != i3) {
                    View childAt2 = getChildAt(i4);
                    if (childAt2 != resolvedLayoutParams.f1106) {
                        int r82 = C1729.m4511(this);
                        int r9 = C2369.m6293(((C0149) childAt2.getLayoutParams()).f1104, r82);
                        if (!(r9 != 0 && (C2369.m6293(resolvedLayoutParams.f1112, r82) & r9) == r9) && ((r8 = resolvedLayoutParams.f1105) == null || !r8.layoutDependsOn(this, childAt, childAt2))) {
                            z = false;
                            if (!z) {
                                continue;
                            } else {
                                if (!(this.mChildDag.f7952.m5977(childAt2) >= 0)) {
                                    this.mChildDag.m5993(childAt2);
                                }
                                C2298<View> k2 = this.mChildDag;
                                if (k2.f7952.m5977(childAt2) >= 0) {
                                    if (k2.f7952.m5977(childAt) >= 0) {
                                        ArrayList<T> orDefault = k2.f7952.getOrDefault(childAt2, null);
                                        if (orDefault == null) {
                                            orDefault = k2.f7953.m4835();
                                            if (orDefault == null) {
                                                orDefault = new ArrayList<>();
                                            }
                                            k2.f7952.put(childAt2, orDefault);
                                        }
                                        orDefault.add(childAt);
                                    }
                                }
                                throw new IllegalArgumentException("All nodes must be present in the graph before being added as an edge");
                            }
                        }
                    }
                    z = true;
                    if (!z) {
                    }
                }
            }
        }
        List<View> list = this.mDependencySortedChildren;
        C2298<View> k3 = this.mChildDag;
        k3.f7951.clear();
        k3.f7954.clear();
        int i5 = k3.f7952.f7909;
        for (int i6 = 0; i6 < i5; i6++) {
            k3.m5994(k3.f7952.m5972(i6), k3.f7951, k3.f7954);
        }
        list.addAll(k3.f7951);
        Collections.reverse(this.mDependencySortedChildren);
    }

    public static void releaseTempRect(Rect rect) {
        rect.setEmpty();
        sRectPool.m4836(rect);
    }

    private void resetTouchBehaviors(boolean z) {
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            AbstractC0144 r4 = ((C0149) childAt.getLayoutParams()).f1105;
            if (r4 != null) {
                long uptimeMillis = SystemClock.uptimeMillis();
                MotionEvent obtain = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                if (z) {
                    r4.onInterceptTouchEvent(this, childAt, obtain);
                } else {
                    r4.onTouchEvent(this, childAt, obtain);
                }
                obtain.recycle();
            }
        }
        for (int i2 = 0; i2 < childCount; i2++) {
            ((C0149) getChildAt(i2).getLayoutParams()).f1113 = false;
        }
        this.mBehaviorTouchView = null;
        this.mDisallowInterceptReset = false;
    }

    public static int resolveAnchoredChildGravity(int i) {
        if (i == 0) {
            return 17;
        }
        return i;
    }

    public static int resolveGravity(int i) {
        if ((i & 7) == 0) {
            i |= 8388611;
        }
        return (i & 112) == 0 ? i | 48 : i;
    }

    public static int resolveKeylineGravity(int i) {
        return i == 0 ? BadgeDrawable.TOP_END : i;
    }

    private void setInsetOffsetX(View view, int i) {
        C0149 r0 = (C0149) view.getLayoutParams();
        int i2 = r0.f1102;
        if (i2 != i) {
            C1729.m4447(view, i - i2);
            r0.f1102 = i;
        }
    }

    private void setInsetOffsetY(View view, int i) {
        C0149 r0 = (C0149) view.getLayoutParams();
        int i2 = r0.f1109;
        if (i2 != i) {
            C1729.m4503(view, i - i2);
            r0.f1109 = i;
        }
    }

    private void setupForInsets() {
        int i = Build.VERSION.SDK_INT;
        if (C1729.m4500(this)) {
            if (this.mApplyWindowInsetsListener == null) {
                this.mApplyWindowInsetsListener = new C0148();
            }
            C1729.m4484(this, this.mApplyWindowInsetsListener);
            setSystemUiVisibility(WebDialog.MAX_PADDING_SCREEN_HEIGHT);
            return;
        }
        C1729.m4484(this, (AbstractC1777) null);
    }

    public void addPreDrawListener() {
        if (this.mIsAttachedToWindow) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new ViewTreeObserver$OnPreDrawListenerC0147();
            }
            getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = true;
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return (layoutParams instanceof C0149) && super.checkLayoutParams(layoutParams);
    }

    public void dispatchDependentViewsChanged(View view) {
        ArrayList<T> orDefault = this.mChildDag.f7952.getOrDefault(view, null);
        if (!(orDefault == null || orDefault.isEmpty())) {
            for (int i = 0; i < orDefault.size(); i++) {
                T t = orDefault.get(i);
                AbstractC0144 r3 = ((C0149) t.getLayoutParams()).f1105;
                if (r3 != null) {
                    r3.onDependentViewChanged(this, t, view);
                }
            }
        }
    }

    public boolean doViewsOverlap(View view, View view2) {
        boolean z = false;
        if (view.getVisibility() != 0 || view2.getVisibility() != 0) {
            return false;
        }
        Rect acquireTempRect = acquireTempRect();
        getChildRect(view, view.getParent() != this, acquireTempRect);
        Rect acquireTempRect2 = acquireTempRect();
        getChildRect(view2, view2.getParent() != this, acquireTempRect2);
        try {
            if (acquireTempRect.left <= acquireTempRect2.right && acquireTempRect.top <= acquireTempRect2.bottom && acquireTempRect.right >= acquireTempRect2.left && acquireTempRect.bottom >= acquireTempRect2.top) {
                z = true;
            }
            return z;
        } finally {
            releaseTempRect(acquireTempRect);
            releaseTempRect(acquireTempRect2);
        }
    }

    public boolean drawChild(Canvas canvas, View view, long j) {
        C0149 r0 = (C0149) view.getLayoutParams();
        AbstractC0144 r1 = r0.f1105;
        if (r1 != null) {
            float scrimOpacity = r1.getScrimOpacity(this, view);
            if (scrimOpacity > 0.0f) {
                if (this.mScrimPaint == null) {
                    this.mScrimPaint = new Paint();
                }
                this.mScrimPaint.setColor(r0.f1105.getScrimColor(this, view));
                this.mScrimPaint.setAlpha(clamp(Math.round(scrimOpacity * 255.0f), 0, BaseProgressIndicator.MAX_ALPHA));
                int save = canvas.save();
                if (view.isOpaque()) {
                    canvas.clipRect((float) view.getLeft(), (float) view.getTop(), (float) view.getRight(), (float) view.getBottom(), Region.Op.DIFFERENCE);
                }
                canvas.drawRect((float) getPaddingLeft(), (float) getPaddingTop(), (float) (getWidth() - getPaddingRight()), (float) (getHeight() - getPaddingBottom()), this.mScrimPaint);
                canvas.restoreToCount(save);
            }
        }
        return super.drawChild(canvas, view, j);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        int[] drawableState = getDrawableState();
        Drawable drawable = this.mStatusBarBackground;
        boolean z = false;
        if (drawable != null && drawable.isStateful()) {
            z = false | drawable.setState(drawableState);
        }
        if (z) {
            invalidate();
        }
    }

    public void ensurePreDrawListener() {
        int childCount = getChildCount();
        boolean z = false;
        int i = 0;
        while (true) {
            if (i >= childCount) {
                break;
            } else if (hasDependencies(getChildAt(i))) {
                z = true;
                break;
            } else {
                i++;
            }
        }
        if (z == this.mNeedsPreDrawListener) {
            return;
        }
        if (z) {
            addPreDrawListener();
        } else {
            removePreDrawListener();
        }
    }

    public void getChildRect(View view, boolean z, Rect rect) {
        if (view.isLayoutRequested() || view.getVisibility() == 8) {
            rect.setEmpty();
        } else if (z) {
            getDescendantRect(view, rect);
        } else {
            rect.set(view.getLeft(), view.getTop(), view.getRight(), view.getBottom());
        }
    }

    public List<View> getDependencies(View view) {
        C2298<View> k = this.mChildDag;
        int i = k.f7952.f7909;
        ArrayList arrayList = null;
        for (int i2 = 0; i2 < i; i2++) {
            ArrayList<T> r4 = k.f7952.m5973(i2);
            if (r4 != null && r4.contains(view)) {
                if (arrayList == null) {
                    arrayList = new ArrayList();
                }
                arrayList.add(k.f7952.m5972(i2));
            }
        }
        this.mTempDependenciesList.clear();
        if (arrayList != null) {
            this.mTempDependenciesList.addAll(arrayList);
        }
        return this.mTempDependenciesList;
    }

    public final List<View> getDependencySortedChildren() {
        prepareChildren();
        return Collections.unmodifiableList(this.mDependencySortedChildren);
    }

    public List<View> getDependents(View view) {
        ArrayList<T> orDefault = this.mChildDag.f7952.getOrDefault(view, null);
        this.mTempDependenciesList.clear();
        if (orDefault != null) {
            this.mTempDependenciesList.addAll(orDefault);
        }
        return this.mTempDependenciesList;
    }

    public void getDescendantRect(View view, Rect rect) {
        C2297.m5991(this, view, rect);
    }

    public void getDesiredAnchoredChildRect(View view, int i, Rect rect, Rect rect2) {
        C0149 r0 = (C0149) view.getLayoutParams();
        int measuredWidth = view.getMeasuredWidth();
        int measuredHeight = view.getMeasuredHeight();
        getDesiredAnchoredChildRectWithoutConstraints(view, i, rect, rect2, r0, measuredWidth, measuredHeight);
        constrainChildRect(r0, rect2, measuredWidth, measuredHeight);
    }

    public void getLastChildRect(View view, Rect rect) {
        rect.set(((C0149) view.getLayoutParams()).f1100);
    }

    public final C1754 getLastWindowInsets() {
        return this.mLastInsets;
    }

    public int getNestedScrollAxes() {
        return this.mNestedScrollingParentHelper.m4547();
    }

    public C0149 getResolvedLayoutParams(View view) {
        C0149 r0 = (C0149) view.getLayoutParams();
        if (!r0.f1103) {
            if (view instanceof AbstractC0146) {
                AbstractC0144 behavior = ((AbstractC0146) view).getBehavior();
                if (behavior == null) {
                    Log.e(TAG, "Attached behavior class is null");
                }
                r0.m576(behavior);
                r0.f1103 = true;
            } else {
                AbstractC0150 r1 = null;
                for (Class<?> cls = view.getClass(); cls != null; cls = cls.getSuperclass()) {
                    r1 = (AbstractC0150) cls.getAnnotation(AbstractC0150.class);
                    if (r1 != null) {
                        break;
                    }
                }
                if (r1 != null) {
                    try {
                        r0.m576((AbstractC0144) r1.value().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
                    } catch (Exception e) {
                        StringBuilder r4 = C1293.m3416("Default behavior class ");
                        r4.append(r1.value().getName());
                        r4.append(" could not be instantiated. Did you forget a default constructor?");
                        Log.e(TAG, r4.toString(), e);
                    }
                }
                r0.f1103 = true;
            }
        }
        return r0;
    }

    public Drawable getStatusBarBackground() {
        return this.mStatusBarBackground;
    }

    public int getSuggestedMinimumHeight() {
        return Math.max(super.getSuggestedMinimumHeight(), getPaddingBottom() + getPaddingTop());
    }

    public int getSuggestedMinimumWidth() {
        return Math.max(super.getSuggestedMinimumWidth(), getPaddingRight() + getPaddingLeft());
    }

    public boolean isPointInChildBounds(View view, int i, int i2) {
        Rect acquireTempRect = acquireTempRect();
        getDescendantRect(view, acquireTempRect);
        try {
            return acquireTempRect.contains(i, i2);
        } finally {
            releaseTempRect(acquireTempRect);
        }
    }

    public void offsetChildToAnchor(View view, int i) {
        AbstractC0144 r0;
        C0149 r10 = (C0149) view.getLayoutParams();
        if (r10.f1101 != null) {
            Rect acquireTempRect = acquireTempRect();
            Rect acquireTempRect2 = acquireTempRect();
            Rect acquireTempRect3 = acquireTempRect();
            getDescendantRect(r10.f1101, acquireTempRect);
            boolean z = false;
            getChildRect(view, false, acquireTempRect2);
            int measuredWidth = view.getMeasuredWidth();
            int measuredHeight = view.getMeasuredHeight();
            getDesiredAnchoredChildRectWithoutConstraints(view, i, acquireTempRect, acquireTempRect3, r10, measuredWidth, measuredHeight);
            if (!(acquireTempRect3.left == acquireTempRect2.left && acquireTempRect3.top == acquireTempRect2.top)) {
                z = true;
            }
            constrainChildRect(r10, acquireTempRect3, measuredWidth, measuredHeight);
            int i2 = acquireTempRect3.left - acquireTempRect2.left;
            int i3 = acquireTempRect3.top - acquireTempRect2.top;
            if (i2 != 0) {
                C1729.m4447(view, i2);
            }
            if (i3 != 0) {
                C1729.m4503(view, i3);
            }
            if (z && (r0 = r10.f1105) != null) {
                r0.onDependentViewChanged(this, view, r10.f1101);
            }
            releaseTempRect(acquireTempRect);
            releaseTempRect(acquireTempRect2);
            releaseTempRect(acquireTempRect3);
        }
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener) {
            if (this.mOnPreDrawListener == null) {
                this.mOnPreDrawListener = new ViewTreeObserver$OnPreDrawListenerC0147();
            }
            getViewTreeObserver().addOnPreDrawListener(this.mOnPreDrawListener);
        }
        if (this.mLastInsets == null && C1729.m4500(this)) {
            int i = Build.VERSION.SDK_INT;
            requestApplyInsets();
        }
        this.mIsAttachedToWindow = true;
    }

    public final void onChildViewsChanged(int i) {
        boolean z;
        int r2 = C1729.m4511(this);
        int size = this.mDependencySortedChildren.size();
        Rect acquireTempRect = acquireTempRect();
        Rect acquireTempRect2 = acquireTempRect();
        Rect acquireTempRect3 = acquireTempRect();
        for (int i2 = 0; i2 < size; i2++) {
            View view = this.mDependencySortedChildren.get(i2);
            C0149 r10 = (C0149) view.getLayoutParams();
            if (i != 0 || view.getVisibility() != 8) {
                for (int i3 = 0; i3 < i2; i3++) {
                    if (r10.f1106 == this.mDependencySortedChildren.get(i3)) {
                        offsetChildToAnchor(view, r2);
                    }
                }
                getChildRect(view, true, acquireTempRect2);
                if (r10.f1104 != 0 && !acquireTempRect2.isEmpty()) {
                    int r12 = C2369.m6293(r10.f1104, r2);
                    int i4 = r12 & 112;
                    if (i4 == 48) {
                        acquireTempRect.top = Math.max(acquireTempRect.top, acquireTempRect2.bottom);
                    } else if (i4 == 80) {
                        acquireTempRect.bottom = Math.max(acquireTempRect.bottom, getHeight() - acquireTempRect2.top);
                    }
                    int i5 = r12 & 7;
                    if (i5 == 3) {
                        acquireTempRect.left = Math.max(acquireTempRect.left, acquireTempRect2.right);
                    } else if (i5 == 5) {
                        acquireTempRect.right = Math.max(acquireTempRect.right, getWidth() - acquireTempRect2.left);
                    }
                }
                if (r10.f1112 != 0 && view.getVisibility() == 0) {
                    offsetChildByInset(view, acquireTempRect, r2);
                }
                if (i != 2) {
                    getLastChildRect(view, acquireTempRect3);
                    if (!acquireTempRect3.equals(acquireTempRect2)) {
                        recordLastChildRect(view, acquireTempRect2);
                    }
                }
                for (int i6 = i2 + 1; i6 < size; i6++) {
                    View view2 = this.mDependencySortedChildren.get(i6);
                    C0149 r14 = (C0149) view2.getLayoutParams();
                    AbstractC0144 r15 = r14.f1105;
                    if (r15 != null && r15.layoutDependsOn(this, view2, view)) {
                        if (i != 0 || !r14.f1098) {
                            if (i != 2) {
                                z = r15.onDependentViewChanged(this, view2, view);
                            } else {
                                r15.onDependentViewRemoved(this, view2, view);
                                z = true;
                            }
                            if (i == 1) {
                                r14.f1098 = z;
                            }
                        } else {
                            r14.f1098 = false;
                        }
                    }
                }
            }
        }
        releaseTempRect(acquireTempRect);
        releaseTempRect(acquireTempRect2);
        releaseTempRect(acquireTempRect3);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        resetTouchBehaviors(false);
        if (this.mNeedsPreDrawListener && this.mOnPreDrawListener != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        View view = this.mNestedScrollingTarget;
        if (view != null) {
            onStopNestedScroll(view);
        }
        this.mIsAttachedToWindow = false;
    }

    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawStatusBarBackground && this.mStatusBarBackground != null) {
            C1754 r0 = this.mLastInsets;
            int r02 = r0 != null ? r0.m4557() : 0;
            if (r02 > 0) {
                this.mStatusBarBackground.setBounds(0, 0, getWidth(), r02);
                this.mStatusBarBackground.draw(canvas);
            }
        }
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            resetTouchBehaviors(true);
        }
        boolean performIntercept = performIntercept(motionEvent, 0);
        if (actionMasked == 1 || actionMasked == 3) {
            resetTouchBehaviors(true);
        }
        return performIntercept;
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        AbstractC0144 r6;
        int r2 = C1729.m4511(this);
        int size = this.mDependencySortedChildren.size();
        for (int i5 = 0; i5 < size; i5++) {
            View view = this.mDependencySortedChildren.get(i5);
            if (view.getVisibility() != 8 && ((r6 = ((C0149) view.getLayoutParams()).f1105) == null || !r6.onLayoutChild(this, view, r2))) {
                onLayoutChild(view, r2);
            }
        }
    }

    public void onLayoutChild(View view, int i) {
        C0149 r0 = (C0149) view.getLayoutParams();
        if (!(r0.f1101 == null && r0.f1110 != -1)) {
            View view2 = r0.f1101;
            if (view2 != null) {
                layoutChildWithAnchor(view, view2, i);
                return;
            }
            int i2 = r0.f1099;
            if (i2 >= 0) {
                layoutChildWithKeyline(view, i2, i);
            } else {
                layoutChild(view, i);
            }
        } else {
            throw new IllegalStateException("An anchor may not be changed after CoordinatorLayout measurement begins before layout is complete.");
        }
    }

    /* JADX WARNING: Code restructure failed: missing block: B:41:0x0115, code lost:
        if (r0.onMeasureChild(r30, r20, r11, r21, r23, 0) == false) goto L_0x0124;
     */
    /* JADX WARNING: Removed duplicated region for block: B:34:0x00bf  */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x00f7  */
    /* JADX WARNING: Removed duplicated region for block: B:42:0x0118  */
    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        AbstractC0144 r0;
        int i9;
        int i10;
        C0149 r26;
        int i11;
        prepareChildren();
        ensurePreDrawListener();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        int paddingRight = getPaddingRight();
        int paddingBottom = getPaddingBottom();
        int r10 = C1729.m4511(this);
        boolean z = r10 == 1;
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        int size2 = View.MeasureSpec.getSize(i2);
        int i12 = paddingLeft + paddingRight;
        int i13 = paddingTop + paddingBottom;
        int suggestedMinimumWidth = getSuggestedMinimumWidth();
        int suggestedMinimumHeight = getSuggestedMinimumHeight();
        boolean z2 = this.mLastInsets != null && C1729.m4500(this);
        int size3 = this.mDependencySortedChildren.size();
        int i14 = suggestedMinimumWidth;
        int i15 = suggestedMinimumHeight;
        int i16 = 0;
        int i17 = 0;
        while (i17 < size3) {
            View view = this.mDependencySortedChildren.get(i17);
            if (view.getVisibility() == 8) {
                i4 = i17;
                i3 = size3;
            } else {
                C0149 r1 = (C0149) view.getLayoutParams();
                int i18 = r1.f1099;
                if (i18 < 0 || mode == 0) {
                    i5 = i15;
                } else {
                    int keyline = getKeyline(i18);
                    int r11 = C2369.m6293(resolveKeylineGravity(r1.f1096), r10) & 7;
                    i5 = i15;
                    if ((r11 == 3 && !z) || (r11 == 5 && z)) {
                        i6 = Math.max(0, (size - paddingRight) - keyline);
                        if (z2) {
                        }
                        i8 = i;
                        i7 = i2;
                        r0 = r1.f1105;
                        if (r0 != null) {
                        }
                        onMeasureChild(view, i8, i6, i7, 0);
                        int max = Math.max(i9, view.getMeasuredWidth() + i12 + ((ViewGroup.MarginLayoutParams) r26).leftMargin + ((ViewGroup.MarginLayoutParams) r26).rightMargin);
                        int max2 = Math.max(i11, view.getMeasuredHeight() + i13 + ((ViewGroup.MarginLayoutParams) r26).topMargin + ((ViewGroup.MarginLayoutParams) r26).bottomMargin);
                        i14 = max;
                        i16 = View.combineMeasuredStates(i10, view.getMeasuredState());
                        i15 = max2;
                    } else if ((r11 == 5 && !z) || (r11 == 3 && z)) {
                        i6 = Math.max(0, keyline - paddingLeft);
                        if (z2 || C1729.m4500(view)) {
                            i8 = i;
                            i7 = i2;
                        } else {
                            int r2 = this.mLastInsets.m4563() + this.mLastInsets.m4556();
                            int r112 = this.mLastInsets.m4558() + this.mLastInsets.m4557();
                            i8 = View.MeasureSpec.makeMeasureSpec(size - r2, mode);
                            i7 = View.MeasureSpec.makeMeasureSpec(size2 - r112, mode2);
                        }
                        r0 = r1.f1105;
                        if (r0 != null) {
                            r26 = r1;
                            i11 = i5;
                            i10 = i16;
                            i9 = i14;
                            i4 = i17;
                            i3 = size3;
                        } else {
                            r26 = r1;
                            i10 = i16;
                            i9 = i14;
                            i3 = size3;
                            i11 = i5;
                            i4 = i17;
                        }
                        onMeasureChild(view, i8, i6, i7, 0);
                        int max3 = Math.max(i9, view.getMeasuredWidth() + i12 + ((ViewGroup.MarginLayoutParams) r26).leftMargin + ((ViewGroup.MarginLayoutParams) r26).rightMargin);
                        int max22 = Math.max(i11, view.getMeasuredHeight() + i13 + ((ViewGroup.MarginLayoutParams) r26).topMargin + ((ViewGroup.MarginLayoutParams) r26).bottomMargin);
                        i14 = max3;
                        i16 = View.combineMeasuredStates(i10, view.getMeasuredState());
                        i15 = max22;
                    }
                }
                i6 = 0;
                if (z2) {
                }
                i8 = i;
                i7 = i2;
                r0 = r1.f1105;
                if (r0 != null) {
                }
                onMeasureChild(view, i8, i6, i7, 0);
                int max32 = Math.max(i9, view.getMeasuredWidth() + i12 + ((ViewGroup.MarginLayoutParams) r26).leftMargin + ((ViewGroup.MarginLayoutParams) r26).rightMargin);
                int max222 = Math.max(i11, view.getMeasuredHeight() + i13 + ((ViewGroup.MarginLayoutParams) r26).topMargin + ((ViewGroup.MarginLayoutParams) r26).bottomMargin);
                i14 = max32;
                i16 = View.combineMeasuredStates(i10, view.getMeasuredState());
                i15 = max222;
            }
            i17 = i4 + 1;
            size3 = i3;
        }
        setMeasuredDimension(View.resolveSizeAndState(i14, i, -16777216 & i16), View.resolveSizeAndState(i15, i2, i16 << 16));
    }

    public void onMeasureChild(View view, int i, int i2, int i3, int i4) {
        measureChildWithMargins(view, i, i2, i3, i4);
    }

    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        AbstractC0144 r4;
        int childCount = getChildCount();
        boolean z2 = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                C0149 r42 = (C0149) childAt.getLayoutParams();
                if (r42.m577(0) && (r4 = r42.f1105) != null) {
                    z2 |= r4.onNestedFling(this, childAt, view, f, f2, z);
                }
            }
        }
        if (z2) {
            onChildViewsChanged(1);
        }
        return z2;
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        AbstractC0144 r4;
        int childCount = getChildCount();
        boolean z = false;
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (childAt.getVisibility() != 8) {
                C0149 r42 = (C0149) childAt.getLayoutParams();
                if (r42.m577(0) && (r4 = r42.f1105) != null) {
                    z |= r4.onNestedPreFling(this, childAt, view, f, f2);
                }
            }
        }
        return z;
    }

    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
        onNestedPreScroll(view, i, i2, iArr, 0);
    }

    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        onNestedScroll(view, i, i2, i3, i4, 0);
    }

    public void onNestedScrollAccepted(View view, View view2, int i) {
        onNestedScrollAccepted(view, view2, i, 0);
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        Parcelable parcelable2;
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        SparseArray<Parcelable> sparseArray = savedState.f1092;
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            AbstractC0144 r4 = getResolvedLayoutParams(childAt).f1105;
            if (!(id == -1 || r4 == null || (parcelable2 = sparseArray.get(id)) == null)) {
                r4.onRestoreInstanceState(this, childAt, parcelable2);
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        Parcelable onSaveInstanceState;
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        SparseArray<Parcelable> sparseArray = new SparseArray<>();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            int id = childAt.getId();
            AbstractC0144 r6 = ((C0149) childAt.getLayoutParams()).f1105;
            if (!(id == -1 || r6 == null || (onSaveInstanceState = r6.onSaveInstanceState(this, childAt)) == null)) {
                sparseArray.append(id, onSaveInstanceState);
            }
        }
        savedState.f1092 = sparseArray;
        return savedState;
    }

    public boolean onStartNestedScroll(View view, View view2, int i) {
        return onStartNestedScroll(view, view2, i, 0);
    }

    public void onStopNestedScroll(View view) {
        onStopNestedScroll(view, 0);
    }

    /* JADX WARNING: Code restructure failed: missing block: B:3:0x0012, code lost:
        if (r3 != false) goto L_0x0016;
     */
    /* JADX WARNING: Removed duplicated region for block: B:11:0x002f  */
    /* JADX WARNING: Removed duplicated region for block: B:12:0x0035  */
    /* JADX WARNING: Removed duplicated region for block: B:15:0x004a  */
    public boolean onTouchEvent(MotionEvent motionEvent) {
        boolean z;
        boolean z2;
        MotionEvent motionEvent2;
        int actionMasked = motionEvent.getActionMasked();
        if (this.mBehaviorTouchView == null) {
            z2 = performIntercept(motionEvent, 1);
        } else {
            z2 = false;
        }
        AbstractC0144 r6 = ((C0149) this.mBehaviorTouchView.getLayoutParams()).f1105;
        if (r6 != null) {
            z = r6.onTouchEvent(this, this.mBehaviorTouchView, motionEvent);
            motionEvent2 = null;
            if (this.mBehaviorTouchView != null) {
                z |= super.onTouchEvent(motionEvent);
            } else if (z2) {
                long uptimeMillis = SystemClock.uptimeMillis();
                motionEvent2 = MotionEvent.obtain(uptimeMillis, uptimeMillis, 3, 0.0f, 0.0f, 0);
                super.onTouchEvent(motionEvent2);
            }
            if (motionEvent2 != null) {
                motionEvent2.recycle();
            }
            if (actionMasked == 1 || actionMasked == 3) {
                resetTouchBehaviors(false);
            }
            return z;
        }
        z = false;
        motionEvent2 = null;
        if (this.mBehaviorTouchView != null) {
        }
        if (motionEvent2 != null) {
        }
        resetTouchBehaviors(false);
        return z;
    }

    public void recordLastChildRect(View view, Rect rect) {
        ((C0149) view.getLayoutParams()).f1100.set(rect);
    }

    public void removePreDrawListener() {
        if (this.mIsAttachedToWindow && this.mOnPreDrawListener != null) {
            getViewTreeObserver().removeOnPreDrawListener(this.mOnPreDrawListener);
        }
        this.mNeedsPreDrawListener = false;
    }

    public boolean requestChildRectangleOnScreen(View view, Rect rect, boolean z) {
        AbstractC0144 r0 = ((C0149) view.getLayoutParams()).f1105;
        if (r0 == null || !r0.onRequestChildRectangleOnScreen(this, view, rect, z)) {
            return super.requestChildRectangleOnScreen(view, rect, z);
        }
        return true;
    }

    public void requestDisallowInterceptTouchEvent(boolean z) {
        super.requestDisallowInterceptTouchEvent(z);
        if (z && !this.mDisallowInterceptReset) {
            resetTouchBehaviors(false);
            this.mDisallowInterceptReset = true;
        }
    }

    public void setFitsSystemWindows(boolean z) {
        super.setFitsSystemWindows(z);
        setupForInsets();
    }

    public void setOnHierarchyChangeListener(ViewGroup.OnHierarchyChangeListener onHierarchyChangeListener) {
        this.mOnHierarchyChangeListener = onHierarchyChangeListener;
    }

    public void setStatusBarBackground(Drawable drawable) {
        Drawable drawable2 = this.mStatusBarBackground;
        if (drawable2 != drawable) {
            Drawable drawable3 = null;
            if (drawable2 != null) {
                drawable2.setCallback(null);
            }
            if (drawable != null) {
                drawable3 = drawable.mutate();
            }
            this.mStatusBarBackground = drawable3;
            Drawable drawable4 = this.mStatusBarBackground;
            if (drawable4 != null) {
                if (drawable4.isStateful()) {
                    this.mStatusBarBackground.setState(getDrawableState());
                }
                C2369.m6340(this.mStatusBarBackground, C1729.m4511(this));
                this.mStatusBarBackground.setVisible(getVisibility() == 0, false);
                this.mStatusBarBackground.setCallback(this);
            }
            C1729.m4449(this);
        }
    }

    public void setStatusBarBackgroundColor(int i) {
        setStatusBarBackground(new ColorDrawable(i));
    }

    public void setStatusBarBackgroundResource(int i) {
        setStatusBarBackground(i != 0 ? C1806.m4683(getContext(), i) : null);
    }

    public void setVisibility(int i) {
        super.setVisibility(i);
        boolean z = i == 0;
        Drawable drawable = this.mStatusBarBackground;
        if (drawable != null && drawable.isVisible() != z) {
            this.mStatusBarBackground.setVisible(z, false);
        }
    }

    public final C1754 setWindowInsets(C1754 r4) {
        if (C2369.m6287(this.mLastInsets, r4)) {
            return r4;
        }
        this.mLastInsets = r4;
        boolean z = true;
        this.mDrawStatusBarBackground = r4 != null && r4.m4557() > 0;
        if (this.mDrawStatusBarBackground || getBackground() != null) {
            z = false;
        }
        setWillNotDraw(z);
        C1754 dispatchApplyWindowInsetsToBehaviors = dispatchApplyWindowInsetsToBehaviors(r4);
        requestLayout();
        return dispatchApplyWindowInsetsToBehaviors;
    }

    public boolean verifyDrawable(Drawable drawable) {
        return super.verifyDrawable(drawable) || drawable == this.mStatusBarBackground;
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.coordinatorLayoutStyle);
    }

    public C0149 generateDefaultLayoutParams() {
        return new C0149(-2, -2);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr, int i3) {
        AbstractC0144 r1;
        int i4;
        int i5;
        int childCount = getChildCount();
        boolean z = false;
        int i6 = 0;
        int i7 = 0;
        for (int i8 = 0; i8 < childCount; i8++) {
            View childAt = getChildAt(i8);
            if (childAt.getVisibility() != 8) {
                C0149 r12 = (C0149) childAt.getLayoutParams();
                if (r12.m577(i3) && (r1 = r12.f1105) != null) {
                    int[] iArr2 = this.mBehaviorConsumed;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    r1.onNestedPreScroll(this, childAt, view, i, i2, iArr2, i3);
                    int[] iArr3 = this.mBehaviorConsumed;
                    if (i > 0) {
                        i4 = Math.max(i6, iArr3[0]);
                    } else {
                        i4 = Math.min(i6, iArr3[0]);
                    }
                    int[] iArr4 = this.mBehaviorConsumed;
                    if (i2 > 0) {
                        i5 = Math.max(i7, iArr4[1]);
                    } else {
                        i5 = Math.min(i7, iArr4[1]);
                    }
                    i6 = i4;
                    i7 = i5;
                    z = true;
                }
            }
        }
        iArr[0] = i6;
        iArr[1] = i7;
        if (z) {
            onChildViewsChanged(1);
        }
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5) {
        onNestedScroll(view, i, i2, i3, i4, 0, this.mNestedScrollingV2ConsumedCompat);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScrollAccepted(View view, View view2, int i, int i2) {
        AbstractC0144 r2;
        C1751 r0 = this.mNestedScrollingParentHelper;
        if (i2 == 1) {
            r0.f6065 = i;
        } else {
            r0.f6066 = i;
        }
        this.mNestedScrollingTarget = view2;
        int childCount = getChildCount();
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            C0149 r22 = (C0149) childAt.getLayoutParams();
            if (r22.m577(i2) && (r2 = r22.f1105) != null) {
                r2.onNestedScrollAccepted(this, childAt, view, view2, i, i2);
            }
        }
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public boolean onStartNestedScroll(View view, View view2, int i, int i2) {
        int childCount = getChildCount();
        boolean z = false;
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt = getChildAt(i3);
            if (childAt.getVisibility() != 8) {
                C0149 r13 = (C0149) childAt.getLayoutParams();
                AbstractC0144 r0 = r13.f1105;
                if (r0 != null) {
                    boolean onStartNestedScroll = r0.onStartNestedScroll(this, childAt, view, view2, i, i2);
                    r13.m575(i2, onStartNestedScroll);
                    z |= onStartNestedScroll;
                } else {
                    r13.m575(i2, false);
                }
            }
        }
        return z;
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onStopNestedScroll(View view, int i) {
        C1751 r0 = this.mNestedScrollingParentHelper;
        if (i == 1) {
            r0.f6065 = 0;
        } else {
            r0.f6066 = 0;
        }
        int childCount = getChildCount();
        for (int i2 = 0; i2 < childCount; i2++) {
            View childAt = getChildAt(i2);
            C0149 r4 = (C0149) childAt.getLayoutParams();
            if (r4.m577(i)) {
                AbstractC0144 r5 = r4.f1105;
                if (r5 != null) {
                    r5.onStopNestedScroll(this, childAt, view, i);
                }
                r4.m575(i, false);
                r4.f1098 = false;
            }
        }
        this.mNestedScrollingTarget = null;
    }

    public CoordinatorLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        TypedArray typedArray;
        this.mDependencySortedChildren = new ArrayList();
        this.mChildDag = new C2298<>();
        this.mTempList1 = new ArrayList();
        this.mTempDependenciesList = new ArrayList();
        this.mBehaviorConsumed = new int[2];
        this.mNestedScrollingV2ConsumedCompat = new int[2];
        this.mNestedScrollingParentHelper = new C1751();
        if (i == 0) {
            typedArray = context.obtainStyledAttributes(attributeSet, R$styleable.CoordinatorLayout, 0, R$style.Widget_Support_CoordinatorLayout);
        } else {
            typedArray = context.obtainStyledAttributes(attributeSet, R$styleable.CoordinatorLayout, i, 0);
        }
        if (Build.VERSION.SDK_INT >= 29) {
            if (i == 0) {
                saveAttributeDataForStyleable(context, R$styleable.CoordinatorLayout, attributeSet, typedArray, 0, R$style.Widget_Support_CoordinatorLayout);
            } else {
                saveAttributeDataForStyleable(context, R$styleable.CoordinatorLayout, attributeSet, typedArray, i, 0);
            }
        }
        int resourceId = typedArray.getResourceId(R$styleable.CoordinatorLayout_keylines, 0);
        if (resourceId != 0) {
            Resources resources = context.getResources();
            this.mKeylines = resources.getIntArray(resourceId);
            float f = resources.getDisplayMetrics().density;
            int length = this.mKeylines.length;
            for (int i2 = 0; i2 < length; i2++) {
                int[] iArr = this.mKeylines;
                iArr[i2] = (int) (((float) iArr[i2]) * f);
            }
        }
        this.mStatusBarBackground = typedArray.getDrawable(R$styleable.CoordinatorLayout_statusBarBackground);
        typedArray.recycle();
        setupForInsets();
        super.setOnHierarchyChangeListener(new ViewGroup$OnHierarchyChangeListenerC0145());
        if (C1729.m4454(this) == 0) {
            int i3 = Build.VERSION.SDK_INT;
            setImportantForAccessibility(1);
        }
    }

    @Override // android.view.ViewGroup
    public C0149 generateLayoutParams(AttributeSet attributeSet) {
        return new C0149(getContext(), attributeSet);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1767
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        AbstractC0144 r1;
        int i6;
        int i7;
        int childCount = getChildCount();
        boolean z = false;
        int i8 = 0;
        int i9 = 0;
        for (int i10 = 0; i10 < childCount; i10++) {
            View childAt = getChildAt(i10);
            if (childAt.getVisibility() != 8) {
                C0149 r12 = (C0149) childAt.getLayoutParams();
                if (r12.m577(i5) && (r1 = r12.f1105) != null) {
                    int[] iArr2 = this.mBehaviorConsumed;
                    iArr2[0] = 0;
                    iArr2[1] = 0;
                    r1.onNestedScroll(this, childAt, view, i, i2, i3, i4, i5, iArr2);
                    int[] iArr3 = this.mBehaviorConsumed;
                    if (i3 > 0) {
                        i6 = Math.max(i8, iArr3[0]);
                    } else {
                        i6 = Math.min(i8, iArr3[0]);
                    }
                    if (i4 > 0) {
                        i7 = Math.max(i9, this.mBehaviorConsumed[1]);
                    } else {
                        i7 = Math.min(i9, this.mBehaviorConsumed[1]);
                    }
                    i8 = i6;
                    i9 = i7;
                    z = true;
                }
            }
        }
        iArr[0] = iArr[0] + i8;
        iArr[1] = iArr[1] + i9;
        if (z) {
            onChildViewsChanged(1);
        }
    }

    @Override // android.view.ViewGroup
    public C0149 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof C0149) {
            return new C0149((C0149) layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new C0149((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new C0149(layoutParams);
    }

    /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$㴹  reason: contains not printable characters */
    public static class C0149 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f1096 = 0;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public boolean f1097;

        /* renamed from: ؿ  reason: contains not printable characters */
        public boolean f1098;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1099 = -1;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public final Rect f1100 = new Rect();

        /* renamed from: ᕣ  reason: contains not printable characters */
        public View f1101;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public int f1102;

        /* renamed from: ῲ  reason: contains not printable characters */
        public boolean f1103 = false;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int f1104 = 0;

        /* renamed from: K  reason: contains not printable characters */
        public AbstractC0144 f1105;

        /* renamed from: 㑃  reason: contains not printable characters */
        public View f1106;

        /* renamed from: 㗗  reason: contains not printable characters */
        public boolean f1107;

        /* renamed from: 㗽  reason: contains not printable characters */
        public Object f1108;

        /* renamed from: 㳳  reason: contains not printable characters */
        public int f1109;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1110 = -1;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1111 = 0;

        /* renamed from: 㿎  reason: contains not printable characters */
        public int f1112 = 0;

        /* renamed from: 䁗  reason: contains not printable characters */
        public boolean f1113;

        public C0149(int i, int i2) {
            super(i, i2);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m576(AbstractC0144 r2) {
            AbstractC0144 r0 = this.f1105;
            if (r0 != r2) {
                if (r0 != null) {
                    r0.onDetachedFromLayoutParams();
                }
                this.f1105 = r2;
                this.f1108 = null;
                this.f1103 = true;
                if (r2 != null) {
                    r2.onAttachedToLayoutParams(this);
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m575(int i, boolean z) {
            if (i == 0) {
                this.f1097 = z;
            } else if (i == 1) {
                this.f1107 = z;
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public boolean m577(int i) {
            if (i == 0) {
                return this.f1097;
            }
            if (i != 1) {
                return false;
            }
            return this.f1107;
        }

        public C0149(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.CoordinatorLayout_Layout);
            this.f1096 = obtainStyledAttributes.getInteger(R$styleable.CoordinatorLayout_Layout_android_layout_gravity, 0);
            this.f1110 = obtainStyledAttributes.getResourceId(R$styleable.CoordinatorLayout_Layout_layout_anchor, -1);
            this.f1111 = obtainStyledAttributes.getInteger(R$styleable.CoordinatorLayout_Layout_layout_anchorGravity, 0);
            this.f1099 = obtainStyledAttributes.getInteger(R$styleable.CoordinatorLayout_Layout_layout_keyline, -1);
            this.f1104 = obtainStyledAttributes.getInt(R$styleable.CoordinatorLayout_Layout_layout_insetEdge, 0);
            this.f1112 = obtainStyledAttributes.getInt(R$styleable.CoordinatorLayout_Layout_layout_dodgeInsetEdges, 0);
            this.f1103 = obtainStyledAttributes.hasValue(R$styleable.CoordinatorLayout_Layout_layout_behavior);
            if (this.f1103) {
                this.f1105 = CoordinatorLayout.parseBehavior(context, attributeSet, obtainStyledAttributes.getString(R$styleable.CoordinatorLayout_Layout_layout_behavior));
            }
            obtainStyledAttributes.recycle();
            AbstractC0144 r5 = this.f1105;
            if (r5 != null) {
                r5.onAttachedToLayoutParams(this);
            }
        }

        public C0149(C0149 r2) {
            super((ViewGroup.MarginLayoutParams) r2);
        }

        public C0149(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
        }

        public C0149(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0143();

        /* renamed from: ῲ  reason: contains not printable characters */
        public SparseArray<Parcelable> f1092;

        /* renamed from: androidx.coordinatorlayout.widget.CoordinatorLayout$SavedState$K  reason: contains not printable characters */
        public static class C0143 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            int readInt = parcel.readInt();
            int[] iArr = new int[readInt];
            parcel.readIntArray(iArr);
            Parcelable[] readParcelableArray = parcel.readParcelableArray(classLoader);
            this.f1092 = new SparseArray<>(readInt);
            for (int i = 0; i < readInt; i++) {
                this.f1092.append(iArr[i], readParcelableArray[i]);
            }
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            SparseArray<Parcelable> sparseArray = this.f1092;
            int size = sparseArray != null ? sparseArray.size() : 0;
            parcel.writeInt(size);
            int[] iArr = new int[size];
            Parcelable[] parcelableArr = new Parcelable[size];
            for (int i2 = 0; i2 < size; i2++) {
                iArr[i2] = this.f1092.keyAt(i2);
                parcelableArr[i2] = this.f1092.valueAt(i2);
            }
            parcel.writeIntArray(iArr);
            parcel.writeParcelableArray(parcelableArr, i);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }
}
