package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewParent;
import ῲ.ⁱ.ῲ.㿎.C2100;

public abstract class VirtualLayout extends ConstraintHelper {

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f1090;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f1091;

    public VirtualLayout(Context context) {
        super(context);
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    public void onAttachedToWindow() {
        ViewParent parent;
        super.onAttachedToWindow();
        if ((this.f1091 || this.f1090) && (parent = getParent()) != null && (parent instanceof ConstraintLayout)) {
            ConstraintLayout constraintLayout = (ConstraintLayout) parent;
            int visibility = getVisibility();
            int i = Build.VERSION.SDK_INT;
            float elevation = getElevation();
            for (int i2 = 0; i2 < this.f990; i2++) {
                View viewById = constraintLayout.getViewById(this.f993[i2]);
                if (viewById != null) {
                    if (this.f1091) {
                        viewById.setVisibility(visibility);
                    }
                    if (this.f1090 && elevation > 0.0f) {
                        int i3 = Build.VERSION.SDK_INT;
                        viewById.setTranslationZ(viewById.getTranslationZ() + elevation);
                    }
                }
            }
        }
    }

    public void setElevation(float f) {
        super.setElevation(f);
        m555();
    }

    public void setVisibility(int i) {
        super.setVisibility(i);
        m555();
    }

    @Override // androidx.constraintlayout.widget.ConstraintHelper
    /* renamed from: K  reason: contains not printable characters */
    public void m573(AttributeSet attributeSet) {
        super.m557(attributeSet);
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_Layout);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ConstraintLayout_Layout_android_visibility) {
                    this.f1091 = true;
                } else if (index == R$styleable.ConstraintLayout_Layout_android_elevation) {
                    this.f1090 = true;
                }
            }
            obtainStyledAttributes.recycle();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m574(C2100 r1, int i, int i2) {
    }

    public VirtualLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public VirtualLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
    }
}
