package androidx.constraintlayout.widget;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.util.SparseArray;
import android.util.SparseIntArray;
import android.view.View;
import android.view.ViewGroup;
import androidx.constraintlayout.solver.widgets.ConstraintAnchor;
import androidx.constraintlayout.solver.widgets.ConstraintWidget;
import com.appsflyer.share.Constants;
import java.util.ArrayList;
import java.util.HashMap;
import ῲ.ⁱ.ʬ.AbstractC2058;
import ῲ.ⁱ.ʬ.C2059;
import ῲ.ⁱ.ʬ.C2065;
import ῲ.ⁱ.ῲ.C2072;
import ῲ.ⁱ.ῲ.C2080;
import ῲ.ⁱ.ῲ.㿎.C2082;
import ῲ.ⁱ.ῲ.㿎.C2083;
import ῲ.ⁱ.ῲ.㿎.C2100;
import ῲ.ⁱ.ῲ.㿎.C2108;
import ῲ.ⁱ.ῲ.㿎.ᕣ.C2088;

public class ConstraintLayout extends ViewGroup {
    public static final boolean DEBUG = false;
    public static final boolean DEBUG_DRAW_CONSTRAINTS = false;
    public static final int DESIGN_INFO_ID = 0;
    public static final boolean MEASURE = false;
    public static final String TAG = "ConstraintLayout";
    public static final boolean USE_CONSTRAINTS_HELPER = true;
    public static final String VERSION = "ConstraintLayout-2.0.2";
    public SparseArray<View> mChildrenByIds = new SparseArray<>();
    public ArrayList<ConstraintHelper> mConstraintHelpers = new ArrayList<>(4);
    public C2065 mConstraintLayoutSpec = null;
    public C2059 mConstraintSet = null;
    public int mConstraintSetId = -1;
    public AbstractC2058 mConstraintsChangedListener;
    public HashMap<String, Integer> mDesignIds = new HashMap<>();
    public boolean mDirtyHierarchy = true;
    public int mLastMeasureHeight = -1;
    public int mLastMeasureHeightMode = 0;
    public int mLastMeasureHeightSize = -1;
    public int mLastMeasureWidth = -1;
    public int mLastMeasureWidthMode = 0;
    public int mLastMeasureWidthSize = -1;
    public C2082 mLayoutWidget = new C2082();
    public int mMaxHeight = Integer.MAX_VALUE;
    public int mMaxWidth = Integer.MAX_VALUE;
    public C0139 mMeasurer = new C0139(this);
    public C2072 mMetrics;
    public int mMinHeight = 0;
    public int mMinWidth = 0;
    public int mOnMeasureHeightMeasureSpec = 0;
    public int mOnMeasureWidthMeasureSpec = 0;
    public int mOptimizationLevel = 257;
    public SparseArray<ConstraintWidget> mTempMapIdToWidget = new SparseArray<>();

    public ConstraintLayout(Context context) {
        super(context);
        init(null, 0, 0);
    }

    private int getPaddingWidth() {
        int max = Math.max(0, getPaddingRight()) + Math.max(0, getPaddingLeft());
        int i = Build.VERSION.SDK_INT;
        int max2 = Math.max(0, getPaddingStart()) + Math.max(0, getPaddingEnd());
        return max2 > 0 ? max2 : max;
    }

    private final ConstraintWidget getTargetWidget(int i) {
        if (i == 0) {
            return this.mLayoutWidget;
        }
        View view = this.mChildrenByIds.get(i);
        if (view == null && (view = findViewById(i)) != null && view != this && view.getParent() == this) {
            onViewAdded(view);
        }
        if (view == this) {
            return this.mLayoutWidget;
        }
        if (view == null) {
            return null;
        }
        return ((C0140) view.getLayoutParams()).f1025;
    }

    private void init(AttributeSet attributeSet, int i, int i2) {
        C2082 r0 = this.mLayoutWidget;
        r0.f826 = this;
        r0.m5477(this.mMeasurer);
        this.mChildrenByIds.put(getId(), this);
        this.mConstraintSet = null;
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_Layout, i, i2);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i3 = 0; i3 < indexCount; i3++) {
                int index = obtainStyledAttributes.getIndex(i3);
                if (index == R$styleable.ConstraintLayout_Layout_android_minWidth) {
                    this.mMinWidth = obtainStyledAttributes.getDimensionPixelOffset(index, this.mMinWidth);
                } else if (index == R$styleable.ConstraintLayout_Layout_android_minHeight) {
                    this.mMinHeight = obtainStyledAttributes.getDimensionPixelOffset(index, this.mMinHeight);
                } else if (index == R$styleable.ConstraintLayout_Layout_android_maxWidth) {
                    this.mMaxWidth = obtainStyledAttributes.getDimensionPixelOffset(index, this.mMaxWidth);
                } else if (index == R$styleable.ConstraintLayout_Layout_android_maxHeight) {
                    this.mMaxHeight = obtainStyledAttributes.getDimensionPixelOffset(index, this.mMaxHeight);
                } else if (index == R$styleable.ConstraintLayout_Layout_layout_optimizationLevel) {
                    this.mOptimizationLevel = obtainStyledAttributes.getInt(index, this.mOptimizationLevel);
                } else if (index == R$styleable.ConstraintLayout_Layout_layoutDescription) {
                    int resourceId = obtainStyledAttributes.getResourceId(index, 0);
                    if (resourceId != 0) {
                        try {
                            parseLayoutDescription(resourceId);
                        } catch (Resources.NotFoundException unused) {
                            this.mConstraintLayoutSpec = null;
                        }
                    }
                } else if (index == R$styleable.ConstraintLayout_Layout_constraintSet) {
                    int resourceId2 = obtainStyledAttributes.getResourceId(index, 0);
                    try {
                        this.mConstraintSet = new C2059();
                        this.mConstraintSet.m5367(getContext(), resourceId2);
                    } catch (Resources.NotFoundException unused2) {
                        this.mConstraintSet = null;
                    }
                    this.mConstraintSetId = resourceId2;
                }
            }
            obtainStyledAttributes.recycle();
        }
        this.mLayoutWidget.m5469(this.mOptimizationLevel);
    }

    private void markHierarchyDirty() {
        this.mDirtyHierarchy = true;
        this.mLastMeasureWidth = -1;
        this.mLastMeasureHeight = -1;
        this.mLastMeasureWidthSize = -1;
        this.mLastMeasureHeightSize = -1;
        this.mLastMeasureWidthMode = 0;
        this.mLastMeasureHeightMode = 0;
    }

    private void setChildrenConstraints() {
        boolean isInEditMode = isInEditMode();
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            ConstraintWidget viewWidget = getViewWidget(getChildAt(i));
            if (viewWidget != null) {
                viewWidget.m475();
            }
        }
        if (isInEditMode) {
            for (int i2 = 0; i2 < childCount; i2++) {
                View childAt = getChildAt(i2);
                try {
                    String resourceName = getResources().getResourceName(childAt.getId());
                    setDesignInformation(0, resourceName, Integer.valueOf(childAt.getId()));
                    int indexOf = resourceName.indexOf(47);
                    if (indexOf != -1) {
                        resourceName = resourceName.substring(indexOf + 1);
                    }
                    getTargetWidget(childAt.getId()).f893 = resourceName;
                } catch (Resources.NotFoundException unused) {
                }
            }
        }
        if (this.mConstraintSetId != -1) {
            for (int i3 = 0; i3 < childCount; i3++) {
                View childAt2 = getChildAt(i3);
                if (childAt2.getId() == this.mConstraintSetId && (childAt2 instanceof Constraints)) {
                    this.mConstraintSet = ((Constraints) childAt2).getConstraintSet();
                }
            }
        }
        C2059 r1 = this.mConstraintSet;
        if (r1 != null) {
            r1.m5374(this, true);
        }
        this.mLayoutWidget.f7284.clear();
        int size = this.mConstraintHelpers.size();
        if (size > 0) {
            for (int i4 = 0; i4 < size; i4++) {
                this.mConstraintHelpers.get(i4).m550(this);
            }
        }
        for (int i5 = 0; i5 < childCount; i5++) {
            View childAt3 = getChildAt(i5);
            if (childAt3 instanceof Placeholder) {
                ((Placeholder) childAt3).m572(this);
            }
        }
        this.mTempMapIdToWidget.clear();
        this.mTempMapIdToWidget.put(0, this.mLayoutWidget);
        this.mTempMapIdToWidget.put(getId(), this.mLayoutWidget);
        for (int i6 = 0; i6 < childCount; i6++) {
            View childAt4 = getChildAt(i6);
            this.mTempMapIdToWidget.put(childAt4.getId(), getViewWidget(childAt4));
        }
        for (int i7 = 0; i7 < childCount; i7++) {
            View childAt5 = getChildAt(i7);
            ConstraintWidget viewWidget2 = getViewWidget(childAt5);
            if (viewWidget2 != null) {
                C0140 k = (C0140) childAt5.getLayoutParams();
                this.mLayoutWidget.m5569(viewWidget2);
                applyConstraintsFromLayoutParams(isInEditMode, childAt5, viewWidget2, k, this.mTempMapIdToWidget);
            }
        }
    }

    private boolean updateHierarchy() {
        int childCount = getChildCount();
        boolean z = false;
        int i = 0;
        while (true) {
            if (i >= childCount) {
                break;
            } else if (getChildAt(i).isLayoutRequested()) {
                z = true;
                break;
            } else {
                i++;
            }
        }
        if (z) {
            setChildrenConstraints();
        }
        return z;
    }

    @Override // android.view.ViewGroup
    public void addView(View view, int i, ViewGroup.LayoutParams layoutParams) {
        super.addView(view, i, layoutParams);
        int i2 = Build.VERSION.SDK_INT;
    }

    /* JADX WARNING: Removed duplicated region for block: B:148:0x02fa  */
    public void applyConstraintsFromLayoutParams(boolean z, View view, ConstraintWidget constraintWidget, C0140 k, SparseArray<ConstraintWidget> sparseArray) {
        float f;
        int i;
        float f2;
        float f3;
        ConstraintWidget constraintWidget2;
        ConstraintWidget constraintWidget3;
        ConstraintWidget constraintWidget4;
        ConstraintWidget constraintWidget5;
        k.m566();
        int i2 = 0;
        k.f1063 = false;
        constraintWidget.f840 = view.getVisibility();
        if (k.f1062) {
            constraintWidget.f838 = true;
            constraintWidget.f840 = 8;
        }
        constraintWidget.f826 = view;
        if (view instanceof ConstraintHelper) {
            ((ConstraintHelper) view).m558(constraintWidget, this.mLayoutWidget.f7189);
        }
        int i3 = -1;
        if (k.f1036) {
            C2083 r1 = (C2083) constraintWidget;
            int i4 = k.f1058;
            int i5 = k.f1013;
            float f4 = k.f1015;
            int i6 = Build.VERSION.SDK_INT;
            int i7 = (f4 > -1.0f ? 1 : (f4 == -1.0f ? 0 : -1));
            if (i7 != 0) {
                if (i7 > 0) {
                    r1.f7208 = f4;
                    r1.f7205 = -1;
                    r1.f7206 = -1;
                }
            } else if (i4 != -1) {
                if (i4 > -1) {
                    r1.f7208 = -1.0f;
                    r1.f7205 = i4;
                    r1.f7206 = -1;
                }
            } else if (i5 != -1 && i5 > -1) {
                r1.f7208 = -1.0f;
                r1.f7205 = -1;
                r1.f7206 = i5;
            }
        } else {
            int i8 = k.f1051;
            int i9 = k.f1040;
            int i10 = k.f1017;
            int i11 = k.f1044;
            int i12 = k.f1054;
            int i13 = k.f1019;
            float f5 = k.f1053;
            int i14 = Build.VERSION.SDK_INT;
            int i15 = k.f1070;
            if (i15 != -1) {
                ConstraintWidget constraintWidget6 = sparseArray.get(i15);
                if (constraintWidget6 != null) {
                    float f6 = k.f1050;
                    int i16 = k.f1011;
                    ConstraintAnchor.Type type = ConstraintAnchor.Type.CENTER;
                    constraintWidget.m491(type, constraintWidget6, type, i16, 0);
                    constraintWidget.f903 = f6;
                }
                f = 0.0f;
            } else {
                if (i8 != -1) {
                    ConstraintWidget constraintWidget7 = sparseArray.get(i8);
                    if (constraintWidget7 != null) {
                        ConstraintAnchor.Type type2 = ConstraintAnchor.Type.LEFT;
                        f3 = f5;
                        constraintWidget.m491(type2, constraintWidget7, type2, ((ViewGroup.MarginLayoutParams) k).leftMargin, i12);
                    } else {
                        f3 = f5;
                    }
                } else {
                    f3 = f5;
                    if (!(i9 == -1 || (constraintWidget5 = sparseArray.get(i9)) == null)) {
                        constraintWidget.m491(ConstraintAnchor.Type.LEFT, constraintWidget5, ConstraintAnchor.Type.RIGHT, ((ViewGroup.MarginLayoutParams) k).leftMargin, i12);
                    }
                }
                if (i10 != -1) {
                    ConstraintWidget constraintWidget8 = sparseArray.get(i10);
                    if (constraintWidget8 != null) {
                        constraintWidget.m491(ConstraintAnchor.Type.RIGHT, constraintWidget8, ConstraintAnchor.Type.LEFT, ((ViewGroup.MarginLayoutParams) k).rightMargin, i13);
                    }
                } else if (!(i11 == -1 || (constraintWidget4 = sparseArray.get(i11)) == null)) {
                    ConstraintAnchor.Type type3 = ConstraintAnchor.Type.RIGHT;
                    constraintWidget.m491(type3, constraintWidget4, type3, ((ViewGroup.MarginLayoutParams) k).rightMargin, i13);
                }
                int i17 = k.f1068;
                if (i17 != -1) {
                    ConstraintWidget constraintWidget9 = sparseArray.get(i17);
                    if (constraintWidget9 != null) {
                        ConstraintAnchor.Type type4 = ConstraintAnchor.Type.TOP;
                        constraintWidget.m491(type4, constraintWidget9, type4, ((ViewGroup.MarginLayoutParams) k).topMargin, k.f1012);
                    }
                } else {
                    int i18 = k.f1035;
                    if (!(i18 == -1 || (constraintWidget3 = sparseArray.get(i18)) == null)) {
                        constraintWidget.m491(ConstraintAnchor.Type.TOP, constraintWidget3, ConstraintAnchor.Type.BOTTOM, ((ViewGroup.MarginLayoutParams) k).topMargin, k.f1012);
                    }
                }
                int i19 = k.f1059;
                if (i19 != -1) {
                    ConstraintWidget constraintWidget10 = sparseArray.get(i19);
                    if (constraintWidget10 != null) {
                        constraintWidget.m491(ConstraintAnchor.Type.BOTTOM, constraintWidget10, ConstraintAnchor.Type.TOP, ((ViewGroup.MarginLayoutParams) k).bottomMargin, k.f1030);
                    }
                } else {
                    int i20 = k.f1033;
                    if (!(i20 == -1 || (constraintWidget2 = sparseArray.get(i20)) == null)) {
                        ConstraintAnchor.Type type5 = ConstraintAnchor.Type.BOTTOM;
                        constraintWidget.m491(type5, constraintWidget2, type5, ((ViewGroup.MarginLayoutParams) k).bottomMargin, k.f1030);
                    }
                }
                int i21 = k.f1047;
                if (i21 != -1) {
                    View view2 = this.mChildrenByIds.get(i21);
                    ConstraintWidget constraintWidget11 = sparseArray.get(k.f1047);
                    if (!(constraintWidget11 == null || view2 == null || !(view2.getLayoutParams() instanceof C0140))) {
                        C0140 k2 = (C0140) view2.getLayoutParams();
                        k.f1027 = true;
                        k2.f1027 = true;
                        constraintWidget.m488(ConstraintAnchor.Type.BASELINE).m464(constraintWidget11.m488(ConstraintAnchor.Type.BASELINE), 0, -1, true);
                        constraintWidget.f852 = true;
                        k2.f1025.f852 = true;
                        constraintWidget.m488(ConstraintAnchor.Type.TOP).m458();
                        constraintWidget.m488(ConstraintAnchor.Type.BOTTOM).m458();
                    }
                }
                f = 0.0f;
                if (f3 >= 0.0f) {
                    constraintWidget.f878 = f3;
                }
                float f7 = k.f1045;
                if (f7 >= 0.0f) {
                    constraintWidget.f888 = f7;
                }
            }
            if (z && !(k.f1009 == -1 && k.f1037 == -1)) {
                int i22 = k.f1009;
                int i23 = k.f1037;
                constraintWidget.f822 = i22;
                constraintWidget.f892 = i23;
            }
            if (k.f1049) {
                constraintWidget.m493(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.m502(((ViewGroup.MarginLayoutParams) k).width);
                if (((ViewGroup.MarginLayoutParams) k).width == -2) {
                    constraintWidget.m493(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            } else if (((ViewGroup.MarginLayoutParams) k).width == -1) {
                if (k.f1022) {
                    constraintWidget.m493(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                } else {
                    constraintWidget.m493(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                }
                constraintWidget.m488(ConstraintAnchor.Type.LEFT).f810 = ((ViewGroup.MarginLayoutParams) k).leftMargin;
                constraintWidget.m488(ConstraintAnchor.Type.RIGHT).f810 = ((ViewGroup.MarginLayoutParams) k).rightMargin;
            } else {
                constraintWidget.m493(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                constraintWidget.m502(0);
            }
            if (k.f1007) {
                constraintWidget.m482(ConstraintWidget.DimensionBehaviour.FIXED);
                constraintWidget.m479(((ViewGroup.MarginLayoutParams) k).height);
                if (((ViewGroup.MarginLayoutParams) k).height == -2) {
                    constraintWidget.m482(ConstraintWidget.DimensionBehaviour.WRAP_CONTENT);
                }
            } else if (((ViewGroup.MarginLayoutParams) k).height == -1) {
                if (k.f1057) {
                    constraintWidget.m482(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                } else {
                    constraintWidget.m482(ConstraintWidget.DimensionBehaviour.MATCH_PARENT);
                }
                constraintWidget.m488(ConstraintAnchor.Type.TOP).f810 = ((ViewGroup.MarginLayoutParams) k).topMargin;
                constraintWidget.m488(ConstraintAnchor.Type.BOTTOM).f810 = ((ViewGroup.MarginLayoutParams) k).bottomMargin;
            } else {
                constraintWidget.m482(ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT);
                constraintWidget.m479(0);
            }
            String str = k.f1055;
            if (str == null || str.length() == 0) {
                constraintWidget.f842 = f;
            } else {
                int length = str.length();
                int indexOf = str.indexOf(44);
                if (indexOf <= 0 || indexOf >= length - 1) {
                    i = 0;
                } else {
                    String substring = str.substring(0, indexOf);
                    if (substring.equalsIgnoreCase("W")) {
                        i3 = 0;
                    } else if (substring.equalsIgnoreCase("H")) {
                        i3 = 1;
                    }
                    i = indexOf + 1;
                }
                int indexOf2 = str.indexOf(58);
                if (indexOf2 < 0 || indexOf2 >= length - 1) {
                    String substring2 = str.substring(i);
                    if (substring2.length() > 0) {
                        f2 = Float.parseFloat(substring2);
                        if (f2 > f) {
                            constraintWidget.f842 = f2;
                            constraintWidget.f855 = i3;
                        }
                    }
                } else {
                    String substring3 = str.substring(i, indexOf2);
                    String substring4 = str.substring(indexOf2 + 1);
                    if (substring3.length() > 0 && substring4.length() > 0) {
                        try {
                            float parseFloat = Float.parseFloat(substring3);
                            float parseFloat2 = Float.parseFloat(substring4);
                            if (parseFloat > f && parseFloat2 > f) {
                                f2 = i3 == 1 ? Math.abs(parseFloat2 / parseFloat) : Math.abs(parseFloat / parseFloat2);
                                if (f2 > f) {
                                }
                            }
                        } catch (NumberFormatException unused) {
                        }
                    }
                }
                f2 = 0.0f;
                if (f2 > f) {
                }
            }
            float f8 = k.f1034;
            float[] fArr = constraintWidget.f883;
            fArr[0] = f8;
            fArr[1] = k.f1023;
            constraintWidget.f898 = k.f1042;
            constraintWidget.f834 = k.f1024;
            int i24 = k.f1029;
            int i25 = k.f1056;
            int i26 = k.f1026;
            float f9 = k.f1048;
            constraintWidget.f874 = i24;
            constraintWidget.f877 = i25;
            if (i26 == Integer.MAX_VALUE) {
                i26 = 0;
            }
            constraintWidget.f829 = i26;
            constraintWidget.f901 = f9;
            if (f9 > f && f9 < 1.0f && constraintWidget.f874 == 0) {
                constraintWidget.f874 = 2;
            }
            int i27 = k.f1008;
            int i28 = k.f1020;
            int i29 = k.f1067;
            float f10 = k.f1065;
            constraintWidget.f827 = i27;
            constraintWidget.f824 = i28;
            if (i29 != Integer.MAX_VALUE) {
                i2 = i29;
            }
            constraintWidget.f894 = i2;
            constraintWidget.f846 = f10;
            if (f10 > f && f10 < 1.0f && constraintWidget.f827 == 0) {
                constraintWidget.f827 = 2;
            }
        }
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0140;
    }

    public void dispatchDraw(Canvas canvas) {
        Object tag;
        int size;
        ArrayList<ConstraintHelper> arrayList = this.mConstraintHelpers;
        if (arrayList != null && (size = arrayList.size()) > 0) {
            for (int i = 0; i < size; i++) {
                this.mConstraintHelpers.get(i).m563(this);
            }
        }
        super.dispatchDraw(canvas);
        if (isInEditMode()) {
            int childCount = getChildCount();
            float width = (float) getWidth();
            float height = (float) getHeight();
            for (int i2 = 0; i2 < childCount; i2++) {
                View childAt = getChildAt(i2);
                if (!(childAt.getVisibility() == 8 || (tag = childAt.getTag()) == null || !(tag instanceof String))) {
                    String[] split = ((String) tag).split(",");
                    if (split.length == 4) {
                        int parseInt = Integer.parseInt(split[0]);
                        int parseInt2 = Integer.parseInt(split[1]);
                        int parseInt3 = Integer.parseInt(split[2]);
                        int i3 = (int) ((((float) parseInt) / 1080.0f) * width);
                        int i4 = (int) ((((float) parseInt2) / 1920.0f) * height);
                        Paint paint = new Paint();
                        paint.setColor(-65536);
                        float f = (float) i3;
                        float f2 = (float) i4;
                        float f3 = (float) (i3 + ((int) ((((float) parseInt3) / 1080.0f) * width)));
                        canvas.drawLine(f, f2, f3, f2, paint);
                        float parseInt4 = (float) (i4 + ((int) ((((float) Integer.parseInt(split[3])) / 1920.0f) * height)));
                        canvas.drawLine(f3, f2, f3, parseInt4, paint);
                        canvas.drawLine(f3, parseInt4, f, parseInt4, paint);
                        canvas.drawLine(f, parseInt4, f, f2, paint);
                        paint.setColor(-16711936);
                        canvas.drawLine(f, f2, f3, parseInt4, paint);
                        canvas.drawLine(f, parseInt4, f3, f2, paint);
                    }
                }
            }
        }
    }

    public void fillMetrics(C2072 r2) {
        this.mLayoutWidget.f7191.m5460(r2);
    }

    public void forceLayout() {
        markHierarchyDirty();
        super.forceLayout();
    }

    public Object getDesignInformation(int i, Object obj) {
        if (i != 0 || !(obj instanceof String)) {
            return null;
        }
        String str = (String) obj;
        HashMap<String, Integer> hashMap = this.mDesignIds;
        if (hashMap == null || !hashMap.containsKey(str)) {
            return null;
        }
        return this.mDesignIds.get(str);
    }

    public int getMaxHeight() {
        return this.mMaxHeight;
    }

    public int getMaxWidth() {
        return this.mMaxWidth;
    }

    public int getMinHeight() {
        return this.mMinHeight;
    }

    public int getMinWidth() {
        return this.mMinWidth;
    }

    public int getOptimizationLevel() {
        return this.mLayoutWidget.f7192;
    }

    public View getViewById(int i) {
        return this.mChildrenByIds.get(i);
    }

    public final ConstraintWidget getViewWidget(View view) {
        if (view == this) {
            return this.mLayoutWidget;
        }
        if (view == null) {
            return null;
        }
        return ((C0140) view.getLayoutParams()).f1025;
    }

    public boolean isRtl() {
        int i = Build.VERSION.SDK_INT;
        if (!((getContext().getApplicationInfo().flags & 4194304) != 0) || 1 != getLayoutDirection()) {
            return false;
        }
        return true;
    }

    public void loadLayoutDescription(int i) {
        if (i != 0) {
            try {
                this.mConstraintLayoutSpec = new C2065(getContext(), this, i);
            } catch (Resources.NotFoundException unused) {
                this.mConstraintLayoutSpec = null;
            }
        } else {
            this.mConstraintLayoutSpec = null;
        }
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        View content;
        int childCount = getChildCount();
        boolean isInEditMode = isInEditMode();
        for (int i5 = 0; i5 < childCount; i5++) {
            View childAt = getChildAt(i5);
            C0140 k = (C0140) childAt.getLayoutParams();
            ConstraintWidget constraintWidget = k.f1025;
            if ((childAt.getVisibility() != 8 || k.f1036 || k.f1010 || k.f1032 || isInEditMode) && !k.f1062) {
                int r0 = constraintWidget.m506();
                int r2 = constraintWidget.m476();
                int r3 = constraintWidget.m478() + r0;
                int r1 = constraintWidget.m473() + r2;
                childAt.layout(r0, r2, r3, r1);
                if ((childAt instanceof Placeholder) && (content = ((Placeholder) childAt).getContent()) != null) {
                    content.setVisibility(0);
                    content.layout(r0, r2, r3, r1);
                }
            }
        }
        int size = this.mConstraintHelpers.size();
        if (size > 0) {
            for (int i6 = 0; i6 < size; i6++) {
                this.mConstraintHelpers.get(i6).m549(this);
            }
        }
    }

    public void onMeasure(int i, int i2) {
        if (!this.mDirtyHierarchy) {
            if (this.mOnMeasureWidthMeasureSpec == i && this.mOnMeasureHeightMeasureSpec == i2) {
                int r4 = this.mLayoutWidget.m478();
                int r5 = this.mLayoutWidget.m473();
                C2082 r0 = this.mLayoutWidget;
                resolveMeasuredDimension(i, i2, r4, r5, r0.f7196, r0.f7197);
                return;
            } else if (this.mOnMeasureWidthMeasureSpec == i && View.MeasureSpec.getMode(i) == 1073741824 && View.MeasureSpec.getMode(i2) == Integer.MIN_VALUE && View.MeasureSpec.getMode(this.mOnMeasureHeightMeasureSpec) == Integer.MIN_VALUE && View.MeasureSpec.getSize(i2) >= this.mLayoutWidget.m473()) {
                this.mOnMeasureWidthMeasureSpec = i;
                this.mOnMeasureHeightMeasureSpec = i2;
                int r42 = this.mLayoutWidget.m478();
                int r52 = this.mLayoutWidget.m473();
                C2082 r02 = this.mLayoutWidget;
                resolveMeasuredDimension(i, i2, r42, r52, r02.f7196, r02.f7197);
                return;
            }
        }
        this.mOnMeasureWidthMeasureSpec = i;
        this.mOnMeasureHeightMeasureSpec = i2;
        this.mLayoutWidget.f7189 = isRtl();
        if (this.mDirtyHierarchy) {
            this.mDirtyHierarchy = false;
            if (updateHierarchy()) {
                this.mLayoutWidget.m5471();
            }
        }
        resolveSystem(this.mLayoutWidget, this.mOptimizationLevel, i, i2);
        int r43 = this.mLayoutWidget.m478();
        int r53 = this.mLayoutWidget.m473();
        C2082 r03 = this.mLayoutWidget;
        resolveMeasuredDimension(i, i2, r43, r53, r03.f7196, r03.f7197);
    }

    public void onViewAdded(View view) {
        int i = Build.VERSION.SDK_INT;
        super.onViewAdded(view);
        ConstraintWidget viewWidget = getViewWidget(view);
        if ((view instanceof Guideline) && !(viewWidget instanceof C2083)) {
            C0140 k = (C0140) view.getLayoutParams();
            k.f1025 = new C2083();
            k.f1036 = true;
            ((C2083) k.f1025).m5483(k.f1018);
        }
        if (view instanceof ConstraintHelper) {
            ConstraintHelper constraintHelper = (ConstraintHelper) view;
            constraintHelper.m548();
            ((C0140) view.getLayoutParams()).f1010 = true;
            if (!this.mConstraintHelpers.contains(constraintHelper)) {
                this.mConstraintHelpers.add(constraintHelper);
            }
        }
        this.mChildrenByIds.put(view.getId(), view);
        this.mDirtyHierarchy = true;
    }

    public void onViewRemoved(View view) {
        int i = Build.VERSION.SDK_INT;
        super.onViewRemoved(view);
        this.mChildrenByIds.remove(view.getId());
        this.mLayoutWidget.m5568(getViewWidget(view));
        this.mConstraintHelpers.remove(view);
        this.mDirtyHierarchy = true;
    }

    public void parseLayoutDescription(int i) {
        this.mConstraintLayoutSpec = new C2065(getContext(), this, i);
    }

    public void removeView(View view) {
        super.removeView(view);
        int i = Build.VERSION.SDK_INT;
    }

    public void requestLayout() {
        markHierarchyDirty();
        super.requestLayout();
    }

    public void resolveMeasuredDimension(int i, int i2, int i3, int i4, boolean z, boolean z2) {
        C0139 r0 = this.mMeasurer;
        int i5 = r0.f999;
        int i6 = i3 + r0.f1004;
        int i7 = Build.VERSION.SDK_INT;
        int resolveSizeAndState = ViewGroup.resolveSizeAndState(i6, i, 0);
        int min = Math.min(this.mMaxWidth, resolveSizeAndState & 16777215);
        int min2 = Math.min(this.mMaxHeight, ViewGroup.resolveSizeAndState(i4 + i5, i2, 0) & 16777215);
        if (z) {
            min |= 16777216;
        }
        if (z2) {
            min2 |= 16777216;
        }
        setMeasuredDimension(min, min2);
        this.mLastMeasureWidth = min;
        this.mLastMeasureHeight = min2;
    }

    public void resolveSystem(C2082 r11, int i, int i2, int i3) {
        int mode = View.MeasureSpec.getMode(i2);
        int size = View.MeasureSpec.getSize(i2);
        int mode2 = View.MeasureSpec.getMode(i3);
        int size2 = View.MeasureSpec.getSize(i3);
        int max = Math.max(0, getPaddingTop());
        int max2 = Math.max(0, getPaddingBottom());
        int i4 = max + max2;
        int paddingWidth = getPaddingWidth();
        C0139 r9 = this.mMeasurer;
        r9.f1000 = max;
        r9.f998 = max2;
        r9.f1004 = paddingWidth;
        r9.f999 = i4;
        r9.f1003 = i2;
        r9.f1001 = i3;
        int i5 = Build.VERSION.SDK_INT;
        int max3 = Math.max(0, getPaddingStart());
        int max4 = Math.max(0, getPaddingEnd());
        if (max3 <= 0 && max4 <= 0) {
            max3 = Math.max(0, getPaddingLeft());
        } else if (isRtl()) {
            max3 = max4;
        }
        int i6 = size - paddingWidth;
        int i7 = size2 - i4;
        setSelfDimensionBehaviour(r11, mode, i6, mode2, i7);
        r11.f7184 = max3;
        r11.f7187 = max;
        r11.f7194.m5515(r11, i, mode, i6, mode2, i7);
    }

    public void setConstraintSet(C2059 r1) {
        this.mConstraintSet = r1;
    }

    public void setDesignInformation(int i, Object obj, Object obj2) {
        if (i == 0 && (obj instanceof String) && (obj2 instanceof Integer)) {
            if (this.mDesignIds == null) {
                this.mDesignIds = new HashMap<>();
            }
            String str = (String) obj;
            int indexOf = str.indexOf(Constants.URL_PATH_DELIMITER);
            if (indexOf != -1) {
                str = str.substring(indexOf + 1);
            }
            this.mDesignIds.put(str, Integer.valueOf(((Integer) obj2).intValue()));
        }
    }

    public void setId(int i) {
        this.mChildrenByIds.remove(getId());
        super.setId(i);
        this.mChildrenByIds.put(getId(), this);
    }

    public void setMaxHeight(int i) {
        if (i != this.mMaxHeight) {
            this.mMaxHeight = i;
            requestLayout();
        }
    }

    public void setMaxWidth(int i) {
        if (i != this.mMaxWidth) {
            this.mMaxWidth = i;
            requestLayout();
        }
    }

    public void setMinHeight(int i) {
        if (i != this.mMinHeight) {
            this.mMinHeight = i;
            requestLayout();
        }
    }

    public void setMinWidth(int i) {
        if (i != this.mMinWidth) {
            this.mMinWidth = i;
            requestLayout();
        }
    }

    public void setOnConstraintsChanged(AbstractC2058 r2) {
        C2065 k = this.mConstraintLayoutSpec;
        if (k != null) {
            k.m5392(r2);
        }
    }

    public void setOptimizationLevel(int i) {
        this.mOptimizationLevel = i;
        C2082 r0 = this.mLayoutWidget;
        r0.f7192 = i;
        C2080.f7165 = r0.m5482(512);
    }

    public void setSelfDimensionBehaviour(C2082 r8, int i, int i2, int i3, int i4) {
        ConstraintWidget.DimensionBehaviour dimensionBehaviour;
        C0139 r0 = this.mMeasurer;
        int i5 = r0.f999;
        int i6 = r0.f1004;
        ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = ConstraintWidget.DimensionBehaviour.FIXED;
        int childCount = getChildCount();
        if (i != Integer.MIN_VALUE) {
            if (i == 0) {
                dimensionBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (childCount == 0) {
                    i2 = Math.max(0, this.mMinWidth);
                }
            } else if (i != 1073741824) {
                dimensionBehaviour = dimensionBehaviour2;
            } else {
                i2 = Math.min(this.mMaxWidth - i6, i2);
                dimensionBehaviour = dimensionBehaviour2;
            }
            i2 = 0;
        } else {
            dimensionBehaviour = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (childCount == 0) {
                i2 = Math.max(0, this.mMinWidth);
            }
        }
        if (i3 != Integer.MIN_VALUE) {
            if (i3 == 0) {
                dimensionBehaviour2 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
                if (childCount == 0) {
                    i4 = Math.max(0, this.mMinHeight);
                }
            } else if (i3 == 1073741824) {
                i4 = Math.min(this.mMaxHeight - i5, i4);
            }
            i4 = 0;
        } else {
            dimensionBehaviour2 = ConstraintWidget.DimensionBehaviour.WRAP_CONTENT;
            if (childCount == 0) {
                i4 = Math.max(0, this.mMinHeight);
            }
        }
        if (!(i2 == r8.m478() && i4 == r8.m473())) {
            r8.f7195.f7211 = true;
        }
        r8.f822 = 0;
        r8.f892 = 0;
        int[] iArr = r8.f884;
        iArr[0] = this.mMaxWidth - i6;
        iArr[1] = this.mMaxHeight - i5;
        r8.m477(0);
        r8.m507(0);
        r8.m493(dimensionBehaviour);
        r8.m502(i2);
        r8.m482(dimensionBehaviour2);
        r8.m479(i4);
        r8.m477(this.mMinWidth - i6);
        r8.m507(this.mMinHeight - i5);
    }

    public void setState(int i, int i2, int i3) {
        C2065 k = this.mConstraintLayoutSpec;
        if (k != null) {
            k.m5390(i, (float) i2, (float) i3);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    public C0140 generateDefaultLayoutParams() {
        return new C0140(-2, -2);
    }

    @Override // android.view.ViewGroup
    public C0140 generateLayoutParams(AttributeSet attributeSet) {
        return new C0140(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new C0140(layoutParams);
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        init(attributeSet, 0, 0);
    }

    public ConstraintLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        init(attributeSet, i, 0);
    }

    @TargetApi(21)
    public ConstraintLayout(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
        init(attributeSet, i, i2);
    }

    /* renamed from: androidx.constraintlayout.widget.ConstraintLayout$ῲ  reason: contains not printable characters */
    public class C0139 implements C2088.AbstractC2089 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f998;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f999;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1000;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int f1001;

        /* renamed from: K  reason: contains not printable characters */
        public ConstraintLayout f1002;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1003;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1004;

        public C0139(ConstraintLayout constraintLayout) {
            this.f1002 = constraintLayout;
        }

        /* JADX WARNING: Removed duplicated region for block: B:102:0x019c  */
        /* JADX WARNING: Removed duplicated region for block: B:107:0x01ad  */
        /* JADX WARNING: Removed duplicated region for block: B:111:0x01c2  */
        /* JADX WARNING: Removed duplicated region for block: B:112:0x01c4  */
        /* JADX WARNING: Removed duplicated region for block: B:115:0x01c9  */
        /* JADX WARNING: Removed duplicated region for block: B:116:0x01cb  */
        /* JADX WARNING: Removed duplicated region for block: B:119:0x01d0  */
        /* JADX WARNING: Removed duplicated region for block: B:125:0x01dc  */
        /* JADX WARNING: Removed duplicated region for block: B:131:0x01e7  */
        /* JADX WARNING: Removed duplicated region for block: B:136:0x01f2  */
        /* JADX WARNING: Removed duplicated region for block: B:142:0x0205 A[ADDED_TO_REGION] */
        /* JADX WARNING: Removed duplicated region for block: B:153:0x021d  */
        /* JADX WARNING: Removed duplicated region for block: B:159:0x0244  */
        /* JADX WARNING: Removed duplicated region for block: B:160:0x024d  */
        /* JADX WARNING: Removed duplicated region for block: B:162:0x0257  */
        /* JADX WARNING: Removed duplicated region for block: B:163:0x0261  */
        /* JADX WARNING: Removed duplicated region for block: B:166:0x026e  */
        /* JADX WARNING: Removed duplicated region for block: B:167:0x0273  */
        /* JADX WARNING: Removed duplicated region for block: B:170:0x0278  */
        /* JADX WARNING: Removed duplicated region for block: B:173:0x0280  */
        /* JADX WARNING: Removed duplicated region for block: B:174:0x0285  */
        /* JADX WARNING: Removed duplicated region for block: B:177:0x028a  */
        /* JADX WARNING: Removed duplicated region for block: B:180:0x029b  */
        /* JADX WARNING: Removed duplicated region for block: B:188:0x02b5 A[ADDED_TO_REGION] */
        /* JADX WARNING: Removed duplicated region for block: B:191:0x02c0  */
        /* JADX WARNING: Removed duplicated region for block: B:192:0x02c7  */
        /* JADX WARNING: Removed duplicated region for block: B:194:0x02cb  */
        /* JADX WARNING: Removed duplicated region for block: B:197:0x02e9  */
        /* JADX WARNING: Removed duplicated region for block: B:198:0x02eb  */
        /* JADX WARNING: Removed duplicated region for block: B:206:0x02fb  */
        /* JADX WARNING: Removed duplicated region for block: B:48:0x00bc  */
        /* JADX WARNING: Removed duplicated region for block: B:82:0x0138  */
        @SuppressLint({"WrongCall"})
        /* renamed from: K  reason: contains not printable characters */
        public final void m564(ConstraintWidget constraintWidget, C2088.C2090 k) {
            boolean z;
            int i;
            int ordinal;
            boolean z2;
            int i2;
            C0140 k2;
            int i3;
            int measuredWidth;
            int measuredHeight;
            int max;
            int i4;
            int max2;
            int i5;
            int i6;
            boolean z3;
            int measuredWidth2;
            int measuredHeight2;
            int baseline;
            if (constraintWidget != null) {
                if (constraintWidget.f840 != 8 || constraintWidget.f838) {
                    ConstraintWidget.DimensionBehaviour dimensionBehaviour = k.f7231;
                    ConstraintWidget.DimensionBehaviour dimensionBehaviour2 = k.f7229;
                    int i7 = k.f7226;
                    int i8 = k.f7234;
                    int i9 = this.f1000 + this.f998;
                    int i10 = this.f1004;
                    View view = (View) constraintWidget.f826;
                    int ordinal2 = dimensionBehaviour.ordinal();
                    if (ordinal2 != 0) {
                        if (ordinal2 == 1) {
                            i = ViewGroup.getChildMeasureSpec(this.f1003, i10, -2);
                            constraintWidget.f859[2] = -2;
                        } else if (ordinal2 == 2) {
                            i = ViewGroup.getChildMeasureSpec(this.f1003, i10, -2);
                            boolean z4 = constraintWidget.f874 == 1;
                            int[] iArr = constraintWidget.f859;
                            iArr[2] = 0;
                            if (k.f7232) {
                                boolean z5 = !(!z4 || iArr[3] == 0 || iArr[0] == constraintWidget.m478()) || (view instanceof Placeholder);
                                if (!z4 || z5) {
                                    i = View.MeasureSpec.makeMeasureSpec(constraintWidget.m478(), 1073741824);
                                }
                            }
                        } else if (ordinal2 != 3) {
                            i = 0;
                        } else {
                            int i11 = this.f1003;
                            ConstraintAnchor constraintAnchor = constraintWidget.f820;
                            int i12 = constraintAnchor != null ? constraintAnchor.f810 + 0 : 0;
                            ConstraintAnchor constraintAnchor2 = constraintWidget.f833;
                            if (constraintAnchor2 != null) {
                                i12 += constraintAnchor2.f810;
                            }
                            i = ViewGroup.getChildMeasureSpec(i11, i10 + i12, -1);
                            constraintWidget.f859[2] = -1;
                        }
                        z = true;
                        ordinal = dimensionBehaviour2.ordinal();
                        if (ordinal == 0) {
                            if (ordinal == 1) {
                                i2 = ViewGroup.getChildMeasureSpec(this.f1001, i9, -2);
                                constraintWidget.f859[3] = -2;
                            } else if (ordinal == 2) {
                                i2 = ViewGroup.getChildMeasureSpec(this.f1001, i9, -2);
                                boolean z6 = constraintWidget.f827 == 1;
                                int[] iArr2 = constraintWidget.f859;
                                iArr2[3] = 0;
                                if (k.f7232) {
                                    boolean z7 = !(!z6 || iArr2[2] == 0 || iArr2[1] == constraintWidget.m473()) || (view instanceof Placeholder);
                                    if (!z6 || z7) {
                                        i2 = View.MeasureSpec.makeMeasureSpec(constraintWidget.m473(), 1073741824);
                                    }
                                }
                            } else if (ordinal != 3) {
                                i2 = 0;
                            } else {
                                int i13 = this.f1001;
                                int i14 = constraintWidget.f820 != null ? constraintWidget.f885.f810 + 0 : 0;
                                if (constraintWidget.f833 != null) {
                                    i14 += constraintWidget.f841.f810;
                                }
                                i2 = ViewGroup.getChildMeasureSpec(i13, i9 + i14, -1);
                                constraintWidget.f859[3] = -1;
                            }
                            z2 = true;
                            C2082 r11 = (C2082) constraintWidget.f867;
                            if (r11 != null && C2108.m5585(ConstraintLayout.this.mOptimizationLevel, 256) && view.getMeasuredWidth() == constraintWidget.m478() && view.getMeasuredWidth() < r11.m478() && view.getMeasuredHeight() == constraintWidget.m473() && view.getMeasuredHeight() < r11.m473() && view.getBaseline() == constraintWidget.f865 && !constraintWidget.m470()) {
                                if (!m565(constraintWidget.f839, i, constraintWidget.m478()) && m565(constraintWidget.f845, i2, constraintWidget.m473())) {
                                    k.f7227 = constraintWidget.m478();
                                    k.f7233 = constraintWidget.m473();
                                    k.f7230 = constraintWidget.f865;
                                    return;
                                }
                            }
                            boolean z8 = dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                            boolean z9 = dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT;
                            boolean z10 = dimensionBehaviour2 != ConstraintWidget.DimensionBehaviour.MATCH_PARENT || dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.FIXED;
                            boolean z11 = dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_PARENT || dimensionBehaviour == ConstraintWidget.DimensionBehaviour.FIXED;
                            boolean z12 = !z8 && constraintWidget.f842 > 0.0f;
                            boolean z13 = !z9 && constraintWidget.f842 > 0.0f;
                            k2 = (C0140) view.getLayoutParams();
                            if (!k.f7232 || !z8 || constraintWidget.f874 != 0 || !z9 || constraintWidget.f827 != 0) {
                                if ((view instanceof VirtualLayout) || !(constraintWidget instanceof C2100)) {
                                    view.measure(i, i2);
                                    constraintWidget.f839 = i;
                                    constraintWidget.f845 = i2;
                                    i3 = 0;
                                    constraintWidget.f900 = false;
                                } else {
                                    ((VirtualLayout) view).m574((C2100) constraintWidget, i, i2);
                                    i3 = 0;
                                }
                                measuredWidth = view.getMeasuredWidth();
                                measuredHeight = view.getMeasuredHeight();
                                int baseline2 = view.getBaseline();
                                if (z) {
                                    int[] iArr3 = constraintWidget.f859;
                                    iArr3[i3] = measuredWidth;
                                    iArr3[2] = measuredHeight;
                                } else {
                                    int[] iArr4 = constraintWidget.f859;
                                    iArr4[i3] = i3;
                                    iArr4[2] = i3;
                                }
                                if (z2) {
                                    int[] iArr5 = constraintWidget.f859;
                                    iArr5[1] = measuredHeight;
                                    iArr5[3] = measuredWidth;
                                } else {
                                    int[] iArr6 = constraintWidget.f859;
                                    iArr6[1] = i3;
                                    iArr6[3] = i3;
                                }
                                int i15 = constraintWidget.f877;
                                max = i15 > 0 ? Math.max(i15, measuredWidth) : measuredWidth;
                                i4 = constraintWidget.f829;
                                if (i4 > 0) {
                                    max = Math.min(i4, max);
                                }
                                int i16 = constraintWidget.f824;
                                max2 = i16 > 0 ? Math.max(i16, measuredHeight) : measuredHeight;
                                i5 = constraintWidget.f894;
                                if (i5 > 0) {
                                    max2 = Math.min(i5, max2);
                                }
                                if (!C2108.m5585(ConstraintLayout.this.mOptimizationLevel, 1)) {
                                    if (z12 && z10) {
                                        max = (int) ((((float) max2) * constraintWidget.f842) + 0.5f);
                                    } else if (z13 && z11) {
                                        max2 = (int) ((((float) max) / constraintWidget.f842) + 0.5f);
                                    }
                                }
                                if (measuredWidth == max || measuredHeight != max2) {
                                    if (measuredWidth != max) {
                                        i6 = 1073741824;
                                        i = View.MeasureSpec.makeMeasureSpec(max, 1073741824);
                                    } else {
                                        i6 = 1073741824;
                                    }
                                    if (measuredHeight != max2) {
                                        i2 = View.MeasureSpec.makeMeasureSpec(max2, i6);
                                    }
                                    view.measure(i, i2);
                                    constraintWidget.f839 = i;
                                    constraintWidget.f845 = i2;
                                    z3 = false;
                                    constraintWidget.f900 = false;
                                    measuredWidth2 = view.getMeasuredWidth();
                                    measuredHeight2 = view.getMeasuredHeight();
                                    baseline = view.getBaseline();
                                    boolean z14 = baseline == -1;
                                    if (!(measuredWidth2 == k.f7226 && measuredHeight2 == k.f7234)) {
                                        z3 = true;
                                    }
                                    k.f7228 = z3;
                                    if (k2.f1027) {
                                        z14 = true;
                                    }
                                    if (!(!z14 || baseline == -1 || constraintWidget.f865 == baseline)) {
                                        k.f7228 = true;
                                    }
                                    k.f7227 = measuredWidth2;
                                    k.f7233 = measuredHeight2;
                                    k.f7235 = z14;
                                    k.f7230 = baseline;
                                    return;
                                }
                                measuredWidth2 = max;
                                measuredHeight2 = max2;
                                baseline = baseline2;
                            } else {
                                measuredWidth2 = 0;
                                measuredHeight2 = 0;
                                baseline = 0;
                            }
                            z3 = false;
                            if (baseline == -1) {
                            }
                            z3 = true;
                            k.f7228 = z3;
                            if (k2.f1027) {
                            }
                            k.f7228 = true;
                            k.f7227 = measuredWidth2;
                            k.f7233 = measuredHeight2;
                            k.f7235 = z14;
                            k.f7230 = baseline;
                            return;
                        }
                        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i8, 1073741824);
                        constraintWidget.f859[3] = i8;
                        i2 = makeMeasureSpec;
                        z2 = false;
                        C2082 r112 = (C2082) constraintWidget.f867;
                        if (!m565(constraintWidget.f839, i, constraintWidget.m478()) && m565(constraintWidget.f845, i2, constraintWidget.m473())) {
                        }
                        if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        }
                        if (dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                        }
                        if (dimensionBehaviour2 != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        }
                        if (dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                        }
                        if (!z8) {
                        }
                        if (!z9) {
                        }
                        k2 = (C0140) view.getLayoutParams();
                        if (!k.f7232) {
                        }
                        if (view instanceof VirtualLayout) {
                        }
                        view.measure(i, i2);
                        constraintWidget.f839 = i;
                        constraintWidget.f845 = i2;
                        i3 = 0;
                        constraintWidget.f900 = false;
                        measuredWidth = view.getMeasuredWidth();
                        measuredHeight = view.getMeasuredHeight();
                        int baseline22 = view.getBaseline();
                        if (z) {
                        }
                        if (z2) {
                        }
                        int i152 = constraintWidget.f877;
                        if (i152 > 0) {
                        }
                        i4 = constraintWidget.f829;
                        if (i4 > 0) {
                        }
                        int i162 = constraintWidget.f824;
                        if (i162 > 0) {
                        }
                        i5 = constraintWidget.f894;
                        if (i5 > 0) {
                        }
                        if (!C2108.m5585(ConstraintLayout.this.mOptimizationLevel, 1)) {
                        }
                        if (measuredWidth == max) {
                        }
                        if (measuredWidth != max) {
                        }
                        if (measuredHeight != max2) {
                        }
                        view.measure(i, i2);
                        constraintWidget.f839 = i;
                        constraintWidget.f845 = i2;
                        z3 = false;
                        constraintWidget.f900 = false;
                        measuredWidth2 = view.getMeasuredWidth();
                        measuredHeight2 = view.getMeasuredHeight();
                        baseline = view.getBaseline();
                        if (baseline == -1) {
                        }
                        z3 = true;
                        k.f7228 = z3;
                        if (k2.f1027) {
                        }
                        k.f7228 = true;
                        k.f7227 = measuredWidth2;
                        k.f7233 = measuredHeight2;
                        k.f7235 = z14;
                        k.f7230 = baseline;
                        return;
                    }
                    int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(i7, 1073741824);
                    constraintWidget.f859[2] = i7;
                    i = makeMeasureSpec2;
                    z = false;
                    ordinal = dimensionBehaviour2.ordinal();
                    if (ordinal == 0) {
                    }
                    z2 = false;
                    C2082 r1122 = (C2082) constraintWidget.f867;
                    if (!m565(constraintWidget.f839, i, constraintWidget.m478()) && m565(constraintWidget.f845, i2, constraintWidget.m473())) {
                    }
                    if (dimensionBehaviour == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    }
                    if (dimensionBehaviour2 == ConstraintWidget.DimensionBehaviour.MATCH_CONSTRAINT) {
                    }
                    if (dimensionBehaviour2 != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    }
                    if (dimensionBehaviour != ConstraintWidget.DimensionBehaviour.MATCH_PARENT) {
                    }
                    if (!z8) {
                    }
                    if (!z9) {
                    }
                    k2 = (C0140) view.getLayoutParams();
                    if (!k.f7232) {
                    }
                    if (view instanceof VirtualLayout) {
                    }
                    view.measure(i, i2);
                    constraintWidget.f839 = i;
                    constraintWidget.f845 = i2;
                    i3 = 0;
                    constraintWidget.f900 = false;
                    measuredWidth = view.getMeasuredWidth();
                    measuredHeight = view.getMeasuredHeight();
                    int baseline222 = view.getBaseline();
                    if (z) {
                    }
                    if (z2) {
                    }
                    int i1522 = constraintWidget.f877;
                    if (i1522 > 0) {
                    }
                    i4 = constraintWidget.f829;
                    if (i4 > 0) {
                    }
                    int i1622 = constraintWidget.f824;
                    if (i1622 > 0) {
                    }
                    i5 = constraintWidget.f894;
                    if (i5 > 0) {
                    }
                    if (!C2108.m5585(ConstraintLayout.this.mOptimizationLevel, 1)) {
                    }
                    if (measuredWidth == max) {
                    }
                    if (measuredWidth != max) {
                    }
                    if (measuredHeight != max2) {
                    }
                    view.measure(i, i2);
                    constraintWidget.f839 = i;
                    constraintWidget.f845 = i2;
                    z3 = false;
                    constraintWidget.f900 = false;
                    measuredWidth2 = view.getMeasuredWidth();
                    measuredHeight2 = view.getMeasuredHeight();
                    baseline = view.getBaseline();
                    if (baseline == -1) {
                    }
                    z3 = true;
                    k.f7228 = z3;
                    if (k2.f1027) {
                    }
                    k.f7228 = true;
                    k.f7227 = measuredWidth2;
                    k.f7233 = measuredHeight2;
                    k.f7235 = z14;
                    k.f7230 = baseline;
                    return;
                }
                k.f7227 = 0;
                k.f7233 = 0;
                k.f7230 = 0;
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public final boolean m565(int i, int i2, int i3) {
            if (i == i2) {
                return true;
            }
            int mode = View.MeasureSpec.getMode(i);
            View.MeasureSpec.getSize(i);
            int mode2 = View.MeasureSpec.getMode(i2);
            int size = View.MeasureSpec.getSize(i2);
            if (mode2 != 1073741824) {
                return false;
            }
            if ((mode == Integer.MIN_VALUE || mode == 0) && i3 == size) {
                return true;
            }
            return false;
        }
    }

    /* renamed from: androidx.constraintlayout.widget.ConstraintLayout$K  reason: contains not printable characters */
    public static class C0140 extends ViewGroup.MarginLayoutParams {

        /* renamed from: ʬ  reason: contains not printable characters */
        public float f1006 = -1.0f;

        /* renamed from: Ϸ  reason: contains not printable characters */
        public boolean f1007 = true;

        /* renamed from: В  reason: contains not printable characters */
        public int f1008 = 0;

        /* renamed from: ѷ  reason: contains not printable characters */
        public int f1009 = -1;

        /* renamed from: ӯ  reason: contains not printable characters */
        public boolean f1010 = false;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public int f1011 = 0;

        /* renamed from: Ԛ  reason: contains not printable characters */
        public int f1012 = -1;

        /* renamed from: Ն  reason: contains not printable characters */
        public int f1013;

        /* renamed from: ؿ  reason: contains not printable characters */
        public int f1014 = -1;

        /* renamed from: ڎ  reason: contains not printable characters */
        public float f1015;

        /* renamed from: ݜ  reason: contains not printable characters */
        public int f1016 = -1;

        /* renamed from: ݰ  reason: contains not printable characters */
        public int f1017 = -1;

        /* renamed from: ࠋ  reason: contains not printable characters */
        public int f1018 = -1;

        /* renamed from: ࡔ  reason: contains not printable characters */
        public int f1019 = -1;

        /* renamed from: ಯ  reason: contains not printable characters */
        public int f1020 = 0;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f1021 = -1;

        /* renamed from: ผ  reason: contains not printable characters */
        public boolean f1022 = false;

        /* renamed from: ᆯ  reason: contains not printable characters */
        public float f1023 = -1.0f;

        /* renamed from: ሽ  reason: contains not printable characters */
        public int f1024 = 0;

        /* renamed from: ኩ  reason: contains not printable characters */
        public ConstraintWidget f1025 = new ConstraintWidget();

        /* renamed from: ጒ  reason: contains not printable characters */
        public int f1026 = 0;

        /* renamed from: Ꮝ  reason: contains not printable characters */
        public boolean f1027 = false;

        /* renamed from: ᑓ  reason: contains not printable characters */
        public int f1028 = -1;

        /* renamed from: ᑾ  reason: contains not printable characters */
        public int f1029 = 0;

        /* renamed from: ᓆ  reason: contains not printable characters */
        public int f1030 = -1;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public int f1031 = -1;

        /* renamed from: ᔝ  reason: contains not printable characters */
        public boolean f1032 = false;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public int f1033 = -1;

        /* renamed from: ᝁ  reason: contains not printable characters */
        public float f1034 = -1.0f;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public int f1035 = -1;

        /* renamed from: ᴊ  reason: contains not printable characters */
        public boolean f1036 = false;

        /* renamed from: ᶲ  reason: contains not printable characters */
        public int f1037 = -1;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f1038 = -1;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public int f1039 = -1;

        /* renamed from: ₱  reason: contains not printable characters */
        public int f1040 = -1;

        /* renamed from: K  reason: contains not printable characters */
        public int f1041 = -1;

        /* renamed from: ⶍ  reason: contains not printable characters */
        public int f1042 = 0;

        /* renamed from: ゎ  reason: contains not printable characters */
        public float f1043 = 0.5f;

        /* renamed from: を  reason: contains not printable characters */
        public int f1044 = -1;

        /* renamed from: ト  reason: contains not printable characters */
        public float f1045 = 0.5f;

        /* renamed from: ピ  reason: contains not printable characters */
        public String f1046 = null;

        /* renamed from: 㑃  reason: contains not printable characters */
        public int f1047 = -1;

        /* renamed from: 㒁  reason: contains not printable characters */
        public float f1048 = 1.0f;

        /* renamed from: 㓚  reason: contains not printable characters */
        public boolean f1049 = true;

        /* renamed from: 㗗  reason: contains not printable characters */
        public float f1050 = 0.0f;

        /* renamed from: 㗼  reason: contains not printable characters */
        public int f1051 = -1;

        /* renamed from: 㗽  reason: contains not printable characters */
        public int f1052 = -1;

        /* renamed from: 㗾  reason: contains not printable characters */
        public float f1053 = 0.5f;

        /* renamed from: 㣙  reason: contains not printable characters */
        public int f1054 = -1;

        /* renamed from: 㮔  reason: contains not printable characters */
        public String f1055 = null;

        /* renamed from: 㮝  reason: contains not printable characters */
        public int f1056 = 0;

        /* renamed from: 㱶  reason: contains not printable characters */
        public boolean f1057 = false;

        /* renamed from: 㳨  reason: contains not printable characters */
        public int f1058;

        /* renamed from: 㳳  reason: contains not printable characters */
        public int f1059 = -1;

        /* renamed from: 㴪  reason: contains not printable characters */
        public int f1060 = -1;

        /* renamed from: 㴹  reason: contains not printable characters */
        public int f1061 = -1;

        /* renamed from: 㵟  reason: contains not printable characters */
        public boolean f1062 = false;

        /* renamed from: 㵳  reason: contains not printable characters */
        public boolean f1063;

        /* renamed from: 㶋  reason: contains not printable characters */
        public int f1064 = -1;

        /* renamed from: 㷛  reason: contains not printable characters */
        public float f1065 = 1.0f;

        /* renamed from: 㸾  reason: contains not printable characters */
        public int f1066 = -1;

        /* renamed from: 㹎  reason: contains not printable characters */
        public int f1067 = 0;

        /* renamed from: 㿎  reason: contains not printable characters */
        public int f1068 = -1;

        /* renamed from: 䀟  reason: contains not printable characters */
        public int f1069 = -1;

        /* renamed from: 䁗  reason: contains not printable characters */
        public int f1070 = -1;

        /* renamed from: 䃖  reason: contains not printable characters */
        public int f1071 = 1;

        /* renamed from: androidx.constraintlayout.widget.ConstraintLayout$K$K  reason: contains not printable characters */
        public static class C0141 {

            /* renamed from: K  reason: contains not printable characters */
            public static final SparseIntArray f1072 = new SparseIntArray();

            static {
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintLeft_toLeftOf, 8);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintLeft_toRightOf, 9);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintRight_toLeftOf, 10);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintRight_toRightOf, 11);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintTop_toTopOf, 12);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintTop_toBottomOf, 13);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintBottom_toTopOf, 14);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintBottom_toBottomOf, 15);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintBaseline_toBaselineOf, 16);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintCircle, 2);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintCircleRadius, 3);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintCircleAngle, 4);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_editor_absoluteX, 49);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_editor_absoluteY, 50);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintGuide_begin, 5);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintGuide_end, 6);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintGuide_percent, 7);
                f1072.append(R$styleable.ConstraintLayout_Layout_android_orientation, 1);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintStart_toEndOf, 17);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintStart_toStartOf, 18);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintEnd_toStartOf, 19);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintEnd_toEndOf, 20);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginLeft, 21);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginTop, 22);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginRight, 23);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginBottom, 24);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginStart, 25);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_goneMarginEnd, 26);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHorizontal_bias, 29);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintVertical_bias, 30);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintDimensionRatio, 44);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHorizontal_weight, 45);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintVertical_weight, 46);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHorizontal_chainStyle, 47);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintVertical_chainStyle, 48);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constrainedWidth, 27);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constrainedHeight, 28);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintWidth_default, 31);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHeight_default, 32);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintWidth_min, 33);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintWidth_max, 34);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintWidth_percent, 35);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHeight_min, 36);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHeight_max, 37);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintHeight_percent, 38);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintLeft_creator, 39);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintTop_creator, 40);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintRight_creator, 41);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintBottom_creator, 42);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintBaseline_creator, 43);
                f1072.append(R$styleable.ConstraintLayout_Layout_layout_constraintTag, 51);
            }
        }

        public C0140(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            int i;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ConstraintLayout_Layout);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i2 = 0; i2 < indexCount; i2++) {
                int index = obtainStyledAttributes.getIndex(i2);
                switch (C0141.f1072.get(index)) {
                    case 1:
                        this.f1018 = obtainStyledAttributes.getInt(index, this.f1018);
                        break;
                    case 2:
                        this.f1070 = obtainStyledAttributes.getResourceId(index, this.f1070);
                        if (this.f1070 == -1) {
                            this.f1070 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 3:
                        this.f1011 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1011);
                        break;
                    case 4:
                        this.f1050 = obtainStyledAttributes.getFloat(index, this.f1050) % 360.0f;
                        float f = this.f1050;
                        if (f < 0.0f) {
                            this.f1050 = (360.0f - f) % 360.0f;
                            break;
                        } else {
                            break;
                        }
                    case 5:
                        this.f1041 = obtainStyledAttributes.getDimensionPixelOffset(index, this.f1041);
                        break;
                    case 6:
                        this.f1038 = obtainStyledAttributes.getDimensionPixelOffset(index, this.f1038);
                        break;
                    case 7:
                        this.f1006 = obtainStyledAttributes.getFloat(index, this.f1006);
                        break;
                    case 8:
                        this.f1066 = obtainStyledAttributes.getResourceId(index, this.f1066);
                        if (this.f1066 == -1) {
                            this.f1066 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 9:
                        this.f1021 = obtainStyledAttributes.getResourceId(index, this.f1021);
                        if (this.f1021 == -1) {
                            this.f1021 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 10:
                        this.f1061 = obtainStyledAttributes.getResourceId(index, this.f1061);
                        if (this.f1061 == -1) {
                            this.f1061 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 11:
                        this.f1039 = obtainStyledAttributes.getResourceId(index, this.f1039);
                        if (this.f1039 == -1) {
                            this.f1039 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 12:
                        this.f1068 = obtainStyledAttributes.getResourceId(index, this.f1068);
                        if (this.f1068 == -1) {
                            this.f1068 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 13:
                        this.f1035 = obtainStyledAttributes.getResourceId(index, this.f1035);
                        if (this.f1035 == -1) {
                            this.f1035 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 14:
                        this.f1059 = obtainStyledAttributes.getResourceId(index, this.f1059);
                        if (this.f1059 == -1) {
                            this.f1059 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 15:
                        this.f1033 = obtainStyledAttributes.getResourceId(index, this.f1033);
                        if (this.f1033 == -1) {
                            this.f1033 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 16:
                        this.f1047 = obtainStyledAttributes.getResourceId(index, this.f1047);
                        if (this.f1047 == -1) {
                            this.f1047 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 17:
                        this.f1014 = obtainStyledAttributes.getResourceId(index, this.f1014);
                        if (this.f1014 == -1) {
                            this.f1014 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 18:
                        this.f1031 = obtainStyledAttributes.getResourceId(index, this.f1031);
                        if (this.f1031 == -1) {
                            this.f1031 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 19:
                        this.f1052 = obtainStyledAttributes.getResourceId(index, this.f1052);
                        if (this.f1052 == -1) {
                            this.f1052 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 20:
                        this.f1016 = obtainStyledAttributes.getResourceId(index, this.f1016);
                        if (this.f1016 == -1) {
                            this.f1016 = obtainStyledAttributes.getInt(index, -1);
                            break;
                        } else {
                            break;
                        }
                    case 21:
                        this.f1069 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1069);
                        break;
                    case 22:
                        this.f1012 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1012);
                        break;
                    case 23:
                        this.f1064 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1064);
                        break;
                    case 24:
                        this.f1030 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1030);
                        break;
                    case 25:
                        this.f1060 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1060);
                        break;
                    case 26:
                        this.f1028 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1028);
                        break;
                    case 27:
                        this.f1022 = obtainStyledAttributes.getBoolean(index, this.f1022);
                        break;
                    case 28:
                        this.f1057 = obtainStyledAttributes.getBoolean(index, this.f1057);
                        break;
                    case 29:
                        this.f1043 = obtainStyledAttributes.getFloat(index, this.f1043);
                        break;
                    case 30:
                        this.f1045 = obtainStyledAttributes.getFloat(index, this.f1045);
                        break;
                    case 31:
                        this.f1029 = obtainStyledAttributes.getInt(index, 0);
                        if (this.f1029 == 1) {
                            Log.e(ConstraintLayout.TAG, "layout_constraintWidth_default=\"wrap\" is deprecated.\nUse layout_width=\"WRAP_CONTENT\" and layout_constrainedWidth=\"true\" instead.");
                            break;
                        } else {
                            break;
                        }
                    case 32:
                        this.f1008 = obtainStyledAttributes.getInt(index, 0);
                        if (this.f1008 == 1) {
                            Log.e(ConstraintLayout.TAG, "layout_constraintHeight_default=\"wrap\" is deprecated.\nUse layout_height=\"WRAP_CONTENT\" and layout_constrainedHeight=\"true\" instead.");
                            break;
                        } else {
                            break;
                        }
                    case 33:
                        try {
                            this.f1056 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1056);
                            break;
                        } catch (Exception unused) {
                            if (obtainStyledAttributes.getInt(index, this.f1056) == -2) {
                                this.f1056 = -2;
                                break;
                            } else {
                                break;
                            }
                        }
                    case 34:
                        try {
                            this.f1026 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1026);
                            break;
                        } catch (Exception unused2) {
                            if (obtainStyledAttributes.getInt(index, this.f1026) == -2) {
                                this.f1026 = -2;
                                break;
                            } else {
                                break;
                            }
                        }
                    case 35:
                        this.f1048 = Math.max(0.0f, obtainStyledAttributes.getFloat(index, this.f1048));
                        this.f1029 = 2;
                        break;
                    case 36:
                        try {
                            this.f1020 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1020);
                            break;
                        } catch (Exception unused3) {
                            if (obtainStyledAttributes.getInt(index, this.f1020) == -2) {
                                this.f1020 = -2;
                                break;
                            } else {
                                break;
                            }
                        }
                    case 37:
                        try {
                            this.f1067 = obtainStyledAttributes.getDimensionPixelSize(index, this.f1067);
                            break;
                        } catch (Exception unused4) {
                            if (obtainStyledAttributes.getInt(index, this.f1067) == -2) {
                                this.f1067 = -2;
                                break;
                            } else {
                                break;
                            }
                        }
                    case 38:
                        this.f1065 = Math.max(0.0f, obtainStyledAttributes.getFloat(index, this.f1065));
                        this.f1008 = 2;
                        break;
                    case 44:
                        this.f1055 = obtainStyledAttributes.getString(index);
                        this.f1071 = -1;
                        String str = this.f1055;
                        if (str != null) {
                            int length = str.length();
                            int indexOf = this.f1055.indexOf(44);
                            if (indexOf <= 0 || indexOf >= length - 1) {
                                i = 0;
                            } else {
                                String substring = this.f1055.substring(0, indexOf);
                                if (substring.equalsIgnoreCase("W")) {
                                    this.f1071 = 0;
                                } else if (substring.equalsIgnoreCase("H")) {
                                    this.f1071 = 1;
                                }
                                i = indexOf + 1;
                            }
                            int indexOf2 = this.f1055.indexOf(58);
                            if (indexOf2 < 0 || indexOf2 >= length - 1) {
                                String substring2 = this.f1055.substring(i);
                                if (substring2.length() > 0) {
                                    Float.parseFloat(substring2);
                                    break;
                                } else {
                                    break;
                                }
                            } else {
                                String substring3 = this.f1055.substring(i, indexOf2);
                                String substring4 = this.f1055.substring(indexOf2 + 1);
                                if (substring3.length() > 0 && substring4.length() > 0) {
                                    try {
                                        float parseFloat = Float.parseFloat(substring3);
                                        float parseFloat2 = Float.parseFloat(substring4);
                                        if (parseFloat > 0.0f && parseFloat2 > 0.0f) {
                                            if (this.f1071 == 1) {
                                                Math.abs(parseFloat2 / parseFloat);
                                                break;
                                            } else {
                                                Math.abs(parseFloat / parseFloat2);
                                                break;
                                            }
                                        }
                                    } catch (NumberFormatException unused5) {
                                        break;
                                    }
                                }
                            }
                        } else {
                            break;
                        }
                        break;
                    case 45:
                        this.f1034 = obtainStyledAttributes.getFloat(index, this.f1034);
                        break;
                    case 46:
                        this.f1023 = obtainStyledAttributes.getFloat(index, this.f1023);
                        break;
                    case 47:
                        this.f1042 = obtainStyledAttributes.getInt(index, 0);
                        break;
                    case 48:
                        this.f1024 = obtainStyledAttributes.getInt(index, 0);
                        break;
                    case 49:
                        this.f1009 = obtainStyledAttributes.getDimensionPixelOffset(index, this.f1009);
                        break;
                    case 50:
                        this.f1037 = obtainStyledAttributes.getDimensionPixelOffset(index, this.f1037);
                        break;
                    case 51:
                        this.f1046 = obtainStyledAttributes.getString(index);
                        break;
                }
            }
            obtainStyledAttributes.recycle();
            m566();
        }

        /* JADX WARNING: Removed duplicated region for block: B:15:0x004e  */
        /* JADX WARNING: Removed duplicated region for block: B:18:0x0055  */
        /* JADX WARNING: Removed duplicated region for block: B:21:0x005c  */
        /* JADX WARNING: Removed duplicated region for block: B:24:0x0062  */
        /* JADX WARNING: Removed duplicated region for block: B:27:0x0068  */
        /* JADX WARNING: Removed duplicated region for block: B:34:0x007e  */
        /* JADX WARNING: Removed duplicated region for block: B:35:0x0086  */
        @TargetApi(17)
        public void resolveLayoutDirection(int i) {
            int i2;
            int i3;
            int i4;
            int i5;
            float f;
            int i6 = ((ViewGroup.MarginLayoutParams) this).leftMargin;
            int i7 = ((ViewGroup.MarginLayoutParams) this).rightMargin;
            int i8 = Build.VERSION.SDK_INT;
            super.resolveLayoutDirection(i);
            boolean z = false;
            boolean z2 = 1 == getLayoutDirection();
            this.f1017 = -1;
            this.f1044 = -1;
            this.f1051 = -1;
            this.f1040 = -1;
            this.f1054 = -1;
            this.f1019 = -1;
            this.f1054 = this.f1069;
            this.f1019 = this.f1064;
            this.f1053 = this.f1043;
            this.f1058 = this.f1041;
            this.f1013 = this.f1038;
            this.f1015 = this.f1006;
            if (z2) {
                int i9 = this.f1014;
                if (i9 != -1) {
                    this.f1017 = i9;
                } else {
                    int i10 = this.f1031;
                    if (i10 != -1) {
                        this.f1044 = i10;
                    }
                    i2 = this.f1052;
                    if (i2 != -1) {
                        this.f1040 = i2;
                        z = true;
                    }
                    i3 = this.f1016;
                    if (i3 != -1) {
                        this.f1051 = i3;
                        z = true;
                    }
                    i4 = this.f1060;
                    if (i4 != -1) {
                        this.f1019 = i4;
                    }
                    i5 = this.f1028;
                    if (i5 != -1) {
                        this.f1054 = i5;
                    }
                    if (z) {
                        this.f1053 = 1.0f - this.f1043;
                    }
                    if (this.f1036 && this.f1018 == 1) {
                        f = this.f1006;
                        if (f == -1.0f) {
                            this.f1015 = 1.0f - f;
                            this.f1058 = -1;
                            this.f1013 = -1;
                        } else {
                            int i11 = this.f1041;
                            if (i11 != -1) {
                                this.f1013 = i11;
                                this.f1058 = -1;
                                this.f1015 = -1.0f;
                            } else {
                                int i12 = this.f1038;
                                if (i12 != -1) {
                                    this.f1058 = i12;
                                    this.f1013 = -1;
                                    this.f1015 = -1.0f;
                                }
                            }
                        }
                    }
                }
                z = true;
                i2 = this.f1052;
                if (i2 != -1) {
                }
                i3 = this.f1016;
                if (i3 != -1) {
                }
                i4 = this.f1060;
                if (i4 != -1) {
                }
                i5 = this.f1028;
                if (i5 != -1) {
                }
                if (z) {
                }
                f = this.f1006;
                if (f == -1.0f) {
                }
            } else {
                int i13 = this.f1014;
                if (i13 != -1) {
                    this.f1040 = i13;
                }
                int i14 = this.f1031;
                if (i14 != -1) {
                    this.f1051 = i14;
                }
                int i15 = this.f1052;
                if (i15 != -1) {
                    this.f1017 = i15;
                }
                int i16 = this.f1016;
                if (i16 != -1) {
                    this.f1044 = i16;
                }
                int i17 = this.f1060;
                if (i17 != -1) {
                    this.f1054 = i17;
                }
                int i18 = this.f1028;
                if (i18 != -1) {
                    this.f1019 = i18;
                }
            }
            if (this.f1052 == -1 && this.f1016 == -1 && this.f1031 == -1 && this.f1014 == -1) {
                int i19 = this.f1061;
                if (i19 != -1) {
                    this.f1017 = i19;
                    if (((ViewGroup.MarginLayoutParams) this).rightMargin <= 0 && i7 > 0) {
                        ((ViewGroup.MarginLayoutParams) this).rightMargin = i7;
                    }
                } else {
                    int i20 = this.f1039;
                    if (i20 != -1) {
                        this.f1044 = i20;
                        if (((ViewGroup.MarginLayoutParams) this).rightMargin <= 0 && i7 > 0) {
                            ((ViewGroup.MarginLayoutParams) this).rightMargin = i7;
                        }
                    }
                }
                int i21 = this.f1066;
                if (i21 != -1) {
                    this.f1051 = i21;
                    if (((ViewGroup.MarginLayoutParams) this).leftMargin <= 0 && i6 > 0) {
                        ((ViewGroup.MarginLayoutParams) this).leftMargin = i6;
                        return;
                    }
                    return;
                }
                int i22 = this.f1021;
                if (i22 != -1) {
                    this.f1040 = i22;
                    if (((ViewGroup.MarginLayoutParams) this).leftMargin <= 0 && i6 > 0) {
                        ((ViewGroup.MarginLayoutParams) this).leftMargin = i6;
                    }
                }
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m566() {
            this.f1036 = false;
            this.f1049 = true;
            this.f1007 = true;
            if (((ViewGroup.MarginLayoutParams) this).width == -2 && this.f1022) {
                this.f1049 = false;
                if (this.f1029 == 0) {
                    this.f1029 = 1;
                }
            }
            if (((ViewGroup.MarginLayoutParams) this).height == -2 && this.f1057) {
                this.f1007 = false;
                if (this.f1008 == 0) {
                    this.f1008 = 1;
                }
            }
            if (((ViewGroup.MarginLayoutParams) this).width == 0 || ((ViewGroup.MarginLayoutParams) this).width == -1) {
                this.f1049 = false;
                if (((ViewGroup.MarginLayoutParams) this).width == 0 && this.f1029 == 1) {
                    ((ViewGroup.MarginLayoutParams) this).width = -2;
                    this.f1022 = true;
                }
            }
            if (((ViewGroup.MarginLayoutParams) this).height == 0 || ((ViewGroup.MarginLayoutParams) this).height == -1) {
                this.f1007 = false;
                if (((ViewGroup.MarginLayoutParams) this).height == 0 && this.f1008 == 1) {
                    ((ViewGroup.MarginLayoutParams) this).height = -2;
                    this.f1057 = true;
                }
            }
            if (this.f1006 != -1.0f || this.f1041 != -1 || this.f1038 != -1) {
                this.f1036 = true;
                this.f1049 = true;
                this.f1007 = true;
                if (!(this.f1025 instanceof C2083)) {
                    this.f1025 = new C2083();
                }
                ((C2083) this.f1025).m5483(this.f1018);
            }
        }

        public C0140(int i, int i2) {
            super(i, i2);
        }

        public C0140(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }
}
