package androidx.constraintlayout.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.util.TypedValue;
import android.util.Xml;
import android.view.View;
import com.google.android.material.progressindicator.BaseProgressIndicator;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParser;
import ඓ.K.K.K.C1293;
import K.K.K.ʬ.C2369;

public class ConstraintAttribute {

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f982;

    /* renamed from: ඓ  reason: contains not printable characters */
    public String f983;

    /* renamed from: ῲ  reason: contains not printable characters */
    public AttributeType f984;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f985;

    /* renamed from: K  reason: contains not printable characters */
    public String f986;

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f987;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f988;

    public enum AttributeType {
        INT_TYPE,
        FLOAT_TYPE,
        COLOR_TYPE,
        COLOR_DRAWABLE_TYPE,
        STRING_TYPE,
        BOOLEAN_TYPE,
        DIMENSION_TYPE
    }

    public ConstraintAttribute(String str, AttributeType attributeType, Object obj) {
        this.f986 = str;
        this.f984 = attributeType;
        m546(obj);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static int m540(int i) {
        int i2 = (i & (~(i >> 31))) - 255;
        return (i2 & (i2 >> 31)) + BaseProgressIndicator.MAX_ALPHA;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public int m543() {
        int ordinal = this.f984.ordinal();
        return (ordinal == 2 || ordinal == 3) ? 4 : 1;
    }

    /* renamed from: K  reason: contains not printable characters */
    public float m544() {
        switch (this.f984.ordinal()) {
            case 0:
                return (float) this.f982;
            case 1:
                return this.f988;
            case 2:
            case 3:
                throw new RuntimeException("Color does not have a single color to interpolate");
            case 4:
                throw new RuntimeException("Cannot interpolate String");
            case 5:
                return this.f987 ? 1.0f : 0.0f;
            case 6:
                return this.f988;
            default:
                return Float.NaN;
        }
    }

    public ConstraintAttribute(ConstraintAttribute constraintAttribute, Object obj) {
        this.f986 = constraintAttribute.f986;
        this.f984 = constraintAttribute.f984;
        m546(obj);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m547(float[] fArr) {
        switch (this.f984.ordinal()) {
            case 0:
                fArr[0] = (float) this.f982;
                return;
            case 1:
                fArr[0] = this.f988;
                return;
            case 2:
            case 3:
                int i = this.f985;
                int i2 = (i >> 24) & BaseProgressIndicator.MAX_ALPHA;
                int i3 = (i >> 16) & BaseProgressIndicator.MAX_ALPHA;
                int i4 = (i >> 8) & BaseProgressIndicator.MAX_ALPHA;
                int i5 = i & BaseProgressIndicator.MAX_ALPHA;
                float pow = (float) Math.pow((double) (((float) i3) / 255.0f), 2.2d);
                float pow2 = (float) Math.pow((double) (((float) i4) / 255.0f), 2.2d);
                fArr[0] = pow;
                fArr[1] = pow2;
                fArr[2] = (float) Math.pow((double) (((float) i5) / 255.0f), 2.2d);
                fArr[3] = ((float) i2) / 255.0f;
                return;
            case 4:
                throw new RuntimeException("Color does not have a single color to interpolate");
            case 5:
                fArr[0] = this.f987 ? 1.0f : 0.0f;
                return;
            case 6:
                fArr[0] = this.f988;
                return;
            default:
                return;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m546(Object obj) {
        switch (this.f984.ordinal()) {
            case 0:
                this.f982 = ((Integer) obj).intValue();
                return;
            case 1:
                this.f988 = ((Float) obj).floatValue();
                return;
            case 2:
            case 3:
                this.f985 = ((Integer) obj).intValue();
                return;
            case 4:
                this.f983 = (String) obj;
                return;
            case 5:
                this.f987 = ((Boolean) obj).booleanValue();
                return;
            case 6:
                this.f988 = ((Float) obj).floatValue();
                return;
            default:
                return;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m542(View view, HashMap<String, ConstraintAttribute> hashMap) {
        Class<?> cls = view.getClass();
        for (String str : hashMap.keySet()) {
            ConstraintAttribute constraintAttribute = hashMap.get(str);
            String r7 = C1293.m3412("set", str);
            try {
                switch (constraintAttribute.f984.ordinal()) {
                    case 0:
                        cls.getMethod(r7, Integer.TYPE).invoke(view, Integer.valueOf(constraintAttribute.f982));
                        continue;
                    case 1:
                        cls.getMethod(r7, Float.TYPE).invoke(view, Float.valueOf(constraintAttribute.f988));
                        continue;
                    case 2:
                        cls.getMethod(r7, Integer.TYPE).invoke(view, Integer.valueOf(constraintAttribute.f985));
                        continue;
                    case 3:
                        Method method = cls.getMethod(r7, Drawable.class);
                        ColorDrawable colorDrawable = new ColorDrawable();
                        colorDrawable.setColor(constraintAttribute.f985);
                        method.invoke(view, colorDrawable);
                        continue;
                    case 4:
                        cls.getMethod(r7, CharSequence.class).invoke(view, constraintAttribute.f983);
                        continue;
                    case 5:
                        cls.getMethod(r7, Boolean.TYPE).invoke(view, Boolean.valueOf(constraintAttribute.f987));
                        continue;
                    case 6:
                        cls.getMethod(r7, Float.TYPE).invoke(view, Float.valueOf(constraintAttribute.f988));
                        continue;
                    default:
                        continue;
                }
            } catch (NoSuchMethodException e) {
                Log.e("TransitionLayout", e.getMessage());
                Log.e("TransitionLayout", " Custom Attribute \"" + str + "\" not found on " + cls.getName());
                StringBuilder sb = new StringBuilder();
                sb.append(cls.getName());
                sb.append(" must have a method ");
                sb.append(r7);
                Log.e("TransitionLayout", sb.toString());
            } catch (IllegalAccessException e2) {
                Log.e("TransitionLayout", " Custom Attribute \"" + str + "\" not found on " + cls.getName());
                e2.printStackTrace();
            } catch (InvocationTargetException e3) {
                Log.e("TransitionLayout", " Custom Attribute \"" + str + "\" not found on " + cls.getName());
                e3.printStackTrace();
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m545(View view, float[] fArr) {
        Class<?> cls = view.getClass();
        StringBuilder r6 = C1293.m3416("set");
        r6.append(this.f986);
        String sb = r6.toString();
        try {
            boolean z = true;
            switch (this.f984.ordinal()) {
                case 0:
                    cls.getMethod(sb, Integer.TYPE).invoke(view, Integer.valueOf((int) fArr[0]));
                    return;
                case 1:
                    cls.getMethod(sb, Float.TYPE).invoke(view, Float.valueOf(fArr[0]));
                    return;
                case 2:
                    Method method = cls.getMethod(sb, Integer.TYPE);
                    int r7 = m540((int) (((float) Math.pow((double) fArr[0], 0.45454545454545453d)) * 255.0f));
                    int r8 = m540((int) (((float) Math.pow((double) fArr[1], 0.45454545454545453d)) * 255.0f));
                    method.invoke(view, Integer.valueOf((r7 << 16) | (m540((int) (fArr[3] * 255.0f)) << 24) | (r8 << 8) | m540((int) (((float) Math.pow((double) fArr[2], 0.45454545454545453d)) * 255.0f))));
                    return;
                case 3:
                    Method method2 = cls.getMethod(sb, Drawable.class);
                    int r72 = m540((int) (((float) Math.pow((double) fArr[0], 0.45454545454545453d)) * 255.0f));
                    int r13 = m540((int) (((float) Math.pow((double) fArr[1], 0.45454545454545453d)) * 255.0f));
                    ColorDrawable colorDrawable = new ColorDrawable();
                    colorDrawable.setColor((r72 << 16) | (m540((int) (fArr[3] * 255.0f)) << 24) | (r13 << 8) | m540((int) (((float) Math.pow((double) fArr[2], 0.45454545454545453d)) * 255.0f)));
                    method2.invoke(view, colorDrawable);
                    return;
                case 4:
                    throw new RuntimeException("unable to interpolate strings " + this.f986);
                case 5:
                    Method method3 = cls.getMethod(sb, Boolean.TYPE);
                    Object[] objArr = new Object[1];
                    if (fArr[0] <= 0.5f) {
                        z = false;
                    }
                    objArr[0] = Boolean.valueOf(z);
                    method3.invoke(view, objArr);
                    return;
                case 6:
                    cls.getMethod(sb, Float.TYPE).invoke(view, Float.valueOf(fArr[0]));
                    return;
                default:
                    return;
            }
        } catch (NoSuchMethodException e) {
            Log.e("TransitionLayout", "no method " + sb + "on View \"" + C2369.m6316(view) + "\"");
            e.printStackTrace();
        } catch (IllegalAccessException e2) {
            Log.e("TransitionLayout", "cannot access method " + sb + "on View \"" + C2369.m6316(view) + "\"");
            e2.printStackTrace();
        } catch (InvocationTargetException e3) {
            e3.printStackTrace();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m541(Context context, XmlPullParser xmlPullParser, HashMap<String, ConstraintAttribute> hashMap) {
        AttributeType attributeType;
        Object string;
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(Xml.asAttributeSet(xmlPullParser), R$styleable.CustomAttribute);
        int indexCount = obtainStyledAttributes.getIndexCount();
        String str = null;
        Object obj = null;
        AttributeType attributeType2 = null;
        for (int i = 0; i < indexCount; i++) {
            int index = obtainStyledAttributes.getIndex(i);
            if (index == R$styleable.CustomAttribute_attributeName) {
                str = obtainStyledAttributes.getString(index);
                if (str != null && str.length() > 0) {
                    str = Character.toUpperCase(str.charAt(0)) + str.substring(1);
                }
            } else if (index == R$styleable.CustomAttribute_customBoolean) {
                obj = Boolean.valueOf(obtainStyledAttributes.getBoolean(index, false));
                attributeType2 = AttributeType.BOOLEAN_TYPE;
            } else {
                if (index == R$styleable.CustomAttribute_customColorValue) {
                    attributeType = AttributeType.COLOR_TYPE;
                    string = Integer.valueOf(obtainStyledAttributes.getColor(index, 0));
                } else if (index == R$styleable.CustomAttribute_customColorDrawableValue) {
                    attributeType = AttributeType.COLOR_DRAWABLE_TYPE;
                    string = Integer.valueOf(obtainStyledAttributes.getColor(index, 0));
                } else if (index == R$styleable.CustomAttribute_customPixelDimension) {
                    attributeType = AttributeType.DIMENSION_TYPE;
                    string = Float.valueOf(TypedValue.applyDimension(1, obtainStyledAttributes.getDimension(index, 0.0f), context.getResources().getDisplayMetrics()));
                } else if (index == R$styleable.CustomAttribute_customDimension) {
                    attributeType = AttributeType.DIMENSION_TYPE;
                    string = Float.valueOf(obtainStyledAttributes.getDimension(index, 0.0f));
                } else if (index == R$styleable.CustomAttribute_customFloatValue) {
                    attributeType = AttributeType.FLOAT_TYPE;
                    string = Float.valueOf(obtainStyledAttributes.getFloat(index, Float.NaN));
                } else if (index == R$styleable.CustomAttribute_customIntegerValue) {
                    attributeType = AttributeType.INT_TYPE;
                    string = Integer.valueOf(obtainStyledAttributes.getInteger(index, -1));
                } else if (index == R$styleable.CustomAttribute_customStringValue) {
                    attributeType = AttributeType.STRING_TYPE;
                    string = obtainStyledAttributes.getString(index);
                }
                attributeType2 = attributeType;
                obj = string;
            }
        }
        if (!(str == null || obj == null)) {
            hashMap.put(str, new ConstraintAttribute(str, attributeType2, obj));
        }
        obtainStyledAttributes.recycle();
    }
}
