package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.AttributeSet;
import android.view.ViewParent;
import androidx.constraintlayout.motion.widget.MotionLayout;
import androidx.constraintlayout.widget.R$styleable;

public class MotionTelltales extends MockView {

    /* renamed from: Ԕ  reason: contains not printable characters */
    public MotionLayout f972;

    /* renamed from: ؿ  reason: contains not printable characters */
    public Matrix f973;

    /* renamed from: ݜ  reason: contains not printable characters */
    public float f974;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public int f975;

    /* renamed from: 㗗  reason: contains not printable characters */
    public float[] f976;

    /* renamed from: 㗽  reason: contains not printable characters */
    public int f977;

    /* renamed from: 䁗  reason: contains not printable characters */
    public Paint f978;

    public MotionTelltales(Context context) {
        super(context);
        this.f978 = new Paint();
        this.f976 = new float[2];
        this.f973 = new Matrix();
        this.f975 = 0;
        this.f977 = -65281;
        this.f974 = 0.25f;
        m534(context, null);
    }

    @Override // androidx.constraintlayout.utils.widget.MockView
    /* renamed from: K  reason: contains not printable characters */
    private void m534(Context context, AttributeSet attributeSet) {
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.MotionTelltales);
            int indexCount = obtainStyledAttributes.getIndexCount();
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.MotionTelltales_telltales_tailColor) {
                    this.f977 = obtainStyledAttributes.getColor(index, this.f977);
                } else if (index == R$styleable.MotionTelltales_telltales_velocityMode) {
                    this.f975 = obtainStyledAttributes.getInt(index, this.f975);
                } else if (index == R$styleable.MotionTelltales_telltales_tailScale) {
                    this.f974 = obtainStyledAttributes.getFloat(index, this.f974);
                }
            }
            obtainStyledAttributes.recycle();
        }
        this.f978.setColor(this.f977);
        this.f978.setStrokeWidth(5.0f);
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
    }

    @Override // androidx.constraintlayout.utils.widget.MockView
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        getMatrix().invert(this.f973);
        if (this.f972 == null) {
            ViewParent parent = getParent();
            if (parent instanceof MotionLayout) {
                this.f972 = (MotionLayout) parent;
                return;
            }
            return;
        }
        int width = getWidth();
        int height = getHeight();
        float[] fArr = {0.1f, 0.25f, 0.5f, 0.75f, 0.9f};
        for (float f : fArr) {
            for (float f2 : fArr) {
                this.f972.m421(this, f2, f, this.f976, this.f975);
                this.f973.mapVectors(this.f976);
                float f3 = ((float) width) * f2;
                float f4 = ((float) height) * f;
                float[] fArr2 = this.f976;
                float f5 = fArr2[0];
                float f6 = this.f974;
                float f7 = f4 - (fArr2[1] * f6);
                this.f973.mapVectors(fArr2);
                canvas.drawLine(f3, f4, f3 - (f5 * f6), f7, this.f978);
            }
        }
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        postInvalidate();
    }

    public void setText(CharSequence charSequence) {
        this.f966 = charSequence.toString();
        requestLayout();
    }

    public MotionTelltales(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f978 = new Paint();
        this.f976 = new float[2];
        this.f973 = new Matrix();
        this.f975 = 0;
        this.f977 = -65281;
        this.f974 = 0.25f;
        m534(context, attributeSet);
    }

    public MotionTelltales(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f978 = new Paint();
        this.f976 = new float[2];
        this.f973 = new Matrix();
        this.f975 = 0;
        this.f977 = -65281;
        this.f974 = 0.25f;
        m534(context, attributeSet);
    }
}
