package androidx.constraintlayout.utils.widget;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Outline;
import android.graphics.Path;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewOutlineProvider;
import androidx.appcompat.widget.AppCompatImageButton;
import androidx.constraintlayout.utils.widget.ImageFilterView;
import androidx.constraintlayout.widget.R$styleable;

public class ImageFilterButton extends AppCompatImageButton {

    /* renamed from: ʬ  reason: contains not printable characters */
    public float f930 = 0.0f;

    /* renamed from: ඓ  reason: contains not printable characters */
    public float f931 = Float.NaN;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f932 = true;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public Drawable[] f933;

    /* renamed from: ῲ  reason: contains not printable characters */
    public ImageFilterView.C0136 f934 = new ImageFilterView.C0136();

    /* renamed from: ⁱ  reason: contains not printable characters */
    public ViewOutlineProvider f935;

    /* renamed from: 㳳  reason: contains not printable characters */
    public LayerDrawable f936;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Path f937;

    /* renamed from: 㸾  reason: contains not printable characters */
    public float f938 = 0.0f;

    /* renamed from: 㿎  reason: contains not printable characters */
    public RectF f939;

    /* renamed from: androidx.constraintlayout.utils.widget.ImageFilterButton$ῲ  reason: contains not printable characters */
    public class C0134 extends ViewOutlineProvider {
        public C0134() {
        }

        public void getOutline(View view, Outline outline) {
            outline.setRoundRect(0, 0, ImageFilterButton.this.getWidth(), ImageFilterButton.this.getHeight(), ImageFilterButton.this.f931);
        }
    }

    /* renamed from: androidx.constraintlayout.utils.widget.ImageFilterButton$K  reason: contains not printable characters */
    public class C0135 extends ViewOutlineProvider {
        public C0135() {
        }

        public void getOutline(View view, Outline outline) {
            int width = ImageFilterButton.this.getWidth();
            int height = ImageFilterButton.this.getHeight();
            outline.setRoundRect(0, 0, width, height, (((float) Math.min(width, height)) * ImageFilterButton.this.f938) / 2.0f);
        }
    }

    public ImageFilterButton(Context context) {
        super(context);
        m530(null);
    }

    private void setOverlay(boolean z) {
        this.f932 = z;
    }

    public void draw(Canvas canvas) {
        int i = Build.VERSION.SDK_INT;
        super.draw(canvas);
        if (0 != 0) {
            canvas.restore();
        }
    }

    public float getContrast() {
        return this.f934.f957;
    }

    public float getCrossfade() {
        return this.f930;
    }

    public float getRound() {
        return this.f931;
    }

    public float getRoundPercent() {
        return this.f938;
    }

    public float getSaturation() {
        return this.f934.f953;
    }

    public float getWarmth() {
        return this.f934.f955;
    }

    public void setBrightness(float f) {
        ImageFilterView.C0136 r0 = this.f934;
        r0.f958 = f;
        r0.m532(this);
    }

    public void setContrast(float f) {
        ImageFilterView.C0136 r0 = this.f934;
        r0.f957 = f;
        r0.m532(this);
    }

    public void setCrossfade(float f) {
        this.f930 = f;
        if (this.f933 != null) {
            if (!this.f932) {
                this.f936.getDrawable(0).setAlpha((int) ((1.0f - this.f930) * 255.0f));
            }
            this.f936.getDrawable(1).setAlpha((int) (this.f930 * 255.0f));
            super.setImageDrawable(this.f936);
        }
    }

    public void setRound(float f) {
        if (Float.isNaN(f)) {
            this.f931 = f;
            float f2 = this.f938;
            this.f938 = -1.0f;
            setRoundPercent(f2);
            return;
        }
        boolean z = this.f931 != f;
        this.f931 = f;
        if (this.f931 != 0.0f) {
            if (this.f937 == null) {
                this.f937 = new Path();
            }
            if (this.f939 == null) {
                this.f939 = new RectF();
            }
            int i = Build.VERSION.SDK_INT;
            if (this.f935 == null) {
                this.f935 = new C0134();
                setOutlineProvider(this.f935);
            }
            setClipToOutline(true);
            this.f939.set(0.0f, 0.0f, (float) getWidth(), (float) getHeight());
            this.f937.reset();
            Path path = this.f937;
            RectF rectF = this.f939;
            float f3 = this.f931;
            path.addRoundRect(rectF, f3, f3, Path.Direction.CW);
        } else {
            int i2 = Build.VERSION.SDK_INT;
            setClipToOutline(false);
        }
        if (z) {
            int i3 = Build.VERSION.SDK_INT;
            invalidateOutline();
        }
    }

    public void setRoundPercent(float f) {
        boolean z = this.f938 != f;
        this.f938 = f;
        if (this.f938 != 0.0f) {
            if (this.f937 == null) {
                this.f937 = new Path();
            }
            if (this.f939 == null) {
                this.f939 = new RectF();
            }
            int i = Build.VERSION.SDK_INT;
            if (this.f935 == null) {
                this.f935 = new C0135();
                setOutlineProvider(this.f935);
            }
            setClipToOutline(true);
            int width = getWidth();
            int height = getHeight();
            float min = (((float) Math.min(width, height)) * this.f938) / 2.0f;
            this.f939.set(0.0f, 0.0f, (float) width, (float) height);
            this.f937.reset();
            this.f937.addRoundRect(this.f939, min, min, Path.Direction.CW);
        } else {
            int i2 = Build.VERSION.SDK_INT;
            setClipToOutline(false);
        }
        if (z) {
            int i3 = Build.VERSION.SDK_INT;
            invalidateOutline();
        }
    }

    public void setSaturation(float f) {
        ImageFilterView.C0136 r0 = this.f934;
        r0.f953 = f;
        r0.m532(this);
    }

    public void setWarmth(float f) {
        ImageFilterView.C0136 r0 = this.f934;
        r0.f955 = f;
        r0.m532(this);
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m530(AttributeSet attributeSet) {
        setPadding(0, 0, 0, 0);
        if (attributeSet != null) {
            TypedArray obtainStyledAttributes = getContext().obtainStyledAttributes(attributeSet, R$styleable.ImageFilterView);
            int indexCount = obtainStyledAttributes.getIndexCount();
            Drawable drawable = obtainStyledAttributes.getDrawable(R$styleable.ImageFilterView_altSrc);
            for (int i = 0; i < indexCount; i++) {
                int index = obtainStyledAttributes.getIndex(i);
                if (index == R$styleable.ImageFilterView_crossfade) {
                    this.f930 = obtainStyledAttributes.getFloat(index, 0.0f);
                } else if (index == R$styleable.ImageFilterView_warmth) {
                    setWarmth(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_saturation) {
                    setSaturation(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_contrast) {
                    setContrast(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_round) {
                    int i2 = Build.VERSION.SDK_INT;
                    setRound(obtainStyledAttributes.getDimension(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_roundPercent) {
                    int i3 = Build.VERSION.SDK_INT;
                    setRoundPercent(obtainStyledAttributes.getFloat(index, 0.0f));
                } else if (index == R$styleable.ImageFilterView_overlay) {
                    setOverlay(obtainStyledAttributes.getBoolean(index, this.f932));
                }
            }
            obtainStyledAttributes.recycle();
            if (drawable != null) {
                this.f933 = new Drawable[2];
                this.f933[0] = getDrawable();
                Drawable[] drawableArr = this.f933;
                drawableArr[1] = drawable;
                this.f936 = new LayerDrawable(drawableArr);
                this.f936.getDrawable(1).setAlpha((int) (this.f930 * 255.0f));
                super.setImageDrawable(this.f936);
            }
        }
    }

    public ImageFilterButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        m530(attributeSet);
    }

    public ImageFilterButton(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        m530(attributeSet);
    }
}
