package androidx.constraintlayout.solver.widgets;

import androidx.constraintlayout.solver.SolverVariable;
import com.facebook.internal.security.CertificateUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import ῲ.ⁱ.ῲ.㿎.C2083;
import ῲ.ⁱ.ῲ.㿎.ᕣ.C2098;
import K.K.K.ʬ.C2369;

public class ConstraintAnchor {

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean f806;

    /* renamed from: ඓ  reason: contains not printable characters */
    public final Type f807;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public SolverVariable f808;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f809;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f810 = 0;

    /* renamed from: K  reason: contains not printable characters */
    public HashSet<ConstraintAnchor> f811 = null;

    /* renamed from: 㴹  reason: contains not printable characters */
    public ConstraintAnchor f812;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final ConstraintWidget f813;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f814 = -1;

    public enum Type {
        NONE,
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE,
        CENTER,
        CENTER_X,
        CENTER_Y
    }

    public ConstraintAnchor(ConstraintWidget constraintWidget, Type type) {
        this.f813 = constraintWidget;
        this.f807 = type;
    }

    public String toString() {
        return this.f813.f893 + CertificateUtil.DELIMITER + this.f807.toString();
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public final ConstraintAnchor m454() {
        switch (this.f807.ordinal()) {
            case 0:
            case 5:
            case 6:
            case 7:
            case 8:
                return null;
            case 1:
                return this.f813.f833;
            case 2:
                return this.f813.f841;
            case 3:
                return this.f813.f820;
            case 4:
                return this.f813.f885;
            default:
                throw new AssertionError(this.f807.name());
        }
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public boolean m455() {
        HashSet<ConstraintAnchor> hashSet = this.f811;
        if (hashSet != null && hashSet.size() > 0) {
            return true;
        }
        return false;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public int m456() {
        ConstraintAnchor constraintAnchor;
        if (this.f813.f840 == 8) {
            return 0;
        }
        int i = this.f814;
        if (i <= -1 || (constraintAnchor = this.f812) == null || constraintAnchor.f813.f840 != 8) {
            return this.f810;
        }
        return i;
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public void m458() {
        HashSet<ConstraintAnchor> hashSet;
        ConstraintAnchor constraintAnchor = this.f812;
        if (!(constraintAnchor == null || (hashSet = constraintAnchor.f811) == null)) {
            hashSet.remove(this);
            if (this.f812.f811.size() == 0) {
                this.f812.f811 = null;
            }
        }
        this.f811 = null;
        this.f812 = null;
        this.f810 = 0;
        this.f814 = -1;
        this.f806 = false;
        this.f809 = 0;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m461(int i, ArrayList<C2098> arrayList, C2098 r5) {
        HashSet<ConstraintAnchor> hashSet = this.f811;
        if (hashSet != null) {
            Iterator<ConstraintAnchor> it2 = hashSet.iterator();
            while (it2.hasNext()) {
                C2369.m6323(it2.next().f813, i, arrayList, r5);
            }
        }
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean m465() {
        return this.f812 != null;
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m466() {
        HashSet<ConstraintAnchor> hashSet = this.f811;
        if (hashSet == null) {
            return false;
        }
        Iterator<ConstraintAnchor> it2 = hashSet.iterator();
        while (it2.hasNext()) {
            if (it2.next().m454().m465()) {
                return true;
            }
        }
        return false;
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m467() {
        SolverVariable solverVariable = this.f808;
        if (solverVariable == null) {
            this.f808 = new SolverVariable(SolverVariable.Type.UNRESTRICTED);
        } else {
            solverVariable.m450();
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m460(int i) {
        this.f809 = i;
        this.f806 = true;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m457(int i) {
        if (m465()) {
            this.f814 = i;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m459() {
        if (!this.f806) {
            return 0;
        }
        return this.f809;
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m462(ConstraintAnchor constraintAnchor) {
        if (constraintAnchor == null) {
            return false;
        }
        Type type = constraintAnchor.f807;
        Type type2 = this.f807;
        if (type != type2) {
            switch (type2.ordinal()) {
                case 0:
                case 5:
                case 7:
                case 8:
                    return false;
                case 1:
                case 3:
                    boolean z = type == Type.LEFT || type == Type.RIGHT;
                    if (constraintAnchor.f813 instanceof C2083) {
                        return z || type == Type.CENTER_X;
                    }
                    return z;
                case 2:
                case 4:
                    boolean z2 = type == Type.TOP || type == Type.BOTTOM;
                    if (constraintAnchor.f813 instanceof C2083) {
                        return z2 || type == Type.CENTER_Y;
                    }
                    return z2;
                case 6:
                    if (type == Type.BASELINE || type == Type.CENTER_X || type == Type.CENTER_Y) {
                        return false;
                    }
                    return true;
                default:
                    throw new AssertionError(this.f807.name());
            }
        } else if (type2 != Type.BASELINE || (constraintAnchor.f813.f852 && this.f813.f852)) {
            return true;
        } else {
            return false;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m464(ConstraintAnchor constraintAnchor, int i, int i2, boolean z) {
        if (constraintAnchor == null) {
            m458();
            return true;
        } else if (!z && !m462(constraintAnchor)) {
            return false;
        } else {
            this.f812 = constraintAnchor;
            ConstraintAnchor constraintAnchor2 = this.f812;
            if (constraintAnchor2.f811 == null) {
                constraintAnchor2.f811 = new HashSet<>();
            }
            HashSet<ConstraintAnchor> hashSet = this.f812.f811;
            if (hashSet != null) {
                hashSet.add(this);
            }
            if (i > 0) {
                this.f810 = i;
            } else {
                this.f810 = 0;
            }
            this.f814 = i2;
            return true;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public boolean m463(ConstraintAnchor constraintAnchor, int i) {
        return m464(constraintAnchor, i, -1, false);
    }
}
