package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.Layout;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.ContextThemeWrapper;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$styleable;
import androidx.appcompat.widget.ActionMenuView;
import androidx.customview.view.AbsSavedState;
import java.util.ArrayList;
import java.util.List;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.AbstractC1887;
import ῲ.ῲ.ඓ.C1892;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.ඓ.㳳.SubMenuC1900;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.K.AbstractC1963;
import ῲ.ῲ.㴹.AbstractC2002;
import ῲ.ῲ.㴹.C2019;
import ῲ.ῲ.㴹.C2031;
import ῲ.ῲ.㴹.C2033;
import ῲ.ῲ.㴹.C2040;
import K.K.K.ʬ.C2369;

public class Toolbar extends ViewGroup {
    public static final String TAG = "Toolbar";
    public AbstractC1897.AbstractC1898 mActionMenuPresenterCallback;
    public int mButtonGravity;
    public ImageButton mCollapseButtonView;
    public CharSequence mCollapseDescription;
    public Drawable mCollapseIcon;
    public boolean mCollapsible;
    public int mContentInsetEndWithActions;
    public int mContentInsetStartWithNavigation;
    public C2031 mContentInsets;
    public boolean mEatingHover;
    public boolean mEatingTouch;
    public View mExpandedActionView;
    public C0120 mExpandedMenuPresenter;
    public int mGravity;
    public final ArrayList<View> mHiddenViews;
    public ImageView mLogoView;
    public int mMaxButtonHeight;
    public C1912.AbstractC1914 mMenuBuilderCallback;
    public ActionMenuView mMenuView;
    public final ActionMenuView.AbstractC0069 mMenuViewItemClickListener;
    public ImageButton mNavButtonView;
    public AbstractC0119 mOnMenuItemClickListener;
    public ActionMenuPresenter mOuterActionMenuPresenter;
    public Context mPopupContext;
    public int mPopupTheme;
    public final Runnable mShowOverflowMenuRunnable;
    public CharSequence mSubtitleText;
    public int mSubtitleTextAppearance;
    public ColorStateList mSubtitleTextColor;
    public TextView mSubtitleTextView;
    public final int[] mTempMargins;
    public final ArrayList<View> mTempViews;
    public int mTitleMarginBottom;
    public int mTitleMarginEnd;
    public int mTitleMarginStart;
    public int mTitleMarginTop;
    public CharSequence mTitleText;
    public int mTitleTextAppearance;
    public ColorStateList mTitleTextColor;
    public TextView mTitleTextView;
    public C2040 mWrapper;

    /* renamed from: androidx.appcompat.widget.Toolbar$ʬ  reason: contains not printable characters */
    public class View$OnClickListenerC0115 implements View.OnClickListener {
        public View$OnClickListenerC0115() {
        }

        public void onClick(View view) {
            Toolbar.this.collapseActionView();
        }
    }

    /* renamed from: androidx.appcompat.widget.Toolbar$ῲ  reason: contains not printable characters */
    public class RunnableC0117 implements Runnable {
        public RunnableC0117() {
        }

        public void run() {
            Toolbar.this.showOverflowMenu();
        }
    }

    /* renamed from: androidx.appcompat.widget.Toolbar$K  reason: contains not printable characters */
    public class C0118 implements ActionMenuView.AbstractC0069 {
        public C0118() {
        }
    }

    /* renamed from: androidx.appcompat.widget.Toolbar$㴹  reason: contains not printable characters */
    public interface AbstractC0119 {
    }

    /* renamed from: androidx.appcompat.widget.Toolbar$㸾  reason: contains not printable characters */
    public class C0120 implements AbstractC1897 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public C1922 f651;

        /* renamed from: ῲ  reason: contains not printable characters */
        public C1912 f652;

        public C0120() {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public boolean collapseItemActionView(C1912 r2, C1922 r3) {
            View view = Toolbar.this.mExpandedActionView;
            if (view instanceof AbstractC1887) {
                ((AbstractC1887) view).m4879();
            }
            Toolbar toolbar = Toolbar.this;
            toolbar.removeView(toolbar.mExpandedActionView);
            Toolbar toolbar2 = Toolbar.this;
            toolbar2.removeView(toolbar2.mCollapseButtonView);
            Toolbar toolbar3 = Toolbar.this;
            toolbar3.mExpandedActionView = null;
            toolbar3.addChildrenForExpandedActionView();
            this.f651 = null;
            Toolbar.this.requestLayout();
            r3.f6525 = false;
            r3.f6515.onItemsChanged(false);
            return true;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public boolean expandItemActionView(C1912 r4, C1922 r5) {
            Toolbar.this.ensureCollapseButtonView();
            ViewParent parent = Toolbar.this.mCollapseButtonView.getParent();
            Toolbar toolbar = Toolbar.this;
            if (parent != toolbar) {
                if (parent instanceof ViewGroup) {
                    ((ViewGroup) parent).removeView(toolbar.mCollapseButtonView);
                }
                Toolbar toolbar2 = Toolbar.this;
                toolbar2.addView(toolbar2.mCollapseButtonView);
            }
            Toolbar.this.mExpandedActionView = r5.getActionView();
            this.f651 = r5;
            ViewParent parent2 = Toolbar.this.mExpandedActionView.getParent();
            Toolbar toolbar3 = Toolbar.this;
            if (parent2 != toolbar3) {
                if (parent2 instanceof ViewGroup) {
                    ((ViewGroup) parent2).removeView(toolbar3.mExpandedActionView);
                }
                C0116 generateDefaultLayoutParams = Toolbar.this.generateDefaultLayoutParams();
                Toolbar toolbar4 = Toolbar.this;
                generateDefaultLayoutParams.f6691 = 8388611 | (toolbar4.mButtonGravity & 112);
                generateDefaultLayoutParams.f648 = 2;
                toolbar4.mExpandedActionView.setLayoutParams(generateDefaultLayoutParams);
                Toolbar toolbar5 = Toolbar.this;
                toolbar5.addView(toolbar5.mExpandedActionView);
            }
            Toolbar.this.removeChildrenForExpandedActionView();
            Toolbar.this.requestLayout();
            r5.f6525 = true;
            r5.f6515.onItemsChanged(false);
            View view = Toolbar.this.mExpandedActionView;
            if (view instanceof AbstractC1887) {
                ((AbstractC1887) view).m4880();
            }
            return true;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public boolean flagActionItems() {
            return false;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public int getId() {
            return 0;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public void initForMenu(Context context, C1912 r3) {
            C1922 r0;
            C1912 r2 = this.f652;
            if (!(r2 == null || (r0 = this.f651) == null)) {
                r2.collapseItemActionView(r0);
            }
            this.f652 = r3;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public void onCloseMenu(C1912 r1, boolean z) {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public void onRestoreInstanceState(Parcelable parcelable) {
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public Parcelable onSaveInstanceState() {
            return null;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public boolean onSubMenuSelected(SubMenuC1900 r1) {
            return false;
        }

        @Override // ῲ.ῲ.ඓ.㳳.AbstractC1897
        public void updateMenuView(boolean z) {
            if (this.f651 != null) {
                C1912 r5 = this.f652;
                boolean z2 = false;
                if (r5 != null) {
                    int size = r5.size();
                    int i = 0;
                    while (true) {
                        if (i >= size) {
                            break;
                        } else if (this.f652.getItem(i) == this.f651) {
                            z2 = true;
                            break;
                        } else {
                            i++;
                        }
                    }
                }
                if (!z2) {
                    collapseItemActionView(this.f652, this.f651);
                }
            }
        }
    }

    public Toolbar(Context context) {
        this(context, null);
    }

    private void addCustomViewsWithGravity(List<View> list, int i) {
        boolean z = C1729.m4511(this) == 1;
        int childCount = getChildCount();
        int r7 = C2369.m6293(i, C1729.m4511(this));
        list.clear();
        if (z) {
            for (int i2 = childCount - 1; i2 >= 0; i2--) {
                View childAt = getChildAt(i2);
                C0116 r1 = (C0116) childAt.getLayoutParams();
                if (r1.f648 == 0 && shouldLayout(childAt) && getChildHorizontalGravity(r1.f6691) == r7) {
                    list.add(childAt);
                }
            }
            return;
        }
        for (int i3 = 0; i3 < childCount; i3++) {
            View childAt2 = getChildAt(i3);
            C0116 r2 = (C0116) childAt2.getLayoutParams();
            if (r2.f648 == 0 && shouldLayout(childAt2) && getChildHorizontalGravity(r2.f6691) == r7) {
                list.add(childAt2);
            }
        }
    }

    private void addSystemView(View view, boolean z) {
        C0116 r0;
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            r0 = generateDefaultLayoutParams();
        } else if (!checkLayoutParams(layoutParams)) {
            r0 = generateLayoutParams(layoutParams);
        } else {
            r0 = (C0116) layoutParams;
        }
        r0.f648 = 1;
        if (!z || this.mExpandedActionView == null) {
            addView(view, r0);
            return;
        }
        view.setLayoutParams(r0);
        this.mHiddenViews.add(view);
    }

    private void ensureContentInsets() {
        if (this.mContentInsets == null) {
            this.mContentInsets = new C2031();
        }
    }

    private void ensureLogoView() {
        if (this.mLogoView == null) {
            this.mLogoView = new AppCompatImageView(getContext());
        }
    }

    private void ensureMenu() {
        ensureMenuView();
        if (this.mMenuView.m267() == null) {
            C1912 r0 = (C1912) this.mMenuView.getMenu();
            if (this.mExpandedMenuPresenter == null) {
                this.mExpandedMenuPresenter = new C0120();
            }
            this.mMenuView.setExpandedActionViewsExclusive(true);
            r0.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
        }
    }

    private void ensureMenuView() {
        if (this.mMenuView == null) {
            this.mMenuView = new ActionMenuView(getContext());
            this.mMenuView.setPopupTheme(this.mPopupTheme);
            this.mMenuView.setOnMenuItemClickListener(this.mMenuViewItemClickListener);
            this.mMenuView.m269(this.mActionMenuPresenterCallback, this.mMenuBuilderCallback);
            C0116 generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f6691 = 8388613 | (this.mButtonGravity & 112);
            this.mMenuView.setLayoutParams(generateDefaultLayoutParams);
            addSystemView(this.mMenuView, false);
        }
    }

    private void ensureNavButtonView() {
        if (this.mNavButtonView == null) {
            this.mNavButtonView = new AppCompatImageButton(getContext(), null, R$attr.toolbarNavigationButtonStyle);
            C0116 generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f6691 = 8388611 | (this.mButtonGravity & 112);
            this.mNavButtonView.setLayoutParams(generateDefaultLayoutParams);
        }
    }

    private int getChildHorizontalGravity(int i) {
        int r0 = C1729.m4511(this);
        int r5 = C2369.m6293(i, r0) & 7;
        if (r5 == 1 || r5 == 3 || r5 == 5) {
            return r5;
        }
        return r0 == 1 ? 5 : 3;
    }

    private int getChildTop(View view, int i) {
        C0116 r0 = (C0116) view.getLayoutParams();
        int measuredHeight = view.getMeasuredHeight();
        int i2 = i > 0 ? (measuredHeight - i) / 2 : 0;
        int childVerticalGravity = getChildVerticalGravity(r0.f6691);
        if (childVerticalGravity == 48) {
            return getPaddingTop() - i2;
        }
        if (childVerticalGravity == 80) {
            return (((getHeight() - getPaddingBottom()) - measuredHeight) - ((ViewGroup.MarginLayoutParams) r0).bottomMargin) - i2;
        }
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int height = getHeight();
        int i3 = (((height - paddingTop) - paddingBottom) - measuredHeight) / 2;
        int i4 = ((ViewGroup.MarginLayoutParams) r0).topMargin;
        if (i3 < i4) {
            i3 = i4;
        } else {
            int i5 = (((height - paddingBottom) - measuredHeight) - i3) - paddingTop;
            int i6 = ((ViewGroup.MarginLayoutParams) r0).bottomMargin;
            if (i5 < i6) {
                i3 = Math.max(0, i3 - (i6 - i5));
            }
        }
        return paddingTop + i3;
    }

    private int getChildVerticalGravity(int i) {
        int i2 = i & 112;
        return (i2 == 16 || i2 == 48 || i2 == 80) ? i2 : this.mGravity & 112;
    }

    private int getHorizontalMargins(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return C2369.m6299(marginLayoutParams) + C2369.m6279(marginLayoutParams);
    }

    private MenuInflater getMenuInflater() {
        return new C1892(getContext());
    }

    private int getVerticalMargins(View view) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        return marginLayoutParams.topMargin + marginLayoutParams.bottomMargin;
    }

    private int getViewListMeasuredWidth(List<View> list, int[] iArr) {
        int i = iArr[0];
        int i2 = iArr[1];
        int size = list.size();
        int i3 = i2;
        int i4 = i;
        int i5 = 0;
        int i6 = 0;
        while (i5 < size) {
            View view = list.get(i5);
            C0116 r6 = (C0116) view.getLayoutParams();
            int i7 = ((ViewGroup.MarginLayoutParams) r6).leftMargin - i4;
            int i8 = ((ViewGroup.MarginLayoutParams) r6).rightMargin - i3;
            int max = Math.max(0, i7);
            int max2 = Math.max(0, i8);
            int max3 = Math.max(0, -i7);
            int max4 = Math.max(0, -i8);
            i6 += view.getMeasuredWidth() + max + max2;
            i5++;
            i3 = max4;
            i4 = max3;
        }
        return i6;
    }

    private boolean isChildOrHidden(View view) {
        return view.getParent() == this || this.mHiddenViews.contains(view);
    }

    private int layoutChildLeft(View view, int i, int[] iArr, int i2) {
        C0116 r0 = (C0116) view.getLayoutParams();
        int i3 = ((ViewGroup.MarginLayoutParams) r0).leftMargin - iArr[0];
        int max = Math.max(0, i3) + i;
        iArr[0] = Math.max(0, -i3);
        int childTop = getChildTop(view, i2);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(max, childTop, max + measuredWidth, view.getMeasuredHeight() + childTop);
        return measuredWidth + ((ViewGroup.MarginLayoutParams) r0).rightMargin + max;
    }

    private int layoutChildRight(View view, int i, int[] iArr, int i2) {
        C0116 r0 = (C0116) view.getLayoutParams();
        int i3 = ((ViewGroup.MarginLayoutParams) r0).rightMargin - iArr[1];
        int max = i - Math.max(0, i3);
        iArr[1] = Math.max(0, -i3);
        int childTop = getChildTop(view, i2);
        int measuredWidth = view.getMeasuredWidth();
        view.layout(max - measuredWidth, childTop, max, view.getMeasuredHeight() + childTop);
        return max - (measuredWidth + ((ViewGroup.MarginLayoutParams) r0).leftMargin);
    }

    private int measureChildCollapseMargins(View view, int i, int i2, int i3, int i4, int[] iArr) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int i5 = marginLayoutParams.leftMargin - iArr[0];
        int i6 = marginLayoutParams.rightMargin - iArr[1];
        int max = Math.max(0, i6) + Math.max(0, i5);
        iArr[0] = Math.max(0, -i5);
        iArr[1] = Math.max(0, -i6);
        view.measure(ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + max + i2, marginLayoutParams.width), ViewGroup.getChildMeasureSpec(i3, getPaddingBottom() + getPaddingTop() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + i4, marginLayoutParams.height));
        return view.getMeasuredWidth() + max;
    }

    private void measureChildConstrained(View view, int i, int i2, int i3, int i4, int i5) {
        ViewGroup.MarginLayoutParams marginLayoutParams = (ViewGroup.MarginLayoutParams) view.getLayoutParams();
        int childMeasureSpec = ViewGroup.getChildMeasureSpec(i, getPaddingRight() + getPaddingLeft() + marginLayoutParams.leftMargin + marginLayoutParams.rightMargin + i2, marginLayoutParams.width);
        int childMeasureSpec2 = ViewGroup.getChildMeasureSpec(i3, getPaddingBottom() + getPaddingTop() + marginLayoutParams.topMargin + marginLayoutParams.bottomMargin + i4, marginLayoutParams.height);
        int mode = View.MeasureSpec.getMode(childMeasureSpec2);
        if (mode != 1073741824 && i5 >= 0) {
            if (mode != 0) {
                i5 = Math.min(View.MeasureSpec.getSize(childMeasureSpec2), i5);
            }
            childMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(i5, 1073741824);
        }
        view.measure(childMeasureSpec, childMeasureSpec2);
    }

    private void postShowOverflowMenu() {
        removeCallbacks(this.mShowOverflowMenuRunnable);
        post(this.mShowOverflowMenuRunnable);
    }

    private boolean shouldCollapse() {
        if (!this.mCollapsible) {
            return false;
        }
        int childCount = getChildCount();
        for (int i = 0; i < childCount; i++) {
            View childAt = getChildAt(i);
            if (shouldLayout(childAt) && childAt.getMeasuredWidth() > 0 && childAt.getMeasuredHeight() > 0) {
                return false;
            }
        }
        return true;
    }

    private boolean shouldLayout(View view) {
        return (view == null || view.getParent() != this || view.getVisibility() == 8) ? false : true;
    }

    public void addChildrenForExpandedActionView() {
        for (int size = this.mHiddenViews.size() - 1; size >= 0; size--) {
            addView(this.mHiddenViews.get(size));
        }
        this.mHiddenViews.clear();
    }

    public boolean canShowOverflowMenu() {
        ActionMenuView actionMenuView;
        return getVisibility() == 0 && (actionMenuView = this.mMenuView) != null && actionMenuView.m275();
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return super.checkLayoutParams(layoutParams) && (layoutParams instanceof C0116);
    }

    public void collapseActionView() {
        C1922 r0;
        C0120 r02 = this.mExpandedMenuPresenter;
        if (r02 == null) {
            r0 = null;
        } else {
            r0 = r02.f651;
        }
        if (r0 != null) {
            r0.collapseActionView();
        }
    }

    public void dismissPopupMenus() {
        ActionMenuView actionMenuView = this.mMenuView;
        if (actionMenuView != null) {
            actionMenuView.m265();
        }
    }

    public void ensureCollapseButtonView() {
        if (this.mCollapseButtonView == null) {
            this.mCollapseButtonView = new AppCompatImageButton(getContext(), null, R$attr.toolbarNavigationButtonStyle);
            this.mCollapseButtonView.setImageDrawable(this.mCollapseIcon);
            this.mCollapseButtonView.setContentDescription(this.mCollapseDescription);
            C0116 generateDefaultLayoutParams = generateDefaultLayoutParams();
            generateDefaultLayoutParams.f6691 = 8388611 | (this.mButtonGravity & 112);
            generateDefaultLayoutParams.f648 = 2;
            this.mCollapseButtonView.setLayoutParams(generateDefaultLayoutParams);
            this.mCollapseButtonView.setOnClickListener(new View$OnClickListenerC0115());
        }
    }

    public CharSequence getCollapseContentDescription() {
        ImageButton imageButton = this.mCollapseButtonView;
        if (imageButton != null) {
            return imageButton.getContentDescription();
        }
        return null;
    }

    public Drawable getCollapseIcon() {
        ImageButton imageButton = this.mCollapseButtonView;
        if (imageButton != null) {
            return imageButton.getDrawable();
        }
        return null;
    }

    public int getContentInsetEnd() {
        C2031 r0 = this.mContentInsets;
        if (r0 != null) {
            return r0.f6881 ? r0.f6882 : r0.f6880;
        }
        return 0;
    }

    public int getContentInsetEndWithActions() {
        int i = this.mContentInsetEndWithActions;
        return i != Integer.MIN_VALUE ? i : getContentInsetEnd();
    }

    public int getContentInsetLeft() {
        C2031 r0 = this.mContentInsets;
        if (r0 != null) {
            return r0.f6882;
        }
        return 0;
    }

    public int getContentInsetRight() {
        C2031 r0 = this.mContentInsets;
        if (r0 != null) {
            return r0.f6880;
        }
        return 0;
    }

    public int getContentInsetStart() {
        C2031 r0 = this.mContentInsets;
        if (r0 != null) {
            return r0.f6881 ? r0.f6880 : r0.f6882;
        }
        return 0;
    }

    public int getContentInsetStartWithNavigation() {
        int i = this.mContentInsetStartWithNavigation;
        return i != Integer.MIN_VALUE ? i : getContentInsetStart();
    }

    public int getCurrentContentInsetEnd() {
        C1912 r0;
        ActionMenuView actionMenuView = this.mMenuView;
        if ((actionMenuView == null || (r0 = actionMenuView.m267()) == null || !r0.hasVisibleItems()) ? false : true) {
            return Math.max(getContentInsetEnd(), Math.max(this.mContentInsetEndWithActions, 0));
        }
        return getContentInsetEnd();
    }

    public int getCurrentContentInsetLeft() {
        if (C1729.m4511(this) == 1) {
            return getCurrentContentInsetEnd();
        }
        return getCurrentContentInsetStart();
    }

    public int getCurrentContentInsetRight() {
        if (C1729.m4511(this) == 1) {
            return getCurrentContentInsetStart();
        }
        return getCurrentContentInsetEnd();
    }

    public int getCurrentContentInsetStart() {
        if (getNavigationIcon() != null) {
            return Math.max(getContentInsetStart(), Math.max(this.mContentInsetStartWithNavigation, 0));
        }
        return getContentInsetStart();
    }

    public Drawable getLogo() {
        ImageView imageView = this.mLogoView;
        if (imageView != null) {
            return imageView.getDrawable();
        }
        return null;
    }

    public CharSequence getLogoDescription() {
        ImageView imageView = this.mLogoView;
        if (imageView != null) {
            return imageView.getContentDescription();
        }
        return null;
    }

    public Menu getMenu() {
        ensureMenu();
        return this.mMenuView.getMenu();
    }

    public CharSequence getNavigationContentDescription() {
        ImageButton imageButton = this.mNavButtonView;
        if (imageButton != null) {
            return imageButton.getContentDescription();
        }
        return null;
    }

    public Drawable getNavigationIcon() {
        ImageButton imageButton = this.mNavButtonView;
        if (imageButton != null) {
            return imageButton.getDrawable();
        }
        return null;
    }

    public ActionMenuPresenter getOuterActionMenuPresenter() {
        return this.mOuterActionMenuPresenter;
    }

    public Drawable getOverflowIcon() {
        ensureMenu();
        return this.mMenuView.getOverflowIcon();
    }

    public Context getPopupContext() {
        return this.mPopupContext;
    }

    public int getPopupTheme() {
        return this.mPopupTheme;
    }

    public CharSequence getSubtitle() {
        return this.mSubtitleText;
    }

    public final TextView getSubtitleTextView() {
        return this.mSubtitleTextView;
    }

    public CharSequence getTitle() {
        return this.mTitleText;
    }

    public int getTitleMarginBottom() {
        return this.mTitleMarginBottom;
    }

    public int getTitleMarginEnd() {
        return this.mTitleMarginEnd;
    }

    public int getTitleMarginStart() {
        return this.mTitleMarginStart;
    }

    public int getTitleMarginTop() {
        return this.mTitleMarginTop;
    }

    public final TextView getTitleTextView() {
        return this.mTitleTextView;
    }

    public AbstractC2002 getWrapper() {
        if (this.mWrapper == null) {
            this.mWrapper = new C2040(this, true);
        }
        return this.mWrapper;
    }

    public boolean hasExpandedActionView() {
        C0120 r0 = this.mExpandedMenuPresenter;
        return (r0 == null || r0.f651 == null) ? false : true;
    }

    public boolean hideOverflowMenu() {
        ActionMenuView actionMenuView = this.mMenuView;
        return actionMenuView != null && actionMenuView.m266();
    }

    public void inflateMenu(int i) {
        getMenuInflater().inflate(i, getMenu());
    }

    public boolean isOverflowMenuShowPending() {
        ActionMenuView actionMenuView = this.mMenuView;
        return actionMenuView != null && actionMenuView.m273();
    }

    public boolean isOverflowMenuShowing() {
        ActionMenuView actionMenuView = this.mMenuView;
        return actionMenuView != null && actionMenuView.m268();
    }

    public boolean isTitleTruncated() {
        Layout layout;
        TextView textView = this.mTitleTextView;
        if (textView == null || (layout = textView.getLayout()) == null) {
            return false;
        }
        int lineCount = layout.getLineCount();
        for (int i = 0; i < lineCount; i++) {
            if (layout.getEllipsisCount(i) > 0) {
                return true;
            }
        }
        return false;
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        removeCallbacks(this.mShowOverflowMenuRunnable);
    }

    public boolean onHoverEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 9) {
            this.mEatingHover = false;
        }
        if (!this.mEatingHover) {
            boolean onHoverEvent = super.onHoverEvent(motionEvent);
            if (actionMasked == 9 && !onHoverEvent) {
                this.mEatingHover = true;
            }
        }
        if (actionMasked == 10 || actionMasked == 3) {
            this.mEatingHover = false;
        }
        return true;
    }

    /* JADX WARNING: Removed duplicated region for block: B:102:0x02a7 A[LOOP:0: B:101:0x02a5->B:102:0x02a7, LOOP_END] */
    /* JADX WARNING: Removed duplicated region for block: B:105:0x02c9 A[LOOP:1: B:104:0x02c7->B:105:0x02c9, LOOP_END] */
    /* JADX WARNING: Removed duplicated region for block: B:108:0x02f3  */
    /* JADX WARNING: Removed duplicated region for block: B:113:0x0302 A[LOOP:2: B:112:0x0300->B:113:0x0302, LOOP_END] */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x005f  */
    /* JADX WARNING: Removed duplicated region for block: B:22:0x0076  */
    /* JADX WARNING: Removed duplicated region for block: B:27:0x00b3  */
    /* JADX WARNING: Removed duplicated region for block: B:32:0x00ca  */
    /* JADX WARNING: Removed duplicated region for block: B:37:0x00e7  */
    /* JADX WARNING: Removed duplicated region for block: B:38:0x0100  */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x0105  */
    /* JADX WARNING: Removed duplicated region for block: B:41:0x011d  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x012d  */
    /* JADX WARNING: Removed duplicated region for block: B:48:0x0130  */
    /* JADX WARNING: Removed duplicated region for block: B:50:0x0134  */
    /* JADX WARNING: Removed duplicated region for block: B:51:0x0137  */
    /* JADX WARNING: Removed duplicated region for block: B:63:0x016a  */
    /* JADX WARNING: Removed duplicated region for block: B:73:0x01a8  */
    /* JADX WARNING: Removed duplicated region for block: B:75:0x01b9  */
    /* JADX WARNING: Removed duplicated region for block: B:88:0x022c  */
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int i5;
        int i6;
        boolean shouldLayout;
        boolean shouldLayout2;
        int i7;
        int i8;
        int i9;
        int i10;
        int i11;
        int i12;
        int size;
        int i13;
        int i14;
        int size2;
        int i15;
        int i16;
        int size3;
        boolean z2;
        int i17;
        int i18;
        boolean z3;
        int i19;
        int i20;
        int i21;
        int i22;
        int i23;
        char c;
        int i24;
        int i25;
        boolean z4 = C1729.m4511(this) == 1;
        int width = getWidth();
        int height = getHeight();
        int paddingLeft = getPaddingLeft();
        int paddingRight = getPaddingRight();
        int paddingTop = getPaddingTop();
        int paddingBottom = getPaddingBottom();
        int i26 = width - paddingRight;
        int[] iArr = this.mTempMargins;
        iArr[1] = 0;
        iArr[0] = 0;
        int r12 = C1729.m4442(this);
        int min = r12 >= 0 ? Math.min(r12, i4 - i2) : 0;
        if (!shouldLayout(this.mNavButtonView)) {
            i6 = paddingLeft;
        } else if (z4) {
            i5 = layoutChildRight(this.mNavButtonView, i26, iArr, min);
            i6 = paddingLeft;
            if (shouldLayout(this.mCollapseButtonView)) {
                if (z4) {
                    i5 = layoutChildRight(this.mCollapseButtonView, i5, iArr, min);
                } else {
                    i6 = layoutChildLeft(this.mCollapseButtonView, i6, iArr, min);
                }
            }
            if (shouldLayout(this.mMenuView)) {
                if (z4) {
                    i6 = layoutChildLeft(this.mMenuView, i6, iArr, min);
                } else {
                    i5 = layoutChildRight(this.mMenuView, i5, iArr, min);
                }
            }
            int currentContentInsetLeft = getCurrentContentInsetLeft();
            int currentContentInsetRight = getCurrentContentInsetRight();
            iArr[0] = Math.max(0, currentContentInsetLeft - i6);
            iArr[1] = Math.max(0, currentContentInsetRight - (i26 - i5));
            int max = Math.max(i6, currentContentInsetLeft);
            int min2 = Math.min(i5, i26 - currentContentInsetRight);
            if (shouldLayout(this.mExpandedActionView)) {
                if (z4) {
                    min2 = layoutChildRight(this.mExpandedActionView, min2, iArr, min);
                } else {
                    max = layoutChildLeft(this.mExpandedActionView, max, iArr, min);
                }
            }
            if (shouldLayout(this.mLogoView)) {
                if (z4) {
                    min2 = layoutChildRight(this.mLogoView, min2, iArr, min);
                } else {
                    max = layoutChildLeft(this.mLogoView, max, iArr, min);
                }
            }
            shouldLayout = shouldLayout(this.mTitleTextView);
            shouldLayout2 = shouldLayout(this.mSubtitleTextView);
            if (!shouldLayout) {
                C0116 r15 = (C0116) this.mTitleTextView.getLayoutParams();
                i7 = paddingRight;
                i8 = this.mTitleTextView.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r15).topMargin + ((ViewGroup.MarginLayoutParams) r15).bottomMargin + 0;
            } else {
                i7 = paddingRight;
                i8 = 0;
            }
            if (!shouldLayout2) {
                C0116 r3 = (C0116) this.mSubtitleTextView.getLayoutParams();
                i9 = width;
                i8 += this.mSubtitleTextView.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r3).topMargin + ((ViewGroup.MarginLayoutParams) r3).bottomMargin;
            } else {
                i9 = width;
            }
            if (!shouldLayout || shouldLayout2) {
                TextView textView = !shouldLayout ? this.mTitleTextView : this.mSubtitleTextView;
                TextView textView2 = !shouldLayout2 ? this.mSubtitleTextView : this.mTitleTextView;
                C0116 r32 = (C0116) textView.getLayoutParams();
                C0116 r4 = (C0116) textView2.getLayoutParams();
                if ((shouldLayout || this.mTitleTextView.getMeasuredWidth() <= 0) && (!shouldLayout2 || this.mSubtitleTextView.getMeasuredWidth() <= 0)) {
                    i11 = paddingLeft;
                    z2 = false;
                } else {
                    i11 = paddingLeft;
                    z2 = true;
                }
                i17 = this.mGravity & 112;
                i10 = min;
                if (i17 != 48) {
                    i18 = max;
                    z3 = shouldLayout2;
                    i19 = getPaddingTop() + ((ViewGroup.MarginLayoutParams) r32).topMargin + this.mTitleMarginTop;
                } else if (i17 != 80) {
                    int i27 = (((height - paddingTop) - paddingBottom) - i8) / 2;
                    int i28 = ((ViewGroup.MarginLayoutParams) r32).topMargin;
                    i18 = max;
                    int i29 = this.mTitleMarginTop;
                    z3 = shouldLayout2;
                    if (i27 < i28 + i29) {
                        i27 = i28 + i29;
                    } else {
                        int i30 = (((height - paddingBottom) - i8) - i27) - paddingTop;
                        int i31 = ((ViewGroup.MarginLayoutParams) r32).bottomMargin;
                        int i32 = this.mTitleMarginBottom;
                        if (i30 < i31 + i32) {
                            i27 = Math.max(0, i27 - ((((ViewGroup.MarginLayoutParams) r4).bottomMargin + i32) - i30));
                        }
                    }
                    i19 = paddingTop + i27;
                } else {
                    i18 = max;
                    z3 = shouldLayout2;
                    i19 = (((height - paddingBottom) - ((ViewGroup.MarginLayoutParams) r4).bottomMargin) - this.mTitleMarginBottom) - i8;
                }
                if (!z4) {
                    if (z2) {
                        i23 = this.mTitleMarginStart;
                        c = 1;
                    } else {
                        c = 1;
                        i23 = 0;
                    }
                    int i33 = i23 - iArr[c];
                    min2 -= Math.max(0, i33);
                    iArr[c] = Math.max(0, -i33);
                    if (shouldLayout) {
                        int measuredWidth = min2 - this.mTitleTextView.getMeasuredWidth();
                        int measuredHeight = this.mTitleTextView.getMeasuredHeight() + i19;
                        this.mTitleTextView.layout(measuredWidth, i19, min2, measuredHeight);
                        i24 = measuredWidth - this.mTitleMarginEnd;
                        i19 = measuredHeight + ((ViewGroup.MarginLayoutParams) ((C0116) this.mTitleTextView.getLayoutParams())).bottomMargin;
                    } else {
                        i24 = min2;
                    }
                    if (z3) {
                        C0116 r1 = (C0116) this.mSubtitleTextView.getLayoutParams();
                        int i34 = i19 + ((ViewGroup.MarginLayoutParams) r1).topMargin;
                        this.mSubtitleTextView.layout(min2 - this.mSubtitleTextView.getMeasuredWidth(), i34, min2, this.mSubtitleTextView.getMeasuredHeight() + i34);
                        i25 = min2 - this.mTitleMarginEnd;
                        int i35 = ((ViewGroup.MarginLayoutParams) r1).bottomMargin;
                    } else {
                        i25 = min2;
                    }
                    if (z2) {
                        min2 = Math.min(i24, i25);
                    }
                    max = i18;
                } else {
                    if (z2) {
                        i20 = this.mTitleMarginStart;
                        i12 = 0;
                    } else {
                        i12 = 0;
                        i20 = 0;
                    }
                    int i36 = i20 - iArr[i12];
                    max = Math.max(i12, i36) + i18;
                    iArr[i12] = Math.max(i12, -i36);
                    if (shouldLayout) {
                        int measuredWidth2 = this.mTitleTextView.getMeasuredWidth() + max;
                        int measuredHeight2 = this.mTitleTextView.getMeasuredHeight() + i19;
                        this.mTitleTextView.layout(max, i19, measuredWidth2, measuredHeight2);
                        i21 = measuredWidth2 + this.mTitleMarginEnd;
                        i19 = measuredHeight2 + ((ViewGroup.MarginLayoutParams) ((C0116) this.mTitleTextView.getLayoutParams())).bottomMargin;
                    } else {
                        i21 = max;
                    }
                    if (z3) {
                        C0116 r33 = (C0116) this.mSubtitleTextView.getLayoutParams();
                        int i37 = i19 + ((ViewGroup.MarginLayoutParams) r33).topMargin;
                        int measuredWidth3 = this.mSubtitleTextView.getMeasuredWidth() + max;
                        this.mSubtitleTextView.layout(max, i37, measuredWidth3, this.mSubtitleTextView.getMeasuredHeight() + i37);
                        i22 = measuredWidth3 + this.mTitleMarginEnd;
                        int i38 = ((ViewGroup.MarginLayoutParams) r33).bottomMargin;
                    } else {
                        i22 = max;
                    }
                    if (z2) {
                        max = Math.max(i21, i22);
                    }
                    addCustomViewsWithGravity(this.mTempViews, 3);
                    size = this.mTempViews.size();
                    i13 = max;
                    for (i14 = 0; i14 < size; i14++) {
                        i13 = layoutChildLeft(this.mTempViews.get(i14), i13, iArr, i10);
                    }
                    addCustomViewsWithGravity(this.mTempViews, 5);
                    size2 = this.mTempViews.size();
                    for (i15 = 0; i15 < size2; i15++) {
                        min2 = layoutChildRight(this.mTempViews.get(i15), min2, iArr, i10);
                    }
                    addCustomViewsWithGravity(this.mTempViews, 1);
                    int viewListMeasuredWidth = getViewListMeasuredWidth(this.mTempViews, iArr);
                    i16 = ((((i9 - i11) - i7) / 2) + i11) - (viewListMeasuredWidth / 2);
                    int i39 = viewListMeasuredWidth + i16;
                    if (i16 >= i13) {
                        i13 = i39 > min2 ? i16 - (i39 - min2) : i16;
                    }
                    size3 = this.mTempViews.size();
                    while (i12 < size3) {
                        i13 = layoutChildLeft(this.mTempViews.get(i12), i13, iArr, i10);
                        i12++;
                    }
                    this.mTempViews.clear();
                    return;
                }
            } else {
                i11 = paddingLeft;
                i10 = min;
            }
            i12 = 0;
            addCustomViewsWithGravity(this.mTempViews, 3);
            size = this.mTempViews.size();
            i13 = max;
            while (i14 < size) {
            }
            addCustomViewsWithGravity(this.mTempViews, 5);
            size2 = this.mTempViews.size();
            while (i15 < size2) {
            }
            addCustomViewsWithGravity(this.mTempViews, 1);
            int viewListMeasuredWidth2 = getViewListMeasuredWidth(this.mTempViews, iArr);
            i16 = ((((i9 - i11) - i7) / 2) + i11) - (viewListMeasuredWidth2 / 2);
            int i392 = viewListMeasuredWidth2 + i16;
            if (i16 >= i13) {
            }
            size3 = this.mTempViews.size();
            while (i12 < size3) {
            }
            this.mTempViews.clear();
            return;
        } else {
            i6 = layoutChildLeft(this.mNavButtonView, paddingLeft, iArr, min);
        }
        i5 = i26;
        if (shouldLayout(this.mCollapseButtonView)) {
        }
        if (shouldLayout(this.mMenuView)) {
        }
        int currentContentInsetLeft2 = getCurrentContentInsetLeft();
        int currentContentInsetRight2 = getCurrentContentInsetRight();
        iArr[0] = Math.max(0, currentContentInsetLeft2 - i6);
        iArr[1] = Math.max(0, currentContentInsetRight2 - (i26 - i5));
        int max2 = Math.max(i6, currentContentInsetLeft2);
        int min22 = Math.min(i5, i26 - currentContentInsetRight2);
        if (shouldLayout(this.mExpandedActionView)) {
        }
        if (shouldLayout(this.mLogoView)) {
        }
        shouldLayout = shouldLayout(this.mTitleTextView);
        shouldLayout2 = shouldLayout(this.mSubtitleTextView);
        if (!shouldLayout) {
        }
        if (!shouldLayout2) {
        }
        if (!shouldLayout) {
        }
        if (!shouldLayout) {
        }
        if (!shouldLayout2) {
        }
        C0116 r322 = (C0116) textView.getLayoutParams();
        C0116 r42 = (C0116) textView2.getLayoutParams();
        if (shouldLayout) {
        }
        i11 = paddingLeft;
        z2 = false;
        i17 = this.mGravity & 112;
        i10 = min;
        if (i17 != 48) {
        }
        if (!z4) {
        }
    }

    public void onMeasure(int i, int i2) {
        char c;
        char c2;
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        int i9;
        int[] iArr = this.mTempMargins;
        if (C2033.m5266(this)) {
            c2 = 1;
            c = 0;
        } else {
            c2 = 0;
            c = 1;
        }
        if (shouldLayout(this.mNavButtonView)) {
            measureChildConstrained(this.mNavButtonView, i, 0, i2, 0, this.mMaxButtonHeight);
            i5 = this.mNavButtonView.getMeasuredWidth() + getHorizontalMargins(this.mNavButtonView);
            i4 = Math.max(0, this.mNavButtonView.getMeasuredHeight() + getVerticalMargins(this.mNavButtonView));
            i3 = View.combineMeasuredStates(0, this.mNavButtonView.getMeasuredState());
        } else {
            i5 = 0;
            i4 = 0;
            i3 = 0;
        }
        if (shouldLayout(this.mCollapseButtonView)) {
            measureChildConstrained(this.mCollapseButtonView, i, 0, i2, 0, this.mMaxButtonHeight);
            i5 = this.mCollapseButtonView.getMeasuredWidth() + getHorizontalMargins(this.mCollapseButtonView);
            i4 = Math.max(i4, this.mCollapseButtonView.getMeasuredHeight() + getVerticalMargins(this.mCollapseButtonView));
            i3 = View.combineMeasuredStates(i3, this.mCollapseButtonView.getMeasuredState());
        }
        int currentContentInsetStart = getCurrentContentInsetStart();
        int max = Math.max(currentContentInsetStart, i5) + 0;
        iArr[c2] = Math.max(0, currentContentInsetStart - i5);
        if (shouldLayout(this.mMenuView)) {
            measureChildConstrained(this.mMenuView, i, max, i2, 0, this.mMaxButtonHeight);
            i6 = this.mMenuView.getMeasuredWidth() + getHorizontalMargins(this.mMenuView);
            i4 = Math.max(i4, this.mMenuView.getMeasuredHeight() + getVerticalMargins(this.mMenuView));
            i3 = View.combineMeasuredStates(i3, this.mMenuView.getMeasuredState());
        } else {
            i6 = 0;
        }
        int currentContentInsetEnd = getCurrentContentInsetEnd();
        int max2 = Math.max(currentContentInsetEnd, i6) + max;
        iArr[c] = Math.max(0, currentContentInsetEnd - i6);
        if (shouldLayout(this.mExpandedActionView)) {
            max2 += measureChildCollapseMargins(this.mExpandedActionView, i, max2, i2, 0, iArr);
            i4 = Math.max(i4, this.mExpandedActionView.getMeasuredHeight() + getVerticalMargins(this.mExpandedActionView));
            i3 = View.combineMeasuredStates(i3, this.mExpandedActionView.getMeasuredState());
        }
        if (shouldLayout(this.mLogoView)) {
            max2 += measureChildCollapseMargins(this.mLogoView, i, max2, i2, 0, iArr);
            i4 = Math.max(i4, this.mLogoView.getMeasuredHeight() + getVerticalMargins(this.mLogoView));
            i3 = View.combineMeasuredStates(i3, this.mLogoView.getMeasuredState());
        }
        int childCount = getChildCount();
        int i10 = i4;
        int i11 = max2;
        for (int i12 = 0; i12 < childCount; i12++) {
            View childAt = getChildAt(i12);
            if (((C0116) childAt.getLayoutParams()).f648 == 0 && shouldLayout(childAt)) {
                i11 += measureChildCollapseMargins(childAt, i, i11, i2, 0, iArr);
                i10 = Math.max(i10, childAt.getMeasuredHeight() + getVerticalMargins(childAt));
                i3 = View.combineMeasuredStates(i3, childAt.getMeasuredState());
            }
        }
        int i13 = this.mTitleMarginTop + this.mTitleMarginBottom;
        int i14 = this.mTitleMarginStart + this.mTitleMarginEnd;
        if (shouldLayout(this.mTitleTextView)) {
            measureChildCollapseMargins(this.mTitleTextView, i, i11 + i14, i2, i13, iArr);
            int measuredWidth = this.mTitleTextView.getMeasuredWidth() + getHorizontalMargins(this.mTitleTextView);
            i7 = this.mTitleTextView.getMeasuredHeight() + getVerticalMargins(this.mTitleTextView);
            i9 = View.combineMeasuredStates(i3, this.mTitleTextView.getMeasuredState());
            i8 = measuredWidth;
        } else {
            i9 = i3;
            i8 = 0;
            i7 = 0;
        }
        if (shouldLayout(this.mSubtitleTextView)) {
            i8 = Math.max(i8, measureChildCollapseMargins(this.mSubtitleTextView, i, i11 + i14, i2, i7 + i13, iArr));
            i7 += this.mSubtitleTextView.getMeasuredHeight() + getVerticalMargins(this.mSubtitleTextView);
            i9 = View.combineMeasuredStates(i9, this.mSubtitleTextView.getMeasuredState());
        }
        int max3 = Math.max(i10, i7);
        int paddingRight = getPaddingRight() + getPaddingLeft();
        int paddingBottom = getPaddingBottom() + getPaddingTop() + max3;
        int resolveSizeAndState = View.resolveSizeAndState(Math.max(paddingRight + i11 + i8, getSuggestedMinimumWidth()), i, -16777216 & i9);
        int resolveSizeAndState2 = View.resolveSizeAndState(Math.max(paddingBottom, getSuggestedMinimumHeight()), i2, i9 << 16);
        if (shouldCollapse()) {
            resolveSizeAndState2 = 0;
        }
        setMeasuredDimension(resolveSizeAndState, resolveSizeAndState2);
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        MenuItem findItem;
        if (!(parcelable instanceof SavedState)) {
            super.onRestoreInstanceState(parcelable);
            return;
        }
        SavedState savedState = (SavedState) parcelable;
        super.onRestoreInstanceState(savedState.getSuperState());
        ActionMenuView actionMenuView = this.mMenuView;
        C1912 r0 = actionMenuView != null ? actionMenuView.m267() : null;
        int i = savedState.f646;
        if (!(i == 0 || this.mExpandedMenuPresenter == null || r0 == null || (findItem = r0.findItem(i)) == null)) {
            findItem.expandActionView();
        }
        if (savedState.f645) {
            postShowOverflowMenu();
        }
    }

    public void onRtlPropertiesChanged(int i) {
        int i2 = Build.VERSION.SDK_INT;
        super.onRtlPropertiesChanged(i);
        ensureContentInsets();
        C2031 r0 = this.mContentInsets;
        boolean z = true;
        if (i != 1) {
            z = false;
        }
        if (z != r0.f6881) {
            r0.f6881 = z;
            if (!r0.f6885) {
                r0.f6882 = r0.f6879;
                r0.f6880 = r0.f6883;
            } else if (z) {
                int i3 = r0.f6884;
                if (i3 == Integer.MIN_VALUE) {
                    i3 = r0.f6879;
                }
                r0.f6882 = i3;
                int i4 = r0.f6878;
                if (i4 == Integer.MIN_VALUE) {
                    i4 = r0.f6883;
                }
                r0.f6880 = i4;
            } else {
                int i5 = r0.f6878;
                if (i5 == Integer.MIN_VALUE) {
                    i5 = r0.f6879;
                }
                r0.f6882 = i5;
                int i6 = r0.f6884;
                if (i6 == Integer.MIN_VALUE) {
                    i6 = r0.f6883;
                }
                r0.f6880 = i6;
            }
        }
    }

    public Parcelable onSaveInstanceState() {
        C1922 r1;
        SavedState savedState = new SavedState(super.onSaveInstanceState());
        C0120 r12 = this.mExpandedMenuPresenter;
        if (!(r12 == null || (r1 = r12.f651) == null)) {
            savedState.f646 = r1.f6529;
        }
        savedState.f645 = isOverflowMenuShowing();
        return savedState;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        int actionMasked = motionEvent.getActionMasked();
        if (actionMasked == 0) {
            this.mEatingTouch = false;
        }
        if (!this.mEatingTouch) {
            boolean onTouchEvent = super.onTouchEvent(motionEvent);
            if (actionMasked == 0 && !onTouchEvent) {
                this.mEatingTouch = true;
            }
        }
        if (actionMasked == 1 || actionMasked == 3) {
            this.mEatingTouch = false;
        }
        return true;
    }

    public void removeChildrenForExpandedActionView() {
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            View childAt = getChildAt(childCount);
            if (!(((C0116) childAt.getLayoutParams()).f648 == 2 || childAt == this.mMenuView)) {
                removeViewAt(childCount);
                this.mHiddenViews.add(childAt);
            }
        }
    }

    public void setCollapseContentDescription(int i) {
        setCollapseContentDescription(i != 0 ? getContext().getText(i) : null);
    }

    public void setCollapseIcon(int i) {
        setCollapseIcon(C1940.m5017(getContext(), i));
    }

    public void setCollapsible(boolean z) {
        this.mCollapsible = z;
        requestLayout();
    }

    public void setContentInsetEndWithActions(int i) {
        if (i < 0) {
            i = Integer.MIN_VALUE;
        }
        if (i != this.mContentInsetEndWithActions) {
            this.mContentInsetEndWithActions = i;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setContentInsetStartWithNavigation(int i) {
        if (i < 0) {
            i = Integer.MIN_VALUE;
        }
        if (i != this.mContentInsetStartWithNavigation) {
            this.mContentInsetStartWithNavigation = i;
            if (getNavigationIcon() != null) {
                requestLayout();
            }
        }
    }

    public void setContentInsetsAbsolute(int i, int i2) {
        ensureContentInsets();
        C2031 r0 = this.mContentInsets;
        r0.f6885 = false;
        if (i != Integer.MIN_VALUE) {
            r0.f6879 = i;
            r0.f6882 = i;
        }
        if (i2 != Integer.MIN_VALUE) {
            r0.f6883 = i2;
            r0.f6880 = i2;
        }
    }

    public void setContentInsetsRelative(int i, int i2) {
        ensureContentInsets();
        this.mContentInsets.m5262(i, i2);
    }

    public void setLogo(int i) {
        setLogo(C1940.m5017(getContext(), i));
    }

    public void setLogoDescription(int i) {
        setLogoDescription(getContext().getText(i));
    }

    public void setMenu(C1912 r4, ActionMenuPresenter actionMenuPresenter) {
        if (r4 != null || this.mMenuView != null) {
            ensureMenuView();
            C1912 r0 = this.mMenuView.m267();
            if (r0 != r4) {
                if (r0 != null) {
                    r0.removeMenuPresenter(this.mOuterActionMenuPresenter);
                    r0.removeMenuPresenter(this.mExpandedMenuPresenter);
                }
                if (this.mExpandedMenuPresenter == null) {
                    this.mExpandedMenuPresenter = new C0120();
                }
                actionMenuPresenter.f432 = true;
                if (r4 != null) {
                    r4.addMenuPresenter(actionMenuPresenter, this.mPopupContext);
                    r4.addMenuPresenter(this.mExpandedMenuPresenter, this.mPopupContext);
                } else {
                    actionMenuPresenter.initForMenu(this.mPopupContext, null);
                    this.mExpandedMenuPresenter.initForMenu(this.mPopupContext, null);
                    actionMenuPresenter.updateMenuView(true);
                    this.mExpandedMenuPresenter.updateMenuView(true);
                }
                this.mMenuView.setPopupTheme(this.mPopupTheme);
                this.mMenuView.setPresenter(actionMenuPresenter);
                this.mOuterActionMenuPresenter = actionMenuPresenter;
            }
        }
    }

    public void setMenuCallbacks(AbstractC1897.AbstractC1898 k, C1912.AbstractC1914 k2) {
        this.mActionMenuPresenterCallback = k;
        this.mMenuBuilderCallback = k2;
        ActionMenuView actionMenuView = this.mMenuView;
        if (actionMenuView != null) {
            actionMenuView.m269(k, k2);
        }
    }

    public void setNavigationContentDescription(int i) {
        setNavigationContentDescription(i != 0 ? getContext().getText(i) : null);
    }

    public void setNavigationIcon(int i) {
        setNavigationIcon(C1940.m5017(getContext(), i));
    }

    public void setNavigationOnClickListener(View.OnClickListener onClickListener) {
        ensureNavButtonView();
        this.mNavButtonView.setOnClickListener(onClickListener);
    }

    public void setOnMenuItemClickListener(AbstractC0119 r1) {
        this.mOnMenuItemClickListener = r1;
    }

    public void setOverflowIcon(Drawable drawable) {
        ensureMenu();
        this.mMenuView.setOverflowIcon(drawable);
    }

    public void setPopupTheme(int i) {
        if (this.mPopupTheme != i) {
            this.mPopupTheme = i;
            if (i == 0) {
                this.mPopupContext = getContext();
            } else {
                this.mPopupContext = new ContextThemeWrapper(getContext(), i);
            }
        }
    }

    public void setSubtitle(int i) {
        setSubtitle(getContext().getText(i));
    }

    public void setSubtitleTextAppearance(Context context, int i) {
        this.mSubtitleTextAppearance = i;
        TextView textView = this.mSubtitleTextView;
        if (textView != null) {
            textView.setTextAppearance(context, i);
        }
    }

    public void setSubtitleTextColor(int i) {
        setSubtitleTextColor(ColorStateList.valueOf(i));
    }

    public void setTitle(int i) {
        setTitle(getContext().getText(i));
    }

    public void setTitleMargin(int i, int i2, int i3, int i4) {
        this.mTitleMarginStart = i;
        this.mTitleMarginTop = i2;
        this.mTitleMarginEnd = i3;
        this.mTitleMarginBottom = i4;
        requestLayout();
    }

    public void setTitleMarginBottom(int i) {
        this.mTitleMarginBottom = i;
        requestLayout();
    }

    public void setTitleMarginEnd(int i) {
        this.mTitleMarginEnd = i;
        requestLayout();
    }

    public void setTitleMarginStart(int i) {
        this.mTitleMarginStart = i;
        requestLayout();
    }

    public void setTitleMarginTop(int i) {
        this.mTitleMarginTop = i;
        requestLayout();
    }

    public void setTitleTextAppearance(Context context, int i) {
        this.mTitleTextAppearance = i;
        TextView textView = this.mTitleTextView;
        if (textView != null) {
            textView.setTextAppearance(context, i);
        }
    }

    public void setTitleTextColor(int i) {
        setTitleTextColor(ColorStateList.valueOf(i));
    }

    public boolean showOverflowMenu() {
        ActionMenuView actionMenuView = this.mMenuView;
        return actionMenuView != null && actionMenuView.m272();
    }

    /* renamed from: androidx.appcompat.widget.Toolbar$ඓ  reason: contains not printable characters */
    public static class C0116 extends AbstractC1963.C1966 {

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f648 = 0;

        public C0116(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0116(int i, int i2) {
            super(i, i2);
            this.f6691 = 8388627;
        }

        public C0116(C0116 r2) {
            super((AbstractC1963.C1966) r2);
            this.f648 = r2.f648;
        }

        public C0116(AbstractC1963.C1966 k) {
            super(k);
        }

        public C0116(ViewGroup.MarginLayoutParams marginLayoutParams) {
            super(marginLayoutParams);
            ((ViewGroup.MarginLayoutParams) this).leftMargin = marginLayoutParams.leftMargin;
            ((ViewGroup.MarginLayoutParams) this).topMargin = marginLayoutParams.topMargin;
            ((ViewGroup.MarginLayoutParams) this).rightMargin = marginLayoutParams.rightMargin;
            ((ViewGroup.MarginLayoutParams) this).bottomMargin = marginLayoutParams.bottomMargin;
        }

        public C0116(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    public Toolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.toolbarStyle);
    }

    public C0116 generateDefaultLayoutParams() {
        return new C0116(-2, -2);
    }

    public void setCollapseContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            ensureCollapseButtonView();
        }
        ImageButton imageButton = this.mCollapseButtonView;
        if (imageButton != null) {
            imageButton.setContentDescription(charSequence);
        }
    }

    public void setCollapseIcon(Drawable drawable) {
        if (drawable != null) {
            ensureCollapseButtonView();
            this.mCollapseButtonView.setImageDrawable(drawable);
            return;
        }
        ImageButton imageButton = this.mCollapseButtonView;
        if (imageButton != null) {
            imageButton.setImageDrawable(this.mCollapseIcon);
        }
    }

    public void setLogo(Drawable drawable) {
        if (drawable != null) {
            ensureLogoView();
            if (!isChildOrHidden(this.mLogoView)) {
                addSystemView(this.mLogoView, true);
            }
        } else {
            ImageView imageView = this.mLogoView;
            if (imageView != null && isChildOrHidden(imageView)) {
                removeView(this.mLogoView);
                this.mHiddenViews.remove(this.mLogoView);
            }
        }
        ImageView imageView2 = this.mLogoView;
        if (imageView2 != null) {
            imageView2.setImageDrawable(drawable);
        }
    }

    public void setLogoDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            ensureLogoView();
        }
        ImageView imageView = this.mLogoView;
        if (imageView != null) {
            imageView.setContentDescription(charSequence);
        }
    }

    public void setNavigationContentDescription(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            ensureNavButtonView();
        }
        ImageButton imageButton = this.mNavButtonView;
        if (imageButton != null) {
            imageButton.setContentDescription(charSequence);
        }
    }

    public void setNavigationIcon(Drawable drawable) {
        if (drawable != null) {
            ensureNavButtonView();
            if (!isChildOrHidden(this.mNavButtonView)) {
                addSystemView(this.mNavButtonView, true);
            }
        } else {
            ImageButton imageButton = this.mNavButtonView;
            if (imageButton != null && isChildOrHidden(imageButton)) {
                removeView(this.mNavButtonView);
                this.mHiddenViews.remove(this.mNavButtonView);
            }
        }
        ImageButton imageButton2 = this.mNavButtonView;
        if (imageButton2 != null) {
            imageButton2.setImageDrawable(drawable);
        }
    }

    public void setSubtitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            if (this.mSubtitleTextView == null) {
                Context context = getContext();
                this.mSubtitleTextView = new AppCompatTextView(context);
                this.mSubtitleTextView.setSingleLine();
                this.mSubtitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                int i = this.mSubtitleTextAppearance;
                if (i != 0) {
                    this.mSubtitleTextView.setTextAppearance(context, i);
                }
                ColorStateList colorStateList = this.mSubtitleTextColor;
                if (colorStateList != null) {
                    this.mSubtitleTextView.setTextColor(colorStateList);
                }
            }
            if (!isChildOrHidden(this.mSubtitleTextView)) {
                addSystemView(this.mSubtitleTextView, true);
            }
        } else {
            TextView textView = this.mSubtitleTextView;
            if (textView != null && isChildOrHidden(textView)) {
                removeView(this.mSubtitleTextView);
                this.mHiddenViews.remove(this.mSubtitleTextView);
            }
        }
        TextView textView2 = this.mSubtitleTextView;
        if (textView2 != null) {
            textView2.setText(charSequence);
        }
        this.mSubtitleText = charSequence;
    }

    public void setSubtitleTextColor(ColorStateList colorStateList) {
        this.mSubtitleTextColor = colorStateList;
        TextView textView = this.mSubtitleTextView;
        if (textView != null) {
            textView.setTextColor(colorStateList);
        }
    }

    public void setTitle(CharSequence charSequence) {
        if (!TextUtils.isEmpty(charSequence)) {
            if (this.mTitleTextView == null) {
                Context context = getContext();
                this.mTitleTextView = new AppCompatTextView(context);
                this.mTitleTextView.setSingleLine();
                this.mTitleTextView.setEllipsize(TextUtils.TruncateAt.END);
                int i = this.mTitleTextAppearance;
                if (i != 0) {
                    this.mTitleTextView.setTextAppearance(context, i);
                }
                ColorStateList colorStateList = this.mTitleTextColor;
                if (colorStateList != null) {
                    this.mTitleTextView.setTextColor(colorStateList);
                }
            }
            if (!isChildOrHidden(this.mTitleTextView)) {
                addSystemView(this.mTitleTextView, true);
            }
        } else {
            TextView textView = this.mTitleTextView;
            if (textView != null && isChildOrHidden(textView)) {
                removeView(this.mTitleTextView);
                this.mHiddenViews.remove(this.mTitleTextView);
            }
        }
        TextView textView2 = this.mTitleTextView;
        if (textView2 != null) {
            textView2.setText(charSequence);
        }
        this.mTitleText = charSequence;
    }

    public void setTitleTextColor(ColorStateList colorStateList) {
        this.mTitleTextColor = colorStateList;
        TextView textView = this.mTitleTextView;
        if (textView != null) {
            textView.setTextColor(colorStateList);
        }
    }

    public static class SavedState extends AbsSavedState {
        public static final Parcelable.Creator<SavedState> CREATOR = new C0114();

        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean f645;

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f646;

        /* renamed from: androidx.appcompat.widget.Toolbar$SavedState$K  reason: contains not printable characters */
        public class C0114 implements Parcelable.ClassLoaderCreator<SavedState> {
            /* Return type fixed from 'java.lang.Object' to match base method */
            @Override // android.os.Parcelable.ClassLoaderCreator
            public SavedState createFromParcel(Parcel parcel, ClassLoader classLoader) {
                return new SavedState(parcel, classLoader);
            }

            @Override // android.os.Parcelable.Creator
            public Object[] newArray(int i) {
                return new SavedState[i];
            }

            @Override // android.os.Parcelable.Creator
            public Object createFromParcel(Parcel parcel) {
                return new SavedState(parcel, null);
            }
        }

        public SavedState(Parcel parcel, ClassLoader classLoader) {
            super(parcel, classLoader);
            this.f646 = parcel.readInt();
            this.f645 = parcel.readInt() != 0;
        }

        @Override // androidx.customview.view.AbsSavedState
        public void writeToParcel(Parcel parcel, int i) {
            super.writeToParcel(parcel, i);
            parcel.writeInt(this.f646);
            parcel.writeInt(this.f645 ? 1 : 0);
        }

        public SavedState(Parcelable parcelable) {
            super(parcelable);
        }
    }

    public Toolbar(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.mGravity = 8388627;
        this.mTempViews = new ArrayList<>();
        this.mHiddenViews = new ArrayList<>();
        this.mTempMargins = new int[2];
        this.mMenuViewItemClickListener = new C0118();
        this.mShowOverflowMenuRunnable = new RunnableC0117();
        C2019 r0 = C2019.m5223(getContext(), attributeSet, R$styleable.Toolbar, i, 0);
        C1729.m4475(this, context, R$styleable.Toolbar, attributeSet, r0.f6846, i, 0);
        this.mTitleTextAppearance = r0.m5230(R$styleable.Toolbar_titleTextAppearance, 0);
        this.mSubtitleTextAppearance = r0.m5230(R$styleable.Toolbar_subtitleTextAppearance, 0);
        this.mGravity = r0.m5226(R$styleable.Toolbar_android_gravity, this.mGravity);
        this.mButtonGravity = r0.m5226(R$styleable.Toolbar_buttonGravity, 48);
        int r11 = r0.m5228(R$styleable.Toolbar_titleMargin, 0);
        r11 = r0.m5237(R$styleable.Toolbar_titleMargins) ? r0.m5228(R$styleable.Toolbar_titleMargins, r11) : r11;
        this.mTitleMarginBottom = r11;
        this.mTitleMarginTop = r11;
        this.mTitleMarginEnd = r11;
        this.mTitleMarginStart = r11;
        int r112 = r0.m5228(R$styleable.Toolbar_titleMarginStart, -1);
        if (r112 >= 0) {
            this.mTitleMarginStart = r112;
        }
        int r113 = r0.m5228(R$styleable.Toolbar_titleMarginEnd, -1);
        if (r113 >= 0) {
            this.mTitleMarginEnd = r113;
        }
        int r114 = r0.m5228(R$styleable.Toolbar_titleMarginTop, -1);
        if (r114 >= 0) {
            this.mTitleMarginTop = r114;
        }
        int r115 = r0.m5228(R$styleable.Toolbar_titleMarginBottom, -1);
        if (r115 >= 0) {
            this.mTitleMarginBottom = r115;
        }
        this.mMaxButtonHeight = r0.m5224(R$styleable.Toolbar_maxButtonHeight, -1);
        int r116 = r0.m5228(R$styleable.Toolbar_contentInsetStart, Integer.MIN_VALUE);
        int r13 = r0.m5228(R$styleable.Toolbar_contentInsetEnd, Integer.MIN_VALUE);
        int r1 = r0.m5224(R$styleable.Toolbar_contentInsetLeft, 0);
        int r3 = r0.m5224(R$styleable.Toolbar_contentInsetRight, 0);
        ensureContentInsets();
        C2031 r4 = this.mContentInsets;
        r4.f6885 = false;
        if (r1 != Integer.MIN_VALUE) {
            r4.f6879 = r1;
            r4.f6882 = r1;
        }
        if (r3 != Integer.MIN_VALUE) {
            r4.f6883 = r3;
            r4.f6880 = r3;
        }
        if (!(r116 == Integer.MIN_VALUE && r13 == Integer.MIN_VALUE)) {
            this.mContentInsets.m5262(r116, r13);
        }
        this.mContentInsetStartWithNavigation = r0.m5228(R$styleable.Toolbar_contentInsetStartWithNavigation, Integer.MIN_VALUE);
        this.mContentInsetEndWithActions = r0.m5228(R$styleable.Toolbar_contentInsetEndWithActions, Integer.MIN_VALUE);
        this.mCollapseIcon = r0.m5229(R$styleable.Toolbar_collapseIcon);
        this.mCollapseDescription = r0.m5227(R$styleable.Toolbar_collapseContentDescription);
        CharSequence r117 = r0.m5227(R$styleable.Toolbar_title);
        if (!TextUtils.isEmpty(r117)) {
            setTitle(r117);
        }
        CharSequence r118 = r0.m5227(R$styleable.Toolbar_subtitle);
        if (!TextUtils.isEmpty(r118)) {
            setSubtitle(r118);
        }
        this.mPopupContext = getContext();
        setPopupTheme(r0.m5230(R$styleable.Toolbar_popupTheme, 0));
        Drawable r119 = r0.m5229(R$styleable.Toolbar_navigationIcon);
        if (r119 != null) {
            setNavigationIcon(r119);
        }
        CharSequence r1110 = r0.m5227(R$styleable.Toolbar_navigationContentDescription);
        if (!TextUtils.isEmpty(r1110)) {
            setNavigationContentDescription(r1110);
        }
        Drawable r1111 = r0.m5229(R$styleable.Toolbar_logo);
        if (r1111 != null) {
            setLogo(r1111);
        }
        CharSequence r1112 = r0.m5227(R$styleable.Toolbar_logoDescription);
        if (!TextUtils.isEmpty(r1112)) {
            setLogoDescription(r1112);
        }
        if (r0.m5237(R$styleable.Toolbar_titleTextColor)) {
            setTitleTextColor(r0.m5233(R$styleable.Toolbar_titleTextColor));
        }
        if (r0.m5237(R$styleable.Toolbar_subtitleTextColor)) {
            setSubtitleTextColor(r0.m5233(R$styleable.Toolbar_subtitleTextColor));
        }
        if (r0.m5237(R$styleable.Toolbar_menu)) {
            inflateMenu(r0.m5230(R$styleable.Toolbar_menu, 0));
        }
        r0.f6846.recycle();
    }

    @Override // android.view.ViewGroup
    public C0116 generateLayoutParams(AttributeSet attributeSet) {
        return new C0116(getContext(), attributeSet);
    }

    @Override // android.view.ViewGroup
    public C0116 generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        if (layoutParams instanceof C0116) {
            return new C0116((C0116) layoutParams);
        }
        if (layoutParams instanceof AbstractC1963.C1966) {
            return new C0116((AbstractC1963.C1966) layoutParams);
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            return new C0116((ViewGroup.MarginLayoutParams) layoutParams);
        }
        return new C0116(layoutParams);
    }
}
