package androidx.appcompat.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewPropertyAnimator;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.DecelerateInterpolator;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.SpinnerAdapter;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$dimen;
import androidx.appcompat.widget.LinearLayoutCompat;
import ῲ.ῲ.ඓ.C1895;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.K.AbstractC1963;
import K.K.K.ʬ.C2369;

public class ScrollingTabContainerView extends HorizontalScrollView implements AdapterView.OnItemSelectedListener {

    /* renamed from: ʬ  reason: contains not printable characters */
    public View$OnClickListenerC0091 f549;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Spinner f550;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public ViewPropertyAnimator f551;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f552;

    /* renamed from: ῲ  reason: contains not printable characters */
    public Runnable f553;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public int f554;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f555;

    /* renamed from: 㴹  reason: contains not printable characters */
    public boolean f556;

    /* renamed from: 㸾  reason: contains not printable characters */
    public LinearLayoutCompat f557;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f558;

    /* renamed from: androidx.appcompat.widget.ScrollingTabContainerView$ʬ  reason: contains not printable characters */
    public class View$OnClickListenerC0091 implements View.OnClickListener {
        public View$OnClickListenerC0091() {
        }

        public void onClick(View view) {
            ((C0095) view).f566.m5091();
            int childCount = ScrollingTabContainerView.this.f557.getChildCount();
            for (int i = 0; i < childCount; i++) {
                View childAt = ScrollingTabContainerView.this.f557.getChildAt(i);
                childAt.setSelected(childAt == view);
            }
        }
    }

    /* renamed from: androidx.appcompat.widget.ScrollingTabContainerView$ඓ  reason: contains not printable characters */
    public class C0092 extends AnimatorListenerAdapter {

        /* renamed from: ῲ  reason: contains not printable characters */
        public int f561;

        /* renamed from: K  reason: contains not printable characters */
        public boolean f562 = false;

        public C0092() {
        }

        public void onAnimationCancel(Animator animator) {
            this.f562 = true;
        }

        public void onAnimationEnd(Animator animator) {
            if (!this.f562) {
                ScrollingTabContainerView scrollingTabContainerView = ScrollingTabContainerView.this;
                scrollingTabContainerView.f551 = null;
                scrollingTabContainerView.setVisibility(this.f561);
            }
        }

        public void onAnimationStart(Animator animator) {
            ScrollingTabContainerView.this.setVisibility(0);
            this.f562 = false;
        }
    }

    /* renamed from: androidx.appcompat.widget.ScrollingTabContainerView$ῲ  reason: contains not printable characters */
    public class C0093 extends BaseAdapter {
        public C0093() {
        }

        public int getCount() {
            return ScrollingTabContainerView.this.f557.getChildCount();
        }

        public Object getItem(int i) {
            return ((C0095) ScrollingTabContainerView.this.f557.getChildAt(i)).f566;
        }

        public long getItemId(int i) {
            return (long) i;
        }

        public View getView(int i, View view, ViewGroup viewGroup) {
            if (view == null) {
                ScrollingTabContainerView scrollingTabContainerView = ScrollingTabContainerView.this;
                return scrollingTabContainerView.m332(((C0095) scrollingTabContainerView.f557.getChildAt(i)).f566, true);
            }
            C0095 r4 = (C0095) view;
            r4.f566 = ((C0095) ScrollingTabContainerView.this.f557.getChildAt(i)).f566;
            r4.m335();
            return view;
        }
    }

    /* renamed from: androidx.appcompat.widget.ScrollingTabContainerView$K  reason: contains not printable characters */
    public class RunnableC0094 implements Runnable {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ View f565;

        public RunnableC0094(View view) {
            this.f565 = view;
        }

        public void run() {
            ScrollingTabContainerView.this.smoothScrollTo(this.f565.getLeft() - ((ScrollingTabContainerView.this.getWidth() - this.f565.getWidth()) / 2), 0);
            ScrollingTabContainerView.this.f553 = null;
        }
    }

    /* renamed from: androidx.appcompat.widget.ScrollingTabContainerView$㸾  reason: contains not printable characters */
    public class C0095 extends LinearLayout {

        /* renamed from: ʬ  reason: contains not printable characters */
        public AbstractC1963.AbstractC1964 f566;

        /* renamed from: ඓ  reason: contains not printable characters */
        public ImageView f567;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final int[] f568 = {16842964};

        /* renamed from: 㴹  reason: contains not printable characters */
        public View f570;

        /* renamed from: 㸾  reason: contains not printable characters */
        public TextView f571;

        public C0095(Context context, AbstractC1963.AbstractC1964 r6, boolean z) {
            super(context, null, R$attr.actionBarTabStyle);
            Drawable drawable;
            int resourceId;
            this.f566 = r6;
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(null, this.f568, R$attr.actionBarTabStyle, 0);
            if (obtainStyledAttributes.hasValue(0)) {
                if (!obtainStyledAttributes.hasValue(0) || (resourceId = obtainStyledAttributes.getResourceId(0, 0)) == 0) {
                    drawable = obtainStyledAttributes.getDrawable(0);
                } else {
                    drawable = C1940.m5017(context, resourceId);
                }
                setBackgroundDrawable(drawable);
            }
            obtainStyledAttributes.recycle();
            if (z) {
                setGravity(8388627);
            }
            m335();
        }

        public void onInitializeAccessibilityEvent(AccessibilityEvent accessibilityEvent) {
            super.onInitializeAccessibilityEvent(accessibilityEvent);
            accessibilityEvent.setClassName("androidx.appcompat.app.ActionBar$Tab");
        }

        public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo accessibilityNodeInfo) {
            super.onInitializeAccessibilityNodeInfo(accessibilityNodeInfo);
            accessibilityNodeInfo.setClassName("androidx.appcompat.app.ActionBar$Tab");
        }

        public void onMeasure(int i, int i2) {
            int i3;
            super.onMeasure(i, i2);
            if (ScrollingTabContainerView.this.f554 > 0 && getMeasuredWidth() > (i3 = ScrollingTabContainerView.this.f554)) {
                super.onMeasure(View.MeasureSpec.makeMeasureSpec(i3, 1073741824), i2);
            }
        }

        public void setSelected(boolean z) {
            boolean z2 = isSelected() != z;
            super.setSelected(z);
            if (z2 && z) {
                sendAccessibilityEvent(4);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m335() {
            AbstractC1963.AbstractC1964 r0 = this.f566;
            View r1 = r0.m5092();
            CharSequence charSequence = null;
            if (r1 != null) {
                ViewParent parent = r1.getParent();
                if (parent != this) {
                    if (parent != null) {
                        ((ViewGroup) parent).removeView(r1);
                    }
                    addView(r1);
                }
                this.f570 = r1;
                TextView textView = this.f571;
                if (textView != null) {
                    textView.setVisibility(8);
                }
                ImageView imageView = this.f567;
                if (imageView != null) {
                    imageView.setVisibility(8);
                    this.f567.setImageDrawable(null);
                    return;
                }
                return;
            }
            View view = this.f570;
            if (view != null) {
                removeView(view);
                this.f570 = null;
            }
            Drawable r12 = r0.m5090();
            CharSequence r4 = r0.m5094();
            if (r12 != null) {
                if (this.f567 == null) {
                    AppCompatImageView appCompatImageView = new AppCompatImageView(getContext());
                    LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams.gravity = 16;
                    appCompatImageView.setLayoutParams(layoutParams);
                    addView(appCompatImageView, 0);
                    this.f567 = appCompatImageView;
                }
                this.f567.setImageDrawable(r12);
                this.f567.setVisibility(0);
            } else {
                ImageView imageView2 = this.f567;
                if (imageView2 != null) {
                    imageView2.setVisibility(8);
                    this.f567.setImageDrawable(null);
                }
            }
            boolean z = !TextUtils.isEmpty(r4);
            if (z) {
                if (this.f571 == null) {
                    AppCompatTextView appCompatTextView = new AppCompatTextView(getContext(), null, R$attr.actionBarTabTextStyle);
                    appCompatTextView.setEllipsize(TextUtils.TruncateAt.END);
                    LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
                    layoutParams2.gravity = 16;
                    appCompatTextView.setLayoutParams(layoutParams2);
                    addView(appCompatTextView);
                    this.f571 = appCompatTextView;
                }
                this.f571.setText(r4);
                this.f571.setVisibility(0);
            } else {
                TextView textView2 = this.f571;
                if (textView2 != null) {
                    textView2.setVisibility(8);
                    this.f571.setText((CharSequence) null);
                }
            }
            ImageView imageView3 = this.f567;
            if (imageView3 != null) {
                imageView3.setContentDescription(r0.m5093());
            }
            if (!z) {
                charSequence = r0.m5093();
            }
            C2369.m6331((View) this, charSequence);
        }
    }

    static {
        new DecelerateInterpolator();
    }

    public ScrollingTabContainerView(Context context) {
        super(context);
        new C0092();
        setHorizontalScrollBarEnabled(false);
        C1895 k = new C1895(context);
        setContentHeight(k.m4919());
        this.f558 = k.f6435.getResources().getDimensionPixelSize(R$dimen.abc_action_bar_stacked_tab_max_width);
        LinearLayoutCompat linearLayoutCompat = new LinearLayoutCompat(getContext(), null, R$attr.actionBarTabBarStyle);
        linearLayoutCompat.setMeasureWithLargestChildEnabled(true);
        linearLayoutCompat.setGravity(17);
        linearLayoutCompat.setLayoutParams(new LinearLayoutCompat.C0090(-2, -1));
        this.f557 = linearLayoutCompat;
        addView(this.f557, new ViewGroup.LayoutParams(-2, -1));
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        Runnable runnable = this.f553;
        if (runnable != null) {
            post(runnable);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        C1895 k = new C1895(getContext());
        setContentHeight(k.m4919());
        this.f558 = k.f6435.getResources().getDimensionPixelSize(R$dimen.abc_action_bar_stacked_tab_max_width);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        Runnable runnable = this.f553;
        if (runnable != null) {
            removeCallbacks(runnable);
        }
    }

    @Override // android.widget.AdapterView.OnItemSelectedListener
    public void onItemSelected(AdapterView<?> adapterView, View view, int i, long j) {
        ((C0095) view).f566.m5091();
    }

    public void onMeasure(int i, int i2) {
        int mode = View.MeasureSpec.getMode(i);
        boolean z = true;
        boolean z2 = mode == 1073741824;
        setFillViewport(z2);
        int childCount = this.f557.getChildCount();
        if (childCount <= 1 || !(mode == 1073741824 || mode == Integer.MIN_VALUE)) {
            this.f554 = -1;
        } else {
            if (childCount > 2) {
                this.f554 = (int) (((float) View.MeasureSpec.getSize(i)) * 0.4f);
            } else {
                this.f554 = View.MeasureSpec.getSize(i) / 2;
            }
            this.f554 = Math.min(this.f554, this.f558);
        }
        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(this.f552, 1073741824);
        if (z2 || !this.f556) {
            z = false;
        }
        if (z) {
            this.f557.measure(0, makeMeasureSpec);
            if (this.f557.getMeasuredWidth() <= View.MeasureSpec.getSize(i)) {
                m331();
            } else if (!m334()) {
                if (this.f550 == null) {
                    AppCompatSpinner appCompatSpinner = new AppCompatSpinner(getContext(), null, R$attr.actionDropDownStyle);
                    appCompatSpinner.setLayoutParams(new LinearLayoutCompat.C0090(-2, -1));
                    appCompatSpinner.setOnItemSelectedListener(this);
                    this.f550 = appCompatSpinner;
                }
                removeView(this.f557);
                addView(this.f550, new ViewGroup.LayoutParams(-2, -1));
                if (this.f550.getAdapter() == null) {
                    this.f550.setAdapter((SpinnerAdapter) new C0093());
                }
                Runnable runnable = this.f553;
                if (runnable != null) {
                    removeCallbacks(runnable);
                    this.f553 = null;
                }
                this.f550.setSelection(this.f555);
            }
        } else {
            m331();
        }
        int measuredWidth = getMeasuredWidth();
        super.onMeasure(i, makeMeasureSpec);
        int measuredWidth2 = getMeasuredWidth();
        if (z2 && measuredWidth != measuredWidth2) {
            setTabSelected(this.f555);
        }
    }

    @Override // android.widget.AdapterView.OnItemSelectedListener
    public void onNothingSelected(AdapterView<?> adapterView) {
    }

    public void setAllowCollapse(boolean z) {
        this.f556 = z;
    }

    public void setContentHeight(int i) {
        this.f552 = i;
        requestLayout();
    }

    public void setTabSelected(int i) {
        this.f555 = i;
        int childCount = this.f557.getChildCount();
        int i2 = 0;
        while (i2 < childCount) {
            View childAt = this.f557.getChildAt(i2);
            boolean z = i2 == i;
            childAt.setSelected(z);
            if (z) {
                m333(i);
            }
            i2++;
        }
        Spinner spinner = this.f550;
        if (spinner != null && i >= 0) {
            spinner.setSelection(i);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public final boolean m331() {
        Spinner spinner = this.f550;
        if (!(spinner != null && spinner.getParent() == this)) {
            return false;
        }
        removeView(this.f550);
        addView(this.f557, new ViewGroup.LayoutParams(-2, -1));
        setTabSelected(this.f550.getSelectedItemPosition());
        return false;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m334() {
        Spinner spinner = this.f550;
        return spinner != null && spinner.getParent() == this;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m333(int i) {
        View childAt = this.f557.getChildAt(i);
        Runnable runnable = this.f553;
        if (runnable != null) {
            removeCallbacks(runnable);
        }
        this.f553 = new RunnableC0094(childAt);
        post(this.f553);
    }

    /* renamed from: K  reason: contains not printable characters */
    public C0095 m332(AbstractC1963.AbstractC1964 r3, boolean z) {
        C0095 r0 = new C0095(getContext(), r3, z);
        if (z) {
            r0.setBackgroundDrawable(null);
            r0.setLayoutParams(new AbsListView.LayoutParams(-1, this.f552));
        } else {
            r0.setFocusable(true);
            if (this.f549 == null) {
                this.f549 = new View$OnClickListenerC0091();
            }
            r0.setOnClickListener(this.f549);
        }
        return r0;
    }
}
