package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.Configuration;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.transition.Transition;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MenuItem;
import android.view.MotionEvent;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.PopupWindow;
import androidx.appcompat.view.menu.ListMenuItemView;
import java.lang.reflect.Method;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.ඓ.㳳.C1924;
import ῲ.ῲ.㴹.AbstractC2043;
import ῲ.ῲ.㴹.C1995;
import ῲ.ῲ.㴹.C2035;

public class MenuPopupWindow extends C1995 implements AbstractC2043 {

    /* renamed from: ಯ  reason: contains not printable characters */
    public static Method f543 = PopupWindow.class.getDeclaredMethod("setTouchModal", Boolean.TYPE);

    /* renamed from: 㮝  reason: contains not printable characters */
    public AbstractC2043 f544;

    public static class MenuDropDownListView extends C2035 {

        /* renamed from: ؿ  reason: contains not printable characters */
        public final int f545;

        /* renamed from: ݜ  reason: contains not printable characters */
        public MenuItem f546;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public final int f547;

        /* renamed from: 㗽  reason: contains not printable characters */
        public AbstractC2043 f548;

        public MenuDropDownListView(Context context, boolean z) {
            super(context, z);
            Configuration configuration = context.getResources().getConfiguration();
            int i = Build.VERSION.SDK_INT;
            if (1 == configuration.getLayoutDirection()) {
                this.f545 = 21;
                this.f547 = 22;
                return;
            }
            this.f545 = 22;
            this.f547 = 21;
        }

        @Override // ῲ.ῲ.㴹.C2035
        public boolean onHoverEvent(MotionEvent motionEvent) {
            int i;
            C1924 r0;
            int pointToPosition;
            int i2;
            if (this.f548 != null) {
                ListAdapter adapter = getAdapter();
                if (adapter instanceof HeaderViewListAdapter) {
                    HeaderViewListAdapter headerViewListAdapter = (HeaderViewListAdapter) adapter;
                    i = headerViewListAdapter.getHeadersCount();
                    r0 = (C1924) headerViewListAdapter.getWrappedAdapter();
                } else {
                    i = 0;
                    r0 = (C1924) adapter;
                }
                C1922 r2 = null;
                if (motionEvent.getAction() != 10 && (pointToPosition = pointToPosition((int) motionEvent.getX(), (int) motionEvent.getY())) != -1 && (i2 = pointToPosition - i) >= 0 && i2 < r0.getCount()) {
                    r2 = r0.getItem(i2);
                }
                MenuItem menuItem = this.f546;
                if (menuItem != r2) {
                    C1912 r02 = r0.f6548;
                    if (menuItem != null) {
                        this.f548.m5309(r02, menuItem);
                    }
                    this.f546 = r2;
                    if (r2 != null) {
                        this.f548.m5310(r02, r2);
                    }
                }
            }
            return super.onHoverEvent(motionEvent);
        }

        public boolean onKeyDown(int i, KeyEvent keyEvent) {
            ListMenuItemView listMenuItemView = (ListMenuItemView) getSelectedView();
            if (listMenuItemView != null && i == this.f545) {
                if (listMenuItemView.isEnabled() && listMenuItemView.getItemData().hasSubMenu()) {
                    performItemClick(listMenuItemView, getSelectedItemPosition(), getSelectedItemId());
                }
                return true;
            } else if (listMenuItemView == null || i != this.f547) {
                return super.onKeyDown(i, keyEvent);
            } else {
                setSelection(-1);
                ((C1924) getAdapter()).f6548.close(false);
                return true;
            }
        }

        public void setHoverListener(AbstractC2043 r1) {
            this.f548 = r1;
        }

        @Override // ῲ.ῲ.㴹.C2035, android.widget.AbsListView
        public /* bridge */ /* synthetic */ void setSelector(Drawable drawable) {
            super.setSelector(drawable);
        }
    }

    static {
        try {
            if (Build.VERSION.SDK_INT <= 28) {
            }
        } catch (NoSuchMethodException unused) {
            Log.i("MenuPopupWindow", "Could not find method setTouchModal() on PopupWindow. Oh well.");
        }
    }

    public MenuPopupWindow(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m324(boolean z) {
        if (Build.VERSION.SDK_INT <= 28) {
            Method method = f543;
            if (method != null) {
                try {
                    method.invoke(this.f6786, Boolean.valueOf(z));
                } catch (Exception unused) {
                    Log.i("MenuPopupWindow", "Could not invoke setTouchModal() on PopupWindow. Oh well.");
                }
            }
        } else {
            this.f6786.setTouchModal(z);
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m325(Object obj) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.f6786.setExitTransition((Transition) obj);
        }
    }

    @Override // ῲ.ῲ.㴹.C1995
    /* renamed from: K  reason: contains not printable characters */
    public C2035 m327(Context context, boolean z) {
        MenuDropDownListView menuDropDownListView = new MenuDropDownListView(context, z);
        menuDropDownListView.setHoverListener(this);
        return menuDropDownListView;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2043
    /* renamed from: ῲ  reason: contains not printable characters */
    public void m326(C1912 r2, MenuItem menuItem) {
        AbstractC2043 r0 = this.f544;
        if (r0 != null) {
            r0.m5309(r2, menuItem);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m328(Object obj) {
        if (Build.VERSION.SDK_INT >= 23) {
            this.f6786.setEnterTransition((Transition) obj);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m330(AbstractC2043 r1) {
        this.f544 = r1;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2043
    /* renamed from: K  reason: contains not printable characters */
    public void m329(C1912 r2, MenuItem menuItem) {
        AbstractC2043 r0 = this.f544;
        if (r0 != null) {
            r0.m5310(r2, menuItem);
        }
    }
}
