package androidx.appcompat.widget;

import android.content.Context;
import android.graphics.Rect;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.FrameLayout;
import androidx.appcompat.app.AppCompatDelegateImpl;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.K.C1946;
import ῲ.ῲ.㴹.AbstractC2034;

public class ContentFrameLayout extends FrameLayout {

    /* renamed from: ʬ  reason: contains not printable characters */
    public TypedValue f531;

    /* renamed from: ඓ  reason: contains not printable characters */
    public TypedValue f532;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public AbstractC0089 f533;

    /* renamed from: ῲ  reason: contains not printable characters */
    public TypedValue f534;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public TypedValue f535;

    /* renamed from: 㴹  reason: contains not printable characters */
    public TypedValue f536;

    /* renamed from: 㸾  reason: contains not printable characters */
    public TypedValue f537;

    /* renamed from: 㿎  reason: contains not printable characters */
    public final Rect f538;

    /* renamed from: androidx.appcompat.widget.ContentFrameLayout$K  reason: contains not printable characters */
    public interface AbstractC0089 {
    }

    public ContentFrameLayout(Context context) {
        this(context, null);
    }

    public TypedValue getFixedHeightMajor() {
        if (this.f536 == null) {
            this.f536 = new TypedValue();
        }
        return this.f536;
    }

    public TypedValue getFixedHeightMinor() {
        if (this.f535 == null) {
            this.f535 = new TypedValue();
        }
        return this.f535;
    }

    public TypedValue getFixedWidthMajor() {
        if (this.f537 == null) {
            this.f537 = new TypedValue();
        }
        return this.f537;
    }

    public TypedValue getFixedWidthMinor() {
        if (this.f532 == null) {
            this.f532 = new TypedValue();
        }
        return this.f532;
    }

    public TypedValue getMinWidthMajor() {
        if (this.f534 == null) {
            this.f534 = new TypedValue();
        }
        return this.f534;
    }

    public TypedValue getMinWidthMinor() {
        if (this.f531 == null) {
            this.f531 = new TypedValue();
        }
        return this.f531;
    }

    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        AbstractC0089 k = this.f533;
        if (k != null) {
            ((C1946) k).m5022();
        }
    }

    public void onDetachedFromWindow() {
        C1912 r0;
        super.onDetachedFromWindow();
        AbstractC0089 k = this.f533;
        if (k != null) {
            AppCompatDelegateImpl appCompatDelegateImpl = ((C1946) k).f6639;
            AbstractC2034 r1 = appCompatDelegateImpl.f270;
            if (r1 != null) {
                r1.m5268();
            }
            if (appCompatDelegateImpl.f259 != null) {
                appCompatDelegateImpl.f280.getDecorView().removeCallbacks(appCompatDelegateImpl.f274);
                if (appCompatDelegateImpl.f259.isShowing()) {
                    try {
                        appCompatDelegateImpl.f259.dismiss();
                    } catch (IllegalArgumentException unused) {
                    }
                }
                appCompatDelegateImpl.f259 = null;
            }
            appCompatDelegateImpl.m180();
            AppCompatDelegateImpl.PanelFeatureState r02 = appCompatDelegateImpl.m182(0);
            if (r02 != null && (r0 = r02.f303) != null) {
                r0.close();
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:19:0x004a  */
    /* JADX WARNING: Removed duplicated region for block: B:22:0x0065  */
    /* JADX WARNING: Removed duplicated region for block: B:35:0x0088  */
    /* JADX WARNING: Removed duplicated region for block: B:40:0x00ad  */
    /* JADX WARNING: Removed duplicated region for block: B:41:0x00b0  */
    /* JADX WARNING: Removed duplicated region for block: B:46:0x00ba  */
    /* JADX WARNING: Removed duplicated region for block: B:48:0x00c0  */
    /* JADX WARNING: Removed duplicated region for block: B:52:0x00ce  */
    /* JADX WARNING: Removed duplicated region for block: B:54:0x00d8  */
    /* JADX WARNING: Removed duplicated region for block: B:57:0x00e0  */
    /* JADX WARNING: Removed duplicated region for block: B:59:? A[RETURN, SYNTHETIC] */
    public void onMeasure(int i, int i2) {
        boolean z;
        int i3;
        int measuredWidth;
        int i4;
        int i5;
        float fraction;
        int i6;
        int i7;
        float fraction2;
        int i8;
        int i9;
        float fraction3;
        DisplayMetrics displayMetrics = getContext().getResources().getDisplayMetrics();
        boolean z2 = true;
        boolean z3 = displayMetrics.widthPixels < displayMetrics.heightPixels;
        int mode = View.MeasureSpec.getMode(i);
        int mode2 = View.MeasureSpec.getMode(i2);
        if (mode == Integer.MIN_VALUE) {
            TypedValue typedValue = z3 ? this.f532 : this.f537;
            if (!(typedValue == null || (i8 = typedValue.type) == 0)) {
                if (i8 == 5) {
                    fraction3 = typedValue.getDimension(displayMetrics);
                } else if (i8 == 6) {
                    int i10 = displayMetrics.widthPixels;
                    fraction3 = typedValue.getFraction((float) i10, (float) i10);
                } else {
                    i9 = 0;
                    if (i9 > 0) {
                        Rect rect = this.f538;
                        i3 = View.MeasureSpec.makeMeasureSpec(Math.min(i9 - (rect.left + rect.right), View.MeasureSpec.getSize(i)), 1073741824);
                        z = true;
                        if (mode2 == Integer.MIN_VALUE) {
                            TypedValue typedValue2 = z3 ? this.f536 : this.f535;
                            if (!(typedValue2 == null || (i6 = typedValue2.type) == 0)) {
                                if (i6 == 5) {
                                    fraction2 = typedValue2.getDimension(displayMetrics);
                                } else if (i6 == 6) {
                                    int i11 = displayMetrics.heightPixels;
                                    fraction2 = typedValue2.getFraction((float) i11, (float) i11);
                                } else {
                                    i7 = 0;
                                    if (i7 > 0) {
                                        Rect rect2 = this.f538;
                                        i2 = View.MeasureSpec.makeMeasureSpec(Math.min(i7 - (rect2.top + rect2.bottom), View.MeasureSpec.getSize(i2)), 1073741824);
                                    }
                                }
                                i7 = (int) fraction2;
                                if (i7 > 0) {
                                }
                            }
                        }
                        super.onMeasure(i3, i2);
                        measuredWidth = getMeasuredWidth();
                        int makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(measuredWidth, 1073741824);
                        if (!z && mode == Integer.MIN_VALUE) {
                            TypedValue typedValue3 = !z3 ? this.f531 : this.f534;
                            if (!(typedValue3 == null || (i4 = typedValue3.type) == 0)) {
                                if (i4 != 5) {
                                    fraction = typedValue3.getDimension(displayMetrics);
                                } else if (i4 == 6) {
                                    int i12 = displayMetrics.widthPixels;
                                    fraction = typedValue3.getFraction((float) i12, (float) i12);
                                } else {
                                    i5 = 0;
                                    if (i5 > 0) {
                                        Rect rect3 = this.f538;
                                        i5 -= rect3.left + rect3.right;
                                    }
                                    if (measuredWidth < i5) {
                                        makeMeasureSpec = View.MeasureSpec.makeMeasureSpec(i5, 1073741824);
                                        if (z2) {
                                            super.onMeasure(makeMeasureSpec, i2);
                                            return;
                                        }
                                        return;
                                    }
                                }
                                i5 = (int) fraction;
                                if (i5 > 0) {
                                }
                                if (measuredWidth < i5) {
                                }
                            }
                        }
                        z2 = false;
                        if (z2) {
                        }
                    }
                }
                i9 = (int) fraction3;
                if (i9 > 0) {
                }
            }
        }
        i3 = i;
        z = false;
        if (mode2 == Integer.MIN_VALUE) {
        }
        super.onMeasure(i3, i2);
        measuredWidth = getMeasuredWidth();
        int makeMeasureSpec2 = View.MeasureSpec.makeMeasureSpec(measuredWidth, 1073741824);
        if (!z3) {
        }
        if (i4 != 5) {
        }
        i5 = (int) fraction;
        if (i5 > 0) {
        }
        if (measuredWidth < i5) {
        }
        z2 = false;
        if (z2) {
        }
    }

    public void setAttachListener(AbstractC0089 k) {
        this.f533 = k;
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m323(int i, int i2, int i3, int i4) {
        this.f538.set(i, i2, i3, i4);
        if (C1729.m4512(this)) {
            requestLayout();
        }
    }

    public ContentFrameLayout(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ContentFrameLayout(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        this.f538 = new Rect();
    }
}
