package androidx.appcompat.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.widget.RadioButton;
import androidx.appcompat.R$attr;
import ῲ.ᨨ.ᨨ.AbstractC1740;
import ῲ.ᨨ.㳳.AbstractC1834;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.C2008;
import ῲ.ῲ.㴹.C2009;
import ῲ.ῲ.㴹.C2048;
import ῲ.ῲ.㴹.C2054;
import ῲ.ῲ.㴹.C2056;

public class AppCompatRadioButton extends RadioButton implements AbstractC1834, AbstractC1740 {
    public final C2048 mBackgroundTintHelper;
    public final C2008 mCompoundButtonHelper;
    public final C2054 mTextHelper;

    public AppCompatRadioButton(Context context) {
        this(context, null);
    }

    public void drawableStateChanged() {
        super.drawableStateChanged();
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5331();
        }
        C2054 r02 = this.mTextHelper;
        if (r02 != null) {
            r02.m5347();
        }
    }

    public int getCompoundPaddingLeft() {
        int compoundPaddingLeft = super.getCompoundPaddingLeft();
        if (this.mCompoundButtonHelper != null) {
            int i = Build.VERSION.SDK_INT;
        }
        return compoundPaddingLeft;
    }

    public ColorStateList getSupportBackgroundTintList() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5329();
        }
        return null;
    }

    public PorterDuff.Mode getSupportBackgroundTintMode() {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            return r0.m5328();
        }
        return null;
    }

    public ColorStateList getSupportButtonTintList() {
        C2008 r0 = this.mCompoundButtonHelper;
        if (r0 != null) {
            return r0.f6823;
        }
        return null;
    }

    public PorterDuff.Mode getSupportButtonTintMode() {
        C2008 r0 = this.mCompoundButtonHelper;
        if (r0 != null) {
            return r0.f6821;
        }
        return null;
    }

    public void setBackgroundDrawable(Drawable drawable) {
        super.setBackgroundDrawable(drawable);
        C2048 r1 = this.mBackgroundTintHelper;
        if (r1 != null) {
            r1.m5336();
        }
    }

    public void setBackgroundResource(int i) {
        super.setBackgroundResource(i);
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5332(i);
        }
    }

    @Override // android.widget.CompoundButton
    public void setButtonDrawable(Drawable drawable) {
        super.setButtonDrawable(drawable);
        C2008 r2 = this.mCompoundButtonHelper;
        if (r2 == null) {
            return;
        }
        if (r2.f6825) {
            r2.f6825 = false;
            return;
        }
        r2.f6825 = true;
        r2.m5197();
    }

    public void setSupportBackgroundTintList(ColorStateList colorStateList) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5330(colorStateList);
        }
    }

    public void setSupportBackgroundTintMode(PorterDuff.Mode mode) {
        C2048 r0 = this.mBackgroundTintHelper;
        if (r0 != null) {
            r0.m5334(mode);
        }
    }

    public void setSupportButtonTintList(ColorStateList colorStateList) {
        C2008 r0 = this.mCompoundButtonHelper;
        if (r0 != null) {
            r0.f6823 = colorStateList;
            r0.f6826 = true;
            r0.m5197();
        }
    }

    public void setSupportButtonTintMode(PorterDuff.Mode mode) {
        C2008 r0 = this.mCompoundButtonHelper;
        if (r0 != null) {
            r0.f6821 = mode;
            r0.f6822 = true;
            r0.m5197();
        }
    }

    public AppCompatRadioButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, R$attr.radioButtonStyle);
    }

    /* JADX INFO: super call moved to the top of the method (can break code semantics) */
    public AppCompatRadioButton(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        C2009.m5199(context);
        C2056.m5362(this, getContext());
        this.mCompoundButtonHelper = new C2008(this);
        this.mCompoundButtonHelper.m5198(attributeSet, i);
        this.mBackgroundTintHelper = new C2048(this);
        this.mBackgroundTintHelper.m5335(attributeSet, i);
        this.mTextHelper = new C2054(this);
        this.mTextHelper.m5355(attributeSet, i);
    }

    @Override // android.widget.CompoundButton
    public void setButtonDrawable(int i) {
        setButtonDrawable(C1940.m5017(getContext(), i));
    }
}
