package androidx.appcompat.widget;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.AttributeSet;
import android.view.Menu;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewPropertyAnimator;
import android.view.Window;
import android.view.WindowInsets;
import android.widget.OverScroller;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$id;
import ඓ.K.K.K.C1293;
import ῲ.ᨨ.ʬ.C1716;
import ῲ.ᨨ.ᨨ.AbstractC1741;
import ῲ.ᨨ.ᨨ.AbstractC1742;
import ῲ.ᨨ.ᨨ.AbstractC1767;
import ῲ.ᨨ.ᨨ.C1729;
import ῲ.ᨨ.ᨨ.C1751;
import ῲ.ᨨ.ᨨ.C1754;
import ῲ.ῲ.ඓ.㳳.AbstractC1897;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ῲ.K.C1940;
import ῲ.ῲ.㴹.AbstractC2002;
import ῲ.ῲ.㴹.AbstractC2034;
import ῲ.ῲ.㴹.C2040;

@SuppressLint({"UnknownNullness"})
public class ActionBarOverlayLayout extends ViewGroup implements AbstractC2034, AbstractC1741, AbstractC1742, AbstractC1767 {

    /* renamed from: ሽ  reason: contains not printable characters */
    public static final int[] f381 = {R$attr.actionBarSize, 16842841};

    /* renamed from: ʬ  reason: contains not printable characters */
    public int f382;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f383;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public final Rect f384;

    /* renamed from: ؿ  reason: contains not printable characters */
    public final Rect f385;

    /* renamed from: ݜ  reason: contains not printable characters */
    public final Rect f386;

    /* renamed from: ඓ  reason: contains not printable characters */
    public ActionBarContainer f387;

    /* renamed from: ᆯ  reason: contains not printable characters */
    public final Runnable f388;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public C1754 f389;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public C1754 f390;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public final Rect f391;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean f392;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public final Runnable f393;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f394;

    /* renamed from: ῲ  reason: contains not printable characters */
    public int f395;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public Drawable f396;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public final C1751 f397;

    /* renamed from: ゎ  reason: contains not printable characters */
    public AbstractC0059 f398;

    /* renamed from: ト  reason: contains not printable characters */
    public OverScroller f399;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f400;

    /* renamed from: 㗗  reason: contains not printable characters */
    public final Rect f401;

    /* renamed from: 㗽  reason: contains not printable characters */
    public final Rect f402;

    /* renamed from: 㮔  reason: contains not printable characters */
    public ViewPropertyAnimator f403;

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean f404;

    /* renamed from: 㴪  reason: contains not printable characters */
    public C1754 f405;

    /* renamed from: 㴹  reason: contains not printable characters */
    public AbstractC2002 f406;

    /* renamed from: 㶋  reason: contains not printable characters */
    public C1754 f407;

    /* renamed from: 㸾  reason: contains not printable characters */
    public ContentFrameLayout f408;

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean f409;

    /* renamed from: 䀟  reason: contains not printable characters */
    public final Rect f410;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f411;

    /* renamed from: 䃖  reason: contains not printable characters */
    public final AnimatorListenerAdapter f412;

    /* renamed from: androidx.appcompat.widget.ActionBarOverlayLayout$ʬ  reason: contains not printable characters */
    public class RunnableC0055 implements Runnable {
        public RunnableC0055() {
        }

        public void run() {
            ActionBarOverlayLayout.this.m242();
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.f403 = actionBarOverlayLayout.f387.animate().translationY((float) (-ActionBarOverlayLayout.this.f387.getHeight())).setListener(ActionBarOverlayLayout.this.f412);
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionBarOverlayLayout$ඓ  reason: contains not printable characters */
    public static class C0056 extends ViewGroup.MarginLayoutParams {
        public C0056(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
        }

        public C0056(int i, int i2) {
            super(i, i2);
        }

        public C0056(ViewGroup.LayoutParams layoutParams) {
            super(layoutParams);
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionBarOverlayLayout$ῲ  reason: contains not printable characters */
    public class RunnableC0057 implements Runnable {
        public RunnableC0057() {
        }

        public void run() {
            ActionBarOverlayLayout.this.m242();
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.f403 = actionBarOverlayLayout.f387.animate().translationY(0.0f).setListener(ActionBarOverlayLayout.this.f412);
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionBarOverlayLayout$K  reason: contains not printable characters */
    public class C0058 extends AnimatorListenerAdapter {
        public C0058() {
        }

        public void onAnimationCancel(Animator animator) {
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.f403 = null;
            actionBarOverlayLayout.f400 = false;
        }

        public void onAnimationEnd(Animator animator) {
            ActionBarOverlayLayout actionBarOverlayLayout = ActionBarOverlayLayout.this;
            actionBarOverlayLayout.f403 = null;
            actionBarOverlayLayout.f400 = false;
        }
    }

    /* renamed from: androidx.appcompat.widget.ActionBarOverlayLayout$㸾  reason: contains not printable characters */
    public interface AbstractC0059 {
        /* renamed from: ʬ  reason: contains not printable characters */
        void m243();

        /* renamed from: ῲ  reason: contains not printable characters */
        void m244();

        /* renamed from: K  reason: contains not printable characters */
        void m245();

        /* renamed from: K  reason: contains not printable characters */
        void m246(int i);

        /* renamed from: K  reason: contains not printable characters */
        void m247(boolean z);

        /* renamed from: 㸾  reason: contains not printable characters */
        void m248();
    }

    public ActionBarOverlayLayout(Context context) {
        this(context, null);
    }

    public boolean checkLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return layoutParams instanceof C0056;
    }

    public void draw(Canvas canvas) {
        int i;
        super.draw(canvas);
        if (this.f396 != null && !this.f409) {
            if (this.f387.getVisibility() == 0) {
                i = (int) (this.f387.getTranslationY() + ((float) this.f387.getBottom()) + 0.5f);
            } else {
                i = 0;
            }
            this.f396.setBounds(0, i, getWidth(), this.f396.getIntrinsicHeight() + i);
            this.f396.draw(canvas);
        }
    }

    public boolean fitSystemWindows(Rect rect) {
        int i = Build.VERSION.SDK_INT;
        return super.fitSystemWindows(rect);
    }

    public int getActionBarHideOffset() {
        ActionBarContainer actionBarContainer = this.f387;
        if (actionBarContainer != null) {
            return -((int) actionBarContainer.getTranslationY());
        }
        return 0;
    }

    public int getNestedScrollAxes() {
        return this.f397.m4547();
    }

    public CharSequence getTitle() {
        m239();
        return ((C2040) this.f406).f6933.getTitle();
    }

    public WindowInsets onApplyWindowInsets(WindowInsets windowInsets) {
        m239();
        C1754 r8 = C1754.m4554(windowInsets);
        boolean r0 = m238(this.f387, new Rect(r8.m4556(), r8.m4557(), r8.m4563(), r8.m4558()), true, true, false, true);
        C1729.m4469(this, r8, this.f401);
        Rect rect = this.f401;
        this.f407 = r8.f6069.m4587(rect.left, rect.top, rect.right, rect.bottom);
        if (!this.f390.equals(this.f407)) {
            this.f390 = this.f407;
            r0 = true;
        }
        if (!this.f385.equals(this.f401)) {
            this.f385.set(this.f401);
            r0 = true;
        }
        if (r0) {
            requestLayout();
        }
        return r8.f6069.m4586().m4560().f6069.m4582().m4559();
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        m235(getContext());
        C1729.m4451(this);
    }

    public void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        m242();
    }

    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        int childCount = getChildCount();
        int paddingLeft = getPaddingLeft();
        int paddingTop = getPaddingTop();
        for (int i5 = 0; i5 < childCount; i5++) {
            View childAt = getChildAt(i5);
            if (childAt.getVisibility() != 8) {
                C0056 r0 = (C0056) childAt.getLayoutParams();
                int measuredWidth = childAt.getMeasuredWidth();
                int measuredHeight = childAt.getMeasuredHeight();
                int i6 = ((ViewGroup.MarginLayoutParams) r0).leftMargin + paddingLeft;
                int i7 = ((ViewGroup.MarginLayoutParams) r0).topMargin + paddingTop;
                childAt.layout(i6, i7, measuredWidth + i6, measuredHeight + i7);
            }
        }
    }

    public void onMeasure(int i, int i2) {
        int i3;
        C1754.C1764 r5;
        m239();
        measureChildWithMargins(this.f387, i, 0, i2, 0);
        C0056 r0 = (C0056) this.f387.getLayoutParams();
        int max = Math.max(0, this.f387.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) r0).leftMargin + ((ViewGroup.MarginLayoutParams) r0).rightMargin);
        int max2 = Math.max(0, this.f387.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r0).topMargin + ((ViewGroup.MarginLayoutParams) r0).bottomMargin);
        int combineMeasuredStates = View.combineMeasuredStates(0, this.f387.getMeasuredState());
        boolean z = (C1729.m4452(this) & 256) != 0;
        if (z) {
            i3 = this.f395;
            if (this.f404 && this.f387.getTabContainer() != null) {
                i3 += this.f395;
            }
        } else {
            i3 = this.f387.getVisibility() != 8 ? this.f387.getMeasuredHeight() : 0;
        }
        this.f391.set(this.f401);
        int i4 = Build.VERSION.SDK_INT;
        this.f405 = this.f407;
        if (this.f394 || z) {
            int i5 = Build.VERSION.SDK_INT;
            C1716 r2 = C1716.m4394(this.f405.m4556(), this.f405.m4557() + i3, this.f405.m4563(), this.f405.m4558() + 0);
            C1754 r4 = this.f405;
            int i6 = Build.VERSION.SDK_INT;
            if (i6 >= 30) {
                r5 = new C1754.C1756(r4);
            } else if (i6 >= 29) {
                r5 = new C1754.C1765(r4);
            } else {
                r5 = new C1754.C1755(r4);
            }
            r5.m4604(r2);
            this.f405 = r5.m4600();
        } else {
            Rect rect = this.f391;
            rect.top += i3;
            rect.bottom += 0;
            this.f405 = this.f405.f6069.m4587(0, i3, 0, 0);
        }
        m238(this.f408, this.f391, true, true, true, true);
        int i7 = Build.VERSION.SDK_INT;
        if (!this.f389.equals(this.f405)) {
            C1754 r22 = this.f405;
            this.f389 = r22;
            C1729.m4468(this.f408, r22);
        } else {
            int i8 = Build.VERSION.SDK_INT;
        }
        measureChildWithMargins(this.f408, i, 0, i2, 0);
        C0056 r23 = (C0056) this.f408.getLayoutParams();
        int max3 = Math.max(max, this.f408.getMeasuredWidth() + ((ViewGroup.MarginLayoutParams) r23).leftMargin + ((ViewGroup.MarginLayoutParams) r23).rightMargin);
        int max4 = Math.max(max2, this.f408.getMeasuredHeight() + ((ViewGroup.MarginLayoutParams) r23).topMargin + ((ViewGroup.MarginLayoutParams) r23).bottomMargin);
        int combineMeasuredStates2 = View.combineMeasuredStates(combineMeasuredStates, this.f408.getMeasuredState());
        setMeasuredDimension(View.resolveSizeAndState(Math.max(getPaddingRight() + getPaddingLeft() + max3, getSuggestedMinimumWidth()), i, combineMeasuredStates2), View.resolveSizeAndState(Math.max(getPaddingBottom() + getPaddingTop() + max4, getSuggestedMinimumHeight()), i2, combineMeasuredStates2 << 16));
    }

    public boolean onNestedFling(View view, float f, float f2, boolean z) {
        boolean z2 = false;
        if (!this.f392 || !z) {
            return false;
        }
        this.f399.fling(0, 0, 0, (int) f2, 0, 0, Integer.MIN_VALUE, Integer.MAX_VALUE);
        if (this.f399.getFinalY() > this.f387.getHeight()) {
            z2 = true;
        }
        if (z2) {
            m242();
            this.f388.run();
        } else {
            m242();
            this.f393.run();
        }
        this.f400 = true;
        return true;
    }

    public boolean onNestedPreFling(View view, float f, float f2) {
        return false;
    }

    public void onNestedPreScroll(View view, int i, int i2, int[] iArr) {
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedPreScroll(View view, int i, int i2, int[] iArr, int i3) {
        if (i3 == 0) {
            onNestedPreScroll(view, i, i2, iArr);
        }
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1767
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5, int[] iArr) {
        onNestedScroll(view, i, i2, i3, i4, i5);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScrollAccepted(View view, View view2, int i, int i2) {
        if (i2 == 0) {
            onNestedScrollAccepted(view, view2, i);
        }
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public boolean onStartNestedScroll(View view, View view2, int i, int i2) {
        return i2 == 0 && onStartNestedScroll(view, view2, i);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onStopNestedScroll(View view, int i) {
        if (i == 0) {
            onStopNestedScroll(view);
        }
    }

    public void onWindowSystemUiVisibilityChanged(int i) {
        int i2 = Build.VERSION.SDK_INT;
        super.onWindowSystemUiVisibilityChanged(i);
        m239();
        int i3 = this.f383 ^ i;
        this.f383 = i;
        boolean z = false;
        boolean z2 = (i & 4) == 0;
        if ((i & 256) != 0) {
            z = true;
        }
        AbstractC0059 r5 = this.f398;
        if (r5 != null) {
            r5.m247(!z);
            if (z2 || !z) {
                this.f398.m245();
            } else {
                this.f398.m243();
            }
        }
        if ((i3 & 256) != 0 && this.f398 != null) {
            C1729.m4451(this);
        }
    }

    public void onWindowVisibilityChanged(int i) {
        super.onWindowVisibilityChanged(i);
        this.f382 = i;
        AbstractC0059 r0 = this.f398;
        if (r0 != null) {
            r0.m246(i);
        }
    }

    public void setActionBarHideOffset(int i) {
        m242();
        this.f387.setTranslationY((float) (-Math.max(0, Math.min(i, this.f387.getHeight()))));
    }

    public void setActionBarVisibilityCallback(AbstractC0059 r2) {
        this.f398 = r2;
        if (getWindowToken() != null) {
            this.f398.m246(this.f382);
            int i = this.f383;
            if (i != 0) {
                onWindowSystemUiVisibilityChanged(i);
                C1729.m4451(this);
            }
        }
    }

    public void setHasNonEmbeddedTabs(boolean z) {
        this.f404 = z;
    }

    public void setHideOnContentScrollEnabled(boolean z) {
        if (z != this.f392) {
            this.f392 = z;
            if (!z) {
                m242();
                setActionBarHideOffset(0);
            }
        }
    }

    public void setIcon(int i) {
        m239();
        C2040 r0 = (C2040) this.f406;
        r0.f6927 = i != 0 ? C1940.m5017(r0.m5294(), i) : null;
        r0.m5301();
    }

    public void setLogo(int i) {
        m239();
        C2040 r0 = (C2040) this.f406;
        r0.m5297(i != 0 ? C1940.m5017(r0.m5294(), i) : null);
    }

    public void setOverlayMode(boolean z) {
        this.f394 = z;
        this.f409 = z && getContext().getApplicationInfo().targetSdkVersion < 19;
    }

    public void setShowingForActionMode(boolean z) {
    }

    public void setUiOptions(int i) {
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    public void setWindowCallback(Window.Callback callback) {
        m239();
        ((C2040) this.f406).f6934 = callback;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    public void setWindowTitle(CharSequence charSequence) {
        m239();
        C2040 r0 = (C2040) this.f406;
        if (!r0.f6939) {
            r0.m5299(charSequence);
        }
    }

    public boolean shouldDelayChildPressedState() {
        return false;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m229() {
        m239();
        return ((C2040) this.f406).f6933.hideOverflowMenu();
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: ඓ  reason: contains not printable characters */
    public void m230() {
        m239();
        ((C2040) this.f406).f6933.dismissPopupMenus();
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean m231() {
        return this.f394;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m232() {
        m239();
        return ((C2040) this.f406).f6933.isOverflowMenuShowing();
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean m233() {
        m239();
        return ((C2040) this.f406).f6933.canShowOverflowMenu();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m235(Context context) {
        TypedArray obtainStyledAttributes = getContext().getTheme().obtainStyledAttributes(f381);
        boolean z = false;
        this.f395 = obtainStyledAttributes.getDimensionPixelSize(0, 0);
        this.f396 = obtainStyledAttributes.getDrawable(1);
        setWillNotDraw(this.f396 == null);
        obtainStyledAttributes.recycle();
        if (context.getApplicationInfo().targetSdkVersion < 19) {
            z = true;
        }
        this.f409 = z;
        this.f399 = new OverScroller(context);
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public void m239() {
        AbstractC2002 r0;
        if (this.f408 == null) {
            this.f408 = (ContentFrameLayout) findViewById(R$id.action_bar_activity_content);
            this.f387 = (ActionBarContainer) findViewById(R$id.action_bar_container);
            View findViewById = findViewById(R$id.action_bar);
            if (findViewById instanceof AbstractC2002) {
                r0 = (AbstractC2002) findViewById;
            } else if (findViewById instanceof Toolbar) {
                r0 = ((Toolbar) findViewById).getWrapper();
            } else {
                StringBuilder r2 = C1293.m3416("Can't make a decor toolbar out of ");
                r2.append(findViewById.getClass().getSimpleName());
                throw new IllegalStateException(r2.toString());
            }
            this.f406 = r0;
        }
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: 㴹  reason: contains not printable characters */
    public void m240() {
        m239();
        ((C2040) this.f406).f6940 = true;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: 㸾  reason: contains not printable characters */
    public boolean m241() {
        m239();
        return ((C2040) this.f406).f6933.showOverflowMenu();
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m242() {
        removeCallbacks(this.f393);
        removeCallbacks(this.f388);
        ViewPropertyAnimator viewPropertyAnimator = this.f403;
        if (viewPropertyAnimator != null) {
            viewPropertyAnimator.cancel();
        }
    }

    public ActionBarOverlayLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f382 = 0;
        this.f401 = new Rect();
        this.f385 = new Rect();
        this.f391 = new Rect();
        this.f402 = new Rect();
        this.f386 = new Rect();
        this.f410 = new Rect();
        this.f384 = new Rect();
        C1754 r2 = C1754.f6068;
        this.f407 = r2;
        this.f390 = r2;
        this.f405 = r2;
        this.f389 = r2;
        this.f412 = new C0058();
        this.f393 = new RunnableC0057();
        this.f388 = new RunnableC0055();
        m235(context);
        this.f397 = new C1751();
    }

    public C0056 generateDefaultLayoutParams() {
        return new C0056(-1, -1);
    }

    @Override // android.view.ViewGroup
    public C0056 generateLayoutParams(AttributeSet attributeSet) {
        return new C0056(getContext(), attributeSet);
    }

    @Override // ῲ.ᨨ.ᨨ.AbstractC1742
    public void onNestedScroll(View view, int i, int i2, int i3, int i4, int i5) {
        if (i5 == 0) {
            onNestedScroll(view, i, i2, i3, i4);
        }
    }

    public void onNestedScrollAccepted(View view, View view2, int i) {
        this.f397.f6066 = i;
        this.f411 = getActionBarHideOffset();
        m242();
        AbstractC0059 r1 = this.f398;
        if (r1 != null) {
            r1.m244();
        }
    }

    public boolean onStartNestedScroll(View view, View view2, int i) {
        if ((i & 2) == 0 || this.f387.getVisibility() != 0) {
            return false;
        }
        return this.f392;
    }

    public void onStopNestedScroll(View view) {
        if (this.f392 && !this.f400) {
            if (this.f411 <= this.f387.getHeight()) {
                m242();
                postDelayed(this.f393, 600);
            } else {
                m242();
                postDelayed(this.f388, 600);
            }
        }
        AbstractC0059 r4 = this.f398;
        if (r4 != null) {
            r4.m248();
        }
    }

    @Override // android.view.ViewGroup
    public ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams layoutParams) {
        return new C0056(layoutParams);
    }

    public void onNestedScroll(View view, int i, int i2, int i3, int i4) {
        this.f411 += i2;
        setActionBarHideOffset(this.f411);
    }

    public void setIcon(Drawable drawable) {
        m239();
        C2040 r0 = (C2040) this.f406;
        r0.f6927 = drawable;
        r0.m5301();
    }

    /* renamed from: K  reason: contains not printable characters */
    public final boolean m238(View view, Rect rect, boolean z, boolean z2, boolean z3, boolean z4) {
        boolean z5;
        int i;
        int i2;
        int i3;
        int i4;
        C0056 r3 = (C0056) view.getLayoutParams();
        if (!z || ((ViewGroup.MarginLayoutParams) r3).leftMargin == (i4 = rect.left)) {
            z5 = false;
        } else {
            ((ViewGroup.MarginLayoutParams) r3).leftMargin = i4;
            z5 = true;
        }
        if (z2 && ((ViewGroup.MarginLayoutParams) r3).topMargin != (i3 = rect.top)) {
            ((ViewGroup.MarginLayoutParams) r3).topMargin = i3;
            z5 = true;
        }
        if (z4 && ((ViewGroup.MarginLayoutParams) r3).rightMargin != (i2 = rect.right)) {
            ((ViewGroup.MarginLayoutParams) r3).rightMargin = i2;
            z5 = true;
        }
        if (!z3 || ((ViewGroup.MarginLayoutParams) r3).bottomMargin == (i = rect.bottom)) {
            return z5;
        }
        ((ViewGroup.MarginLayoutParams) r3).bottomMargin = i;
        return true;
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: K  reason: contains not printable characters */
    public void m234(int i) {
        m239();
        if (i == 2) {
            ((C2040) this.f406).m5291();
        } else if (i == 5) {
            ((C2040) this.f406).m5293();
        } else if (i == 109) {
            setOverlayMode(true);
        }
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: K  reason: contains not printable characters */
    public boolean m237() {
        m239();
        return ((C2040) this.f406).f6933.isOverflowMenuShowPending();
    }

    @Override // ῲ.ῲ.㴹.AbstractC2034
    /* renamed from: K  reason: contains not printable characters */
    public void m236(Menu menu, AbstractC1897.AbstractC1898 k) {
        m239();
        C2040 r0 = (C2040) this.f406;
        if (r0.f6925 == null) {
            r0.f6925 = new ActionMenuPresenter(r0.f6933.getContext());
            r0.f6925.f6467 = R$id.action_menu_presenter;
        }
        ActionMenuPresenter actionMenuPresenter = r0.f6925;
        actionMenuPresenter.f6468 = k;
        r0.f6933.setMenu((C1912) menu, actionMenuPresenter);
    }
}
