package androidx.appcompat.view.menu;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.appcompat.R$styleable;
import androidx.appcompat.widget.ActionMenuPresenter;
import androidx.appcompat.widget.ActionMenuView;
import androidx.appcompat.widget.AppCompatTextView;
import ῲ.ῲ.ඓ.㳳.AbstractC1903;
import ῲ.ῲ.ඓ.㳳.AbstractC1917;
import ῲ.ῲ.ඓ.㳳.C1912;
import ῲ.ῲ.ඓ.㳳.C1922;
import ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051;
import K.K.K.ʬ.C2369;

public class ActionMenuItemView extends AppCompatTextView implements AbstractC1917.AbstractC1918, View.OnClickListener, ActionMenuView.AbstractC0071 {

    /* renamed from: ʬ  reason: contains not printable characters */
    public CharSequence f327;

    /* renamed from: ඓ  reason: contains not printable characters */
    public C1912.AbstractC1913 f328;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f329;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public boolean f330;

    /* renamed from: ῲ  reason: contains not printable characters */
    public C1922 f331;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public AbstractC0052 f332;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f333;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f334;

    /* renamed from: 㴹  reason: contains not printable characters */
    public AbstractView$OnTouchListenerC2051 f335;

    /* renamed from: 㸾  reason: contains not printable characters */
    public Drawable f336;

    /* renamed from: 㿎  reason: contains not printable characters */
    public boolean f337;

    /* renamed from: androidx.appcompat.view.menu.ActionMenuItemView$ῲ  reason: contains not printable characters */
    public static abstract class AbstractC0052 {
    }

    /* renamed from: androidx.appcompat.view.menu.ActionMenuItemView$K  reason: contains not printable characters */
    public class C0053 extends AbstractView$OnTouchListenerC2051 {
        public C0053() {
            super(ActionMenuItemView.this);
        }

        @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
        /* renamed from: ʬ  reason: contains not printable characters */
        public boolean m213() {
            AbstractC1903 r0;
            ActionMenuItemView actionMenuItemView = ActionMenuItemView.this;
            C1912.AbstractC1913 r1 = actionMenuItemView.f328;
            if (r1 == null || !r1.m4935(actionMenuItemView.f331) || (r0 = m214()) == null || !r0.m4925()) {
                return false;
            }
            return true;
        }

        @Override // ῲ.ῲ.㴹.AbstractView$OnTouchListenerC2051
        /* renamed from: ῲ  reason: contains not printable characters */
        public AbstractC1903 m214() {
            ActionMenuPresenter.C0064 k;
            AbstractC0052 r0 = ActionMenuItemView.this.f332;
            if (r0 == null || (k = ActionMenuPresenter.this.f425) == null) {
                return null;
            }
            return k.m4995();
        }
    }

    public ActionMenuItemView(Context context) {
        this(context, null);
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public C1922 getItemData() {
        return this.f331;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public void initialize(C1922 r1, int i) {
        CharSequence charSequence;
        this.f331 = r1;
        setIcon(r1.getIcon());
        if (prefersCondensedTitle()) {
            charSequence = r1.getTitleCondensed();
        } else {
            charSequence = r1.f6519;
        }
        setTitle(charSequence);
        setId(r1.f6529);
        setVisibility(r1.isVisible() ? 0 : 8);
        setEnabled(r1.isEnabled());
        if (r1.hasSubMenu() && this.f335 == null) {
            this.f335 = new C0053();
        }
    }

    public void onClick(View view) {
        C1912.AbstractC1913 r2 = this.f328;
        if (r2 != null) {
            r2.m4935(this.f331);
        }
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.f337 = m212();
        m209();
    }

    @Override // androidx.appcompat.widget.AppCompatTextView
    public void onMeasure(int i, int i2) {
        int i3;
        int i4;
        boolean r0 = m208();
        if (r0 && (i4 = this.f329) >= 0) {
            super.setPadding(i4, getPaddingTop(), getPaddingRight(), getPaddingBottom());
        }
        super.onMeasure(i, i2);
        int mode = View.MeasureSpec.getMode(i);
        int size = View.MeasureSpec.getSize(i);
        int measuredWidth = getMeasuredWidth();
        if (mode == Integer.MIN_VALUE) {
            i3 = Math.min(size, this.f334);
        } else {
            i3 = this.f334;
        }
        if (mode != 1073741824 && this.f334 > 0 && measuredWidth < i3) {
            super.onMeasure(View.MeasureSpec.makeMeasureSpec(i3, 1073741824), i2);
        }
        if (!r0 && this.f336 != null) {
            super.setPadding((getMeasuredWidth() - this.f336.getBounds().width()) / 2, getPaddingTop(), getPaddingRight(), getPaddingBottom());
        }
    }

    public void onRestoreInstanceState(Parcelable parcelable) {
        super.onRestoreInstanceState(null);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        AbstractView$OnTouchListenerC2051 r0;
        if (!this.f331.hasSubMenu() || (r0 = this.f335) == null || !r0.onTouch(this, motionEvent)) {
            return super.onTouchEvent(motionEvent);
        }
        return true;
    }

    @Override // ῲ.ῲ.ඓ.㳳.AbstractC1917.AbstractC1918
    public boolean prefersCondensedTitle() {
        return true;
    }

    public void setCheckable(boolean z) {
    }

    public void setChecked(boolean z) {
    }

    public void setExpandedFormat(boolean z) {
        if (this.f330 != z) {
            this.f330 = z;
            C1922 r2 = this.f331;
            if (r2 != null) {
                r2.f6515.onItemActionRequestChanged(r2);
            }
        }
    }

    public void setIcon(Drawable drawable) {
        this.f336 = drawable;
        if (drawable != null) {
            int intrinsicWidth = drawable.getIntrinsicWidth();
            int intrinsicHeight = drawable.getIntrinsicHeight();
            int i = this.f333;
            if (intrinsicWidth > i) {
                intrinsicHeight = (int) (((float) intrinsicHeight) * (((float) i) / ((float) intrinsicWidth)));
                intrinsicWidth = i;
            }
            int i2 = this.f333;
            if (intrinsicHeight > i2) {
                intrinsicWidth = (int) (((float) intrinsicWidth) * (((float) i2) / ((float) intrinsicHeight)));
                intrinsicHeight = i2;
            }
            drawable.setBounds(0, 0, intrinsicWidth, intrinsicHeight);
        }
        setCompoundDrawables(drawable, null, null, null);
        m209();
    }

    public void setItemInvoker(C1912.AbstractC1913 r1) {
        this.f328 = r1;
    }

    public void setPadding(int i, int i2, int i3, int i4) {
        this.f329 = i;
        super.setPadding(i, i2, i3, i4);
    }

    public void setPopupCallback(AbstractC0052 r1) {
        this.f332 = r1;
    }

    public void setTitle(CharSequence charSequence) {
        this.f327 = charSequence;
        m209();
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public boolean m208() {
        return !TextUtils.isEmpty(getText());
    }

    /* renamed from: ඓ  reason: contains not printable characters */
    public final void m209() {
        CharSequence charSequence;
        boolean z = true;
        boolean z2 = !TextUtils.isEmpty(this.f327);
        if (this.f336 != null) {
            if (!((this.f331.f6530 & 4) == 4) || (!this.f337 && !this.f330)) {
                z = false;
            }
        }
        boolean z3 = z2 & z;
        CharSequence charSequence2 = null;
        setText(z3 ? this.f327 : null);
        CharSequence charSequence3 = this.f331.f6534;
        if (TextUtils.isEmpty(charSequence3)) {
            if (z3) {
                charSequence = null;
            } else {
                charSequence = this.f331.f6519;
            }
            setContentDescription(charSequence);
        } else {
            setContentDescription(charSequence3);
        }
        CharSequence charSequence4 = this.f331.f6518;
        if (TextUtils.isEmpty(charSequence4)) {
            if (!z3) {
                charSequence2 = this.f331.f6519;
            }
            C2369.m6331((View) this, charSequence2);
            return;
        }
        C2369.m6331((View) this, charSequence4);
    }

    @Override // androidx.appcompat.widget.ActionMenuView.AbstractC0071
    /* renamed from: ῲ  reason: contains not printable characters */
    public boolean m210() {
        return m208() && this.f331.getIcon() == null;
    }

    @Override // androidx.appcompat.widget.ActionMenuView.AbstractC0071
    /* renamed from: K  reason: contains not printable characters */
    public boolean m211() {
        return m208();
    }

    /* renamed from: 㸾  reason: contains not printable characters */
    public final boolean m212() {
        Configuration configuration = getContext().getResources().getConfiguration();
        int i = configuration.screenWidthDp;
        return i >= 480 || (i >= 640 && configuration.screenHeightDp >= 480) || configuration.orientation == 2;
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActionMenuItemView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        Resources resources = context.getResources();
        this.f337 = m212();
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.ActionMenuItemView, i, 0);
        this.f334 = obtainStyledAttributes.getDimensionPixelSize(R$styleable.ActionMenuItemView_android_minWidth, 0);
        obtainStyledAttributes.recycle();
        this.f333 = (int) ((resources.getDisplayMetrics().density * 32.0f) + 0.5f);
        setOnClickListener(this);
        this.f329 = -1;
        setSaveEnabled(false);
    }
}
