package androidx.appcompat.app;

import android.content.Context;
import android.content.DialogInterface;
import android.content.res.TypedArray;
import android.database.Cursor;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStub;
import android.view.Window;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import androidx.appcompat.R$attr;
import androidx.appcompat.R$styleable;
import androidx.core.widget.NestedScrollView;
import java.lang.ref.WeakReference;
import ῲ.ῲ.K.DialogC1947;

public class AlertController {

    /* renamed from: ʬ  reason: contains not printable characters */
    public final Window f141;

    /* renamed from: В  reason: contains not printable characters */
    public int f142 = -1;

    /* renamed from: ѷ  reason: contains not printable characters */
    public boolean f143;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public boolean f144 = false;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public Message f145;

    /* renamed from: ؿ  reason: contains not printable characters */
    public CharSequence f146;

    /* renamed from: ݜ  reason: contains not printable characters */
    public Button f147;

    /* renamed from: ࠋ  reason: contains not printable characters */
    public Handler f148;

    /* renamed from: ಯ  reason: contains not printable characters */
    public int f149;

    /* renamed from: ඓ  reason: contains not printable characters */
    public CharSequence f150;

    /* renamed from: ผ  reason: contains not printable characters */
    public final View.OnClickListener f151 = new View$OnClickListenerC0037();

    /* renamed from: ᆯ  reason: contains not printable characters */
    public TextView f152;

    /* renamed from: ሽ  reason: contains not printable characters */
    public View f153;

    /* renamed from: ጒ  reason: contains not printable characters */
    public int f154;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public Message f155;

    /* renamed from: ᑾ  reason: contains not printable characters */
    public ListAdapter f156;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public Button f157;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public Message f158;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f159;

    /* renamed from: ᝁ  reason: contains not printable characters */
    public ImageView f160;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f161;

    /* renamed from: ᶲ  reason: contains not printable characters */
    public int f162 = 0;

    /* renamed from: ῲ  reason: contains not printable characters */
    public final DialogC1947 f163;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public ListView f164;

    /* renamed from: K  reason: contains not printable characters */
    public final Context f165;

    /* renamed from: ⶍ  reason: contains not printable characters */
    public TextView f166;

    /* renamed from: ゎ  reason: contains not printable characters */
    public Drawable f167;

    /* renamed from: ト  reason: contains not printable characters */
    public NestedScrollView f168;

    /* renamed from: 㑃  reason: contains not printable characters */
    public int f169;

    /* renamed from: 㒁  reason: contains not printable characters */
    public int f170;

    /* renamed from: 㗗  reason: contains not printable characters */
    public Button f171;

    /* renamed from: 㗽  reason: contains not printable characters */
    public Drawable f172;

    /* renamed from: 㮔  reason: contains not printable characters */
    public int f173 = 0;

    /* renamed from: 㮝  reason: contains not printable characters */
    public int f174;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f175;

    /* renamed from: 㴪  reason: contains not printable characters */
    public CharSequence f176;

    /* renamed from: 㴹  reason: contains not printable characters */
    public CharSequence f177;

    /* renamed from: 㶋  reason: contains not printable characters */
    public Drawable f178;

    /* renamed from: 㷛  reason: contains not printable characters */
    public int f179;

    /* renamed from: 㸾  reason: contains not printable characters */
    public final int f180;

    /* renamed from: 㹎  reason: contains not printable characters */
    public int f181;

    /* renamed from: 㿎  reason: contains not printable characters */
    public View f182;

    /* renamed from: 䀟  reason: contains not printable characters */
    public CharSequence f183;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f184;

    /* renamed from: 䃖  reason: contains not printable characters */
    public Drawable f185;

    public static class RecycleListView extends ListView {

        /* renamed from: ʬ  reason: contains not printable characters */
        public final int f186;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final int f187;

        public RecycleListView(Context context) {
            this(context, null);
        }

        /* renamed from: K  reason: contains not printable characters */
        public void m132(boolean z, boolean z2) {
            if (!z2 || !z) {
                setPadding(getPaddingLeft(), z ? getPaddingTop() : this.f187, getPaddingRight(), z2 ? getPaddingBottom() : this.f186);
            }
        }

        public RecycleListView(Context context, AttributeSet attributeSet) {
            super(context, attributeSet);
            TypedArray obtainStyledAttributes = context.obtainStyledAttributes(attributeSet, R$styleable.RecycleListView);
            this.f186 = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.RecycleListView_paddingBottomNoButtons, -1);
            this.f187 = obtainStyledAttributes.getDimensionPixelOffset(R$styleable.RecycleListView_paddingTopNoTitle, -1);
        }
    }

    /* renamed from: androidx.appcompat.app.AlertController$ʬ  reason: contains not printable characters */
    public static final class HandlerC0035 extends Handler {

        /* renamed from: K  reason: contains not printable characters */
        public WeakReference<DialogInterface> f188;

        public HandlerC0035(DialogInterface dialogInterface) {
            this.f188 = new WeakReference<>(dialogInterface);
        }

        public void handleMessage(Message message) {
            int i = message.what;
            if (i == -3 || i == -2 || i == -1) {
                ((DialogInterface.OnClickListener) message.obj).onClick(this.f188.get(), message.what);
            } else if (i == 1) {
                ((DialogInterface) message.obj).dismiss();
            }
        }
    }

    /* renamed from: androidx.appcompat.app.AlertController$ῲ  reason: contains not printable characters */
    public static class C0036 {

        /* renamed from: ʬ  reason: contains not printable characters */
        public int f189 = 0;

        /* renamed from: В  reason: contains not printable characters */
        public int f190 = -1;

        /* renamed from: ѷ  reason: contains not printable characters */
        public boolean f191;

        /* renamed from: Ԕ  reason: contains not printable characters */
        public DialogInterface.OnClickListener f192;

        /* renamed from: Ԛ  reason: contains not printable characters */
        public DialogInterface.OnKeyListener f193;

        /* renamed from: ؿ  reason: contains not printable characters */
        public Drawable f194;

        /* renamed from: ݜ  reason: contains not printable characters */
        public DialogInterface.OnCancelListener f195;

        /* renamed from: ಯ  reason: contains not printable characters */
        public Cursor f196;

        /* renamed from: ඓ  reason: contains not printable characters */
        public int f197 = 0;

        /* renamed from: ᆯ  reason: contains not printable characters */
        public boolean f198 = false;

        /* renamed from: ሽ  reason: contains not printable characters */
        public boolean f199;

        /* renamed from: ጒ  reason: contains not printable characters */
        public String f200;

        /* renamed from: ᑓ  reason: contains not printable characters */
        public int f201;

        /* renamed from: ᑾ  reason: contains not printable characters */
        public boolean f202;

        /* renamed from: ᓆ  reason: contains not printable characters */
        public ListAdapter f203;

        /* renamed from: ᓣ  reason: contains not printable characters */
        public DialogInterface.OnClickListener f204;

        /* renamed from: ᕣ  reason: contains not printable characters */
        public DialogInterface.OnClickListener f205;

        /* renamed from: ᝁ  reason: contains not printable characters */
        public int f206;

        /* renamed from: ᨨ  reason: contains not printable characters */
        public CharSequence f207;

        /* renamed from: ῲ  reason: contains not printable characters */
        public final LayoutInflater f208;

        /* renamed from: ⁱ  reason: contains not printable characters */
        public View f209;

        /* renamed from: K  reason: contains not printable characters */
        public final Context f210;

        /* renamed from: ⶍ  reason: contains not printable characters */
        public boolean[] f211;

        /* renamed from: ゎ  reason: contains not printable characters */
        public View f212;

        /* renamed from: ト  reason: contains not printable characters */
        public int f213;

        /* renamed from: 㑃  reason: contains not printable characters */
        public CharSequence f214;

        /* renamed from: 㒁  reason: contains not printable characters */
        public boolean f215;

        /* renamed from: 㗗  reason: contains not printable characters */
        public CharSequence f216;

        /* renamed from: 㗽  reason: contains not printable characters */
        public boolean f217;

        /* renamed from: 㮔  reason: contains not printable characters */
        public int f218;

        /* renamed from: 㮝  reason: contains not printable characters */
        public DialogInterface.OnMultiChoiceClickListener f219;

        /* renamed from: 㳳  reason: contains not printable characters */
        public Drawable f220;

        /* renamed from: 㴪  reason: contains not printable characters */
        public DialogInterface.OnClickListener f221;

        /* renamed from: 㴹  reason: contains not printable characters */
        public CharSequence f222;

        /* renamed from: 㶋  reason: contains not printable characters */
        public CharSequence[] f223;

        /* renamed from: 㷛  reason: contains not printable characters */
        public AdapterView.OnItemSelectedListener f224;

        /* renamed from: 㸾  reason: contains not printable characters */
        public Drawable f225;

        /* renamed from: 㹎  reason: contains not printable characters */
        public String f226;

        /* renamed from: 㿎  reason: contains not printable characters */
        public CharSequence f227;

        /* renamed from: 䀟  reason: contains not printable characters */
        public DialogInterface.OnDismissListener f228;

        /* renamed from: 䁗  reason: contains not printable characters */
        public Drawable f229;

        /* renamed from: 䃖  reason: contains not printable characters */
        public int f230;

        public C0036(Context context) {
            this.f210 = context;
            this.f217 = true;
            this.f208 = (LayoutInflater) context.getSystemService("layout_inflater");
        }
    }

    /* renamed from: androidx.appcompat.app.AlertController$K  reason: contains not printable characters */
    public class View$OnClickListenerC0037 implements View.OnClickListener {
        public View$OnClickListenerC0037() {
        }

        public void onClick(View view) {
            Message message;
            Message message2;
            Message message3;
            Message message4;
            AlertController alertController = AlertController.this;
            if (view != alertController.f171 || (message4 = alertController.f158) == null) {
                AlertController alertController2 = AlertController.this;
                if (view != alertController2.f147 || (message3 = alertController2.f145) == null) {
                    AlertController alertController3 = AlertController.this;
                    message = (view != alertController3.f157 || (message2 = alertController3.f155) == null) ? null : Message.obtain(message2);
                } else {
                    message = Message.obtain(message3);
                }
            } else {
                message = Message.obtain(message4);
            }
            if (message != null) {
                message.sendToTarget();
            }
            AlertController alertController4 = AlertController.this;
            alertController4.f148.obtainMessage(1, alertController4.f163).sendToTarget();
        }
    }

    /* renamed from: androidx.appcompat.app.AlertController$㸾  reason: contains not printable characters */
    public static class C0038 extends ArrayAdapter<CharSequence> {
        public C0038(Context context, int i, int i2, CharSequence[] charSequenceArr) {
            super(context, i, i2, charSequenceArr);
        }

        public long getItemId(int i) {
            return (long) i;
        }

        public boolean hasStableIds() {
            return true;
        }
    }

    public AlertController(Context context, DialogC1947 r5, Window window) {
        this.f165 = context;
        this.f163 = r5;
        this.f141 = window;
        this.f148 = new HandlerC0035(r5);
        TypedArray obtainStyledAttributes = context.obtainStyledAttributes(null, R$styleable.AlertDialog, R$attr.alertDialogStyle, 0);
        this.f174 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_android_layout, 0);
        this.f149 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_buttonPanelSideLayout, 0);
        this.f154 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_listLayout, 0);
        this.f181 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_multiChoiceItemLayout, 0);
        this.f170 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_singleChoiceItemLayout, 0);
        this.f179 = obtainStyledAttributes.getResourceId(R$styleable.AlertDialog_listItemLayout, 0);
        this.f143 = obtainStyledAttributes.getBoolean(R$styleable.AlertDialog_showTitle, true);
        this.f180 = obtainStyledAttributes.getDimensionPixelSize(R$styleable.AlertDialog_buttonIconDimen, 0);
        obtainStyledAttributes.recycle();
        r5.supportRequestWindowFeature(1);
    }

    /* renamed from: K  reason: contains not printable characters */
    public static boolean m125(View view) {
        if (view.onCheckIsTextEditor()) {
            return true;
        }
        if (!(view instanceof ViewGroup)) {
            return false;
        }
        ViewGroup viewGroup = (ViewGroup) view;
        int childCount = viewGroup.getChildCount();
        while (childCount > 0) {
            childCount--;
            if (m125(viewGroup.getChildAt(childCount))) {
                return true;
            }
        }
        return false;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m126(int i) {
        this.f185 = null;
        this.f173 = i;
        ImageView imageView = this.f160;
        if (imageView == null) {
            return;
        }
        if (i != 0) {
            imageView.setVisibility(0);
            this.f160.setImageResource(this.f173);
            return;
        }
        imageView.setVisibility(8);
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m131(CharSequence charSequence) {
        this.f150 = charSequence;
        TextView textView = this.f152;
        if (textView != null) {
            textView.setText(charSequence);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m129(int i, CharSequence charSequence, DialogInterface.OnClickListener onClickListener, Message message, Drawable drawable) {
        if (message == null && onClickListener != null) {
            message = this.f148.obtainMessage(i, onClickListener);
        }
        if (i == -3) {
            this.f176 = charSequence;
            this.f155 = message;
            this.f167 = drawable;
        } else if (i == -2) {
            this.f183 = charSequence;
            this.f145 = message;
            this.f178 = drawable;
        } else if (i == -1) {
            this.f146 = charSequence;
            this.f158 = message;
            this.f172 = drawable;
        } else {
            throw new IllegalArgumentException("Button does not exist");
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m127(int i) {
        TypedValue typedValue = new TypedValue();
        this.f165.getTheme().resolveAttribute(i, typedValue, true);
        return typedValue.resourceId;
    }

    /* renamed from: K  reason: contains not printable characters */
    public final ViewGroup m128(View view, View view2) {
        if (view == null) {
            if (view2 instanceof ViewStub) {
                view2 = ((ViewStub) view2).inflate();
            }
            return (ViewGroup) view2;
        }
        if (view2 != null) {
            ViewParent parent = view2.getParent();
            if (parent instanceof ViewGroup) {
                ((ViewGroup) parent).removeView(view2);
            }
        }
        if (view instanceof ViewStub) {
            view = ((ViewStub) view).inflate();
        }
        return (ViewGroup) view;
    }

    /* renamed from: K  reason: contains not printable characters */
    public static void m124(View view, View view2, View view3) {
        int i = 0;
        if (view2 != null) {
            view2.setVisibility(view.canScrollVertically(-1) ? 0 : 4);
        }
        if (view3 != null) {
            if (!view.canScrollVertically(1)) {
                i = 4;
            }
            view3.setVisibility(i);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public final void m130(Button button) {
        LinearLayout.LayoutParams layoutParams = (LinearLayout.LayoutParams) button.getLayoutParams();
        layoutParams.gravity = 1;
        layoutParams.weight = 0.5f;
        button.setLayoutParams(layoutParams);
    }
}
