package androidx.activity;

import android.os.Build;
import android.os.Bundle;
import android.view.View;
import android.view.Window;
import androidx.lifecycle.Lifecycle;
import ῲ.Ԛ.AbstractC1560;
import ῲ.Ԛ.C1561;
import ῲ.Ԛ.C1562;
import ῲ.ؿ.AbstractC1569;
import ῲ.ؿ.AbstractC1574;
import ῲ.ؿ.AbstractC1586;
import ῲ.ؿ.C1568;
import ῲ.ؿ.C1584;
import ῲ.ؿ.FragmentC1579;
import ῲ.K.AbstractC2195;

public class ComponentActivity extends androidx.core.app.ComponentActivity implements AbstractC1574, AbstractC1586, AbstractC1560, AbstractC2195 {
    public int mContentLayoutId;
    public final C1584 mLifecycleRegistry;
    public final OnBackPressedDispatcher mOnBackPressedDispatcher;
    public final C1561 mSavedStateRegistryController;
    public C1568 mViewModelStore;

    /* renamed from: androidx.activity.ComponentActivity$ῲ  reason: contains not printable characters */
    public static final class C0032 {

        /* renamed from: ῲ  reason: contains not printable characters */
        public C1568 f125;

        /* renamed from: K  reason: contains not printable characters */
        public Object f126;
    }

    /* renamed from: androidx.activity.ComponentActivity$K  reason: contains not printable characters */
    public class RunnableC0033 implements Runnable {
        public RunnableC0033() {
        }

        public void run() {
            ComponentActivity.super.onBackPressed();
        }
    }

    public ComponentActivity() {
        this.mLifecycleRegistry = new C1584(this);
        this.mSavedStateRegistryController = new C1561(this);
        this.mOnBackPressedDispatcher = new OnBackPressedDispatcher(new RunnableC0033());
        if (getLifecycle() != null) {
            int i = Build.VERSION.SDK_INT;
            getLifecycle().m690(new AbstractC1569() {
                /* class androidx.activity.ComponentActivity.AnonymousClass2 */

                @Override // ῲ.ؿ.AbstractC1569
                /* renamed from: K  reason: contains not printable characters */
                public void m118(AbstractC1574 r1, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_STOP) {
                        Window window = ComponentActivity.this.getWindow();
                        View peekDecorView = window != null ? window.peekDecorView() : null;
                        if (peekDecorView != null) {
                            peekDecorView.cancelPendingInputEvents();
                        }
                    }
                }
            });
            getLifecycle().m690(new AbstractC1569() {
                /* class androidx.activity.ComponentActivity.AnonymousClass3 */

                @Override // ῲ.ؿ.AbstractC1569
                /* renamed from: K  reason: contains not printable characters */
                public void m119(AbstractC1574 r1, Lifecycle.Event event) {
                    if (event == Lifecycle.Event.ON_DESTROY && !ComponentActivity.this.isChangingConfigurations()) {
                        ComponentActivity.this.getViewModelStore().m4112();
                    }
                }
            });
            if (Build.VERSION.SDK_INT <= 23) {
                getLifecycle().m690(new ImmLeaksCleaner(this));
                return;
            }
            return;
        }
        throw new IllegalStateException("getLifecycle() returned null in ComponentActivity's constructor. Please make sure you are lazily constructing your Lifecycle in the first call to getLifecycle() rather than relying on field initialization.");
    }

    @Deprecated
    public Object getLastCustomNonConfigurationInstance() {
        C0032 r0 = (C0032) getLastNonConfigurationInstance();
        if (r0 != null) {
            return r0.f126;
        }
        return null;
    }

    @Override // androidx.core.app.ComponentActivity, ῲ.ؿ.AbstractC1574
    public Lifecycle getLifecycle() {
        return this.mLifecycleRegistry;
    }

    @Override // ῲ.K.AbstractC2195
    public final OnBackPressedDispatcher getOnBackPressedDispatcher() {
        return this.mOnBackPressedDispatcher;
    }

    @Override // ῲ.Ԛ.AbstractC1560
    public final C1562 getSavedStateRegistry() {
        return this.mSavedStateRegistryController.f5732;
    }

    @Override // ῲ.ؿ.AbstractC1586
    public C1568 getViewModelStore() {
        if (getApplication() != null) {
            if (this.mViewModelStore == null) {
                C0032 r0 = (C0032) getLastNonConfigurationInstance();
                if (r0 != null) {
                    this.mViewModelStore = r0.f125;
                }
                if (this.mViewModelStore == null) {
                    this.mViewModelStore = new C1568();
                }
            }
            return this.mViewModelStore;
        }
        throw new IllegalStateException("Your activity is not yet attached to the Application instance. You can't request ViewModel before onCreate call.");
    }

    public void onBackPressed() {
        this.mOnBackPressedDispatcher.m121();
    }

    @Override // androidx.core.app.ComponentActivity
    public void onCreate(Bundle bundle) {
        super.onCreate(bundle);
        this.mSavedStateRegistryController.m4105(bundle);
        FragmentC1579.m4129(this);
        int i = this.mContentLayoutId;
        if (i != 0) {
            setContentView(i);
        }
    }

    @Deprecated
    public Object onRetainCustomNonConfigurationInstance() {
        return null;
    }

    public final Object onRetainNonConfigurationInstance() {
        C0032 r2;
        Object onRetainCustomNonConfigurationInstance = onRetainCustomNonConfigurationInstance();
        C1568 r1 = this.mViewModelStore;
        if (r1 == null && (r2 = (C0032) getLastNonConfigurationInstance()) != null) {
            r1 = r2.f125;
        }
        if (r1 == null && onRetainCustomNonConfigurationInstance == null) {
            return null;
        }
        C0032 r22 = new C0032();
        r22.f126 = onRetainCustomNonConfigurationInstance;
        r22.f125 = r1;
        return r22;
    }

    @Override // androidx.core.app.ComponentActivity
    public void onSaveInstanceState(Bundle bundle) {
        Lifecycle lifecycle = getLifecycle();
        if (lifecycle instanceof C1584) {
            ((C1584) lifecycle).m4145(Lifecycle.State.CREATED);
        }
        super.onSaveInstanceState(bundle);
        this.mSavedStateRegistryController.f5732.m4106(bundle);
    }

    public ComponentActivity(int i) {
        this();
        this.mContentLayoutId = i;
    }
}
