package ai.advance.common.camera;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.AttributeSet;
import android.view.TextureView;
import android.view.View;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ඓ.K.K.K.C1293;
import K.K.K.ʬ.C2369;
import K.K.K.ʬ.C2370;

public class GuardianCameraView extends TextureView implements Camera.PreviewCallback, View.OnLayoutChangeListener {

    /* renamed from: ʬ  reason: contains not printable characters */
    public Activity f0;

    /* renamed from: Ԕ  reason: contains not printable characters */
    public int f1;

    /* renamed from: Ԛ  reason: contains not printable characters */
    public float f2;

    /* renamed from: ؿ  reason: contains not printable characters */
    public Camera.AutoFocusCallback f3;

    /* renamed from: ݜ  reason: contains not printable characters */
    public ExecutorService f4;

    /* renamed from: ඓ  reason: contains not printable characters */
    public Camera f5;

    /* renamed from: ᑓ  reason: contains not printable characters */
    public AbstractC0002 f6;

    /* renamed from: ᓆ  reason: contains not printable characters */
    public TextureView.SurfaceTextureListener f7;

    /* renamed from: ᓣ  reason: contains not printable characters */
    public boolean f8;

    /* renamed from: ᕣ  reason: contains not printable characters */
    public int f9;

    /* renamed from: ᨨ  reason: contains not printable characters */
    public int f10;

    /* renamed from: ῲ  reason: contains not printable characters */
    public long f11;

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean f12;

    /* renamed from: 㑃  reason: contains not printable characters */
    public boolean f13;

    /* renamed from: 㗗  reason: contains not printable characters */
    public HandlerC0004 f14;

    /* renamed from: 㗽  reason: contains not printable characters */
    public boolean f15;

    /* renamed from: 㳳  reason: contains not printable characters */
    public int f16;

    /* renamed from: 㴪  reason: contains not printable characters */
    public Rect f17;

    /* renamed from: 㴹  reason: contains not printable characters */
    public Camera.Size f18;

    /* renamed from: 㶋  reason: contains not printable characters */
    public float f19;

    /* renamed from: 㸾  reason: contains not printable characters */
    public AbstractC0010 f20;

    /* renamed from: 㿎  reason: contains not printable characters */
    public int f21;

    /* renamed from: 䀟  reason: contains not printable characters */
    public boolean f22;

    /* renamed from: 䁗  reason: contains not printable characters */
    public int f23;

    /* renamed from: ai.advance.common.camera.GuardianCameraView$ʬ  reason: contains not printable characters */
    public class C0000 implements Comparator<Camera.Size> {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ float f25;

        public C0000(float f) {
            this.f25 = f;
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, java.lang.Object] */
        @Override // java.util.Comparator
        public int compare(Camera.Size size, Camera.Size size2) {
            return Float.compare(Math.abs(this.f25 - GuardianCameraView.this.m2(size)), Math.abs(this.f25 - GuardianCameraView.this.m2(size2)));
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$ඓ  reason: contains not printable characters */
    public class TextureView$SurfaceTextureListenerC0001 implements TextureView.SurfaceTextureListener {
        public TextureView$SurfaceTextureListenerC0001() {
        }

        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int i, int i2) {
            GuardianCameraView guardianCameraView = GuardianCameraView.this;
            guardianCameraView.f22 = true;
            guardianCameraView.m22();
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            GuardianCameraView guardianCameraView = GuardianCameraView.this;
            guardianCameraView.f22 = false;
            guardianCameraView.m18();
            return true;
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int i, int i2) {
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
            AbstractC0010 r0 = GuardianCameraView.this.f20;
            if (r0 != null) {
                r0.onSurfaceTextureUpdated(surfaceTexture);
            }
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$ᨨ  reason: contains not printable characters */
    public interface AbstractC0002 {
        /* renamed from: K  reason: contains not printable characters */
        void m23(Bitmap bitmap);
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$ῲ  reason: contains not printable characters */
    public class C0003 implements Camera.AutoFocusCallback {
        public C0003() {
        }

        public void onAutoFocus(boolean z, Camera camera) {
            GuardianCameraView.this.getMainHandler().m25();
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$ⁱ  reason: contains not printable characters */
    public class HandlerC0004 extends Handler {
        public HandlerC0004(Looper looper) {
            super(looper);
        }

        public void handleMessage(Message message) {
            super.handleMessage(message);
            int i = message.what;
            if (i != 9245) {
                if (i != 9246) {
                    return;
                }
            } else if (!GuardianCameraView.this.m10() || !GuardianCameraView.this.f8) {
                return;
            }
            try {
                GuardianCameraView.this.f5.autoFocus(GuardianCameraView.this.getAutoFocusCallback());
            } catch (Exception unused) {
            }
        }

        /* renamed from: ʬ  reason: contains not printable characters */
        public synchronized void m24() {
            removeMessages(9245);
            removeMessages(9246);
        }

        /* renamed from: ῲ  reason: contains not printable characters */
        public synchronized void m25() {
            if (GuardianCameraView.this.f8) {
                sendEmptyMessageDelayed(9245, GuardianCameraView.this.f11);
            }
        }

        /* renamed from: K  reason: contains not printable characters */
        public synchronized void m26() {
            sendEmptyMessage(9246);
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$K  reason: contains not printable characters */
    public class View$OnClickListenerC0005 implements View.OnClickListener {
        public View$OnClickListenerC0005() {
        }

        public void onClick(View view) {
            GuardianCameraView.this.m20();
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$㴹  reason: contains not printable characters */
    public class RunnableC0006 implements Runnable {

        /* renamed from: ῲ  reason: contains not printable characters */
        public final /* synthetic */ byte[] f31;

        /* renamed from: ai.advance.common.camera.GuardianCameraView$㴹$ῲ  reason: contains not printable characters */
        public class RunnableC0007 implements Runnable {

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ Bitmap f33;

            public RunnableC0007(Bitmap bitmap) {
                this.f33 = bitmap;
            }

            public void run() {
                AbstractC0002 r1;
                GuardianCameraView guardianCameraView = GuardianCameraView.this;
                if (guardianCameraView.f0 != null && (r1 = guardianCameraView.f6) != null) {
                    r1.m23(GuardianCameraView.m1(guardianCameraView, this.f33));
                }
            }
        }

        /* renamed from: ai.advance.common.camera.GuardianCameraView$㴹$K  reason: contains not printable characters */
        public class RunnableC0008 implements Runnable {

            /* renamed from: ῲ  reason: contains not printable characters */
            public final /* synthetic */ Bitmap f35;

            public RunnableC0008(Bitmap bitmap) {
                this.f35 = bitmap;
            }

            public void run() {
                AbstractC0002 r1;
                GuardianCameraView guardianCameraView = GuardianCameraView.this;
                if (guardianCameraView.f0 != null && (r1 = guardianCameraView.f6) != null) {
                    r1.m23(GuardianCameraView.m1(guardianCameraView, this.f35));
                }
            }
        }

        public RunnableC0006(byte[] bArr) {
            this.f31 = bArr;
        }

        public void run() {
            byte[] bArr = this.f31;
            GuardianCameraView guardianCameraView = GuardianCameraView.this;
            Camera.Size size = guardianCameraView.f18;
            Bitmap r0 = C2370.m6358(bArr, size.width, size.height, guardianCameraView.f9, guardianCameraView.m6(), GuardianCameraView.this.m19());
            GuardianCameraView guardianCameraView2 = GuardianCameraView.this;
            Rect rect = guardianCameraView2.f17;
            if (rect == null) {
                guardianCameraView2.f0.runOnUiThread(new RunnableC0008(r0));
                return;
            }
            float cameraTransformHeightRatio = GuardianCameraView.this.getCameraTransformHeightRatio() * (((float) rect.top) / ((float) guardianCameraView2.getViewHeight()));
            GuardianCameraView guardianCameraView3 = GuardianCameraView.this;
            float cameraTransformWidthRatio = GuardianCameraView.this.getCameraTransformWidthRatio() * (((float) guardianCameraView3.f17.left) / ((float) guardianCameraView3.getViewWidth()));
            GuardianCameraView guardianCameraView4 = GuardianCameraView.this;
            float cameraTransformWidthRatio2 = GuardianCameraView.this.getCameraTransformWidthRatio() * (((float) guardianCameraView4.f17.right) / ((float) guardianCameraView4.getViewWidth()));
            GuardianCameraView guardianCameraView5 = GuardianCameraView.this;
            float cameraTransformHeightRatio2 = GuardianCameraView.this.getCameraTransformHeightRatio() * (((float) guardianCameraView5.f17.bottom) / ((float) guardianCameraView5.getViewHeight()));
            int width = (int) (((float) r0.getWidth()) * cameraTransformWidthRatio);
            int height = (int) (((float) r0.getHeight()) * cameraTransformHeightRatio);
            int width2 = (int) ((cameraTransformWidthRatio2 - cameraTransformWidthRatio) * ((float) r0.getWidth()));
            int height2 = (int) ((cameraTransformHeightRatio2 - cameraTransformHeightRatio) * ((float) r0.getHeight()));
            try {
                int width3 = r0.getWidth();
                int height3 = r0.getHeight();
                int width4 = GuardianCameraView.this.m19() ? (int) ((1.0f - cameraTransformWidthRatio2) * ((float) r0.getWidth())) : width;
                Bitmap createBitmap = Bitmap.createBitmap(r0, width4, height, width4 + width2 > width3 ? width3 - width4 : width2, height + height2 > height3 ? height3 - height : height2, (Matrix) null, false);
                r0.recycle();
                GuardianCameraView.this.f0.runOnUiThread(new RunnableC0007(createBitmap));
            } catch (Exception unused) {
            }
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$㸾  reason: contains not printable characters */
    public class C0009 implements Comparator<Camera.Size> {
        public C0009() {
        }

        /* JADX DEBUG: Method arguments types fixed to match base method, original types: [java.lang.Object, java.lang.Object] */
        @Override // java.util.Comparator
        public int compare(Camera.Size size, Camera.Size size2) {
            return Float.compare((float) m27(size), (float) m27(size2));
        }

        /* renamed from: K  reason: contains not printable characters */
        public int m27(Camera.Size size) {
            return Math.abs((GuardianCameraView.this.getViewHeight() - GuardianCameraView.this.m12(size)) + (GuardianCameraView.this.getViewWidth() - GuardianCameraView.this.m8(size)));
        }
    }

    /* renamed from: ai.advance.common.camera.GuardianCameraView$㿎  reason: contains not printable characters */
    public interface AbstractC0010 {
        void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture);

        /* renamed from: ʬ  reason: contains not printable characters */
        void m28();

        /* renamed from: K  reason: contains not printable characters */
        void m29(byte[] bArr, Camera.Size size);
    }

    public GuardianCameraView(Context context) {
        this(context, null);
    }

    public GuardianCameraView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.f11 = 1300;
        this.f22 = false;
        this.f7 = new TextureView$SurfaceTextureListenerC0001();
        if (context instanceof Activity) {
            this.f0 = (Activity) context;
        }
        m7();
        setSurfaceTextureListener(this.f7);
        addOnLayoutChangeListener(this);
        setOnClickListener(new View$OnClickListenerC0005());
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private synchronized HandlerC0004 getMainHandler() {
        if (this.f14 == null) {
            this.f14 = new HandlerC0004(Looper.getMainLooper());
        }
        return this.f14;
    }

    /* renamed from: K  reason: contains not printable characters */
    public static /* synthetic */ Bitmap m1(GuardianCameraView guardianCameraView, Bitmap bitmap) {
        if (!guardianCameraView.m19()) {
            return bitmap;
        }
        Matrix matrix = new Matrix();
        matrix.postScale(-1.0f, 1.0f);
        Bitmap createBitmap = Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
        bitmap.recycle();
        return createBitmap;
    }

    public synchronized Camera.AutoFocusCallback getAutoFocusCallback() {
        if (this.f3 == null) {
            this.f3 = new C0003();
        }
        return this.f3;
    }

    public Camera getCamera() {
        return this.f5;
    }

    public float getCameraTransformHeightRatio() {
        return this.f19;
    }

    public float getCameraTransformWidthRatio() {
        return this.f2;
    }

    public ExecutorService getExecutor() {
        if (this.f4 == null) {
            this.f4 = Executors.newCachedThreadPool();
        }
        return this.f4;
    }

    public Camera.Size getPreviewSize() {
        return this.f18;
    }

    public float getScale() {
        return 1.0f;
    }

    public int getViewHeight() {
        return this.f1;
    }

    public int getViewWidth() {
        return this.f23;
    }

    public void onLayoutChange(View view, int i, int i2, int i3, int i4, int i5, int i6, int i7, int i8) {
        if ((this.f23 == getMeasuredWidth() && this.f1 == getMeasuredHeight()) ? false : true) {
            this.f23 = getMeasuredWidth();
            this.f1 = getMeasuredHeight();
            if (this.f13) {
                m3(this.f21);
            } else if (m10()) {
                m5();
            }
        }
    }

    public void onPreviewFrame(byte[] bArr, Camera camera) {
        Camera.Size size;
        AbstractC0010 r3 = this.f20;
        if (!(r3 == null || this.f5 == null || (size = this.f18) == null)) {
            r3.m29(bArr, size);
        }
        m16(bArr);
    }

    public void setAutoFocusEnable(long j) {
        this.f8 = true;
        this.f11 = j;
        if (m10()) {
            m17();
        }
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public float m2(Camera.Size size) {
        return ((float) m8(size)) / ((float) m12(size));
    }

    /* renamed from: ʬ  reason: contains not printable characters */
    public void m3(int i) {
        m21();
        m14(i, this.f20);
        m22();
    }

    /* renamed from: Ԕ  reason: contains not printable characters */
    public void m4() {
        getMainHandler().m24();
    }

    /* renamed from: ؿ  reason: contains not printable characters */
    public void m5() {
        RectF rectF;
        if (this.f18 != null) {
            float viewWidth = (float) getViewWidth();
            float viewHeight = (float) getViewHeight();
            float r2 = m2(this.f18);
            RectF rectF2 = new RectF(0.0f, 0.0f, viewHeight, viewWidth);
            if (m6()) {
                rectF = new RectF(0.0f, 0.0f, viewHeight, r2 * viewHeight);
                this.f2 = rectF.width() / rectF2.width();
                this.f19 = rectF.height() / rectF2.height();
            } else {
                RectF rectF3 = new RectF(0.0f, 0.0f, viewWidth / r2, viewWidth);
                this.f2 = rectF3.height() / rectF2.height();
                this.f19 = rectF3.width() / rectF2.width();
                rectF = rectF3;
            }
            this.f2 = rectF.width() / rectF2.width();
            this.f19 = rectF.height() / rectF2.height();
            Matrix matrix = new Matrix();
            matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
            setTransform(matrix);
        }
    }

    /* renamed from: ᕣ  reason: contains not printable characters */
    public boolean m6() {
        return getResources().getConfiguration().orientation == 1;
    }

    /* renamed from: ᨨ  reason: contains not printable characters */
    public void m7() {
        this.f10 = C2369.m6291();
        this.f16 = C2369.m6275();
        if (this.f10 == -1) {
            C2369.m6274("No back facing camera detected on the device.");
        }
        if (this.f16 == -1) {
            C2369.m6274("No front facing camera detected on the device.");
        }
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public int m8(Camera.Size size) {
        return m6() ? size.height : size.width;
    }

    /* renamed from: ῲ  reason: contains not printable characters */
    public void m9(int i) {
        AbstractC0010 r4;
        if (!this.f12) {
            try {
                this.f12 = true;
                this.f5 = Camera.open(i);
                Camera.Parameters parameters = this.f5.getParameters();
                this.f18 = m13(this.f5.getParameters());
                parameters.setPreviewSize(this.f18.width, this.f18.height);
                this.f9 = m11(i);
                this.f5.setDisplayOrientation(this.f9);
                this.f5.setParameters(parameters);
                m5();
                m17();
            } catch (Exception e) {
                StringBuilder r0 = C1293.m3416("open camera exception:");
                r0.append(e.getMessage());
                C2369.m6274(r0.toString());
            }
            if (this.f5 == null && (r4 = this.f20) != null) {
                r4.m28();
            }
            this.f12 = false;
        }
    }

    /* renamed from: ⁱ  reason: contains not printable characters */
    public boolean m10() {
        return this.f5 != null;
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m11(int i) {
        return C2369.m6295(i, this.f0);
    }

    /* renamed from: K  reason: contains not printable characters */
    public int m12(Camera.Size size) {
        return m6() ? size.width : size.height;
    }

    /* renamed from: K  reason: contains not printable characters */
    public Camera.Size m13(Camera.Parameters parameters) {
        Object obj;
        try {
            List<Camera.Size> supportedPreviewSizes = parameters.getSupportedPreviewSizes();
            Collections.sort(supportedPreviewSizes, new C0000(((float) getViewWidth()) / ((float) getViewHeight())));
            ArrayList arrayList = new ArrayList();
            float f = 0.0f;
            if (supportedPreviewSizes.size() > 0) {
                f = m2(supportedPreviewSizes.get(0));
            }
            for (Camera.Size size : supportedPreviewSizes) {
                if (((double) Math.abs(m2(size) - f)) < 0.1d) {
                    arrayList.add(size);
                }
            }
            Collections.sort(arrayList, new C0009());
            if (arrayList.size() > 0) {
                obj = arrayList.get(0);
            } else if (supportedPreviewSizes.size() <= 0) {
                return null;
            } else {
                obj = supportedPreviewSizes.get(0);
            }
            return (Camera.Size) obj;
        } catch (Exception unused) {
            return null;
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m14(int i, AbstractC0010 r2) {
        this.f20 = r2;
        this.f21 = i;
        if (this.f0 == null) {
            AbstractC0010 r1 = this.f20;
            if (r1 != null) {
                r1.m28();
            }
        } else if (this.f23 == 0) {
            this.f13 = true;
        } else {
            this.f13 = false;
            m9(i);
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m15(GuardianCameraView guardianCameraView) {
        Camera camera = this.f5;
        if (camera != null) {
            try {
                camera.setPreviewTexture(guardianCameraView.getSurfaceTexture());
                this.f5.startPreview();
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /* renamed from: K  reason: contains not printable characters */
    public void m16(byte[] bArr) {
        if (this.f15) {
            this.f15 = false;
            getExecutor().execute(new RunnableC0006(bArr));
        }
    }

    /* renamed from: 㑃  reason: contains not printable characters */
    public synchronized void m17() {
        if (m10()) {
            getMainHandler().m25();
        }
    }

    /* renamed from: 㗗  reason: contains not printable characters */
    public void m18() {
        if (m10()) {
            this.f5.stopPreview();
            this.f5.setPreviewCallback(null);
        }
    }

    /* renamed from: 㳳  reason: contains not printable characters */
    public boolean m19() {
        int i = this.f16;
        return i != -1 && this.f21 == i;
    }

    /* renamed from: 㴹  reason: contains not printable characters */
    public void m20() {
        getMainHandler().m26();
    }

    /* renamed from: 㿎  reason: contains not printable characters */
    public void m21() {
        m4();
        Camera camera = this.f5;
        if (camera != null) {
            camera.stopPreview();
            this.f5.setPreviewCallback(null);
            this.f5.release();
            this.f5 = null;
        }
    }

    /* renamed from: 䁗  reason: contains not printable characters */
    public void m22() {
        if (m10() && this.f22) {
            m15(this);
            this.f5.setPreviewCallback(this);
        }
    }
}
